/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptolib.v1;

import com.google.common.base.Preconditions;
import java.nio.ByteBuffer;
import javax.security.auth.Destroyable;
import org.cryptomator.cryptolib.api.FileHeader;
import org.cryptomator.cryptolib.common.DestroyableSecretKey;

class FileHeaderImpl
implements FileHeader,
Destroyable {
    static final int NONCE_POS = 0;
    static final int NONCE_LEN = 16;
    static final int PAYLOAD_POS = 16;
    static final int PAYLOAD_LEN = 40;
    static final int MAC_POS = 56;
    static final int MAC_LEN = 32;
    static final int SIZE = 88;
    private final byte[] nonce;
    private final Payload payload;

    FileHeaderImpl(byte[] nonce, Payload payload) {
        if (nonce.length != 16) {
            throw new IllegalArgumentException("Invalid nonce length. (was: " + nonce.length + ", required: " + 16 + ")");
        }
        this.nonce = nonce;
        this.payload = payload;
    }

    static FileHeaderImpl cast(FileHeader header) {
        if (header instanceof FileHeaderImpl) {
            return (FileHeaderImpl)header;
        }
        throw new IllegalArgumentException("Unsupported header type " + header.getClass());
    }

    public byte[] getNonce() {
        return this.nonce;
    }

    public Payload getPayload() {
        return this.payload;
    }

    @Override
    public long getReserved() {
        return this.payload.getReserved();
    }

    @Override
    public void setReserved(long reserved) {
        this.payload.setReserved(reserved);
    }

    @Override
    public boolean isDestroyed() {
        return this.payload.isDestroyed();
    }

    @Override
    public void destroy() {
        this.payload.destroy();
    }

    public static class Payload
    implements Destroyable {
        static final int REVERSED_LEN = 8;
        static final int CONTENT_KEY_LEN = 32;
        static final int SIZE = 40;
        private long reserved;
        private final DestroyableSecretKey contentKey;

        Payload(long reversed, byte[] contentKeyBytes) {
            Preconditions.checkArgument((contentKeyBytes.length == 32 ? 1 : 0) != 0, (Object)("Invalid key length. (was: " + contentKeyBytes.length + ", required: " + 32 + ")"));
            this.reserved = reversed;
            this.contentKey = new DestroyableSecretKey(contentKeyBytes, "AES");
        }

        static Payload decode(ByteBuffer cleartextPayloadBuf) {
            Preconditions.checkArgument((cleartextPayloadBuf.remaining() == 40 ? 1 : 0) != 0, (Object)"invalid payload buffer length");
            long reserved = cleartextPayloadBuf.getLong();
            byte[] contentKeyBytes = new byte[32];
            cleartextPayloadBuf.get(contentKeyBytes);
            return new Payload(reserved, contentKeyBytes);
        }

        ByteBuffer encode() {
            ByteBuffer buf = ByteBuffer.allocate(40);
            buf.putLong(this.reserved);
            buf.put(this.contentKey.getEncoded());
            buf.flip();
            return buf;
        }

        private long getReserved() {
            return this.reserved;
        }

        private void setReserved(long reserved) {
            this.reserved = reserved;
        }

        DestroyableSecretKey getContentKey() {
            return this.contentKey;
        }

        @Override
        public boolean isDestroyed() {
            return this.contentKey.isDestroyed();
        }

        @Override
        public void destroy() {
            this.contentKey.destroy();
        }
    }
}

