/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.restapi;

import javax.ws.rs.CookieParam;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.persistency.outcome.Schema;
import org.cristalise.kernel.persistency.outcomebuilder.OutcomeBuilder;
import org.cristalise.kernel.persistency.outcomebuilder.OutcomeBuilderException;
import org.cristalise.kernel.process.resource.BuiltInResources;
import org.cristalise.kernel.utils.LocalObjectLoader;
import org.cristalise.restapi.ResourceAccess;
import org.cristalise.restapi.RestHandler;
import org.cristalise.restapi.SystemProperties;
import org.cristalise.restapi.WebAppExceptionBuilder;
import org.json.JSONArray;

@Path(value="/schema")
public class SchemaAccess
extends ResourceAccess {
    @GET
    @Produces(value={"application/json"})
    public Response listAllSchemas(@DefaultValue(value="0") @QueryParam(value="start") Integer start, @QueryParam(value="batch") Integer batchSize, @CookieParam(value="cauth") Cookie authCookie, @Context UriInfo uri) {
        RestHandler.AuthData authData = this.checkAuthCookie(authCookie);
        NewCookie cookie = this.checkAndCreateNewCookie(authData);
        if (batchSize == null) {
            batchSize = SystemProperties.REST_DefaultBatchSize.getInteger();
        }
        return this.listAllResources(BuiltInResources.SCHEMA_RESOURCE, uri, start, batchSize, cookie).build();
    }

    @GET
    @Path(value="{name}")
    @Produces(value={"application/json"})
    public Response listSchemaVersions(@PathParam(value="name") String name, @CookieParam(value="cauth") Cookie authCookie, @Context UriInfo uri) {
        RestHandler.AuthData authData = this.checkAuthCookie(authCookie);
        NewCookie cookie = this.checkAndCreateNewCookie(authData);
        return this.listResourceVersions(BuiltInResources.SCHEMA_RESOURCE, name, uri, cookie).build();
    }

    @GET
    @Path(value="{name}/{version}")
    @Produces(value={"text/xml", "application/xml", "application/json"})
    public Response getSchema(@Context HttpHeaders headers, @PathParam(value="name") String name, @PathParam(value="version") Integer version, @CookieParam(value="cauth") Cookie authCookie) {
        RestHandler.AuthData authData = this.checkAuthCookie(authCookie);
        NewCookie cookie = this.checkAndCreateNewCookie(authData);
        return this.getResource(BuiltInResources.SCHEMA_RESOURCE, name, version, SchemaAccess.produceJSON(headers.getAcceptableMediaTypes()), cookie).build();
    }

    @GET
    @Path(value="{name}/{version}/formTemplate")
    @Produces(value={"application/json"})
    public Response getSchemaFormTemplate(@Context HttpHeaders headers, @PathParam(value="name") String name, @PathParam(value="version") Integer version, @CookieParam(value="cauth") Cookie authCookie) {
        RestHandler.AuthData authData = this.checkAuthCookie(authCookie);
        NewCookie cookie = this.checkAndCreateNewCookie(authData);
        try {
            Schema schema = LocalObjectLoader.getSchema((String)name, (int)version);
            JSONArray form = new OutcomeBuilder(schema, false).generateNgDynamicFormsJson();
            return Response.ok((Object)form.toString()).cookie(new NewCookie[]{cookie}).build();
        }
        catch (InvalidDataException | ObjectNotFoundException | OutcomeBuilderException e) {
            throw new WebAppExceptionBuilder().message("Schema " + name + " v" + version + " doesn't point to any data").status(Response.Status.NOT_FOUND).newCookie(cookie).build();
        }
        catch (Exception e) {
            throw new WebAppExceptionBuilder().exception(e).newCookie(cookie).build();
        }
    }

    @GET
    @Path(value="{name}/{version}/viewTemplate")
    @Produces(value={"application/json"})
    public Response getSchemaViewTemplate(@Context HttpHeaders headers, @PathParam(value="name") String name, @PathParam(value="version") Integer version, @CookieParam(value="cauth") Cookie authCookie) {
        RestHandler.AuthData authData = this.checkAuthCookie(authCookie);
        NewCookie cookie = this.checkAndCreateNewCookie(authData);
        try {
            Schema schema = LocalObjectLoader.getSchema((String)name, (int)version);
            return Response.ok((Object)new OutcomeBuilder(schema).exportViewTemplate()).cookie(new NewCookie[]{cookie}).build();
        }
        catch (InvalidDataException | ObjectNotFoundException | OutcomeBuilderException e) {
            throw new WebAppExceptionBuilder().message("Schema " + name + " v" + version + " doesn't point to any data").status(Response.Status.NOT_FOUND).newCookie(cookie).build();
        }
        catch (Exception e) {
            throw new WebAppExceptionBuilder().exception(e).newCookie(cookie).build();
        }
    }
}

