/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.restapi;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.entity.proxy.ItemProxy;
import org.cristalise.kernel.lookup.DomainPath;
import org.cristalise.kernel.lookup.Lookup;
import org.cristalise.kernel.lookup.Path;
import org.cristalise.kernel.persistency.ClusterType;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.process.resource.BuiltInResources;
import org.cristalise.kernel.property.Property;
import org.cristalise.kernel.utils.LocalObjectLoader;
import org.cristalise.restapi.ItemUtils;
import org.cristalise.restapi.WebAppExceptionBuilder;
import org.json.XML;

public class ResourceAccess
extends ItemUtils {
    public Response.ResponseBuilder listAllResources(BuiltInResources resource, UriInfo uri, int start, int batchSize, NewCookie cookie) {
        DomainPath searchRoot = new DomainPath(resource.getTypeRoot());
        ArrayList<Property> props = new ArrayList<Property>();
        if (resource == BuiltInResources.ELEM_ACT_DESC_RESOURCE) {
            props.add(new Property("Type", "ActivityDesc"));
            props.add(new Property("Complexity", "Elementary"));
        } else if (resource == BuiltInResources.COMP_ACT_DESC_RESOURCE) {
            props.add(new Property("Type", "ActivityDesc"));
            props.add(new Property("Complexity", "Composite"));
        } else {
            props.add(new Property("Type", resource.getSchemaName()));
        }
        Lookup.PagedResult pr = Gateway.getLookup().search((Path)searchRoot, props, start, batchSize);
        ArrayList resourceArray = new ArrayList();
        for (Path p : pr.rows) {
            LinkedHashMap<String, Object> resourceNameData = new LinkedHashMap<String, Object>();
            try {
                ItemProxy proxy = Gateway.getProxy((Path)p.getItemPath());
                String name = proxy.getName();
                resourceNameData.put("name", name);
                resourceNameData.put("url", uri.getAbsolutePathBuilder().path(name).build(new Object[0]).toString());
                resourceArray.add(resourceNameData);
            }
            catch (ObjectNotFoundException e) {
                resourceNameData.put("name", "Path not found for name:" + p.getName());
            }
        }
        return this.toJSON(this.getPagedResult(uri, start, batchSize, pr.maxRows, resourceArray), cookie);
    }

    public Response.ResponseBuilder listResourceVersions(BuiltInResources resource, String name, UriInfo uri, NewCookie cookie) {
        Iterator iter;
        String resourceTypeName = resource.getSchemaName();
        if (resource == BuiltInResources.ELEM_ACT_DESC_RESOURCE || resource == BuiltInResources.COMP_ACT_DESC_RESOURCE) {
            resourceTypeName = "ActivityDesc";
        }
        if (!(iter = Gateway.getLookup().search((Path)new DomainPath("/desc/" + resourceTypeName), name)).hasNext()) {
            throw new WebAppExceptionBuilder().message(resourceTypeName + " not found").status(Response.Status.NOT_FOUND).build();
        }
        try {
            ItemProxy item = Gateway.getProxy((Path)((Path)iter.next()));
            return this.toJSON(this.getResourceVersions(item, String.valueOf(ClusterType.VIEWPOINT) + "/" + resource.getSchemaName(), name, uri, cookie), cookie);
        }
        catch (ObjectNotFoundException e) {
            throw new WebAppExceptionBuilder().message(resourceTypeName + " has no versions").exception((Exception)((Object)e)).status(Response.Status.NOT_FOUND).newCookie(cookie).build();
        }
        catch (Exception e) {
            throw new WebAppExceptionBuilder().exception(e).newCookie(cookie).build();
        }
    }

    public ArrayList<LinkedHashMap<String, Object>> getResourceVersions(ItemProxy item, String clusterPath, String name, UriInfo uri, NewCookie cookie) {
        try {
            String[] children = item.getContents(clusterPath);
            ArrayList<LinkedHashMap<String, Object>> childrenData = new ArrayList<LinkedHashMap<String, Object>>();
            for (String childName : children) {
                if (childName.equals("last")) continue;
                LinkedHashMap<String, Object> childData = new LinkedHashMap<String, Object>();
                childData.put("version", childName);
                childData.put("url", uri.getAbsolutePathBuilder().path(childName).build(new Object[0]));
                childrenData.add(childData);
            }
            return childrenData;
        }
        catch (Exception e) {
            throw new WebAppExceptionBuilder().exception(e).newCookie(cookie).build();
        }
    }

    public Response.ResponseBuilder getResource(BuiltInResources resource, String name, Integer version, boolean json, NewCookie cookie) {
        try {
            String result = switch (resource) {
                case BuiltInResources.SCHEMA_RESOURCE -> LocalObjectLoader.getSchema((String)name, (int)version).getSchemaData();
                case BuiltInResources.STATE_MACHINE_RESOURCE -> Gateway.getMarshaller().marshall((Object)LocalObjectLoader.getStateMachine((String)name, (int)version));
                case BuiltInResources.SCRIPT_RESOURCE -> LocalObjectLoader.getScript((String)name, (int)version).getScriptData();
                case BuiltInResources.QUERY_RESOURCE -> LocalObjectLoader.getQuery((String)name, (int)version).getQueryXML();
                case BuiltInResources.ELEM_ACT_DESC_RESOURCE -> Gateway.getMarshaller().marshall((Object)LocalObjectLoader.getElemActDef((String)name, (int)version));
                case BuiltInResources.COMP_ACT_DESC_RESOURCE -> Gateway.getMarshaller().marshall((Object)LocalObjectLoader.getCompActDef((String)name, (int)version));
                default -> throw new WebAppExceptionBuilder().message(resource.name() + " " + name + " v" + version + " not handle").status(Response.Status.BAD_REQUEST).build();
            };
            if (json) {
                result = XML.toJSONObject((String)result, (boolean)true).toString();
            }
            return Response.ok((Object)result);
        }
        catch (ObjectNotFoundException e) {
            throw new WebAppExceptionBuilder(resource.name() + " " + name + " v" + version + " does not exist", (Exception)((Object)e), Response.Status.NOT_FOUND, cookie).build();
        }
        catch (InvalidDataException e) {
            throw new WebAppExceptionBuilder(resource.name() + " " + name + " v" + version + " does not point to any data", (Exception)((Object)e), Response.Status.NOT_FOUND, cookie).build();
        }
        catch (Exception e) {
            throw new WebAppExceptionBuilder().exception(e).newCookie(cookie).build();
        }
    }
}

