/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.restapi;

import java.net.URI;
import org.apache.commons.lang3.StringUtils;
import org.cristalise.kernel.process.AbstractMain;
import org.cristalise.kernel.process.ShutdownHandler;
import org.cristalise.kernel.process.StandardClient;
import org.cristalise.kernel.process.resource.BadArgumentsException;
import org.cristalise.restapi.CORSResponseFilter;
import org.cristalise.restapi.SystemProperties;
import org.glassfish.grizzly.http.server.HttpServer;
import org.glassfish.jersey.grizzly2.httpserver.GrizzlyHttpServerFactory;
import org.glassfish.jersey.media.multipart.MultiPartFeature;
import org.glassfish.jersey.server.ResourceConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Main
extends StandardClient {
    private static final Logger log = LoggerFactory.getLogger(Main.class);
    static HttpServer server;

    public static void startServer(String[] args) throws Exception {
        Main.setShutdownHandler((ShutdownHandler)new ShutdownHandler(){

            public void shutdown(int errCode, boolean isServer) {
                if (server != null) {
                    server.shutdownNow();
                }
            }
        });
        Main.standardInitialisation((String[])args);
        String uri = SystemProperties.REST_URI.getString();
        if (StringUtils.isBlank((CharSequence)uri)) {
            throw new BadArgumentsException("Please specify REST.URI on which to listen in config.");
        }
        ResourceConfig rc = new ResourceConfig().packages(new String[]{"org.cristalise.restapi"});
        rc.register(MultiPartFeature.class);
        if (SystemProperties.REST_addCorsHeaders.getBoolean().booleanValue()) {
            rc.register(CORSResponseFilter.class);
        }
        server = GrizzlyHttpServerFactory.createHttpServer((URI)URI.create(uri), (ResourceConfig)rc);
        log.info("startServer() - Jersey app started with WADL available at {}/application.wadl", (Object)uri);
        server.start();
        log.info("startServer() - DONE");
        Thread.currentThread().join();
    }

    public static void main(String[] args) {
        try {
            Main.startServer(args);
        }
        catch (Exception e) {
            log.error("main()", (Throwable)e);
            AbstractMain.shutdown((int)1);
        }
        AbstractMain.shutdown((int)0);
    }
}

