/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.restapi;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.ws.rs.CookieParam;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.graph.model.Vertex;
import org.cristalise.kernel.lifecycle.instance.Activity;
import org.cristalise.kernel.lifecycle.instance.CompositeActivity;
import org.cristalise.kernel.lifecycle.instance.Next;
import org.cristalise.kernel.lifecycle.instance.Workflow;
import org.cristalise.kernel.lookup.InvalidItemPathException;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.restapi.ItemUtils;
import org.cristalise.restapi.WebAppExceptionBuilder;
import org.json.XML;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/item/{uuid}/workflow")
public class ItemWorkflow
extends ItemUtils {
    private static final Logger log = LoggerFactory.getLogger(ItemWorkflow.class);

    private Map<String, Object> getGanttTask(String uuid, String parent, Activity act) throws InvalidItemPathException, ObjectNotFoundException {
        LinkedHashMap<String, Object> aTask = new LinkedHashMap<String, Object>();
        if (parent == null) {
            aTask.put("id", uuid);
            aTask.put("type", "project");
            aTask.put("text", this.getProxy(uuid, null).getName());
            aTask.put("open", true);
            aTask.put("duration", "");
            aTask.put("start_date", "");
        } else {
            aTask.put("id", uuid + "/" + act.getID());
            aTask.put("parent", parent);
            aTask.put("type", "task");
            aTask.put("text", act.getTypeName());
            Integer duration = (Integer)act.getProperties().get((Object)"Duration");
            aTask.put("duration", BigDecimal.valueOf((double)duration.intValue() / 3600.0));
            aTask.put("start_date", new SimpleDateFormat("yyyy-MM-dd HH:mm").format(new Date()));
        }
        return aTask;
    }

    private Map<String, Object> getGanttLink(String uuid, Next edge) {
        LinkedHashMap<String, Object> aLink = new LinkedHashMap<String, Object>();
        aLink.put("id", uuid + "/" + edge.getID());
        aLink.put("source", uuid + "/" + edge.getOriginVertexId());
        aLink.put("target", uuid + "/" + edge.getTerminusVertexId());
        aLink.put("type", "0");
        return aLink;
    }

    private Map<String, Object> getGanttObject(Workflow wf) throws InvalidItemPathException, ObjectNotFoundException {
        CompositeActivity domain = (CompositeActivity)wf.search("workflow/domain");
        LinkedHashMap<String, Object> ganttObject = new LinkedHashMap<String, Object>();
        ArrayList<Map<String, Object>> tasks = new ArrayList<Map<String, Object>>();
        ArrayList<Map<String, Object>> links = new ArrayList<Map<String, Object>>();
        Map<String, Object> parentTask = this.getGanttTask(wf.getItemUUID(), null, (Activity)domain);
        tasks.add(parentTask);
        Vertex vertex = domain.getChildrenGraphModel().getStartVertex();
        do {
            if (vertex instanceof Activity) {
                Activity act = (Activity)vertex;
                tasks.add(this.getGanttTask(wf.getItemUUID(), wf.getItemUUID(), act));
                int[] outEdgeIds = act.getOutEdgeIds();
                if (outEdgeIds != null && outEdgeIds.length == 1) {
                    Next edge = (Next)domain.getChildrenGraphModel().resolveEdge(outEdgeIds[0]);
                    links.add(this.getGanttLink(wf.getItemUUID(), edge));
                    vertex = domain.getChildrenGraphModel().getVertexById(edge.getTerminusVertexId());
                    continue;
                }
                vertex = null;
                continue;
            }
            log.warn("getGanttJSON() - Cannot handle vertex type:{}", (Object)vertex.getClass().getSimpleName());
        } while (vertex != null);
        ganttObject.put("data", tasks);
        ganttObject.put("links", links);
        return ganttObject;
    }

    @GET
    @Produces(value={"text/xml", "application/xml", "application/json"})
    public Response getWorkflow(@Context HttpHeaders headers, @PathParam(value="uuid") String uuid, @QueryParam(value="gantt") String gantt, @CookieParam(value="cauth") Cookie authCookie, @Context UriInfo uri) {
        NewCookie cookie = this.checkAndCreateNewCookie(this.checkAuthCookie(authCookie));
        try {
            Workflow wf = this.getProxy(uuid, cookie).getWorkflow();
            if (ItemWorkflow.produceJSON(headers.getAcceptableMediaTypes())) {
                if (gantt == null) {
                    return Response.ok((Object)XML.toJSONObject((String)Gateway.getMarshaller().marshall((Object)wf), (boolean)true)).cookie(new NewCookie[]{cookie}).build();
                }
                return this.toJSON(this.getGanttObject(wf), cookie).build();
            }
            if (gantt == null) {
                return Response.ok((Object)Gateway.getMarshaller().marshall((Object)wf)).cookie(new NewCookie[]{cookie}).build();
            }
            throw new WebAppExceptionBuilder().message("Cannot product Gantt in XML format").status(Response.Status.BAD_REQUEST).newCookie(cookie).build();
        }
        catch (Exception e) {
            throw new WebAppExceptionBuilder().exception(e).newCookie(cookie).build();
        }
    }
}

