/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.restapi;

import javax.ws.rs.CookieParam;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import org.cristalise.kernel.entity.proxy.AgentProxy;
import org.cristalise.kernel.entity.proxy.ItemProxy;
import org.cristalise.kernel.lifecycle.instance.predefined.agent.ForcedLogout;
import org.cristalise.kernel.lifecycle.instance.predefined.agent.LoginTimeout;
import org.cristalise.kernel.lifecycle.instance.predefined.agent.Logout;
import org.cristalise.kernel.lookup.AgentPath;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.restapi.RestHandler;
import org.cristalise.restapi.WebAppExceptionBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="logout")
public class CookieLogout
extends RestHandler {
    private static final Logger log = LoggerFactory.getLogger(CookieLogout.class);

    @GET
    @Produces(value={"text/xml", "application/xml", "application/json"})
    public Response logout(@Context HttpHeaders headers, @QueryParam(value="reason") String reason, @CookieParam(value="cauth") Cookie authCookie) {
        try {
            AgentPath ap = this.getAgentPath(authCookie);
            log.debug("agent:'{}' reason:'{}'", (Object)ap.getAgentName(), (Object)reason);
            AgentProxy agent = Gateway.getAgentProxy((AgentPath)ap);
            if ("timeout".equals(reason)) {
                agent.execute((ItemProxy)agent, LoginTimeout.class);
            } else if ("windowClose".equals(reason)) {
                agent.execute((ItemProxy)agent, ForcedLogout.class);
            } else {
                agent.execute((ItemProxy)agent, Logout.class);
            }
        }
        catch (Exception e) {
            log.error("Problem logging out", (Throwable)e);
            throw new WebAppExceptionBuilder().message("Problem logging out").status(Response.Status.INTERNAL_SERVER_ERROR).build();
        }
        return Response.ok().build();
    }
}

