/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.restapi;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.ByteBuffer;
import java.security.Key;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.crypto.AesCipherService;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.common.SystemKey;
import org.cristalise.kernel.entity.proxy.AgentProxy;
import org.cristalise.kernel.lookup.AgentPath;
import org.cristalise.kernel.lookup.DomainPath;
import org.cristalise.kernel.lookup.InvalidAgentPathException;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.lookup.Lookup;
import org.cristalise.kernel.lookup.Path;
import org.cristalise.kernel.lookup.RolePath;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.property.BuiltInItemProperties;
import org.cristalise.kernel.property.Property;
import org.cristalise.kernel.utils.Logger;
import org.cristalise.restapi.WebAppExceptionBuilder;

public abstract class RestHandler {
    private ObjectMapper mapper = new ObjectMapper();
    private boolean requireLogin = Gateway.getProperties().getBoolean("REST.requireLoginCookie", true);
    private int defaultLogLevel = Gateway.getProperties().getInt("LOGGER.defaultLevel", 9);
    private static Key cookieKey;
    private static AesCipherService aesCipherService;
    public static final String COOKIENAME = "cauth";
    public static final String USERNAME = "username";
    public static final String PASSWORD = "password";

    protected synchronized AuthData decryptAuthData(String authData) throws InvalidAgentPathException, IllegalBlockSizeException, BadPaddingException, InvalidDataException {
        byte[] bytes = DatatypeConverter.parseBase64Binary((String)authData);
        int cntRetries = 1;
        while (true) {
            try {
                return new AuthData(aesCipherService.decrypt(bytes, cookieKey.getEncoded()).getBytes());
            }
            catch (Exception e) {
                Logger.error((String)("Exception caught in decryptAuthData: #" + cntRetries + ": " + e.getMessage()), (Object[])new Object[0]);
                if (Logger.doLog((int)this.defaultLogLevel)) {
                    Logger.error((Throwable)e);
                }
                if (cntRetries == 5) {
                    throw e;
                }
                ++cntRetries;
                continue;
            }
            break;
        }
    }

    protected synchronized String encryptAuthData(AuthData auth) throws IllegalBlockSizeException, BadPaddingException {
        byte[] bytes = aesCipherService.encrypt(auth.getBytes(), cookieKey.getEncoded()).getBytes();
        return DatatypeConverter.printBase64Binary((byte[])bytes);
    }

    public Response.ResponseBuilder toJSON(Object data, NewCookie cookie) {
        try {
            String json = this.mapper.writeValueAsString(data);
            Logger.msg((int)8, (String)json, (Object[])new Object[0]);
            if (cookie != null) {
                return Response.ok((Object)json).cookie(new NewCookie[]{cookie});
            }
            return Response.ok((Object)json);
        }
        catch (IOException e) {
            throw new WebAppExceptionBuilder("Problem building response JSON", e, Response.Status.INTERNAL_SERVER_ERROR, cookie).build();
        }
    }

    public NewCookie checkAndCreateNewCookie(AuthData authData) {
        boolean userNoTimeout;
        if (authData != null && !(userNoTimeout = this.isUserNoTimeout(authData.agent)) && (new Date().getTime() - authData.timestamp.getTime()) / 1000L > 30L) {
            authData.timestamp = new Date();
            return this.createNewCookie(authData);
        }
        return null;
    }

    public NewCookie checkAndCreateNewCookie(Cookie authCookie) {
        return this.checkAndCreateNewCookie(this.checkAuthCookie(authCookie));
    }

    public NewCookie createNewCookie(AgentPath agentPath) {
        AuthData agentData = new AuthData(agentPath);
        return this.createNewCookie(agentData);
    }

    public NewCookie createNewCookie(AuthData authData) {
        try {
            NewCookie cookie = new NewCookie(COOKIENAME, this.encryptAuthData(authData), "/", null, null, -1, false);
            return cookie;
        }
        catch (BadPaddingException | IllegalBlockSizeException e) {
            Logger.error((Throwable)e);
            throw new WebAppExceptionBuilder("Problem building response JSON: ", e, Response.Status.INTERNAL_SERVER_ERROR, null).build();
        }
    }

    public synchronized AgentPath getAgentPath(Cookie authCookie) {
        AuthData authData = this.checkAuthCookie(authCookie);
        if (authData == null) {
            return null;
        }
        return authData.agent;
    }

    public synchronized AuthData checkAuthCookie(Cookie authCookie) {
        if (authCookie == null) {
            return this.checkAuthData(null);
        }
        return this.checkAuthData(authCookie.getValue());
    }

    private AuthData checkAuthData(String authData) {
        if (!this.requireLogin) {
            return null;
        }
        if (authData == null) {
            throw new WebAppExceptionBuilder().message("Missing authentication data").status(Response.Status.UNAUTHORIZED).build();
        }
        try {
            AuthData data = this.decryptAuthData(authData);
            return data;
        }
        catch (InvalidDataException | InvalidAgentPathException e) {
            Logger.error((String)(e.getMessage() + " - authData:" + authData), (Object[])new Object[0]);
            if (Logger.doLog((int)this.defaultLogLevel)) {
                Logger.error((Throwable)e);
            }
            throw new WebAppExceptionBuilder().message("Invalid agent or login data").status(Response.Status.UNAUTHORIZED).build();
        }
        catch (Exception e) {
            Logger.error((String)(e.getMessage() + " - authData:" + authData), (Object[])new Object[0]);
            if (Logger.doLog((int)this.defaultLogLevel)) {
                Logger.error((Throwable)e);
            }
            throw new WebAppExceptionBuilder().message("Error reading authentication data").status(Response.Status.UNAUTHORIZED).build();
        }
    }

    public AgentProxy getAgent(String agentName, Cookie authCookie) throws ObjectNotFoundException {
        if (authCookie == null) {
            return this.getAgent(agentName, (String)null);
        }
        return this.getAgent(agentName, authCookie.getValue());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public AgentProxy getAgent(String agentName, String authData) throws ObjectNotFoundException {
        AuthData agentAuthData = this.checkAuthData(authData);
        try {
            AgentPath agentPath;
            if (agentAuthData == null) {
                if (!StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{agentName})) throw new ObjectNotFoundException("AgentName is empty");
                agentPath = Gateway.getLookup().getAgentPath(agentName);
                return (AgentProxy)Gateway.getProxyManager().getProxy((Path)agentPath);
            } else {
                agentPath = agentAuthData.agent;
            }
            return (AgentProxy)Gateway.getProxyManager().getProxy((Path)agentPath);
        }
        catch (ObjectNotFoundException e) {
            Logger.error((Throwable)e);
            throw new ObjectNotFoundException("Agent not found");
        }
    }

    public Map<String, Object> getPagedResult(UriInfo uri, int start, int batchSize, int totalRows, List<?> rows) {
        LinkedHashMap<String, Object> pagedReturnData = new LinkedHashMap<String, Object>();
        pagedReturnData.put("start", start);
        pagedReturnData.put("pageSize", batchSize);
        pagedReturnData.put("totalRows", totalRows);
        if (batchSize > 0 && start - batchSize >= 0) {
            pagedReturnData.put("prevPage", uri.getAbsolutePathBuilder().replaceQueryParam("start", new Object[]{start - batchSize}).replaceQueryParam("batch", new Object[]{batchSize}).build(new Object[0]));
        }
        if (batchSize > 0 && start + batchSize < totalRows) {
            pagedReturnData.put("nextPage", uri.getAbsolutePathBuilder().replaceQueryParam("start", new Object[]{start + batchSize}).replaceQueryParam("batch", new Object[]{batchSize}).build(new Object[0]));
        }
        pagedReturnData.put("rows", rows);
        return pagedReturnData;
    }

    public List<Property> getPropertiesFromQParams(String search) {
        String[] terms = search.split(",");
        ArrayList<Property> props = new ArrayList<Property>();
        for (int i = 0; i < terms.length; ++i) {
            if (terms[i].contains(":")) {
                String[] nameval = terms[i].split(":");
                String value = nameval[1];
                if (nameval.length != 2) {
                    throw new WebAppExceptionBuilder().message("Invalid search term: " + terms[i]).status(Response.Status.BAD_REQUEST).build();
                }
                try {
                    value = URLDecoder.decode(nameval[1], "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    Logger.error((Throwable)e);
                    throw new WebAppExceptionBuilder().message("Error decoding search value: " + nameval[1]).status(Response.Status.BAD_REQUEST).build();
                }
                props.add(new Property(nameval[0], value));
                continue;
            }
            if (i == 0) {
                props.add(new Property(BuiltInItemProperties.NAME, terms[i]));
                continue;
            }
            throw new WebAppExceptionBuilder().message("Only the first search term may omit property name").status(Response.Status.BAD_REQUEST).build();
        }
        return props;
    }

    private boolean isUserNoTimeout(AgentPath agent) {
        RolePath[] roles = agent.getRoles();
        String roleWithoutTimeout = Gateway.getProperties().getString("REST.role.withoutTimeout");
        boolean userNoTimeout = false;
        if (StringUtils.isNotBlank((CharSequence)roleWithoutTimeout)) {
            for (RolePath role : roles) {
                if (!role.getName().equals(roleWithoutTimeout)) continue;
                Logger.msg((int)8, (String)"AuthData - cookie timeout is disabled for the current user:%s", (Object[])new Object[]{agent.getName()});
                userNoTimeout = true;
            }
        }
        return userNoTimeout;
    }

    protected Map<String, Object> makeItemDomainPathsData(ItemPath ip) {
        Lookup.PagedResult result = Gateway.getLookup().searchAliases(ip, 0, 50);
        LinkedHashMap<String, Object> returnVal = new LinkedHashMap<String, Object>();
        ArrayList<String> domainPathesData = new ArrayList<String>();
        for (Path p : result.rows) {
            domainPathesData.add(p.getStringPath());
        }
        if (domainPathesData.size() != 0) {
            returnVal.put("uuid", ip.getUUID().toString());
            returnVal.put("name", ((DomainPath)result.rows.get(0)).getName());
            returnVal.put("domainPaths", domainPathesData);
        } else if (ip instanceof AgentPath) {
            returnVal.put("uuid", ip.getUUID().toString());
            returnVal.put("name", ((AgentPath)ip).getAgentName());
            returnVal.put("error", "Agent has no aliases");
        }
        return returnVal;
    }

    static {
        int keySize = Gateway.getProperties().getBoolean("REST.allowWeakKey", false) ? 128 : 256;
        aesCipherService = new AesCipherService();
        cookieKey = aesCipherService.generateNewKey(keySize);
    }

    public class AuthData {
        AgentPath agent;
        Date timestamp;

        public AuthData(AgentPath agent) {
            this.agent = agent;
            this.timestamp = new Date();
        }

        public AuthData(byte[] bytes) throws InvalidAgentPathException, InvalidDataException {
            ByteBuffer buf = ByteBuffer.wrap(bytes);
            SystemKey sysKey = new SystemKey(buf.getLong(), buf.getLong());
            this.agent = new AgentPath(new ItemPath(sysKey));
            this.timestamp = new Date(buf.getLong());
            int cookieLife = Gateway.getProperties().getInt("REST.loginCookieLife", 0);
            boolean userNoTimeout = RestHandler.this.isUserNoTimeout(this.agent);
            if (!userNoTimeout && cookieLife > 0 && (new Date().getTime() - this.timestamp.getTime()) / 1000L > (long)cookieLife) {
                throw new InvalidDataException("Cookie too old");
            }
        }

        public byte[] getBytes() {
            byte[] bytes = new byte[192];
            SystemKey sysKey = this.agent.getSystemKey();
            ByteBuffer buf = ByteBuffer.wrap(bytes);
            buf.putLong(sysKey.msb);
            buf.putLong(sysKey.lsb);
            buf.putLong(this.timestamp.getTime());
            return bytes;
        }
    }
}

