/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.restapi;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.ws.rs.CookieParam;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.cristalise.kernel.common.PersistencyException;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.process.resource.BuiltInResources;
import org.cristalise.restapi.ItemUtils;
import org.cristalise.restapi.ResourceAccess;
import org.cristalise.restapi.ScriptUtils;
import org.cristalise.storage.jooqdb.JooqHandler;
import org.jooq.DSLContext;
import org.jooq.exception.DataAccessException;

@Path(value="/script")
public class ScriptAccess
extends ResourceAccess {
    private ScriptUtils scriptUtils = new ScriptUtils();

    @GET
    @Produces(value={"application/json"})
    public Response listAllScripts(@DefaultValue(value="0") @QueryParam(value="start") Integer start, @QueryParam(value="batch") Integer batchSize, @CookieParam(value="cauth") Cookie authCookie, @Context UriInfo uri) {
        this.checkAuthCookie(authCookie);
        if (batchSize == null) {
            batchSize = Gateway.getProperties().getInt("REST.DefaultBatchSize", 75);
        }
        return this.listAllResources(BuiltInResources.SCRIPT_RESOURCE, uri, start, batchSize);
    }

    @GET
    @Path(value="{name}")
    @Produces(value={"application/json"})
    public Response listScriptVersions(@PathParam(value="name") String name, @CookieParam(value="cauth") Cookie authCookie, @Context UriInfo uri) {
        this.checkAuthCookie(authCookie);
        return this.listResourceVersions(BuiltInResources.SCRIPT_RESOURCE, name, uri);
    }

    @GET
    @Path(value="{name}/{version}")
    @Produces(value={"text/xml", "application/xml", "application/json"})
    public Response getScript(@Context HttpHeaders headers, @PathParam(value="name") String name, @PathParam(value="version") Integer version, @CookieParam(value="cauth") Cookie authCookie) {
        this.checkAuthCookie(authCookie);
        return this.getResource(BuiltInResources.SCRIPT_RESOURCE, name, version, ScriptAccess.produceJSON(headers.getAcceptableMediaTypes()));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @GET
    @Path(value="scriptResult")
    @Produces(value={"text/xml", "application/xml", "application/json"})
    public Response getScriptResult(@Context HttpHeaders headers, @QueryParam(value="script") String scriptName, @QueryParam(value="version") Integer scriptVersion, @QueryParam(value="inputs") String inputJson, @CookieParam(value="cauth") Cookie authCookie) {
        this.checkAuthCookie(authCookie);
        try (DSLContext context = JooqHandler.connect();){
            Response response = this.scriptUtils.executeScript(headers, null, scriptName, scriptVersion, inputJson, (Map<String, Object>)ImmutableMap.of((Object)"dsl", (Object)context));
            return response;
        }
        catch (PersistencyException | DataAccessException e) {
            throw ItemUtils.createWebAppException("Error connecting to database, please contact support", (Exception)e, Response.Status.NOT_FOUND);
        }
    }
}

