/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.restapi;

import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.lookup.AgentPath;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.utils.Logger;
import org.cristalise.restapi.RestHandler;

@Path(value="auth")
public class TokenLogin
extends RestHandler {
    @GET
    @Produces(value={"text/plain"})
    public Response login(@QueryParam(value="user") String user, @QueryParam(value="pass") String pass, @Context UriInfo uri) {
        AgentPath agentPath;
        try {
            if (!Gateway.getAuthenticator().authenticate(user, pass, null)) {
                throw new WebApplicationException("Bad username/password", 401);
            }
        }
        catch (InvalidDataException e) {
            Logger.error((Throwable)e);
            throw new WebApplicationException("Problem logging in");
        }
        catch (ObjectNotFoundException e1) {
            throw new WebApplicationException("Bad username/password", 401);
        }
        try {
            agentPath = Gateway.getLookup().getAgentPath(user);
        }
        catch (ObjectNotFoundException e) {
            Logger.error((Throwable)e);
            throw new WebApplicationException("Agent '" + user + "' not found", 404);
        }
        RestHandler.AuthData agentData = (RestHandler)this.new RestHandler.AuthData(agentPath);
        try {
            String token = this.encryptAuthData(agentData);
            return Response.ok((Object)token).build();
        }
        catch (Exception e) {
            Logger.error((Throwable)e);
            throw new WebApplicationException("Error creating token");
        }
    }
}

