/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.restapi;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.entity.proxy.ItemProxy;
import org.cristalise.kernel.lookup.DomainPath;
import org.cristalise.kernel.lookup.Lookup;
import org.cristalise.kernel.lookup.Path;
import org.cristalise.kernel.persistency.ClusterType;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.process.resource.BuiltInResources;
import org.cristalise.kernel.property.Property;
import org.cristalise.kernel.utils.LocalObjectLoader;
import org.cristalise.kernel.utils.Logger;
import org.cristalise.restapi.ItemUtils;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.json.XML;

public class ResourceAccess
extends ItemUtils {
    public Response listAllResources(BuiltInResources resource, UriInfo uri, int start, int batchSize) {
        DomainPath searchRoot = new DomainPath(resource.getTypeRoot());
        ArrayList<Property> props = new ArrayList<Property>();
        if (resource == BuiltInResources.ELEM_ACT_DESC_RESOURCE) {
            props.add(new Property("Type", "ActivityDesc"));
            props.add(new Property("Complexity", "Elementary"));
        } else if (resource == BuiltInResources.COMP_ACT_DESC_RESOURCE) {
            props.add(new Property("Type", "ActivityDesc"));
            props.add(new Property("Complexity", "Composite"));
        } else {
            props.add(new Property("Type", resource.getSchemaName()));
        }
        Lookup.PagedResult pr = Gateway.getLookup().search((Path)searchRoot, props, start, batchSize);
        ArrayList resourceArray = new ArrayList();
        for (Path p : pr.rows) {
            LinkedHashMap<String, String> resourceNameData = new LinkedHashMap<String, String>();
            try {
                ItemProxy proxy = Gateway.getProxyManager().getProxy((Path)p.getItemPath());
                String name = proxy.getName();
                resourceNameData.put("name", name);
                resourceNameData.put("url", uri.getAbsolutePathBuilder().path(name).build(new Object[0]).toString());
                resourceArray.add(resourceNameData);
            }
            catch (ObjectNotFoundException e) {
                resourceNameData.put("name", "Path not found for name:" + p.getName());
            }
        }
        return this.toJSON(this.getPagedResult(uri, start, batchSize, pr.maxRows, resourceArray));
    }

    public Response listResourceVersions(BuiltInResources resource, String name, UriInfo uri) {
        Iterator iter;
        String resourceTypeName = resource.getSchemaName();
        if (resource == BuiltInResources.ELEM_ACT_DESC_RESOURCE || resource == BuiltInResources.COMP_ACT_DESC_RESOURCE) {
            resourceTypeName = "ActivityDesc";
        }
        if (!(iter = Gateway.getLookup().search((Path)new DomainPath("/desc/" + resourceTypeName), name)).hasNext()) {
            throw ItemUtils.createWebAppException(resourceTypeName + " not found", Response.Status.NOT_FOUND);
        }
        try {
            ItemProxy item = Gateway.getProxyManager().getProxy((Path)iter.next());
            return this.toJSON(this.getResourceVersions(item, ClusterType.VIEWPOINT + "/" + resource.getSchemaName(), name, uri));
        }
        catch (ObjectNotFoundException e) {
            throw ItemUtils.createWebAppException(resource.getSchemaName() + " has no versions", Response.Status.NOT_FOUND);
        }
    }

    public ArrayList<LinkedHashMap<String, Object>> getResourceVersions(ItemProxy item, String clusterPath, String name, UriInfo uri) {
        try {
            String[] children = item.getContents(clusterPath);
            ArrayList<LinkedHashMap<String, Object>> childrenData = new ArrayList<LinkedHashMap<String, Object>>();
            for (String childName : children) {
                if (childName.equals("last")) continue;
                LinkedHashMap<String, Object> childData = new LinkedHashMap<String, Object>();
                childData.put("version", childName);
                childData.put("url", uri.getAbsolutePathBuilder().path(childName).build(new Object[0]));
                childrenData.add(childData);
            }
            return childrenData;
        }
        catch (ObjectNotFoundException e) {
            Logger.error((Throwable)e);
            throw ItemUtils.createWebAppException("Database Error");
        }
    }

    public Response getResource(BuiltInResources resource, String name, Integer version, boolean json) {
        try {
            String result;
            switch (resource) {
                case SCHEMA_RESOURCE: {
                    result = LocalObjectLoader.getSchema((String)name, (int)version).getSchemaData();
                    break;
                }
                case STATE_MACHINE_RESOURCE: {
                    result = Gateway.getMarshaller().marshall((Object)LocalObjectLoader.getStateMachine((String)name, (int)version));
                    break;
                }
                case SCRIPT_RESOURCE: {
                    result = LocalObjectLoader.getScript((String)name, (int)version).getScriptData();
                    break;
                }
                case QUERY_RESOURCE: {
                    result = LocalObjectLoader.getQuery((String)name, (int)version).getQueryXML();
                    break;
                }
                case ELEM_ACT_DESC_RESOURCE: {
                    result = Gateway.getMarshaller().marshall((Object)LocalObjectLoader.getElemActDef((String)name, (int)version));
                    break;
                }
                case COMP_ACT_DESC_RESOURCE: {
                    result = Gateway.getMarshaller().marshall((Object)LocalObjectLoader.getCompActDef((String)name, (int)version));
                    break;
                }
                default: {
                    throw ItemUtils.createWebAppException(resource.name() + " " + name + " v" + version + " not handled", Response.Status.NOT_IMPLEMENTED);
                }
            }
            if (json) {
                result = XML.toJSONObject((String)result).toString();
            }
            return Response.ok((Object)result).build();
        }
        catch (ObjectNotFoundException e) {
            throw ItemUtils.createWebAppException(resource.name() + " " + name + " v" + version + " does not exist", Response.Status.NOT_FOUND);
        }
        catch (InvalidDataException e) {
            throw ItemUtils.createWebAppException(resource.name() + " " + name + " v" + version + " doesn't point to any data", Response.Status.NOT_FOUND);
        }
        catch (IOException | MappingException | MarshalException | ValidationException e) {
            throw ItemUtils.createWebAppException(resource.name() + " " + name + " v" + version + " xml convert problem", Response.Status.INTERNAL_SERVER_ERROR);
        }
    }
}

