/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.restapi;

import java.net.URI;
import java.util.ArrayList;
import java.util.Map;
import javax.ws.rs.CookieParam;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.lookup.DomainPath;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.lookup.Lookup;
import org.cristalise.kernel.lookup.Path;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.restapi.ItemUtils;
import org.cristalise.restapi.PathUtils;

@javax.ws.rs.Path(value="/domain")
public class PathAccess
extends PathUtils {
    @GET
    @Produces(value={"application/json"})
    public Response queryPath(@DefaultValue(value="0") @QueryParam(value="start") Integer start, @QueryParam(value="batch") Integer batchSize, @QueryParam(value="search") String search, @CookieParam(value="cauth") Cookie authCookie, @Context UriInfo uri) {
        return this.queryPath("/", start, batchSize, search, authCookie, uri);
    }

    @GET
    @javax.ws.rs.Path(value="{path: .*}")
    @Produces(value={"application/json"})
    public Response queryPath(@PathParam(value="path") String path, @DefaultValue(value="0") @QueryParam(value="start") Integer start, @QueryParam(value="batch") Integer batchSize, @QueryParam(value="search") String search, @CookieParam(value="cauth") Cookie authCookie, @Context UriInfo uri) {
        this.checkAuthCookie(authCookie);
        DomainPath domPath = new DomainPath(path);
        if (batchSize == null) {
            batchSize = Gateway.getProperties().getInt("REST.Path.DefaultBatchSize", Gateway.getProperties().getInt("REST.DefaultBatchSize", 75));
        }
        if (!domPath.exists()) {
            throw ItemUtils.createWebAppException("Domain path does not exist", Response.Status.NOT_FOUND);
        }
        try {
            ItemPath item = domPath.getItemPath();
            return Response.seeOther((URI)ItemUtils.getItemURI(uri, item, new Object[0])).build();
        }
        catch (ObjectNotFoundException item) {
            Lookup.PagedResult childSearch = search == null ? Gateway.getLookup().getChildren((Path)domPath, start.intValue(), batchSize.intValue()) : Gateway.getLookup().search((Path)domPath, this.getPropertiesFromQParams(search), start.intValue(), batchSize.intValue());
            ArrayList<Map<String, Object>> pathDataArray = new ArrayList<Map<String, Object>>();
            for (Path p : childSearch.rows) {
                pathDataArray.add(this.makeLookupData(path, p, uri));
            }
            return this.toJSON(this.getPagedResult(uri, start, batchSize, childSearch.maxRows, pathDataArray));
        }
    }
}

