/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.salt.extensions.notification.graph.impl;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.corpus_tools.salt.extensions.notification.Listener;
import org.corpus_tools.salt.extensions.notification.graph.Notifier;
import org.corpus_tools.salt.extensions.notification.graph.impl.NotifierHelper;
import org.corpus_tools.salt.graph.GRAPH_ATTRIBUTES;
import org.corpus_tools.salt.graph.Graph;
import org.corpus_tools.salt.graph.Label;
import org.corpus_tools.salt.graph.Layer;
import org.corpus_tools.salt.graph.Node;
import org.corpus_tools.salt.graph.Relation;
import org.corpus_tools.salt.graph.impl.GraphImpl;
import org.corpus_tools.salt.graph.impl.NodeImpl;
import org.corpus_tools.salt.graph.impl.RelationImpl;

public class GraphNotifierImpl<N extends Node, R extends Relation<N, N>, L extends Layer<N, R>>
extends GraphImpl<N, R, L>
implements Graph<N, R, L>,
Notifier {
    protected List<Listener> listenerList = null;
    private Graph<?, ?, ?> owner;

    @Override
    public List<Listener> getListener() {
        return NotifierHelper.getListener(this.listenerList);
    }

    @Override
    public synchronized void addListener(Listener listener) {
        this.listenerList = NotifierHelper.addListener(this.listenerList, listener);
    }

    @Override
    public void addListener(Collection<Listener> listener) {
        this.listenerList = NotifierHelper.addListener(this.listenerList, listener);
    }

    @Override
    public synchronized void removeListener(Listener listener) {
        this.listenerList = NotifierHelper.removeListener(this.listenerList, listener);
    }

    public Graph<?, ?, ?> getOwner() {
        return this.owner;
    }

    public void setOwner(Graph<?, ?, ?> owner) {
        this.owner = owner;
    }

    public void addLabel(Label label) {
        super.addLabel(label);
        if (this.listenerList != null) {
            NotifierHelper.notify(this.listenerList, Listener.NOTIFICATION_TYPE.ADD, GRAPH_ATTRIBUTES.GRAPH_LABELS, null, label, this);
        }
    }

    public void removeLabel(String qName) {
        Label oldValue = this.getLabel(qName);
        super.removeLabel(qName);
        if (this.listenerList != null) {
            NotifierHelper.notify(this.listenerList, Listener.NOTIFICATION_TYPE.REMOVE, GRAPH_ATTRIBUTES.GRAPH_LABELS, oldValue, null, this);
        }
    }

    public void removeAll() {
        Collection oldValue = this.getLabels();
        super.removeAll();
        if (this.listenerList != null) {
            NotifierHelper.notify(this.listenerList, Listener.NOTIFICATION_TYPE.REMOVE_ALL, GRAPH_ATTRIBUTES.GRAPH_LABELS, oldValue, null, this);
        }
    }

    public void addNode(N node) {
        super.addNode(node);
        if (this.owner != null && node instanceof NodeImpl) {
            ((NodeImpl)node).basicSetGraph_WithoutRemoving(this.owner);
        }
        if (this.listenerList != null) {
            NotifierHelper.notify(this.listenerList, Listener.NOTIFICATION_TYPE.ADD, GRAPH_ATTRIBUTES.GRAPH_NODES, null, node, this);
        }
    }

    public void removeNode(N node) {
        super.removeNode(node);
        if (this.listenerList != null) {
            NotifierHelper.notify(this.listenerList, Listener.NOTIFICATION_TYPE.REMOVE, GRAPH_ATTRIBUTES.GRAPH_NODES, node, null, this);
        }
    }

    public void addRelation(Relation<? extends N, ? extends N> relation) {
        super.addRelation(relation);
        if (this.owner != null && relation instanceof RelationImpl) {
            ((RelationImpl)relation).basicSetGraph_WithoutRemoving(this.owner);
        }
        if (this.listenerList != null) {
            NotifierHelper.notify(this.listenerList, Listener.NOTIFICATION_TYPE.ADD, GRAPH_ATTRIBUTES.GRAPH_RELATIONS, null, relation, this);
        }
    }

    public void removeRelation(Relation<? extends N, ? extends N> relation) {
        super.removeRelation(relation);
        if (this.listenerList != null) {
            NotifierHelper.notify(this.listenerList, Listener.NOTIFICATION_TYPE.REMOVE, GRAPH_ATTRIBUTES.GRAPH_RELATIONS, relation, null, this);
        }
    }

    public void removeRelations() {
        List oldValue = this.getRelations();
        super.removeRelations();
        if (this.listenerList != null) {
            NotifierHelper.notify(this.listenerList, Listener.NOTIFICATION_TYPE.REMOVE_ALL, GRAPH_ATTRIBUTES.GRAPH_RELATIONS, oldValue, null, this);
        }
    }

    public void addLayer(L layer) {
        super.addLayer(layer);
        if (this.listenerList != null) {
            NotifierHelper.notify(this.listenerList, Listener.NOTIFICATION_TYPE.ADD, GRAPH_ATTRIBUTES.GRAPH_LAYERS, null, layer, this);
        }
    }

    public void removeLayer(L layer) {
        Set oldValue = this.getLayers();
        super.removeLayer(layer);
        if (this.listenerList != null) {
            NotifierHelper.notify(this.listenerList, Listener.NOTIFICATION_TYPE.REMOVE, GRAPH_ATTRIBUTES.GRAPH_LAYERS, oldValue, null, this);
        }
    }
}

