/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.salt.extensions.notification.graph.impl;

import java.util.Collection;
import java.util.List;
import org.corpus_tools.salt.extensions.notification.Listener;
import org.corpus_tools.salt.extensions.notification.graph.Notifier;
import org.corpus_tools.salt.extensions.notification.graph.impl.NotifierHelper;
import org.corpus_tools.salt.graph.GRAPH_ATTRIBUTES;
import org.corpus_tools.salt.graph.Label;
import org.corpus_tools.salt.graph.Node;
import org.corpus_tools.salt.graph.Relation;
import org.corpus_tools.salt.graph.impl.RelationImpl;

public class RelationNotifierImpl<S extends Node, T extends Node>
extends RelationImpl<S, T>
implements Relation<S, T>,
Notifier {
    protected List<Listener> listenerList = null;

    @Override
    public List<Listener> getListener() {
        return NotifierHelper.getListener(this.listenerList);
    }

    @Override
    public synchronized void addListener(Listener listener) {
        this.listenerList = NotifierHelper.addListener(this.listenerList, listener);
    }

    @Override
    public void addListener(Collection<Listener> listener) {
        this.listenerList = NotifierHelper.addListener(this.listenerList, listener);
    }

    @Override
    public synchronized void removeListener(Listener listener) {
        this.listenerList = NotifierHelper.removeListener(this.listenerList, listener);
    }

    public void addLabel(Label label) {
        super.addLabel(label);
        if (this.listenerList != null) {
            NotifierHelper.notify(this.listenerList, Listener.NOTIFICATION_TYPE.ADD, GRAPH_ATTRIBUTES.RELATION_LABELS, null, label, this);
        }
    }

    public void removeLabel(String qName) {
        Label oldValue = this.getLabel(qName);
        super.removeLabel(qName);
        if (this.listenerList != null) {
            NotifierHelper.notify(this.listenerList, Listener.NOTIFICATION_TYPE.REMOVE, GRAPH_ATTRIBUTES.RELATION_LABELS, oldValue, null, this);
        }
    }

    public void removeAll() {
        Collection oldValue = this.getLabels();
        super.removeAll();
        if (this.listenerList != null) {
            NotifierHelper.notify(this.listenerList, Listener.NOTIFICATION_TYPE.REMOVE_ALL, GRAPH_ATTRIBUTES.RELATION_LABELS, oldValue, null, this);
        }
    }

    public void setSource(S source) {
        Node oldValue = this.getSource();
        super.setSource(source);
        if (this.listenerList != null) {
            NotifierHelper.notify(this.listenerList, Listener.NOTIFICATION_TYPE.SET, GRAPH_ATTRIBUTES.RELATION_SOURCE, oldValue, this.getSource(), this);
        }
    }

    public void setTarget(T target) {
        Node oldValue = this.getTarget();
        super.setTarget(target);
        if (this.listenerList != null) {
            NotifierHelper.notify(this.listenerList, Listener.NOTIFICATION_TYPE.SET, GRAPH_ATTRIBUTES.RELATION_TARGET, oldValue, this.getTarget(), this);
        }
    }
}

