/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.peppermodules.PTBModules;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.Stack;
import java.util.Vector;
import org.corpus_tools.pepper.common.DOCUMENT_STATUS;
import org.corpus_tools.pepper.impl.PepperMapperImpl;
import org.corpus_tools.pepper.modules.exceptions.PepperModuleException;
import org.corpus_tools.peppermodules.PTBModules.PTBImporterProperties;
import org.corpus_tools.salt.SaltFactory;
import org.corpus_tools.salt.common.SDominanceRelation;
import org.corpus_tools.salt.common.SSequentialDS;
import org.corpus_tools.salt.common.SStructure;
import org.corpus_tools.salt.common.SStructuredNode;
import org.corpus_tools.salt.common.STextualDS;
import org.corpus_tools.salt.common.SToken;
import org.corpus_tools.salt.core.SAnnotation;
import org.corpus_tools.salt.core.SLayer;
import org.corpus_tools.salt.core.SNode;
import org.corpus_tools.salt.graph.Layer;
import org.corpus_tools.salt.graph.Node;
import org.corpus_tools.salt.graph.Relation;

public class PTBImporterMapper
extends PepperMapperImpl {
    private String strNamespace;
    private String strPosName;
    private String strCatName;
    private String strRelationType;
    private String strRelationAnnoSeparator;
    private String strRelationAnnoNameSpace;
    private String strRelationAnnoName;
    private Boolean bolRelationAnnos;
    private Boolean bolHandleSlashTokens;
    private StringBuilder stbText = new StringBuilder();
    private STextualDS txtText = null;
    private SLayer lyrPTB = null;
    private Stack<Vector<SNode>> stNodeVectors = new Stack();
    private String strPos = "";
    private String strTok = "";
    private String strNode = "";
    private String[] strSplitCompoundAnno = new String[2];
    private String strTempAnno;
    private SAnnotation anoTemp = null;
    private int intTokStartChar;
    private int intTokEndChar;
    private Vector<SNode> vecNodeList = new Vector();
    private int intCountClosingBrackets = 0;

    protected void initialize() {
    }

    public DOCUMENT_STATUS mapSCorpus() {
        this.getResourceURI();
        this.getDocument();
        return DOCUMENT_STATUS.COMPLETED;
    }

    public DOCUMENT_STATUS mapSDocument() {
        this.getSettings();
        if (this.getDocument().getDocumentGraph() == null) {
            this.getDocument().setDocumentGraph(SaltFactory.createSDocumentGraph());
        }
        this.lyrPTB = SaltFactory.createSLayer();
        this.lyrPTB.setName(this.strNamespace);
        this.getDocument().getDocumentGraph().addLayer((Layer)this.lyrPTB);
        this.txtText = this.getDocument().getDocumentGraph().createTextualDS("");
        LineNumberReader lnr = null;
        try {
            lnr = new LineNumberReader(new FileReader(new File(this.getResourceURI().toFileString())));
            lnr.skip(Long.MAX_VALUE);
            lnr.close();
        }
        catch (IOException e1) {
            throw new PepperModuleException("Cannot read the input file " + this.getResourceURI().toFileString() + ": " + e1.getMessage(), (Throwable)e1);
        }
        BufferedReader br = null;
        try {
            br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.getResourceURI().toFileString()), "UTF8"));
            String strValidate = br.readLine();
            if (strValidate == null) {
                throw new PepperModuleException("Cannot find text file to process - Input is null");
            }
            while (!strValidate.trim().startsWith("(") && !strValidate.trim().startsWith(")")) {
                strValidate = br.readLine();
            }
            String line = strValidate;
            line.trim();
            int readline = 0;
            boolean addProgress = false;
            int progress = 0;
            while (strValidate != null) {
                progress = ++readline * 100 / lnr.getLineNumber() % 5;
                if (addProgress && progress == 0) {
                    this.addProgress(0.05);
                    addProgress = false;
                } else if (progress != 0) {
                    addProgress = true;
                }
                if (this.CountInString(line, "(") == this.CountInString(line, ")")) {
                    if (this.bolHandleSlashTokens.booleanValue()) {
                        line = line.replaceAll("(?<= )([^ \\(\\)]+)/([^ \\(\\)]+)(?= )", "($2 $1)");
                    }
                    this.mapSentence(line);
                    strValidate = br.readLine();
                    if (strValidate == null) {
                        break;
                    }
                    while (!strValidate.trim().startsWith("(") && (strValidate = br.readLine()) != null) {
                    }
                    if (strValidate == null) continue;
                    line = strValidate.trim();
                    continue;
                }
                strValidate = br.readLine();
                if (strValidate == null) {
                    break;
                }
                while (!strValidate.trim().startsWith("(") && (strValidate = br.readLine()) != null) {
                }
                if (strValidate == null) continue;
                line = line + " " + strValidate.trim();
            }
        }
        catch (FileNotFoundException e) {
            throw new PepperModuleException("The file " + this.getResourceURI().toFileString() + " was not found", (Throwable)e);
        }
        catch (IOException e) {
            throw new PepperModuleException("Cannot read the input file " + this.getResourceURI().toFileString(), (Throwable)e);
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (IOException e) {
                throw new PepperModuleException("Cannot close the stream for input file " + this.getResourceURI().toFileString(), (Throwable)e);
            }
        }
        this.txtText.setText(this.stbText.toString());
        return DOCUMENT_STATUS.COMPLETED;
    }

    public void mapSentence(String strSentence) {
        String[] strAllNodes;
        if (strSentence.startsWith("( (")) {
            strSentence = strSentence.substring(2, strSentence.length() - 2);
        }
        SStructure nodCurrentNode = null;
        for (String strSingleNode : strAllNodes = strSentence.split(" \\(")) {
            if ((strSingleNode = strSingleNode.trim()).startsWith("(")) {
                strSingleNode = strSingleNode.substring(1);
            }
            if (!(")".equals(strSingleNode) || " ".equals(strSingleNode) || strSingleNode.isEmpty())) {
                if (strSingleNode.length() > strSingleNode.replace(" ", "").length()) {
                    this.strPos = strSingleNode.substring(0, strSingleNode.indexOf(32));
                    this.strTok = strSingleNode.substring(strSingleNode.indexOf(32)).trim();
                    this.strTok = this.strTok.replace(")", "");
                    this.strTok = this.strTok.trim();
                    this.intTokStartChar = this.stbText.toString().length();
                    this.stbText.append(this.strTok);
                    this.stbText.append(" ");
                    this.intTokEndChar = this.stbText.toString().length() - 1;
                    SToken tokCurrentToken = this.getDocument().getDocumentGraph().createToken((SSequentialDS)this.txtText, Integer.valueOf(this.intTokStartChar), Integer.valueOf(this.intTokEndChar));
                    tokCurrentToken.createAnnotation(this.strNamespace, this.strPosName, (Object)this.strPos);
                    nodCurrentNode = tokCurrentToken;
                } else {
                    this.strNode = strSingleNode.replace("(", "");
                    nodCurrentNode = SaltFactory.createSStructure();
                    this.getDocument().getDocumentGraph().addNode((Node)nodCurrentNode);
                    nodCurrentNode.addLayer((Layer)this.lyrPTB);
                    nodCurrentNode.createAnnotation(this.strNamespace, this.strCatName, (Object)this.strNode.trim());
                }
                if (this.vecNodeList.isEmpty()) {
                    this.vecNodeList = new Vector();
                    this.vecNodeList.add((SNode)nodCurrentNode);
                    this.stNodeVectors.push(this.vecNodeList);
                    this.vecNodeList = new Vector();
                } else {
                    this.vecNodeList = this.stNodeVectors.pop();
                    this.vecNodeList.add((SNode)nodCurrentNode);
                    this.stNodeVectors.push(this.vecNodeList);
                }
                this.intCountClosingBrackets = this.CountInString(strSingleNode, ")");
                for (int i = 0; i < this.intCountClosingBrackets; ++i) {
                    if (this.stNodeVectors.isEmpty()) continue;
                    this.vecNodeList = this.stNodeVectors.pop();
                    if (!this.stNodeVectors.isEmpty()) {
                        nodCurrentNode = this.stNodeVectors.peek().lastElement();
                        for (SNode nodChild : this.vecNodeList) {
                            if (!(nodCurrentNode instanceof SStructure)) continue;
                            SDominanceRelation domCurrentDom = SaltFactory.createSDominanceRelation();
                            domCurrentDom.setSource((Node)nodCurrentNode);
                            domCurrentDom.setTarget((Node)((SStructuredNode)nodChild));
                            domCurrentDom.setType(this.strRelationType);
                            domCurrentDom.addLayer((Layer)this.lyrPTB);
                            this.getDocument().getDocumentGraph().addRelation((Relation)domCurrentDom);
                            if (!this.bolRelationAnnos.booleanValue()) continue;
                            this.anoTemp = (SAnnotation)nodChild.getAnnotations().iterator().next();
                            this.strTempAnno = this.anoTemp.getValue_STEXT().toString();
                            if (!this.strTempAnno.contains(this.strRelationAnnoSeparator) || this.strTempAnno.startsWith(this.strRelationAnnoSeparator) || this.strTempAnno.indexOf(this.strRelationAnnoSeparator) == this.strTempAnno.length()) continue;
                            this.strSplitCompoundAnno[0] = this.strTempAnno.substring(0, this.strTempAnno.indexOf(this.strRelationAnnoSeparator));
                            this.strSplitCompoundAnno[1] = this.strTempAnno.substring(this.strTempAnno.indexOf(this.strRelationAnnoSeparator) + 1);
                            this.anoTemp.setValue((Object)this.strSplitCompoundAnno[0]);
                            domCurrentDom.createAnnotation(this.strRelationAnnoNameSpace, this.strRelationAnnoName, (Object)this.strSplitCompoundAnno[1]);
                        }
                    }
                    this.vecNodeList.removeAllElements();
                }
            }
            this.vecNodeList.removeAllElements();
        }
    }

    public int CountInString(String strInput, String strToCount) {
        return strInput.length() - strInput.replace(strToCount, "").length();
    }

    private void getSettings() {
        this.strNamespace = ((PTBImporterProperties)this.getProperties()).getNodeNamespace();
        this.strPosName = ((PTBImporterProperties)this.getProperties()).getPosName();
        this.strCatName = ((PTBImporterProperties)this.getProperties()).getCatName();
        this.strRelationType = ((PTBImporterProperties)this.getProperties()).getRelationType();
        this.strRelationAnnoSeparator = ((PTBImporterProperties)this.getProperties()).getRelationAnnoSeparator();
        this.strRelationAnnoNameSpace = ((PTBImporterProperties)this.getProperties()).getRelationAnnoNamespace();
        this.strRelationAnnoName = ((PTBImporterProperties)this.getProperties()).getRelationAnnoName();
        this.bolRelationAnnos = ((PTBImporterProperties)this.getProperties()).getImportRelationAnnos();
        this.bolHandleSlashTokens = ((PTBImporterProperties)this.getProperties()).getHandleSlashTokens();
    }
}

