/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.peppermodules.conll;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.corpus_tools.pepper.common.DOCUMENT_STATUS;
import org.corpus_tools.pepper.impl.PepperMapperImpl;
import org.corpus_tools.pepper.modules.PepperMapper;
import org.corpus_tools.pepper.modules.exceptions.PepperModuleDataException;
import org.corpus_tools.pepper.modules.exceptions.PepperModuleException;
import org.corpus_tools.peppermodules.CoNLLModules.CoNLLExporterProperties;
import org.corpus_tools.peppermodules.conll.ConllDataField;
import org.corpus_tools.peppermodules.conll.tupleconnector.TupleConnectorFactory;
import org.corpus_tools.peppermodules.conll.tupleconnector.TupleWriter;
import org.corpus_tools.salt.common.SDocumentGraph;
import org.corpus_tools.salt.common.SOrderRelation;
import org.corpus_tools.salt.common.SSpan;
import org.corpus_tools.salt.common.SSpanningRelation;
import org.corpus_tools.salt.common.SToken;
import org.corpus_tools.salt.core.SAnnotation;
import org.corpus_tools.salt.core.SNode;
import org.corpus_tools.salt.core.SRelation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Salt2ConllMapper
extends PepperMapperImpl
implements PepperMapper {
    private static final Logger logger = LoggerFactory.getLogger(Salt2ConllMapper.class);
    private static final String ERR_MSG_NO_DOCUMENT = "No document to convert.";
    private static final String ERR_MSG_EMPTY_DOCUMENT = "Document is empty.";
    private static final String NO_VALUE = "_";
    private static final String ERR_MSG_ADD_TUPLE = "There was an error adding a tuple to the tuplewriter.";
    private static final String ERR_MSG_OUTPUT_FILE = "An error occured creating the output file";
    private static final String ERR_MSG_WRONG_COLUMN_FORMAT = "The column configuration provided in the job configuration does not match. Make sure you use the right number of columns and you mark collapsing correctly.";
    private String tokName = null;
    private String dependencyQName = null;
    private String lemmaQName = null;
    private String posQName = null;
    private String cposQName = null;
    private String featsQName = null;
    private String miscQName = null;
    private String tokinfoQName = null;
    private Set<String> spanAnnos = null;
    private SDocumentGraph docGraph = null;

    public DOCUMENT_STATUS mapSDocument() {
        if (this.getDocument() == null) {
            throw new PepperModuleDataException((PepperMapper)this, ERR_MSG_NO_DOCUMENT);
        }
        this.docGraph = this.getDocument().getDocumentGraph();
        if (this.docGraph == null) {
            throw new PepperModuleDataException((PepperMapper)this, ERR_MSG_EMPTY_DOCUMENT);
        }
        this.readProperties();
        TupleWriter tw = TupleConnectorFactory.fINSTANCE.createTupleWriter();
        String dirname = this.getResourceURI().toFileString();
        new File(dirname).mkdirs();
        String conllFileName = dirname + this.getDocument().getName() + "." + "txt";
        File file = new File(conllFileName);
        try {
            if (!file.exists()) {
                file.createNewFile();
            }
        }
        catch (IOException e1) {
            throw new PepperModuleException((PepperMapper)this, ERR_MSG_OUTPUT_FILE);
        }
        tw.setFile(file);
        ArrayList<String> tuple = null;
        SAnnotation anno = null;
        boolean[] onSpan = new boolean[]{this.spanAnnos.contains(this.lemmaQName), this.spanAnnos.contains(this.cposQName), this.spanAnnos.contains(this.posQName), this.spanAnnos.contains(this.featsQName), this.spanAnnos.contains(this.miscQName), this.spanAnnos.contains(this.tokinfoQName)};
        boolean searchSpan = onSpan[0] || onSpan[1] || onSpan[2] || onSpan[3] || onSpan[4] || onSpan[5];
        Set<Object> tokenSet = new HashSet();
        if (this.tokName != null) {
            List orderRelations = this.docGraph.getRelations().stream().filter(r -> r instanceof SOrderRelation).collect(Collectors.toList());
            List selectedRelations = orderRelations.stream().filter(r -> this.tokName.equals(r.getType())).collect(Collectors.toList());
            tokenSet = selectedRelations.stream().map(r -> (SToken)r.getSource()).collect(Collectors.toSet());
            tokenSet.addAll(selectedRelations.stream().map(r -> (SToken)r.getTarget()).collect(Collectors.toSet()));
            if (tokenSet.isEmpty()) {
                if (orderRelations.isEmpty()) {
                    throw new PepperModuleDataException((PepperMapper)this, "No explicit segmentations found. Try removing property segmentation.name");
                }
                HashSet b = new HashSet();
                orderRelations.stream().map(r -> r.getType()).collect(Collectors.toSet()).stream().forEach(b::add);
                throw new PepperModuleDataException((PepperMapper)this, "No segmentation with name " + this.tokName + " could be found. Valid names are: " + String.join((CharSequence)", ", b));
            }
        } else {
            tokenSet.addAll(this.docGraph.getTokens());
        }
        HashMap<SToken, Integer> token2Id = new HashMap<SToken, Integer>();
        String unitName = ((CoNLLExporterProperties)this.getProperties()).getDiscourseUnit();
        if (unitName != null) {
            for (SSpan span : this.docGraph.getSpans()) {
                if (span.getAnnotation(unitName) == null) continue;
                List overlappedTokens = this.docGraph.getOverlappedTokens((SNode)span).stream().filter(tokenSet::contains).collect(Collectors.toList());
                int i = 1;
                for (SToken tok : this.docGraph.getSortedTokenByText(overlappedTokens)) {
                    token2Id.put(tok, i++);
                }
            }
            if (token2Id.isEmpty()) {
                throw new PepperModuleDataException((PepperMapper)this, "No tokens in span group " + unitName + " on tokenization " + this.tokName + " defined.");
            }
        }
        if (token2Id.isEmpty()) {
            int i = 1;
            for (SToken tok : this.docGraph.getSortedTokenByText(tokenSet.stream().collect(Collectors.toList()))) {
                token2Id.put(tok, i++);
            }
        }
        int tokId = 0;
        for (SToken tok : this.docGraph.getSortedTokenByText(tokenSet.stream().collect(Collectors.toList()))) {
            if (unitName != null && !token2Id.containsKey(tok)) continue;
            if ((Integer)token2Id.get(tok) <= tokId) {
                try {
                    tw.addTuple(new ArrayList<String>());
                }
                catch (FileNotFoundException e) {
                    throw new PepperModuleException();
                }
            }
            tokId = (Integer)token2Id.get(tok);
            tuple = new ArrayList<String>();
            tuple.add(Integer.toString(tokId));
            tuple.add(this.docGraph.getText((SNode)tok).trim());
            SSpan span = null;
            if (!this.lemmaQName.trim().isEmpty()) {
                if (searchSpan && onSpan[0]) {
                    span = this.getAnnotatedSpan(tok, this.lemmaQName);
                    if (span != null) {
                        anno = span.getAnnotation(this.lemmaQName);
                    }
                } else {
                    anno = tok.getAnnotation(this.lemmaQName);
                }
                if (anno == null || NO_VALUE.equals(this.lemmaQName)) {
                    tuple.add(NO_VALUE);
                } else {
                    tuple.add(anno.getValue().toString());
                }
            }
            anno = null;
            if (!this.cposQName.trim().isEmpty()) {
                if (searchSpan && onSpan[1]) {
                    span = this.getAnnotatedSpan(tok, this.cposQName);
                    if (span != null) {
                        anno = span.getAnnotation(this.cposQName);
                    }
                } else {
                    anno = tok.getAnnotation(this.cposQName);
                }
                if (anno == null || NO_VALUE.equals(this.cposQName)) {
                    tuple.add(NO_VALUE);
                } else {
                    tuple.add(anno.getValue().toString());
                }
            }
            anno = null;
            if (!this.posQName.trim().isEmpty()) {
                if (searchSpan && onSpan[2]) {
                    span = this.getAnnotatedSpan(tok, this.posQName);
                    if (span != null) {
                        anno = span.getAnnotation(this.posQName);
                    }
                } else {
                    anno = tok.getAnnotation(this.posQName);
                }
                if (anno == null || NO_VALUE.equals(this.posQName)) {
                    tuple.add(NO_VALUE);
                } else {
                    tuple.add(anno.getValue().toString());
                }
            }
            anno = null;
            List<String> toFeatureNames = ((CoNLLExporterProperties)this.props).getFeatureAnnos();
            if (!this.featsQName.trim().isEmpty()) {
                ArrayList<String> kvPairs = new ArrayList<String>();
                for (String featAnnoName : toFeatureNames) {
                    SAnnotation featAnno = null;
                    if (this.spanAnnos.contains(featAnnoName)) {
                        span = this.getAnnotatedSpan(tok, featAnnoName);
                        featAnno = span == null ? null : span.getAnnotation(featAnnoName);
                    } else {
                        tok.getAnnotation(featAnnoName);
                    }
                    if (featAnno == null) continue;
                    kvPairs.add(StringUtils.join((Object[])new String[]{featAnnoName, featAnno.getValue_STEXT()}, (String)"="));
                }
                if (searchSpan && onSpan[3]) {
                    span = this.getAnnotatedSpan(tok, this.featsQName);
                    if (span != null) {
                        anno = span.getAnnotation(this.featsQName);
                    }
                } else {
                    anno = tok.getAnnotation(this.featsQName);
                }
                if ((anno == null || NO_VALUE.equals(this.featsQName)) && kvPairs.isEmpty()) {
                    kvPairs.add(NO_VALUE);
                } else if (anno != null) {
                    kvPairs.add(StringUtils.join((Object[])new String[]{this.featsQName, anno.getValue_STEXT()}, (String)"="));
                }
                tuple.add(StringUtils.join(kvPairs, (String)"|"));
            }
            anno = null;
            if (!this.dependencyQName.trim().isEmpty()) {
                List incoming = tok.getInRelations();
                boolean isDependency = false;
                SRelation next = null;
                anno = null;
                if (!incoming.isEmpty()) {
                    Iterator iter = incoming.iterator();
                    while (iter.hasNext() && !isDependency) {
                        next = (SRelation)iter.next();
                        isDependency = next.getAnnotation(this.dependencyQName) != null;
                        anno = next.getAnnotation(this.dependencyQName);
                    }
                    tuple.add(isDependency ? Integer.toString((Integer)token2Id.get(next.getSource())) : NO_VALUE);
                    tuple.add(anno == null ? NO_VALUE : (anno.getValue() == null ? NO_VALUE : anno.getValue_STEXT()));
                }
            }
            anno = null;
            if (!this.miscQName.trim().isEmpty()) {
                if (searchSpan && onSpan[4]) {
                    span = this.getAnnotatedSpan(tok, this.miscQName);
                    if (span != null) {
                        anno = span.getAnnotation(this.miscQName);
                    }
                } else {
                    anno = tok.getAnnotation(this.miscQName);
                }
                if (anno == null || NO_VALUE.equals(this.miscQName)) {
                    tuple.add(NO_VALUE);
                } else {
                    tuple.add(anno.getValue().toString());
                }
            }
            anno = null;
            if (!this.tokinfoQName.trim().isEmpty()) {
                if (searchSpan && onSpan[5]) {
                    span = this.getAnnotatedSpan(tok, this.tokinfoQName);
                    if (span != null) {
                        anno = span.getAnnotation(this.tokinfoQName);
                    }
                } else {
                    anno = tok.getAnnotation(this.tokinfoQName);
                }
                if (anno == null || NO_VALUE.equals(this.tokinfoQName)) {
                    tuple.add(NO_VALUE);
                } else {
                    tuple.add(anno.getValue().toString());
                }
            }
            try {
                tw.addTuple(tuple);
            }
            catch (FileNotFoundException e) {
                throw new PepperModuleException((PepperMapper)this, ERR_MSG_ADD_TUPLE);
            }
        }
        return DOCUMENT_STATUS.COMPLETED;
    }

    private SSpan getAnnotatedSpan(SToken tok, String annoQName) {
        SSpan span = null;
        SAnnotation anno = null;
        Iterator itRels = tok.getInRelations().iterator();
        while (anno == null && itRels.hasNext()) {
            SRelation nxtRel = (SRelation)itRels.next();
            if (!(nxtRel instanceof SSpanningRelation)) continue;
            span = (SSpan)nxtRel.getSource();
            anno = span.getAnnotation(annoQName);
        }
        return anno == null ? null : span;
    }

    private void readProperties() {
        CoNLLExporterProperties properties = (CoNLLExporterProperties)this.getProperties();
        Map<ConllDataField, String> columns = properties.getColumns();
        if (columns == null) {
            throw new PepperModuleException(ERR_MSG_WRONG_COLUMN_FORMAT);
        }
        this.tokName = properties.getSegmentationName();
        this.dependencyQName = columns.get((Object)ConllDataField.DEPREL);
        this.lemmaQName = columns.get((Object)ConllDataField.LEMMA);
        this.posQName = columns.get((Object)ConllDataField.POSTAG);
        this.cposQName = columns.get((Object)ConllDataField.CPOSTAG);
        this.featsQName = columns.get((Object)ConllDataField.FEATS);
        this.miscQName = columns.get((Object)ConllDataField.PHEAD);
        this.tokinfoQName = columns.get((Object)ConllDataField.PDEPREL);
        this.spanAnnos = properties.getSpanAnnotations();
    }
}

