/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.peppermodules.CoNLLModules;

import com.google.common.base.Joiner;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.corpus_tools.pepper.modules.PepperModuleProperties;
import org.corpus_tools.pepper.modules.PepperModuleProperty;
import org.corpus_tools.peppermodules.conll.ConllDataField;

public class CoNLLExporterProperties
extends PepperModuleProperties {
    public static final String PROP_COL_CONFIG = "cols";
    public static final String PROP_SPAN_ANNOS = "spanAnnotations";
    public static final String COLLAPSE_VALUE = " ";
    private static final String[] DEFAULTS = new String[]{"salt::lemma", "_", "salt::pos", "_", "func", "_", "_"};
    public static final String MARKER_USE_DEFAULT = "*";
    public static final String PROP_SEGMENTATION_NAME = "segmentation.name";
    public static final String PROP_DISCOURSE_UNIT_ANNO_NAME = "discourse.anno.name";
    public static final String PROP_ANNOS_AS_FEATURES = "annos.as.features";

    public CoNLLExporterProperties() {
        this.addProperty(new PepperModuleProperty(PROP_COL_CONFIG, String.class, "In this string the annotation names (and collapse instructions) for the CoNLL columns are encoded.", (Object)Joiner.on((String)",").join((Object[])DEFAULTS), false));
        this.addProperty(new PepperModuleProperty(PROP_SPAN_ANNOS, String.class, "This property contains all the annotations that will be found on spans over the tokens, but not the token itself.", (Object)"", false));
        this.addProperty(new PepperModuleProperty(PROP_SEGMENTATION_NAME, String.class, "If provided, a specific segmentation is selected rather than all tokens found in a document. The segmentation needs to be marked with SOrderRelations with the specified name.", null, false));
        this.addProperty(PepperModuleProperty.create().withName(PROP_DISCOURSE_UNIT_ANNO_NAME).withType(String.class).withDescription("Provide an annotation name that marks sentence spans (or another discourse unit to mark sentences in conll). The annotation is expected to be a span annotation. If a token is not covered by a sentence span, but nevertheless contained in a selected segmentation, it will be ignored.").isRequired(false).build());
        this.addProperty(PepperModuleProperty.create().withName(PROP_ANNOS_AS_FEATURES).withType(String.class).withDescription("The annotations listed in csv-style will be exported into CoNLLs feature column as \"KEY=VALUE\"-pairs.").isRequired(false).build());
    }

    public Map<ConllDataField, String> getColumns() {
        String columnStr = this.getProperty(PROP_COL_CONFIG).getValue().toString();
        String[] columns = columnStr.split(",");
        ConllDataField[] header = new ConllDataField[]{ConllDataField.LEMMA, ConllDataField.CPOSTAG, ConllDataField.POSTAG, ConllDataField.FEATS, ConllDataField.DEPREL, ConllDataField.PHEAD, ConllDataField.PDEPREL};
        HashMap<ConllDataField, String> colInfo = new HashMap<ConllDataField, String>();
        for (int i = 0; i < columns.length; ++i) {
            colInfo.put(header[i], MARKER_USE_DEFAULT.equals(columns[i]) ? DEFAULTS[i] : columns[i]);
        }
        if (columns.length < 7) {
            if (columns.length < 6) {
                return null;
            }
            colInfo.put(header[header.length - 1], COLLAPSE_VALUE);
        }
        return colInfo;
    }

    public Set<String> getSpanAnnotations() {
        HashSet<String> spanAnnos = new HashSet<String>();
        String propVal = this.getProperty(PROP_SPAN_ANNOS).getValue().toString();
        if (propVal.startsWith("{")) {
            propVal = propVal.substring(1);
        }
        if (propVal.endsWith("}")) {
            propVal = propVal.substring(0, propVal.length() - 1);
        }
        for (String a : propVal.split(",")) {
            spanAnnos.add(a.trim());
        }
        return spanAnnos;
    }

    public String getSegmentationName() {
        Object value = this.getProperty(PROP_SEGMENTATION_NAME).getValue();
        if (value != null) {
            return (String)value;
        }
        return null;
    }

    public String getDiscourseUnit() {
        Object value = this.getProperty(PROP_DISCOURSE_UNIT_ANNO_NAME).getValue();
        return value == null ? null : (String)value;
    }

    public List<String> getFeatureAnnos() {
        Object value = this.getProperty(PROP_ANNOS_AS_FEATURES).getValue();
        if (value == null) {
            return Collections.emptyList();
        }
        String input = ((String)value).replaceAll("\\{|\\}", "");
        return Arrays.asList(input.split("(( )+)?,(( )+)?"));
    }
}

