/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.peppermodules.conll;

import java.util.ArrayList;

public enum ConllDataField {
    ID(1, true),
    FORM(2, true),
    LEMMA(3, false, "_"),
    CPOSTAG(4, false, "_"),
    POSTAG(5, false, "_"),
    FEATS(6, false, "_"),
    HEAD(7, true),
    DEPREL(8, false, "_"),
    PHEAD(9, false, "_"),
    PDEPREL(10, false, "_");

    private final int fieldNum;
    private final boolean mandatory;
    private final String dummyValue;
    private static String[] names;

    private ConllDataField(int fieldNum, boolean mandatory) {
        this(fieldNum, mandatory, "");
    }

    private ConllDataField(int fieldNum, boolean mandatory, String dummyValue) {
        this.fieldNum = fieldNum;
        this.mandatory = mandatory;
        this.dummyValue = dummyValue;
    }

    public int getFieldNum() {
        return this.fieldNum;
    }

    public boolean isMandatory() {
        return this.mandatory;
    }

    public String getDummyValue() {
        return this.dummyValue;
    }

    public static String[] getNames() {
        if (names == null) {
            ArrayList<String> namesList = new ArrayList<String>();
            for (ConllDataField field : ConllDataField.values()) {
                namesList.add(field.name());
            }
            names = (String[])namesList.toArray();
        }
        return names;
    }

    public String getPropertyKey_Name() {
        return ConllDataField.getPropertyKey_Name_byFieldNum(this.fieldNum);
    }

    public static ConllDataField getFieldByNum(int fieldNum) {
        if (fieldNum > 0 && fieldNum <= ConllDataField.values().length) {
            return ConllDataField.values()[fieldNum - 1];
        }
        return null;
    }

    public static String getPropertyKey_Name_byFieldNum(int fieldNum) {
        return "conll.field" + fieldNum + ".name";
    }

    static {
        names = null;
    }
}

