/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.peppermodules.CoNLLModules;

import com.google.common.base.Joiner;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.corpus_tools.pepper.modules.PepperModuleProperties;
import org.corpus_tools.pepper.modules.PepperModuleProperty;
import org.corpus_tools.peppermodules.conll.ConllDataField;

public class CoNLLExporterProperties
extends PepperModuleProperties {
    public static final String PROP_COL_CONFIG = "cols";
    public static final String PROP_SPAN_ANNOS = "spanAnnotations";
    public static final String COLLAPSE_VALUE = " ";
    private static final String[] DEFAULTS = new String[]{"salt::lemma", "_", "salt::pos", "_", "func", "_", "_"};
    public static final String MARKER_USE_DEFAULT = "*";

    public CoNLLExporterProperties() {
        this.addProperty(new PepperModuleProperty(PROP_COL_CONFIG, String.class, "In this string the annotation names (and collapse instructions) for the CoNLL columns are encoded.", (Object)Joiner.on((String)",").join((Object[])DEFAULTS), false));
        this.addProperty(new PepperModuleProperty(PROP_SPAN_ANNOS, String.class, "This property contains all the annotations that will be found on spans over the tokens, but not the token itself.", (Object)"", false));
    }

    public Map<ConllDataField, String> getColumns() {
        String columnStr = this.getProperty(PROP_COL_CONFIG).getValue().toString();
        String[] columns = columnStr.split(",");
        ConllDataField[] header = new ConllDataField[]{ConllDataField.LEMMA, ConllDataField.CPOSTAG, ConllDataField.POSTAG, ConllDataField.FEATS, ConllDataField.DEPREL, ConllDataField.PHEAD, ConllDataField.PDEPREL};
        HashMap<ConllDataField, String> colInfo = new HashMap<ConllDataField, String>();
        for (int i = 0; i < columns.length; ++i) {
            colInfo.put(header[i], MARKER_USE_DEFAULT.equals(columns[i]) ? DEFAULTS[i] : columns[i]);
        }
        if (columns.length < 7) {
            if (columns.length < 6) {
                return null;
            }
            colInfo.put(header[header.length - 1], COLLAPSE_VALUE);
        }
        return colInfo;
    }

    public Set<String> getSpanAnnotations() {
        HashSet<String> spanAnnos = new HashSet<String>();
        String propVal = this.getProperty(PROP_SPAN_ANNOS).getValue().toString();
        if (propVal.startsWith("{")) {
            propVal = propVal.substring(1);
        }
        if (propVal.endsWith("}")) {
            propVal = propVal.substring(0, propVal.length() - 1);
        }
        for (String a : propVal.split(",")) {
            spanAnnos.add(a.trim());
        }
        return spanAnnos;
    }
}

