/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.peppermodules.conll;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.corpus_tools.pepper.common.DOCUMENT_STATUS;
import org.corpus_tools.pepper.impl.PepperMapperImpl;
import org.corpus_tools.pepper.modules.PepperMapper;
import org.corpus_tools.pepper.modules.exceptions.PepperModuleDataException;
import org.corpus_tools.peppermodules.CoNLLModules.CoNLLImporterProperties;
import org.corpus_tools.peppermodules.conll.ConllDataField;
import org.corpus_tools.peppermodules.conll.tupleconnector.TupleConnectorFactory;
import org.corpus_tools.peppermodules.conll.tupleconnector.TupleReader;
import org.corpus_tools.salt.SaltFactory;
import org.corpus_tools.salt.common.SPointingRelation;
import org.corpus_tools.salt.common.SSpan;
import org.corpus_tools.salt.common.STextualDS;
import org.corpus_tools.salt.common.STextualRelation;
import org.corpus_tools.salt.common.SToken;
import org.corpus_tools.salt.core.SAnnotation;
import org.corpus_tools.salt.graph.Graph;
import org.corpus_tools.salt.graph.Node;
import org.corpus_tools.salt.semantics.SLemmaAnnotation;
import org.corpus_tools.salt.semantics.SPOSAnnotation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Conll2SaltMapper
extends PepperMapperImpl {
    private static final Logger logger = LoggerFactory.getLogger(Conll2SaltMapper.class);
    private ConllDataField firstSPOSField = null;
    private ConllDataField secondSPOSField = null;
    private final ConllDataField DEFAULT_SPOS = ConllDataField.POSTAG;
    private static final String PROJECTIVE = "projective";
    private static final String PRODEP = "prodep";
    private static final String DEP = "dep";
    private static final String DEPREL = "deprel";
    private static final String CAT = "cat";
    private static final String S = "S";
    public static final String TRUE = "true";
    public static final String FALSE = "false";
    public static final String TYPE = "TYPE";
    public static final String NAMESPACE = "NAMESPACE";
    public static final String DEFAULT_FEATURE = "morph";
    private final String FEATURESEPARATOR = "\\|";
    boolean splitFeatures;
    boolean useSLemmaAnnotation;
    boolean useSPOSAnnotation;

    public Conll2SaltMapper() {
        this.setProperties(new CoNLLImporterProperties());
    }

    private boolean getSplitFeatures() {
        return (Boolean)this.getProperties().getProperty("conll.splitFeatures").getValue();
    }

    private boolean getUseSLemmaAnnotation() {
        String propVal = (String)this.getProperties().getProperty("conll.SLEMMA").getValue();
        if (propVal.equals("LEMMA")) {
            return true;
        }
        if (propVal.equals("NONE")) {
            return false;
        }
        logger.warn(String.format("Invalid value '%s' for property '%s'. Default value '%s' is used.", propVal, "conll.SLEMMA", "LEMMA"));
        return true;
    }

    private boolean getUseSPOSAnnotation() {
        String val;
        this.firstSPOSField = null;
        this.secondSPOSField = null;
        if (this.getProperties().getProperty("conll.SPOS") == null) {
            this.firstSPOSField = this.DEFAULT_SPOS;
            return true;
        }
        String propVal = (String)this.getProperties().getProperty("conll.SPOS").getValue();
        String[] propVals = propVal.split(",");
        if (propVals.length > 2) {
            logger.warn(String.format("Found '%s' for property '%s'. Only two values are regarded, the rest will be ignored.", propVal, "conll.SPOS"));
        }
        if (propVals.length > 1 && propVals[0].equals("NONE")) {
            logger.warn(String.format("Found '%s' for property '%s'. With this setting, no SPOSAnnotation will ever be created.", propVal, "conll.SPOS"));
        }
        if ((val = propVals[0].trim()).equals("NONE")) {
            return false;
        }
        if (val.equals("POSTAG") || val.equals("CPOSTAG")) {
            if (val.equals("POSTAG")) {
                this.firstSPOSField = ConllDataField.POSTAG;
            } else if (val.equals("CPOSTAG")) {
                this.firstSPOSField = ConllDataField.CPOSTAG;
            }
        } else if (propVals.length == 1) {
            logger.warn(String.format("Invalid value '%s' for property '%s'. Using default value.", val, "conll.SPOS"));
            this.firstSPOSField = this.DEFAULT_SPOS;
        } else {
            logger.warn(String.format("Invalid value '%s' for property '%s'. Using alternative value.", val, "conll.SPOS"));
        }
        if (propVals.length >= 2 && !(val = propVals[1].trim()).equals("NONE")) {
            if (val.equals("POSTAG") || val.equals("CPOSTAG")) {
                ConllDataField field = null;
                if (val.equals("POSTAG")) {
                    field = ConllDataField.POSTAG;
                } else if (val.equals("CPOSTAG")) {
                    field = ConllDataField.CPOSTAG;
                }
                if (this.firstSPOSField == null) {
                    this.firstSPOSField = field;
                } else {
                    this.secondSPOSField = field;
                }
            } else if (this.firstSPOSField == null) {
                logger.warn(String.format("Invalid alternative value '%s' for property '%s'. Using default value.", val, "conll.SPOS"));
                this.firstSPOSField = this.DEFAULT_SPOS;
            } else {
                logger.warn(String.format("Invalid alternative value '%s' for property '%s'.", val, "conll.SPOS"));
            }
        }
        return this.firstSPOSField != null;
    }

    private void createPOSandCPOSAnnotation(ArrayList<String> fieldValues, SToken sToken) {
        if (!this.useSPOSAnnotation) {
            ConllDataField[] posFields = new ConllDataField[]{ConllDataField.POSTAG, ConllDataField.CPOSTAG};
            for (int index = 0; index < posFields.length; ++index) {
                ConllDataField field = posFields[index];
                String fieldValue = fieldValues.get(field.getFieldNum() - 1);
                if (fieldValue == null) continue;
                SAnnotation sAnnotation = SaltFactory.createSAnnotation();
                sAnnotation.setName(this.getProperties().getProperties().getProperty(field.getPropertyKey_Name(), field.name()));
                sAnnotation.setValue((Object)fieldValue);
                sToken.addAnnotation(sAnnotation);
            }
        } else {
            SPOSAnnotation anno;
            String fieldVal;
            int index;
            int SPOSAnnotationIndex = -1;
            ConllDataField[] bothFields = new ConllDataField[]{this.firstSPOSField, this.secondSPOSField};
            ConllDataField field = null;
            for (index = 0; index < bothFields.length; ++index) {
                if (SPOSAnnotationIndex != -1 || (field = bothFields[index]) == null || (fieldVal = fieldValues.get(field.getFieldNum() - 1)) == null) continue;
                anno = SaltFactory.createSPOSAnnotation();
                anno.setValue((Object)fieldVal);
                sToken.addAnnotation((SAnnotation)anno);
                SPOSAnnotationIndex = index;
            }
            for (index = 0; index < bothFields.length; ++index) {
                if (SPOSAnnotationIndex == index || (field = bothFields[index]) == null || (fieldVal = fieldValues.get(field.getFieldNum() - 1)) == null) continue;
                anno = SaltFactory.createSAnnotation();
                anno.setName(this.getProperties().getProperties().getProperty(field.getPropertyKey_Name(), field.name()));
                anno.setValue((Object)fieldVal);
                sToken.addAnnotation((SAnnotation)anno);
                SPOSAnnotationIndex = index;
            }
        }
    }

    public DOCUMENT_STATUS mapSDocument() {
        if (this.getDocument().getDocumentGraph() == null) {
            this.getDocument().setDocumentGraph(SaltFactory.createSDocumentGraph());
        }
        TupleReader tupleReader = TupleConnectorFactory.fINSTANCE.createTupleReader();
        try {
            tupleReader.setFile(new File(this.getResourceURI().toFileString()));
            tupleReader.readFile();
        }
        catch (IOException e) {
            String errorMessage = "input file could not be read. Abort conversion of file " + this.getResourceURI() + ".";
            logger.error(errorMessage);
            throw new PepperModuleDataException((PepperMapper)this, errorMessage);
        }
        STextualDS sTextualDS = SaltFactory.createSTextualDS();
        sTextualDS.setGraph((Graph)this.getDocument().getDocumentGraph());
        ArrayList<SToken> tokenList = new ArrayList<SToken>();
        HashMap<SPointingRelation, Integer> pointingRelationMap = new HashMap<SPointingRelation, Integer>();
        ArrayList<String> fieldValues = new ArrayList<String>();
        Collection<String> tuple = null;
        int numOfTuples = tupleReader.getNumOfTuples();
        int lastTupleIndex = numOfTuples - 1;
        int tupleSize = 0;
        int numOfColumnsExpected = ConllDataField.values().length;
        int fieldNum = 1;
        this.useSLemmaAnnotation = this.getUseSLemmaAnnotation();
        this.useSPOSAnnotation = this.getUseSPOSAnnotation();
        this.splitFeatures = this.getSplitFeatures();
        boolean considerProjectivity = !this.getProperties().getProperties().getProperty("conll.projectiveMode", TRUE).equalsIgnoreCase(TRUE);
        boolean projectiveModeIsType = !this.getProperties().getProperties().getProperty("conll.projectiveMode", TYPE).equalsIgnoreCase(NAMESPACE);
        ArrayList<Integer> nonMatchingCategoryNumberLines = new ArrayList<Integer>();
        int stringBuilderCharBufferSize = tupleReader.characterSize(ConllDataField.FORM.getFieldNum() - 1) + numOfTuples;
        StringBuilder primaryText = new StringBuilder(stringBuilderCharBufferSize);
        LinkedList<SToken> sentenceToken = new LinkedList<SToken>();
        for (int rowIndex = 0; rowIndex < numOfTuples; ++rowIndex) {
            try {
                tuple = tupleReader.getTuple();
            }
            catch (IOException e) {
                String errorMessage = String.format("line %d of input file could not be read. Abort conversion of file " + this.getResourceURI() + ".", rowIndex + 1);
                throw new PepperModuleDataException((PepperMapper)this, errorMessage);
            }
            tupleSize = tuple.size();
            fieldValues.clear();
            if (tupleSize != 1 && tupleSize != numOfColumnsExpected) {
                String errorMessage = String.format("invalid format in line %d of input file. lines must be empty or contain %d columns of data. Abort conversion of file " + this.getResourceURI() + ".", rowIndex + 1, numOfColumnsExpected);
                throw new PepperModuleDataException((PepperMapper)this, errorMessage);
            }
            if (tupleSize > 1) {
                fieldNum = 1;
                Iterator<String> iter = tuple.iterator();
                while (iter.hasNext()) {
                    ConllDataField field = ConllDataField.getFieldByNum(fieldNum);
                    String fieldValue = iter.next();
                    if (fieldValue.equals(field.getDummyValue())) {
                        fieldValue = null;
                        if (field.isMandatory()) {
                            String errorMessage = String.format("mandatory value for %s missing in line %d of input file '" + this.getResourceURI() + "'!", field.toString(), rowIndex + 1);
                            throw new PepperModuleDataException((PepperMapper)this, errorMessage);
                        }
                    }
                    fieldValues.add(fieldValue);
                    ++fieldNum;
                }
                SToken sToken = SaltFactory.createSToken();
                sToken.setGraph((Graph)this.getDocument().getDocumentGraph());
                tokenList.add(sToken);
                int tokenTextStartOffset = primaryText.length();
                primaryText.append((String)fieldValues.get(ConllDataField.FORM.getFieldNum() - 1)).append(" ");
                int tokenTextEndOffset = primaryText.length() - 1;
                STextualRelation sTextualRelation = SaltFactory.createSTextualRelation();
                sTextualRelation.setSource((Node)sToken);
                sTextualRelation.setTarget((Node)sTextualDS);
                sTextualRelation.setStart((Number)tokenTextStartOffset);
                sTextualRelation.setEnd((Number)tokenTextEndOffset);
                sTextualRelation.setGraph((Graph)this.getDocument().getDocumentGraph());
                sentenceToken.add(sToken);
                ConllDataField field = ConllDataField.LEMMA;
                String fieldValue = (String)fieldValues.get(field.getFieldNum() - 1);
                if (fieldValue != null) {
                    SLemmaAnnotation sAnnotation = null;
                    if (this.useSLemmaAnnotation) {
                        sAnnotation = SaltFactory.createSLemmaAnnotation();
                    } else {
                        sAnnotation = SaltFactory.createSAnnotation();
                        sAnnotation.setName(this.getProperties().getProperties().getProperty(field.getPropertyKey_Name(), field.name()));
                    }
                    sAnnotation.setValue((Object)fieldValue);
                    sToken.addAnnotation((SAnnotation)sAnnotation);
                }
                this.createPOSandCPOSAnnotation(fieldValues, sToken);
                String featureValue = fieldValues.get(ConllDataField.FEATS.getFieldNum() - 1);
                if (featureValue != null && featureValue.length() > 0) {
                    String ruleKey = "conll.field6.POSTAG." + fieldValues.get(ConllDataField.POSTAG.getFieldNum() - 1);
                    if (!this.getProperties().getProperties().containsKey(ruleKey)) {
                        ruleKey = "conll.field6.CPOSTAG." + fieldValues.get(ConllDataField.CPOSTAG.getFieldNum() - 1);
                        if (!this.getProperties().getProperties().containsKey(ruleKey)) {
                            ruleKey = "conll.field6.default";
                        }
                    }
                    String featureKey = this.getProperties().getProperties().getProperty(ruleKey, DEFAULT_FEATURE);
                    boolean doSplit = this.splitFeatures;
                    String[] featureKeys = null;
                    if (doSplit) {
                        featureKeys = featureKey.split("\\|");
                        if (ruleKey == "conll.field6.default") {
                            boolean bl = doSplit = featureKeys.length > 1;
                        }
                    }
                    if (doSplit) {
                        String[] featureValues = featureValue.split("\\|");
                        for (int idx = 0; idx < Math.min(featureKeys.length, featureValues.length); ++idx) {
                            sToken.createAnnotation(null, featureKeys[idx], (Object)featureValues[idx]);
                        }
                        if (featureKeys.length != featureValues.length) {
                            nonMatchingCategoryNumberLines.add(rowIndex + 1);
                        }
                    } else {
                        sToken.createAnnotation(null, featureKey, (Object)featureValue);
                    }
                }
                String tokenIDStr = fieldValues.get(ConllDataField.ID.getFieldNum() - 1);
                Integer tokenID = null;
                try {
                    tokenID = Integer.parseInt(tokenIDStr);
                }
                catch (NumberFormatException e) {
                    String errorMessage = String.format("Invalid integer value '%s' for ID in line %d of input file. Abort conversion of file " + this.getResourceURI() + ".", tokenIDStr, rowIndex + 1);
                    throw new PepperModuleDataException((PepperMapper)this, errorMessage);
                }
                String headIDStr = fieldValues.get(ConllDataField.HEAD.getFieldNum() - 1);
                Integer headID = null;
                try {
                    headID = Integer.parseInt(headIDStr);
                }
                catch (NumberFormatException e) {
                    String errorMessage = String.format("Invalid integer value '%s' for HEAD in line %d of input file '" + this.getResourceURI() + "'. Abort conversion of file " + this.getResourceURI() + ".", headIDStr, rowIndex + 1);
                    throw new PepperModuleDataException((PepperMapper)this, errorMessage);
                }
                if (headID > 0) {
                    SAnnotation sAnnotation = SaltFactory.createSAnnotation();
                    sAnnotation.setName(DEPREL);
                    String annoValue = fieldValues.get(ConllDataField.DEPREL.getFieldNum() - 1);
                    sAnnotation.setValue((Object)annoValue);
                    SPointingRelation sPointingRelation = SaltFactory.createSPointingRelation();
                    sPointingRelation.setType(DEP);
                    sPointingRelation.setSource((Node)sToken);
                    sPointingRelation.setTarget((Node)sToken);
                    sPointingRelation.addAnnotation(sAnnotation);
                    sPointingRelation.setGraph((Graph)this.getDocument().getDocumentGraph());
                    if (headID <= tokenID) {
                        sPointingRelation.setSource((Node)tokenList.get(headID - 1));
                    } else {
                        pointingRelationMap.put(sPointingRelation, headID);
                    }
                }
                if (considerProjectivity) {
                    String proheadIDStr = fieldValues.get(ConllDataField.PHEAD.getFieldNum() - 1);
                    Integer proheadID = null;
                    try {
                        proheadID = Integer.parseInt(proheadIDStr);
                    }
                    catch (NumberFormatException e) {
                        String errorMessage = String.format("invalid integer value '%s' for PHEAD in line %d of input file. Abort conversion of file " + this.getResourceURI() + ".", proheadIDStr, rowIndex + 1);
                        throw new PepperModuleDataException((PepperMapper)this, errorMessage);
                    }
                    if (proheadID > 0) {
                        SAnnotation sAnnotation = SaltFactory.createSAnnotation();
                        sAnnotation.setName(DEPREL);
                        sAnnotation.setValue((Object)fieldValues.get(ConllDataField.PDEPREL.getFieldNum() - 1));
                        SPointingRelation sPointingRelation = SaltFactory.createSPointingRelation();
                        sPointingRelation.addAnnotation(sAnnotation);
                        sPointingRelation.setSource((Node)sToken);
                        sPointingRelation.setTarget((Node)sToken);
                        sPointingRelation.setGraph((Graph)this.getDocument().getDocumentGraph());
                        if (projectiveModeIsType) {
                            sPointingRelation.setType(PRODEP);
                        } else {
                            sAnnotation.setNamespace(PROJECTIVE);
                            sPointingRelation.setType(DEP);
                        }
                        if (proheadID <= tokenID) {
                            sPointingRelation.setSource((Node)tokenList.get(proheadID - 1));
                        } else {
                            pointingRelationMap.put(sPointingRelation, proheadID);
                        }
                    }
                }
            } else {
                if (!sentenceToken.isEmpty() && ((CoNLLImporterProperties)this.getProperties()).isSentence().booleanValue()) {
                    SSpan sSpan = this.getDocument().getDocumentGraph().createSpan(sentenceToken);
                    sSpan.createAnnotation(null, CAT, (Object)S);
                }
                sentenceToken.clear();
            }
            if (tupleSize != 1 && rowIndex != lastTupleIndex) continue;
            for (Map.Entry entry : pointingRelationMap.entrySet()) {
                ((SPointingRelation)entry.getKey()).setSource((Node)tokenList.get((Integer)entry.getValue() - 1));
            }
            tokenList.clear();
            pointingRelationMap.clear();
        }
        if (!sentenceToken.isEmpty() && ((CoNLLImporterProperties)this.getProperties()).isSentence().booleanValue()) {
            SSpan sSpan = this.getDocument().getDocumentGraph().createSpan(sentenceToken);
            sSpan.createAnnotation(null, CAT, (Object)S);
        }
        primaryText.deleteCharAt(primaryText.length() - 1);
        sTextualDS.setText(primaryText.toString());
        if (nonMatchingCategoryNumberLines.size() > 0) {
            logger.warn("Number of feature values doesn't match number of categories in lines: " + nonMatchingCategoryNumberLines.toString());
        }
        return DOCUMENT_STATUS.COMPLETED;
    }
}

