/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.peppermodules.conll;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.corpus_tools.pepper.common.DOCUMENT_STATUS;
import org.corpus_tools.pepper.impl.PepperMapperImpl;
import org.corpus_tools.pepper.modules.PepperMapper;
import org.corpus_tools.pepper.modules.exceptions.PepperModuleDataException;
import org.corpus_tools.pepper.modules.exceptions.PepperModuleException;
import org.corpus_tools.peppermodules.CoNLLModules.CoNLLExporterProperties;
import org.corpus_tools.peppermodules.conll.ConllDataField;
import org.corpus_tools.peppermodules.conll.tupleconnector.TupleConnectorFactory;
import org.corpus_tools.peppermodules.conll.tupleconnector.TupleWriter;
import org.corpus_tools.salt.common.SDocumentGraph;
import org.corpus_tools.salt.common.SSpan;
import org.corpus_tools.salt.common.SSpanningRelation;
import org.corpus_tools.salt.common.SToken;
import org.corpus_tools.salt.core.SAnnotation;
import org.corpus_tools.salt.core.SNode;
import org.corpus_tools.salt.core.SRelation;

public class Salt2ConllMapper
extends PepperMapperImpl
implements PepperMapper {
    private static final String ERR_MSG_NO_DOCUMENT = "No document to convert.";
    private static final String ERR_MSG_EMPTY_DOCUMENT = "Document is empty.";
    private static final String NO_VALUE = "_";
    private static final String ERR_MSG_ADD_TUPLE = "There was an error adding a tuple to the tuplewriter.";
    private static final String ERR_MSG_OUTPUT_FILE = "An error occured creating the output file";
    private static final String ERR_MSG_WRONG_COLUMN_FORMAT = "The column configuration provided in the job configuration does not match. Make sure you use the right number of columns and you mark collapsing correctly.";
    private String dependencyQName = null;
    private String lemmaQName = null;
    private String posQName = null;
    private String cposQName = null;
    private String featsQName = null;
    private String miscQName = null;
    private String tokinfoQName = null;
    private Set<String> spanAnnos = null;
    private SDocumentGraph docGraph = null;

    public DOCUMENT_STATUS mapSDocument() {
        if (this.getDocument() == null) {
            throw new PepperModuleDataException((PepperMapper)this, ERR_MSG_NO_DOCUMENT);
        }
        this.docGraph = this.getDocument().getDocumentGraph();
        if (this.docGraph == null) {
            throw new PepperModuleDataException((PepperMapper)this, ERR_MSG_EMPTY_DOCUMENT);
        }
        this.readProperties();
        TupleWriter tw = TupleConnectorFactory.fINSTANCE.createTupleWriter();
        String dirname = this.getResourceURI().toFileString();
        new File(dirname).mkdirs();
        String conllFileName = dirname + this.getDocument().getName() + "." + "txt";
        File file = new File(conllFileName);
        try {
            if (!file.exists()) {
                file.createNewFile();
            }
        }
        catch (IOException e1) {
            throw new PepperModuleException((PepperMapper)this, ERR_MSG_OUTPUT_FILE);
        }
        tw.setFile(file);
        ArrayList<String> tuple = null;
        SAnnotation anno = null;
        boolean[] onSpan = new boolean[]{this.spanAnnos.contains(this.lemmaQName), this.spanAnnos.contains(this.cposQName), this.spanAnnos.contains(this.posQName), this.spanAnnos.contains(this.featsQName), this.spanAnnos.contains(this.miscQName), this.spanAnnos.contains(this.tokinfoQName)};
        boolean searchSpan = onSpan[0] || onSpan[1] || onSpan[2] || onSpan[3] || onSpan[4] || onSpan[5];
        for (SToken tok : this.docGraph.getSortedTokenByText()) {
            tuple = new ArrayList<String>();
            tuple.add(tok.getName().replaceAll("[^0-9]", ""));
            tuple.add(this.docGraph.getText((SNode)tok));
            SSpan span = null;
            if (!this.lemmaQName.trim().isEmpty()) {
                if (searchSpan && onSpan[0]) {
                    span = this.getAnnotatedSpan(tok, this.lemmaQName);
                    if (span != null) {
                        anno = span.getAnnotation(this.lemmaQName);
                    }
                } else {
                    anno = tok.getAnnotation(this.lemmaQName);
                }
                if (anno == null || NO_VALUE.equals(this.lemmaQName)) {
                    tuple.add(NO_VALUE);
                } else {
                    tuple.add(anno.getValue().toString());
                }
            }
            anno = null;
            if (!this.cposQName.trim().isEmpty()) {
                if (searchSpan && onSpan[1]) {
                    span = this.getAnnotatedSpan(tok, this.cposQName);
                    if (span != null) {
                        anno = span.getAnnotation(this.cposQName);
                    }
                } else {
                    anno = tok.getAnnotation(this.cposQName);
                }
                if (anno == null || NO_VALUE.equals(this.cposQName)) {
                    tuple.add(NO_VALUE);
                } else {
                    tuple.add(anno.getValue().toString());
                }
            }
            anno = null;
            if (!this.posQName.trim().isEmpty()) {
                if (searchSpan && onSpan[2]) {
                    span = this.getAnnotatedSpan(tok, this.posQName);
                    if (span != null) {
                        anno = span.getAnnotation(this.posQName);
                    }
                } else {
                    anno = tok.getAnnotation(this.posQName);
                }
                if (anno == null || NO_VALUE.equals(this.posQName)) {
                    tuple.add(NO_VALUE);
                } else {
                    tuple.add(anno.getValue().toString());
                }
            }
            anno = null;
            if (!this.featsQName.trim().isEmpty()) {
                if (searchSpan && onSpan[3]) {
                    span = this.getAnnotatedSpan(tok, this.featsQName);
                    if (span != null) {
                        anno = span.getAnnotation(this.featsQName);
                    }
                } else {
                    anno = tok.getAnnotation(this.featsQName);
                }
                if (anno == null || NO_VALUE.equals(this.featsQName)) {
                    tuple.add(NO_VALUE);
                } else {
                    tuple.add(anno.getValue().toString());
                }
            }
            anno = null;
            if (!this.dependencyQName.trim().isEmpty()) {
                List incoming = tok.getInRelations();
                boolean isDependency = false;
                SRelation next = null;
                anno = null;
                if (!incoming.isEmpty()) {
                    Iterator iter = incoming.iterator();
                    while (iter.hasNext() && !isDependency) {
                        next = (SRelation)iter.next();
                        isDependency = next.getAnnotation(this.dependencyQName) != null;
                        anno = next.getAnnotation(this.dependencyQName);
                    }
                    tuple.add(isDependency ? ((SToken)next.getSource()).getName().replaceAll("[^0-9]", "") : NO_VALUE);
                    tuple.add(anno == null ? NO_VALUE : (anno.getValue() == null ? NO_VALUE : anno.getValue_STEXT()));
                }
            }
            anno = null;
            if (!this.miscQName.trim().isEmpty()) {
                if (searchSpan && onSpan[4]) {
                    span = this.getAnnotatedSpan(tok, this.miscQName);
                    if (span != null) {
                        anno = span.getAnnotation(this.miscQName);
                    }
                } else {
                    anno = tok.getAnnotation(this.miscQName);
                }
                if (anno == null || NO_VALUE.equals(this.miscQName)) {
                    tuple.add(NO_VALUE);
                } else {
                    tuple.add(anno.getValue().toString());
                }
            }
            anno = null;
            if (!this.tokinfoQName.trim().isEmpty()) {
                if (searchSpan && onSpan[5]) {
                    span = this.getAnnotatedSpan(tok, this.tokinfoQName);
                    if (span != null) {
                        anno = span.getAnnotation(this.tokinfoQName);
                    }
                } else {
                    anno = tok.getAnnotation(this.tokinfoQName);
                }
                if (anno == null || NO_VALUE.equals(this.tokinfoQName)) {
                    tuple.add(NO_VALUE);
                } else {
                    tuple.add(anno.getValue().toString());
                }
            }
            try {
                tw.addTuple(tuple);
            }
            catch (FileNotFoundException e) {
                throw new PepperModuleException((PepperMapper)this, ERR_MSG_ADD_TUPLE);
            }
        }
        return DOCUMENT_STATUS.COMPLETED;
    }

    private SSpan getAnnotatedSpan(SToken tok, String annoQName) {
        SSpan span = null;
        SAnnotation anno = null;
        Iterator itRels = tok.getInRelations().iterator();
        while (anno == null && itRels.hasNext()) {
            SRelation nxtRel = (SRelation)itRels.next();
            if (!(nxtRel instanceof SSpanningRelation)) continue;
            span = (SSpan)nxtRel.getSource();
            anno = span.getAnnotation(annoQName);
        }
        return anno == null ? null : span;
    }

    private void readProperties() {
        CoNLLExporterProperties properties = (CoNLLExporterProperties)this.getProperties();
        Map<ConllDataField, String> columns = properties.getColumns();
        if (columns == null) {
            throw new PepperModuleException(ERR_MSG_WRONG_COLUMN_FORMAT);
        }
        this.dependencyQName = columns.get((Object)ConllDataField.DEPREL);
        this.lemmaQName = columns.get((Object)ConllDataField.LEMMA);
        this.posQName = columns.get((Object)ConllDataField.POSTAG);
        this.cposQName = columns.get((Object)ConllDataField.CPOSTAG);
        this.featsQName = columns.get((Object)ConllDataField.FEATS);
        this.miscQName = columns.get((Object)ConllDataField.PHEAD);
        this.tokinfoQName = columns.get((Object)ConllDataField.PDEPREL);
        this.spanAnnos = properties.getSpanAnnotations();
    }
}

