/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.pepperModules_CoNLLCorefModules;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.corpus_tools.pepper.common.DOCUMENT_STATUS;
import org.corpus_tools.pepper.impl.PepperMapperImpl;
import org.corpus_tools.pepper.modules.PepperMapper;
import org.corpus_tools.pepper.modules.exceptions.PepperModuleDataException;
import org.corpus_tools.pepperModules_CoNLLCorefModules.CoNLLCorefImporterProperties;
import org.corpus_tools.pepperModules_CoNLLCorefModules.CoNLLCorefMarkable;
import org.corpus_tools.pepperModules_CoNLLCorefModules.DefaultDict;
import org.corpus_tools.peppermodules.conll.tupleconnector.TupleConnectorFactory;
import org.corpus_tools.peppermodules.conll.tupleconnector.TupleReader;
import org.corpus_tools.salt.SaltFactory;
import org.corpus_tools.salt.common.SPointingRelation;
import org.corpus_tools.salt.common.SSpan;
import org.corpus_tools.salt.common.STextualDS;
import org.corpus_tools.salt.common.STextualRelation;
import org.corpus_tools.salt.common.SToken;
import org.corpus_tools.salt.core.SAnnotation;
import org.corpus_tools.salt.core.SLayer;
import org.corpus_tools.salt.graph.Graph;
import org.corpus_tools.salt.graph.Layer;
import org.corpus_tools.salt.graph.Node;
import org.corpus_tools.salt.graph.Relation;
import org.eclipse.emf.common.util.URI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoNLLCoref2SaltMapper
extends PepperMapperImpl {
    private String namespace;
    private String relType;
    private String annoName;
    private String annoVal;
    private SLayer layer;
    private static final Logger logger = LoggerFactory.getLogger(CoNLLCoref2SaltMapper.class);

    public CoNLLCoref2SaltMapper() {
        this.setProperties(new CoNLLCorefImporterProperties());
    }

    public DOCUMENT_STATUS mapSCorpus() {
        return DOCUMENT_STATUS.COMPLETED;
    }

    public DOCUMENT_STATUS mapSDocument() {
        this.getDocument().setDocumentGraph(SaltFactory.createSDocumentGraph());
        this.namespace = this.getProperties().getProperties().getProperty("CoNLLCoref.namespace", "coref");
        this.relType = this.getProperties().getProperties().getProperty("CoNLLCoref.relType", "coref");
        this.annoName = this.getProperties().getProperties().getProperty("CoNLLCoref.spanAnnotationName", "entity");
        this.annoVal = this.getProperties().getProperties().getProperty("CoNLLCoref.spanAnnotationValue", "entity");
        if (this.namespace != null) {
            this.layer = SaltFactory.createSLayer();
            this.layer.setName(this.namespace);
            this.layer.setGraph((Graph)this.getDocument().getDocumentGraph());
        }
        URI resource = this.getResourceURI();
        logger.debug("Importing the file {}.", (Object)resource.toFileString());
        TupleReader tupleReader = TupleConnectorFactory.fINSTANCE.createTupleReader();
        try {
            tupleReader.setSeperator("\t");
            tupleReader.setFile(new File(this.getResourceURI().toFileString()));
            tupleReader.readFile();
        }
        catch (IOException e) {
            String errorMessage = "Input file could not be read. Aborting conversion of file " + this.getResourceURI() + ".";
            logger.error(errorMessage);
            throw new PepperModuleDataException((PepperMapper)this, errorMessage);
        }
        STextualDS sTextualDS = SaltFactory.createSTextualDS();
        sTextualDS.setGraph((Graph)this.getDocument().getDocumentGraph());
        int tok_counter = 0;
        ArrayList<SToken> tokens = new ArrayList<SToken>();
        ArrayList<CoNLLCorefMarkable> markables = new ArrayList<CoNLLCorefMarkable>();
        DefaultDict markstart_dict = new DefaultDict(ArrayList.class);
        DefaultDict markend_dict = new DefaultDict(ArrayList.class);
        LinkedHashMap<String, CoNLLCorefMarkable> last_mark_by_group = new LinkedHashMap<String, CoNLLCorefMarkable>();
        LinkedHashMap<String, CoNLLCorefMarkable> open_marks_by_group = new LinkedHashMap<String, CoNLLCorefMarkable>();
        DefaultDict<String, String> mark_text_by_group = new DefaultDict<String, String>(String.class);
        Collection tuple = null;
        int numOfTuples = tupleReader.getNumOfTuples();
        int stringBuilderCharBufferSize = tupleReader.characterSize(Integer.valueOf(2)) + numOfTuples;
        StringBuilder primaryText = new StringBuilder(stringBuilderCharBufferSize);
        String corefInfo = "";
        Pattern patOpen = Pattern.compile("\\(([0-9]+)");
        Pattern patClose = Pattern.compile("([0-9]+)\\)");
        Pattern patDouble = Pattern.compile("\\(([0-9]+)\\)");
        boolean nestedClosed = true;
        for (int rowIndex = 0; rowIndex < numOfTuples; ++rowIndex) {
            CoNLLCorefMarkable new_mark;
            String group;
            try {
                tuple = tupleReader.getTuple();
            }
            catch (IOException e) {
                String errorMessage = String.format("line %d of input file could not be read. Abort conversion of file " + this.getResourceURI() + ".", rowIndex + 1);
                throw new PepperModuleDataException((PepperMapper)this, errorMessage);
            }
            int tupleSize = tuple.size();
            if (tupleSize < 2) continue;
            Iterator iter = tuple.iterator();
            iter.next();
            String tokText = (String)iter.next();
            while (iter.hasNext()) {
                corefInfo = (String)iter.next();
            }
            SToken sToken = SaltFactory.createSToken();
            sToken.setGraph((Graph)this.getDocument().getDocumentGraph());
            int tokenTextStartOffset = primaryText.length();
            primaryText.append(tokText).append(" ");
            int tokenTextEndOffset = primaryText.length() - 1;
            STextualRelation sTextualRelation = SaltFactory.createSTextualRelation();
            sTextualRelation.setSource((Node)sToken);
            sTextualRelation.setTarget((Node)sTextualDS);
            sTextualRelation.setStart((Number)tokenTextStartOffset);
            sTextualRelation.setEnd((Number)tokenTextEndOffset);
            sTextualRelation.setGraph((Graph)this.getDocument().getDocumentGraph());
            tokens.add(sToken);
            Matcher m = patDouble.matcher(corefInfo);
            while (m.find()) {
                group = m.group(1);
                new_mark = new CoNLLCorefMarkable(tok_counter);
                new_mark.setEnd(tok_counter);
                if (last_mark_by_group.containsKey(group)) {
                    new_mark.antecedent = (CoNLLCorefMarkable)last_mark_by_group.get(group);
                }
                if (open_marks_by_group.containsKey(group)) {
                    // empty if block
                }
                last_mark_by_group.put(group, new_mark);
                markables.add(new_mark);
                ((List)markstart_dict.get(tok_counter)).add(new_mark);
                ((List)markend_dict.get(tok_counter)).add(new_mark);
            }
            corefInfo = corefInfo.replaceAll("\\(([0-9]+)\\)", "");
            m = patOpen.matcher(corefInfo);
            while (m.find()) {
                group = m.group(1);
                new_mark = new CoNLLCorefMarkable(tok_counter);
                markables.add(new_mark);
                if (last_mark_by_group.containsKey(group)) {
                    new_mark.antecedent = (CoNLLCorefMarkable)last_mark_by_group.get(group);
                }
                if (open_marks_by_group.containsKey(group)) {
                    nestedClosed = false;
                } else {
                    open_marks_by_group.put(group, new_mark);
                }
                last_mark_by_group.put(group, new_mark);
                mark_text_by_group.put(group, (String)mark_text_by_group.get(group) + tokText + " ");
                ((List)markstart_dict.get(tok_counter)).add(new_mark);
            }
            corefInfo = corefInfo.replaceAll("\\(([0-9]+)", "");
            m = patClose.matcher(corefInfo);
            while (m.find()) {
                group = m.group(1);
                CoNLLCorefMarkable mark = open_marks_by_group.containsKey(group) ? (!nestedClosed ? (CoNLLCorefMarkable)last_mark_by_group.get(group) : (open_marks_by_group.get(group) != last_mark_by_group.get(group) && nestedClosed ? (CoNLLCorefMarkable)open_marks_by_group.get(group) : (CoNLLCorefMarkable)last_mark_by_group.get(group))) : (CoNLLCorefMarkable)last_mark_by_group.get(group);
                mark.setText(((String)mark_text_by_group.get(group)).trim());
                mark.setEnd(tok_counter);
                ((List)markend_dict.get(tok_counter)).add(mark);
                if (!nestedClosed && open_marks_by_group.containsKey(group)) {
                    nestedClosed = true;
                    continue;
                }
                mark_text_by_group.put(group, "");
                open_marks_by_group.remove(group);
            }
            for (String g : mark_text_by_group.keySet()) {
                if (mark_text_by_group.get(g) == "") continue;
                mark_text_by_group.put(g, (String)mark_text_by_group.get(g) + tokText + " ");
            }
            ++tok_counter;
        }
        primaryText.deleteCharAt(primaryText.length() - 1);
        sTextualDS.setText(primaryText.toString());
        for (CoNLLCorefMarkable mark : markables) {
            for (int i = mark.getStart(); i <= mark.getEnd(); ++i) {
                mark.addToken((SToken)tokens.get(i));
            }
        }
        LinkedHashMap<CoNLLCorefMarkable, SSpan> marks2spans = new LinkedHashMap<CoNLLCorefMarkable, SSpan>();
        for (CoNLLCorefMarkable mark : markables) {
            SSpan sSpan = this.getDocument().getDocumentGraph().createSpan(mark.getTokens());
            if (this.namespace != null) {
                if (sSpan == null) {
                    throw new PepperModuleDataException((PepperMapper)this, "Null span detected, created from markable object: " + mark.toString());
                }
                sSpan.addLayer((Layer)this.layer);
            }
            if (this.annoName != "" && this.annoVal != "") {
                SAnnotation annotation = SaltFactory.createSAnnotation();
                annotation.setName(this.annoName);
                annotation.setValue((Object)this.annoVal);
                if (this.namespace != null) {
                    annotation.setNamespace(this.namespace);
                }
                sSpan.addAnnotation(annotation);
            }
            if (mark.getNodeName() != null) {
                sSpan.setName(mark.getNodeName());
            }
            marks2spans.put(mark, sSpan);
        }
        for (CoNLLCorefMarkable mark : markables) {
            if (mark.antecedent == null) continue;
            SPointingRelation sRel = SaltFactory.createSPointingRelation();
            sRel.setSource((Node)marks2spans.get(mark));
            sRel.setTarget((Node)marks2spans.get(mark.antecedent));
            sRel.setType(this.relType);
            if (this.namespace != null) {
                sRel.addLayer((Layer)this.layer);
            }
            this.getDocument().getDocumentGraph().addRelation((Relation)sRel);
        }
        return DOCUMENT_STATUS.COMPLETED;
    }
}

