/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.pepper.cli;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.corpus_tools.pepper.cli.PepperStarter;
import org.corpus_tools.pepper.exceptions.PepperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.DefaultHandler2;

public class XMLTagExtractor
extends DefaultHandler2 {
    private static final Logger logger = LoggerFactory.getLogger(PepperStarter.class);
    private URI xmlResource = null;
    private URI javaResource = null;
    public static final String PREFIX_NAMESPACE = "NS_";
    public static final String PREFIX_NAMESPACE_VALUE = "NS_VALUE_";
    public static final String PREFIX_ELEMENT = "TAG_";
    public static final String PREFIX_ATTRIBUTE = "ATT_";
    private HashSet<String> tagNames = null;
    private HashSet<String> attributeNames = null;
    private Map<String, String> namespaceDeclaration = null;
    public static final String ARG_INPUT = "-i";
    public static final String ARG_OUTPUT = "-o";

    public void setXmlResource(URI resource) throws FileNotFoundException {
        if (resource == null) {
            throw new NullPointerException("Cannot start extracting, xml resource is empty.");
        }
        File inFile = new File(resource.toString());
        if (!inFile.exists()) {
            throw new FileNotFoundException("Cannot start extracting, xml resource '" + inFile + "' does not exist.");
        }
        this.xmlResource = resource;
    }

    public URI getXmlResource() {
        return this.xmlResource;
    }

    public void setJavaResource(URI resource) throws FileNotFoundException {
        if (resource == null) {
            throw new NullPointerException("Cannot start extracting, xml resource is empty.");
        }
        File outFile = new File(resource.toString());
        if (!outFile.exists() && !outFile.mkdirs()) {
            logger.warn("Cannot create folder '" + outFile.getAbsolutePath() + "'.");
        }
        this.javaResource = resource;
    }

    public URI getJavaResource() {
        return this.javaResource;
    }

    public void extract() {
        PrintWriter writer;
        XMLReader xmlReader;
        SAXParser parser;
        File resourceFile = new File(this.getXmlResource().toString());
        if (!resourceFile.exists()) {
            throw new PepperException("Cannot load a xml-resource, because the file does not exist: " + resourceFile);
        }
        if (!resourceFile.canRead()) {
            throw new PepperException("Cannot load a xml-resource, because the file can not be read: " + resourceFile);
        }
        File outFile = new File(this.getJavaResource().toString());
        if (outFile.isDirectory()) {
            String[] parts = resourceFile.getName().split("[.]");
            String outFileName = parts[0] + ".java";
            outFile = new File(outFile.getAbsolutePath() + "/" + outFileName);
        }
        SAXParserFactory factory = SAXParserFactory.newInstance();
        try {
            parser = factory.newSAXParser();
            xmlReader = parser.getXMLReader();
            xmlReader.setContentHandler(this);
        }
        catch (ParserConfigurationException e) {
            throw new PepperException("Cannot load a xml-resource '" + resourceFile.getAbsolutePath() + "'.", (Throwable)e);
        }
        catch (Exception e) {
            throw new PepperException("Cannot load a xml-resource '" + resourceFile.getAbsolutePath() + "'.", (Throwable)e);
        }
        try {
            FileInputStream inputStream = new FileInputStream(resourceFile);
            InputStreamReader reader = new InputStreamReader((InputStream)inputStream, "UTF-8");
            Iterator<String> is = new InputSource(reader);
            ((InputSource)((Object)is)).setEncoding("UTF-8");
            xmlReader.parse((InputSource)((Object)is));
        }
        catch (SAXException e) {
            try {
                parser = factory.newSAXParser();
                xmlReader = parser.getXMLReader();
                xmlReader.setContentHandler(this);
                xmlReader.parse(resourceFile.getAbsolutePath());
            }
            catch (Exception e1) {
                throw new PepperException("Cannot load a xml-resource '" + resourceFile.getAbsolutePath() + "'.", (Throwable)e1);
            }
        }
        catch (Exception e) {
            if (e instanceof PepperException) {
                throw (PepperException)((Object)e);
            }
            throw new PepperException("Cannot read xml-file'" + this.getXmlResource() + "', because of a nested exception. ", (Throwable)e);
        }
        String dictionaryName = null;
        try {
            writer = new PrintWriter(outFile, "UTF-8");
            try {
                dictionaryName = outFile.getName().replace(".java", "");
                writer.println("package myPackage;");
                writer.println("");
                writer.println("/**");
                writer.println("* This interface is a dictionary for files following the model of '" + outFile.getName().replace(".java", "") + "'.");
                writer.println("*");
                writer.println("* @author " + XMLTagExtractor.class.getSimpleName());
                writer.println("**/");
                writer.println("public interface " + dictionaryName + "{");
                for (String key : this.getNamespaces().keySet()) {
                    String ns = this.getNamespaces().get(key);
                    writer.println("\t\t/** constant to address the xml-namespace prefix'" + key + "'. **/");
                    writer.println("\t\tpublic static final String NS_" + key.toUpperCase().replace(":", "_").replace("-", "_") + "= \"" + key + "\";");
                    writer.println("\t\t/** constant to address the xml-namespace '" + ns + "'. **/");
                    writer.println("\t\tpublic static final String NS_VALUE_" + key.toUpperCase().replace(":", "_").replace("-", "_") + "= \"" + ns + "\";");
                }
                writer.println();
                for (String tagName : this.getTagNames()) {
                    writer.println("\t\t/** constant to address the xml-element '" + tagName + "'. **/");
                    writer.println("\t\tpublic static final String TAG_" + tagName.toUpperCase().replace(":", "_").replace("-", "_") + "= \"" + this.toNCNames(tagName) + "\";");
                }
                writer.println();
                for (String attName : this.getAttributeNames()) {
                    writer.println("\t\t/** constant to address the xml-attribute '" + attName + "'. **/");
                    writer.println("\t\tpublic static final String ATT_" + attName.toUpperCase().replace(":", "_").replace("-", "_") + "= \"" + this.toNCNames(attName) + "\";");
                }
                writer.println("}");
            }
            finally {
                writer.close();
            }
        }
        catch (FileNotFoundException | UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        outFile = new File(outFile.getAbsolutePath().replace(".java", "") + "Reader.java");
        try {
            writer = new PrintWriter(outFile, "UTF-8");
            try {
                writer.println("package myPackage;");
                writer.println("");
                writer.println("import org.xml.sax.Attributes;");
                writer.println("import org.xml.sax.SAXException;");
                writer.println("import org.xml.sax.ext.DefaultHandler2;");
                writer.println("");
                writer.println("/**");
                writer.println("* This class parses an xml file following the model of '" + outFile.getName().replace(".java", "") + "'.");
                writer.println("*");
                writer.println("* @author " + XMLTagExtractor.class.getSimpleName());
                writer.println("**/");
                writer.println("public class " + outFile.getName().replace(".java", "") + " extends DefaultHandler2 implements " + dictionaryName + " {");
                writer.println("\t\t@Override");
                writer.println("\t\tpublic void startElement(\tString uri,");
                writer.println("\t\t\t\tString localName,");
                writer.println("\t\t\t\tString qName,");
                writer.println("\t\t\t\tAttributes attributes)throws SAXException");
                writer.println("\t\t{");
                int i = 0;
                for (String tagName : this.getTagNames()) {
                    writer.print("\t\t\t");
                    if (i == 0) {
                        writer.print("if");
                    } else {
                        writer.print("else if");
                    }
                    ++i;
                    writer.println(" (TAG_" + tagName.toUpperCase().replace(":", "_").replace("-", "_") + ".equals(qName)){");
                    writer.println("\t\t\t}");
                }
                writer.println("\t\t}");
                writer.println("}");
            }
            finally {
                writer.close();
            }
        }
        catch (FileNotFoundException | UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    private HashSet<String> getTagNames() {
        if (this.tagNames == null) {
            this.tagNames = new HashSet();
        }
        return this.tagNames;
    }

    private HashSet<String> getAttributeNames() {
        if (this.attributeNames == null) {
            this.attributeNames = new HashSet();
        }
        return this.attributeNames;
    }

    private Map<String, String> getNamespaces() {
        if (this.namespaceDeclaration == null) {
            this.namespaceDeclaration = new Hashtable<String, String>();
        }
        return this.namespaceDeclaration;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.getTagNames().add(qName);
        for (int i = 0; i < attributes.getLength(); ++i) {
            String attName = attributes.getQName(i);
            if (attName.startsWith("xmlns:")) {
                String prefix = attName.replace("xmlns:", "");
                String ns = attributes.getValue(i);
                if (this.getNamespaces().containsKey(prefix)) continue;
                this.getNamespaces().put(prefix, ns);
                continue;
            }
            this.getAttributeNames().add(attributes.getQName(i));
        }
    }

    private String toNCNames(String name) {
        name = name.substring(name.lastIndexOf(":") + 1);
        return name;
    }

    public static void main(String[] args) {
        URI input = null;
        URI output = null;
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                if (ARG_INPUT.equals(args[i])) {
                    input = URI.create(args[i + 1]);
                    ++i;
                    continue;
                }
                if (!ARG_OUTPUT.equals(args[i])) continue;
                output = URI.create(args[i + 1]);
                ++i;
            }
        }
        XMLTagExtractor extractor = new XMLTagExtractor();
        try {
            System.out.println("input: " + input);
            System.out.println("output: " + output);
            if (input != null && output != null) {
                extractor.setXmlResource(input);
                extractor.setJavaResource(output);
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            System.exit(-1);
        }
        extractor.extract();
    }
}

