/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.pepper.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import org.corpus_tools.pepper.modules.exceptions.PepperModuleTestException;

public class FileComparator {
    public boolean compareFiles(File file1, File file2) throws IOException {
        boolean retVal = false;
        if (file1 == null || file2 == null) {
            throw new PepperModuleTestException("One of the files to compare are null.");
        }
        if (!file1.exists()) {
            throw new PepperModuleTestException("The file '" + file1 + "' does not exist.");
        }
        if (!file2.exists()) {
            throw new PepperModuleTestException("The file '" + file2 + "' does not exist.");
        }
        StringBuilder contentFile1 = new StringBuilder();
        StringBuilder contentFile2 = new StringBuilder();
        try (BufferedReader brFile1 = new BufferedReader(new FileReader(file1));
             BufferedReader brFile2 = new BufferedReader(new FileReader(file2));){
            String line = null;
            while ((line = brFile1.readLine()) != null) {
                contentFile1.append(line);
            }
            line = null;
            while ((line = brFile2.readLine()) != null) {
                contentFile2.append(line);
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (contentFile1.toString().isEmpty()) {
            retVal = contentFile2.toString().isEmpty();
        } else if (contentFile1.toString().equals(contentFile2.toString())) {
            retVal = true;
        }
        return retVal;
    }
}

