/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.pepper.core;

import java.util.Properties;
import org.corpus_tools.pepper.common.MODULE_TYPE;
import org.corpus_tools.pepper.common.PepperJob;
import org.corpus_tools.pepper.common.StepDesc;
import org.corpus_tools.pepper.core.PepperParamsReader;
import org.eclipse.emf.common.util.URI;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.ext.DefaultHandler2;

public class WorkflowDescriptionReader
extends DefaultHandler2 {
    public static final String TAG_PEPEPR_JOB = "pepper-job";
    public static final String TAG_CUSTOMIZATION = "customization";
    public static final String TAG_PROP = "property";
    public static final String TAG_IMPORTER = "importer";
    public static final String TAG_MANIPULATOR = "manipulator";
    public static final String TAG_EXPORTER = "exporter";
    public static final String ATT_ID = "id";
    public static final String ATT_VERSION = "version";
    public static final String ATT_KEY = "key";
    public static final String ATT_PATH = "path";
    public static final String ATT_NAME = "name";
    public static final String ATT_FORMAT_NAME = "formatName";
    public static final String ATT_FORMAT_VERSION = "formatVersion";
    private PepperJob pepperJob = null;
    private URI location = null;
    private StepDesc stepDesc = null;
    private Properties props = null;
    private String propName = null;
    private StringBuilder propValue = null;
    private PepperParamsReader delegatee = null;

    public PepperJob getPepperJob() {
        return this.pepperJob;
    }

    public void setPepperJob(PepperJob pepperJob) {
        this.pepperJob = pepperJob;
    }

    public URI getLocation() {
        return this.location;
    }

    public void setLocation(URI location) {
        this.location = location;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if ("PepperParams".equals(qName) || "pepperParams:PepperParams".equals(qName)) {
            this.delegatee = new PepperParamsReader();
            this.delegatee.setJob(this.getPepperJob());
            this.delegatee.setLocation(this.getLocation());
        } else if (TAG_IMPORTER.equals(qName)) {
            this.stepDesc = new StepDesc();
            this.stepDesc.setModuleType(MODULE_TYPE.IMPORTER);
            this.mapStepDesc(this.stepDesc, attributes);
        } else if (TAG_MANIPULATOR.equals(qName)) {
            this.stepDesc = new StepDesc();
            this.stepDesc.setModuleType(MODULE_TYPE.MANIPULATOR);
            this.mapStepDesc(this.stepDesc, attributes);
        } else if (TAG_EXPORTER.equals(qName)) {
            this.stepDesc = new StepDesc();
            this.stepDesc.setModuleType(MODULE_TYPE.EXPORTER);
            this.mapStepDesc(this.stepDesc, attributes);
        } else if (TAG_CUSTOMIZATION.equals(qName)) {
            if (this.stepDesc != null) {
                this.props = new Properties();
                this.stepDesc.setProps(this.props);
            }
        } else if (TAG_PROP.equals(qName)) {
            if (this.stepDesc.getProps() == null) {
                this.props = new Properties();
                this.stepDesc.setProps(this.props);
            }
            this.propName = attributes.getValue(ATT_KEY);
            this.propName = this.propName.trim();
        }
        if (this.delegatee != null) {
            this.delegatee.startElement(uri, localName, qName, attributes);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.props != null && this.propName != null && !this.propName.isEmpty()) {
            if (this.propValue == null) {
                this.propValue = new StringBuilder();
            }
            for (int i = start; i < start + length; ++i) {
                this.propValue.append(ch[i]);
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (TAG_PROP.equals(qName)) {
            if (this.props != null && this.propName != null && !this.propName.isEmpty()) {
                if (this.propValue != null) {
                    this.props.put(this.propName, this.propValue.toString());
                } else {
                    this.props.put(this.propName, "");
                }
                this.propValue = null;
                this.propName = null;
            }
        } else if (TAG_IMPORTER.equals(qName) || TAG_MANIPULATOR.equals(qName) || TAG_EXPORTER.equals(qName)) {
            this.getPepperJob().addStepDesc(this.stepDesc);
        }
    }

    private void mapStepDesc(StepDesc stepDesc, Attributes attributes) {
        if (attributes.getValue(ATT_NAME) != null) {
            stepDesc.setName(attributes.getValue(ATT_NAME));
        }
        if (attributes.getValue(ATT_VERSION) != null) {
            stepDesc.setVersion(attributes.getValue(ATT_VERSION));
        }
        if (MODULE_TYPE.IMPORTER.equals((Object)stepDesc.getModuleType()) || MODULE_TYPE.EXPORTER.equals((Object)stepDesc.getModuleType())) {
            if (attributes.getValue(ATT_FORMAT_NAME) != null) {
                stepDesc.getCorpusDesc().getFormatDesc().setFormatName(attributes.getValue(ATT_FORMAT_NAME));
            }
            if (attributes.getValue(ATT_FORMAT_VERSION) != null) {
                stepDesc.getCorpusDesc().getFormatDesc().setFormatVersion(attributes.getValue(ATT_FORMAT_VERSION));
            }
            if (attributes.getValue(ATT_PATH) != null) {
                stepDesc.getCorpusDesc().setCorpusPath(this.resolveURI(attributes.getValue(ATT_PATH)));
            }
        }
    }

    public URI resolveURI(String path) {
        URI uri = null;
        if (path != null && !path.isEmpty()) {
            path = path.replace("\\", "/");
            char[] seq = path.toCharArray();
            if (path.startsWith(".") && this.getLocation() != null) {
                uri = URI.createFileURI((String)path).resolve(this.getLocation());
            } else if (path.startsWith("/") || seq.length >= 2 && seq[1] == ':' && seq[2] == '\\') {
                uri = URI.createFileURI((String)path);
            } else if (path.startsWith("file:")) {
                path = path.replace("file:///", "");
                path = path.replace("file://", "");
                path = path.replace("file:", "");
                uri = URI.createFileURI((String)path);
            } else {
                uri = URI.createURI((String)path);
            }
        }
        return uri;
    }
}

