/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.salt.util;

import com.google.common.base.Strings;
import java.util.Hashtable;

public class DiffOptions
extends Hashtable<String, Boolean> {
    public static final String OPTION_IGNORE_DOCUMENTS = "ignoreDocuments";
    public static final String OPTION_IGNORE_FEATURES = "ignoreFeatures";
    public static final String OPTION_IGNORE_ANNOTATIONS = "ignoreAnnotations";
    public static final String OPTION_IGNORE_META_ANNOTATIONS = "ignoreMetaAnnotstaions";
    public static final String OPTION_IGNORE_PROCESSING_ANNOTATIONS = "ignoreProcessingAnnotations";
    public static final String OPTION_IGNORE_ID = "ignoreId";
    public static final String OPTION_IGNORE_NAME = "ignoreName";
    public static final String OPTION_IGNORE_CORPUS_STRUCTURE_NAME = "ignoreCorpusStructureName";
    public static final String OPTION_IGNORE_LAYER = "ignoreLayer";

    public DiffOptions() {
        this.put(OPTION_IGNORE_DOCUMENTS, false);
        this.put(OPTION_IGNORE_ANNOTATIONS, false);
        this.put(OPTION_IGNORE_META_ANNOTATIONS, false);
        this.put(OPTION_IGNORE_PROCESSING_ANNOTATIONS, true);
        this.put(OPTION_IGNORE_FEATURES, false);
        this.put(OPTION_IGNORE_ID, true);
        this.put(OPTION_IGNORE_NAME, true);
        this.put(OPTION_IGNORE_CORPUS_STRUCTURE_NAME, false);
        this.put(OPTION_IGNORE_LAYER, false);
    }

    public DiffOptions setOption(String key, Boolean value) {
        if (key != null && value != null) {
            this.put(key, value);
        }
        return this;
    }

    public static class Builder {
        private DiffOptions diffOptions = new DiffOptions();

        public Builder withOption(String option, boolean value) {
            if (!Strings.isNullOrEmpty((String)option)) {
                this.diffOptions.put(option, value);
            }
            return this;
        }

        public DiffOptions build() {
            return this.diffOptions;
        }
    }
}

