/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.pepper.common;

import org.corpus_tools.pepper.common.FormatDesc;
import org.eclipse.emf.common.util.URI;

public class CorpusDesc {
    protected FormatDesc formatDesc = null;
    protected URI corpusPath = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FormatDesc getFormatDesc() {
        if (this.formatDesc == null) {
            CorpusDesc corpusDesc = this;
            synchronized (corpusDesc) {
                this.formatDesc = new FormatDesc();
            }
        }
        return this.formatDesc;
    }

    public CorpusDesc setFormatDesc(FormatDesc formatDesc) {
        this.formatDesc = formatDesc;
        return this;
    }

    public URI getCorpusPath() {
        return this.corpusPath;
    }

    public CorpusDesc setCorpusPath(URI corpusPath) {
        this.corpusPath = corpusPath;
        return this;
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append(this.getCorpusPath());
        if (this.getFormatDesc() != null) {
            str.append("(");
            str.append(this.getFormatDesc().getFormatName());
            str.append(", ");
            str.append(this.getFormatDesc().getFormatVersion());
            str.append(")");
        }
        return str.toString();
    }

    public static class Builder {
        private final CorpusDesc corpusDesc = new CorpusDesc();

        public Builder withCorpusPath(URI corpusPath) {
            this.corpusDesc.setCorpusPath(corpusPath);
            return this;
        }

        public Builder withCorpusPath(String corpusPath) {
            this.corpusDesc.setCorpusPath(URI.createFileURI((String)corpusPath));
            return this;
        }

        public Builder withFormatName(String formatName) {
            this.corpusDesc.getFormatDesc().setFormatName(formatName);
            return this;
        }

        public Builder withFormatVersion(String formatVersion) {
            this.corpusDesc.getFormatDesc().setFormatVersion(formatVersion);
            return this;
        }

        public Builder withFormatReference(URI formatReference) {
            this.corpusDesc.getFormatDesc().setFormatReference(formatReference);
            return this;
        }

        public CorpusDesc build() {
            return this.corpusDesc;
        }
    }
}

