/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.pepper.testFramework.helpers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.corpus_tools.pepper.common.FormatDesc;
import org.corpus_tools.pepper.modules.PepperExporter;
import org.corpus_tools.pepper.modules.PepperImporter;
import org.corpus_tools.pepper.modules.PepperModule;
import org.corpus_tools.pepper.modules.exceptions.PepperModuleTestException;
import org.corpus_tools.pepper.testFramework.helpers.PepperModuleTest;
import org.junit.Assert;
import org.junit.Test;

public abstract class PepperImExporterTest
extends PepperModuleTest {
    @Deprecated
    protected List<FormatDesc> supportedFormatsCheck = null;

    @Override
    protected void setFixture(PepperModule fixture) {
        if (fixture == null) {
            throw new PepperModuleTestException("Cannot start pepper test, because no pepper module was set for current test. ");
        }
        if (!(fixture instanceof PepperImporter) && !(fixture instanceof PepperExporter)) {
            throw new PepperModuleTestException(fixture, "Cannot start pepper test, because the set pepper module neither an im- nor an exporter ");
        }
        super.setFixture(fixture);
        this.initializeFormatsToBeSupportedWhenNecessary();
    }

    private void initializeFormatsToBeSupportedWhenNecessary() {
        if (this.supportedFormatsCheck == null) {
            this.supportedFormatsCheck = new ArrayList<FormatDesc>();
        }
    }

    @Deprecated
    public void addSupportedFormat(FormatDesc formatDesc) {
    }

    public void addFormatWhichShouldBeSupported(FormatDesc formatDesc) {
        this.initializeFormatsToBeSupportedWhenNecessary();
        if (formatDesc == null) {
            Assert.fail((String)"Cannot add an empty format description.");
        }
        this.supportedFormatsCheck.add(formatDesc);
    }

    public void addFormatWhichShouldBeSupported(String formatName, String formatVersion) {
        this.addFormatWhichShouldBeSupported(new FormatDesc.FormatDescBuilder().withName(formatName).withVersion(formatVersion).build());
    }

    @Test
    public void checkThatCorrectFormatsAreSupported() {
        Assertions.assertThat(this.getSupportedFormatsFromFixture()).containsAll(this.supportedFormatsCheck);
    }

    private List<FormatDesc> getSupportedFormatsFromFixture() {
        if (this.getFixture() == null) {
            return Collections.emptyList();
        }
        if (this.getFixture() instanceof PepperImporter) {
            return ((PepperImporter)this.getFixture()).getSupportedFormats();
        }
        if (this.getFixture() instanceof PepperExporter) {
            return ((PepperExporter)this.getFixture()).getSupportedFormats();
        }
        return Collections.emptyList();
    }
}

