/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.pepper.cli;

import ch.qos.logback.classic.LoggerContext;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.time.DurationFormatUtils;
import org.corpus_tools.pepper.cli.ConvertWizardConsole;
import org.corpus_tools.pepper.cli.Greet;
import org.corpus_tools.pepper.cli.OSGiConsole;
import org.corpus_tools.pepper.cli.PepperStarterConfiguration;
import org.corpus_tools.pepper.common.ModuleFitness;
import org.corpus_tools.pepper.common.PepperJob;
import org.corpus_tools.pepper.common.PepperModuleDesc;
import org.corpus_tools.pepper.common.PepperUtil;
import org.corpus_tools.pepper.connectors.PepperConnector;
import org.corpus_tools.pepper.connectors.impl.PepperOSGiConnector;
import org.corpus_tools.pepper.exceptions.PepperException;
import org.corpus_tools.pepper.modules.PepperModuleProperty;
import org.eclipse.emf.common.util.URI;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.ext.DefaultHandler2;
import org.xml.sax.helpers.DefaultHandler;

public class PepperStarter {
    private static final Logger logger = LoggerFactory.getLogger(PepperStarter.class);
    private PepperConnector pepper = null;
    private PepperStarterConfiguration pepperConf = null;
    private Map<Integer, PepperModuleDesc> number2module = null;
    private Boolean isDebug = false;
    Map<String, String[]> moduleTable;
    private static final String MODULES_XML_PATH = "./conf/modules.xml";
    public static final String PROMPT = "pepper";
    private BufferedReader input = new BufferedReader(new InputStreamReader(System.in));
    private PrintStream output = System.out;
    public static final String FILE_ENDING_PEPPER = "pepper";
    public static final int CONSOLE_WIDTH = 120;
    public static final int CONSOLE_WIDTH_120 = 120;
    public static final int CONSOLE_WIDTH_80 = 80;

    public PepperStarter() {
    }

    public PepperStarter(PepperConnector pepperConnector) {
        this.setPepper(pepperConnector);
    }

    public PepperConnector getPepper() {
        return this.pepper;
    }

    public void setPepper(PepperConnector pepper) {
        this.pepper = pepper;
        if (!this.getPepper().isInitialized()) {
            this.getPepper().init();
        }
    }

    public PepperStarterConfiguration getPepperConfiguration() {
        return this.pepperConf;
    }

    public void setPepperConfiguration(PepperStarterConfiguration pepperConf) {
        this.pepperConf = pepperConf;
    }

    public String help() {
        String retVal = null;
        Integer[] length = new Integer[4];
        if (this.getPepperConfiguration().getConsoleWidth() == 80) {
            length[0] = 7;
            length[1] = 5;
            length[2] = 10;
            length[3] = 48;
        } else {
            length[0] = 20;
            length[1] = 5;
            length[2] = 15;
            length[3] = 70;
        }
        String[][] map = new String[COMMAND.values().length + 1][4];
        map[0][0] = "command";
        map[0][1] = "short";
        map[0][2] = "parameters";
        map[0][3] = "description";
        int i = 0;
        for (COMMAND command : COMMAND.values()) {
            map[++i][0] = command.getName();
            map[i][1] = command.getAbbreviation();
            map[i][2] = command.getParameters() == null ? " -- " : command.getParameters();
            map[i][3] = command.getDescription();
        }
        retVal = PepperUtil.createTable((Integer[])length, (String[][])map, (boolean)true, (boolean)true, (boolean)true);
        return retVal;
    }

    public String list() {
        StringBuilder retVal = new StringBuilder();
        ArrayList moduleDescs = null;
        try {
            moduleDescs = new ArrayList(this.getPepper().getRegisteredModules());
        }
        catch (Exception e) {
            if (this.isDebug.booleanValue()) {
                e.printStackTrace();
            }
            retVal.append("Cannot display any Pepper module. Call " + COMMAND.START_OSGI.getName() + " might solve the problem. ");
            return retVal.toString();
        }
        Collections.sort(moduleDescs);
        this.number2module = new HashMap<Integer, PepperModuleDesc>(moduleDescs.size());
        retVal.append(PepperUtil.reportModuleList((int)this.getPepperConfiguration().getConsoleWidth(), moduleDescs, this.number2module));
        retVal.append("To get more information on a particular module enter 'list No' or 'list module-name'. ");
        return retVal.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String list(String moduleSelector) {
        PepperModuleDesc moduleDesc;
        StringBuilder retVal;
        block13: {
            retVal = new StringBuilder();
            moduleDesc = null;
            Collection moduleDescs = null;
            try {
                moduleDescs = this.getPepper().getRegisteredModules();
            }
            catch (Exception e) {
                if (this.isDebug.booleanValue()) {
                    e.printStackTrace();
                }
                retVal.append("Cannot display any Pepper module.");
                return retVal.toString();
            }
            Integer numOfModule = null;
            try {
                numOfModule = Integer.parseInt(moduleSelector);
                if (this.number2module != null) {
                    moduleDesc = this.number2module.get(numOfModule);
                }
            }
            catch (NumberFormatException ex) {
                if (moduleDesc != null || moduleSelector == null || moduleDescs == null || moduleDescs.size() <= 0) break block13;
                for (PepperModuleDesc desc : moduleDescs) {
                    if (!moduleSelector.equalsIgnoreCase(desc.getName())) continue;
                    moduleDesc = desc;
                    break;
                }
            }
        }
        if (moduleDesc == null) {
            retVal.append("- no Pepper module was found for given name '" + moduleSelector + "' -");
            return retVal.toString();
        }
        Integer[] length = new Integer[2];
        if (80 == this.getPepperConfiguration().getConsoleWidth()) {
            length[0] = 14;
            length[1] = 60;
        } else {
            length[0] = 14;
            length[1] = 100;
        }
        int numOfEntries = 5;
        if (moduleDesc.getProperties() != null) {
            ++numOfEntries;
            ++numOfEntries;
            ++numOfEntries;
            numOfEntries += moduleDesc.getProperties().getPropertyDesctriptions().size();
        }
        String[][] map = new String[numOfEntries][2];
        map[0][0] = "name:";
        map[0][1] = moduleDesc.getName();
        map[1][0] = "version:";
        map[1][1] = moduleDesc.getVersion();
        map[2][0] = "supplier:";
        map[2][1] = moduleDesc.getSupplierContact() == null ? "" : moduleDesc.getSupplierContact().toString();
        map[3][0] = "website:";
        map[3][1] = moduleDesc.getSupplierHomepage() == null ? "" : moduleDesc.getSupplierHomepage().toString();
        map[4][0] = "description:";
        map[4][1] = moduleDesc.getDesc();
        if (moduleDesc.getProperties() != null) {
            map[5][0] = "--";
            map[6][1] = "customization properties";
            map[7][0] = "--";
            int i = 8;
            for (PepperModuleProperty prop : moduleDesc.getProperties().getPropertyDesctriptions()) {
                map[i][0] = prop.getName();
                map[i][1] = prop.getDescription();
                ++i;
            }
        }
        retVal.append(PepperUtil.createTable((Integer[])length, (String[][])map, (boolean)false, (boolean)true, (boolean)true));
        retVal.append("\n");
        return retVal.toString();
    }

    public String start_osgi() {
        if (this.getPepper() instanceof PepperOSGiConnector) {
            try {
                this.getPepper().init();
            }
            catch (Exception e) {
                if (this.isDebug.booleanValue()) {
                    e.printStackTrace();
                }
                return "Cannot start OSGi, because of a nested exception: " + e.getMessage();
            }
            return "started OSGi";
        }
        return "Cannot start OSGi, since Pepper is not running in OSGi mode. ";
    }

    public String stop_osgi() {
        if (this.getPepper() instanceof PepperOSGiConnector) {
            try {
                ((PepperOSGiConnector)this.getPepper()).stopOSGi();
            }
            catch (Exception e) {
                if (this.isDebug.booleanValue()) {
                    e.printStackTrace();
                }
                return "Cannot stop OSGi, because of a nested exception: " + e.getMessage();
            }
            return "stoped OSGi";
        }
        return "Cannot stop OSGi, since Pepper is not running in OSGi mode. ";
    }

    public String clean() {
        String retVal;
        block2: {
            this.stop_osgi();
            retVal = "";
            try {
                FileUtils.deleteDirectory((File)this.getPepper().getConfiguration().getTempPath());
                retVal = "Cleaned up Pepper instance, please call " + COMMAND.START_OSGI.getName() + " to make Pepper ready to run again.";
            }
            catch (IOException e) {
                retVal = "Cannot clean Pepper instance, because of " + e.getMessage();
                if (!this.isDebug.booleanValue()) break block2;
                e.printStackTrace();
            }
        }
        return retVal;
    }

    public String debug() {
        this.isDebug = this.isDebug == false;
        if (this.isDebug.booleanValue()) {
            return "Debug mode is on.";
        }
        return "Debug mode is off.";
    }

    public String osgi() {
        if (this.getPepper() instanceof PepperOSGiConnector) {
            OSGiConsole console = new OSGiConsole((PepperOSGiConnector)this.getPepper(), "pepper");
            console.start(this.input, this.output);
            return "exit OSGi";
        }
        return "No OSGi console available, since Pepper is not running in OSGi mode. ";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void convert(String workFlowPath) {
        PepperJob pepperJob = null;
        String jobId = null;
        if (workFlowPath == null || workFlowPath.isEmpty()) {
            ConvertWizardConsole console = new ConvertWizardConsole("pepper");
            console.setPepper(this.getPepper());
            console.isDebug = this.isDebug;
            pepperJob = console.start(this.input, this.output);
            if (pepperJob != null) {
                jobId = pepperJob.getId();
            }
        } else if ("water".equalsIgnoreCase(workFlowPath)) {
            String msg = "###############___\n##############)===(\n##############)===(\n##############|H##|\n##############|H##|\n##############|H##|\n#############/=====\\\n############/#######\\\n###########/=========\\\n##########:HHHHHHHH##H:\n##########|HHHHHHHH##H|\n##########|HHHHHHHH##H|\n##########|HHHHHHHH##H|\n##########|===========|\n##########|###########|\n##########|#\\\\########|\n##########|OOO#In#####|#_________\n##########|#OO#vino###||#########|\n##########|##O#veritas|%#########%\n##########|###########|#\\#######/\n##########|===========|##`.###.'\n##########|HHHHHHHH##H|####\\#/\n##########|HHHHHHHH##H|####(#)\n##########|HHHHHHHH##H|####.|.\n###########~~~~~~~~~~~###~~~^~~~\n Cheers!\n";
            this.output.println(msg.replace("#", " "));
        } else {
            String workFlowCanonicalPath;
            File workFlowFile = new File(workFlowPath);
            try {
                workFlowCanonicalPath = workFlowFile.getCanonicalPath();
            }
            catch (IOException ex) {
                workFlowCanonicalPath = workFlowFile.getAbsolutePath();
            }
            URI workFlowUri = URI.createFileURI((String)workFlowCanonicalPath);
            jobId = this.pepper.createJob();
            pepperJob = this.pepper.getJob(jobId);
            pepperJob.load(workFlowUri);
        }
        if (pepperJob != null) {
            PepperUtil.PepperJobReporter observer = new PepperUtil.PepperJobReporter(pepperJob, this.getPepper().getConfiguration().getReportInterval().intValue());
            observer.start();
            Long timestamp = System.currentTimeMillis();
            try {
                pepperJob.convert();
                timestamp = System.currentTimeMillis() - timestamp;
                observer.setStop(true);
                this.output.println(pepperJob.getStatusReport());
                this.output.println("Conversion ended successfully, required time: " + DurationFormatUtils.formatDurationHMS((long)timestamp) + " s");
            }
            catch (Exception e) {
                timestamp = System.currentTimeMillis() - timestamp;
                this.output.println("CONVERSION ENDED WITH ERRORS, REQUIRED TIME: " + DurationFormatUtils.formatDurationHMS((long)timestamp) + " s");
                this.output.println(PepperUtil.breakString((String)"   ", (String)(e.getMessage() + " (" + e.getClass().getSimpleName() + ")")));
                this.output.println("full stack trace:");
                e.printStackTrace(this.output);
            }
            finally {
                observer.setStop(true);
                this.pepper.removeJob(jobId);
            }
        }
    }

    public String installAndStart(List<String> params) {
        if (this.getPepper() instanceof PepperOSGiConnector) {
            OSGiConsole console = new OSGiConsole((PepperOSGiConnector)this.getPepper(), "pepper");
            console.installAndStart(params, this.output);
            return "launched Pepper module";
        }
        return "No OSGi console available, since Pepper is not running in OSGi mode. ";
    }

    public String remove(List<String> params) {
        if (this.getPepper() instanceof PepperOSGiConnector) {
            OSGiConsole console = new OSGiConsole((PepperOSGiConnector)this.getPepper(), "pepper");
            console.remove(params, this.output);
            return "";
        }
        return "No OSGi console availablem, since Pepper is not running in OSGi mode. ";
    }

    @Deprecated
    public String selfTest() {
        StringBuilder retVal = new StringBuilder();
        Collection problems = this.getPepper().selfTest();
        if (problems.size() == 0) {
            retVal.append("- no problems detected -");
        } else {
            retVal.append("following problems have been found:");
            for (String problem : problems) {
                retVal.append("\t" + problem);
            }
        }
        return retVal.toString();
    }

    public String fitness() {
        StringBuilder retVal = new StringBuilder();
        Collection moduleFitnisses = this.getPepper().checkFitness();
        for (ModuleFitness moduleFitness : moduleFitnisses) {
            ModuleFitness.Fitness overallFitness = moduleFitness.getOverallFitness();
            retVal.append(this.printFitnessDetails(moduleFitness.getModuleName(), overallFitness + "", 80, 0));
            if (ModuleFitness.Fitness.FIT.equals((Object)overallFitness)) continue;
            for (ModuleFitness.FitnessFeature healthFeature : ModuleFitness.FitnessFeature.getHealthFeatures()) {
                Boolean featureHealth = moduleFitness.getFitness(healthFeature);
                if (featureHealth == null) continue;
                retVal.append(this.printFitnessDetails(healthFeature + "", featureHealth != false ? "YES" : "NO", 80, 4));
            }
            for (ModuleFitness.FitnessFeature fitnessFeature : ModuleFitness.FitnessFeature.getFitnessFeatures()) {
                Boolean featureFitness = moduleFitness.getFitness(fitnessFeature);
                if (featureFitness == null) continue;
                retVal.append(this.printFitnessDetails(fitnessFeature + "", featureFitness != false ? "YES" : "NO", 80, 4));
            }
        }
        retVal.append("For more information on particular fitness features see: https://korpling.github.io/pepper/doc/fitness.html. ");
        return retVal.toString();
    }

    private String printFitnessDetails(String name, String value, int size, int blanks) {
        int i;
        StringBuilder str = new StringBuilder();
        for (i = 0; i < blanks; ++i) {
            str.append(" ");
        }
        str.append(name);
        for (i = 0; i < size - name.length() - value.length() - 2 * blanks; ++i) {
            str.append(".");
        }
        str.append(value);
        str.append("\n");
        return str.toString();
    }

    public String conf() {
        StringBuilder retVal = new StringBuilder();
        String format = "| %1$-40s | %2$-50s |\n";
        String line = "+------------------------------------------+----------------------------------------------------+\n";
        retVal.append(line);
        retVal.append(String.format(format, "name", "value"));
        retVal.append(line);
        for (Object propName : this.getPepper().getConfiguration().keySet()) {
            retVal.append(String.format(format, propName, this.getPepper().getConfiguration().getProperty(propName.toString())));
        }
        retVal.append(line);
        return retVal.toString();
    }

    private String update(List<String> params) {
        StringBuilder retVal;
        block32: {
            if (params.size() == 0) {
                return "Please specify a module you want to update.";
            }
            retVal = new StringBuilder();
            String newLine = System.getProperty("line.separator");
            String indent = "\t";
            if (logger.isDebugEnabled()) {
                StringBuilder paramOut = new StringBuilder();
                paramOut.append("update parameters:");
                for (String param : params) {
                    paramOut.append(newLine).append(param);
                }
                logger.debug(paramOut.toString());
            }
            boolean isSnapshot = params.size() > 0 && "snapshot".equalsIgnoreCase(params.get(0)) || params.size() > 1 && "snapshot".equalsIgnoreCase(params.get(1));
            boolean ignoreVersion = params.size() > 0 && "iv".equalsIgnoreCase(params.get(0)) || params.size() > 1 && "iv".equalsIgnoreCase(params.get(1));
            PepperOSGiConnector pepperConnector = (PepperOSGiConnector)this.getPepper();
            try {
                int i;
                this.moduleTable = this.getModuleTable();
                if ("all".equalsIgnoreCase(params.get(0)) || (isSnapshot && !ignoreVersion || ignoreVersion && !isSnapshot) && params.size() > 1 && "all".equalsIgnoreCase(params.get(1)) || isSnapshot && ignoreVersion && params.size() > 2 && "all".equalsIgnoreCase(params.get(2))) {
                    ArrayList<String> lines = new ArrayList<String>();
                    for (Map.Entry<String, String[]> entry : this.moduleTable.entrySet()) {
                        if (pepperConnector.update(entry.getValue()[0], entry.getKey(), isSnapshot ? entry.getValue()[1] : entry.getValue()[2], isSnapshot, ignoreVersion)) {
                            lines.add(entry.getKey().concat(" successfully updated."));
                            continue;
                        }
                        lines.add(entry.getKey().concat(" NOT updated."));
                    }
                    Collections.sort(lines);
                    retVal.append(newLine);
                    for (String line : lines) {
                        retVal.append(line).append(newLine);
                    }
                    break block32;
                }
                String s = null;
                int n = isSnapshot ? (ignoreVersion ? 2 : 1) : (i = ignoreVersion ? 1 : 0);
                while (i < params.size()) {
                    s = params.get(i);
                    if (this.moduleTable.keySet().contains(s)) {
                        String[] v = this.moduleTable.get(s);
                        if (pepperConnector.update(v[0], s, isSnapshot ? v[1] : v[2], isSnapshot, ignoreVersion)) {
                            retVal.append("Successfully updated ").append(s).append(" from " + (isSnapshot ? this.moduleTable.get(s)[1] : this.moduleTable.get(s)[2])).append(newLine);
                        } else {
                            retVal.append("No update was performed for ").append(s).append(".");
                        }
                    } else if ("config".equals(s)) {
                        retVal.append(newLine).append(indent).append("update configuration for pepper modules:").append(newLine).append(newLine);
                        for (Map.Entry entry : this.moduleTable.entrySet()) {
                            String[] v = (String[])entry.getValue();
                            retVal.append(indent).append((String)entry.getKey()).append(indent).append(v[0]).append(indent).append(v[1]).append(indent).append(v[2]).append(newLine);
                        }
                        retVal.append(newLine);
                        retVal.append(indent).append("to add/modify a configuration use the following command (update will be executed, too!):").append(newLine).append(newLine).append(indent).append("update GROUP_ID::ARTIFACT_ID::REPOSITORY_URL").append(newLine);
                        retVal.append(newLine).append(indent).append("GROUP_ID: the groupId of the pepper module");
                        retVal.append(newLine).append(indent).append("ARTIFACT_ID: the artifactId of the pepper module, usually \"pepperModules-___Modules\"");
                        retVal.append(newLine).append(indent).append("REPOSITORY_URL: the url of the maven repository that contains the module").append(newLine);
                    } else if (s.contains("::")) {
                        String[] args = s.split("::");
                        if (pepperConnector.update(args[0], args[1], args[2], isSnapshot, ignoreVersion)) {
                            retVal.append("Successfully updated ").append(args[0]).append(".").append(args[1]).append(" from maven repository ").append(args[2]).append(".").append(newLine);
                        } else {
                            retVal.append("No update was performed for ").append(args[1]).append(newLine);
                        }
                    } else {
                        if (s.matches("file://.*") || s.matches("https?://.*")) {
                            try {
                                pepperConnector.installAndCopy(java.net.URI.create(s)).start();
                            }
                            catch (BundleException e) {
                                logger.debug(s + " caused: " + e.getMessage());
                                return "File not installed due to a BundleException";
                            }
                            return "File installed. No dependency resolution in this mode.";
                        }
                        if ("blacklist".equals(s) || "bl".equals(s)) {
                            retVal.append(pepperConnector.getBlacklist());
                        } else if ("iv".equalsIgnoreCase(s)) {
                            ignoreVersion = true;
                        } else if ("snapshot".equalsIgnoreCase(s)) {
                            isSnapshot = true;
                        } else if ("--help".equalsIgnoreCase(s)) {
                            retVal.append(newLine).append(indent).append("update [snapshot] [iv] MODULES_NAME").append(newLine).append(indent).append("updates the specified pepper modules").append(newLine).append(indent).append("snapshot:\tIf the newest version is a snapshot, pepper chooses to install it.").append(newLine).append(indent).append("iv:\t\tIf the pepper modules are depending on another version of pepper, they would usually not be installed.").append(newLine).append(indent).append(indent).append(indent).append("By setting this flag you can override this behaviour.").append(newLine).append(newLine).append(indent).append("update [snapshot] [iv] all").append(newLine).append(indent).append("All pepper modules configured in modules.xml will be updated/installed.").append(newLine).append(newLine).append(indent).append("update config").append(newLine).append(indent).append("displays the configuration given in modules.xml.").append(newLine).append(newLine).append(indent).append("update GROUP_ID::ARTIFACT_ID::REPOSITORY_URL").append(newLine).append(indent).append("adds/modifies a configuration in modules.xml AND starts the update process.").append(newLine).append(newLine).append(indent).append("update URL").append(newLine).append(indent).append("installs a file by its URL. Dependencies will not be resolved.").append(newLine);
                        } else {
                            retVal.append(indent).append(s).append(" is not a known module.").append(newLine).append(indent).append("For more information type \"u config\"").append(newLine);
                        }
                    }
                    ++i;
                }
            }
            catch (IOException | ParserConfigurationException | SAXException e) {
                retVal.append("An error occured during the update.");
            }
        }
        return retVal.toString();
    }

    private Map<String, String[]> getModuleTable() throws ParserConfigurationException, SAXException, IOException {
        if (this.moduleTable != null) {
            return this.moduleTable;
        }
        TreeMap<String, String[]> table = new TreeMap<String, String[]>();
        SAXParser saxParser = SAXParserFactory.newInstance().newSAXParser();
        try {
            saxParser.parse(MODULES_XML_PATH, (DefaultHandler)new ModuleTableReader(table));
        }
        catch (Exception e) {
            logger.debug("Could not parse modules.xml", (Throwable)e);
        }
        return table;
    }

    private boolean write2ConfigFile(String groupId, String artifactId, String repository) {
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        try {
            boolean changes = false;
            File configFile = new File(MODULES_XML_PATH);
            DocumentBuilder docBuilder = dbFactory.newDocumentBuilder();
            Document doc = docBuilder.parse(configFile);
            NodeList configuredModules = doc.getElementsByTagName("artifactId");
            if (configuredModules.getLength() == 0) {
                return false;
            }
            Node item = configuredModules.item(0);
            int j = 0;
            while (j + 1 < configuredModules.getLength() && !artifactId.equals(item.getTextContent())) {
                item = configuredModules.item(++j);
            }
            if (artifactId.equals(item.getTextContent())) {
                Node itemGroupId = null;
                Node itemRepo = null;
                Node node = null;
                for (int i = 0; i < item.getParentNode().getChildNodes().getLength() && (itemGroupId == null || itemRepo == null); ++i) {
                    node = item.getParentNode().getChildNodes().item(i);
                    if ("groupId".equals(node.getLocalName())) {
                        itemGroupId = node;
                    }
                    if (!"repository".equals(node.getLocalName())) continue;
                    itemRepo = node;
                }
                if (itemGroupId != null) {
                    itemGroupId.setTextContent(groupId);
                    changes = true;
                } else if (!groupId.equals(doc.getElementsByTagName("defaultGroupId").item(0).getTextContent())) {
                    itemGroupId = doc.createElement("groupId");
                    itemGroupId.setTextContent(groupId);
                    item.getParentNode().appendChild(itemGroupId);
                    changes = true;
                }
                if (itemRepo != null) {
                    itemRepo.setTextContent(repository);
                    changes = true;
                }
                itemGroupId = null;
                itemRepo = null;
                node = null;
            } else {
                changes = true;
                Node listNode = doc.getElementsByTagName("pepperModulesList").item(0);
                Element newModule = doc.createElement("pepperModules");
                Element groupIdNode = doc.createElement("groupId");
                groupIdNode.appendChild(doc.createTextNode(groupId));
                Element artifactIdNode = doc.createElement("artifactId");
                artifactIdNode.appendChild(doc.createTextNode(artifactId));
                Element repositoryNode = doc.createElement("repository");
                repositoryNode.appendChild(doc.createTextNode(repository));
                newModule.appendChild(groupIdNode);
                newModule.appendChild(artifactIdNode);
                newModule.appendChild(repositoryNode);
                listNode.appendChild(newModule);
                listNode = null;
                newModule = null;
                groupIdNode = null;
                artifactIdNode = null;
                repository = null;
            }
            if (changes) {
                TransformerFactory trFactory = TransformerFactory.newInstance();
                Transformer transformer = trFactory.newTransformer();
                transformer.setOutputProperty("indent", "yes");
                transformer.setOutputProperty("encoding", "UTF-8");
                DOMSource src = new DOMSource(doc);
                StreamResult result = new StreamResult(configFile);
                transformer.transform(src, result);
                trFactory = null;
                transformer = null;
                src = null;
                result = null;
            }
            docBuilder = null;
            doc = null;
            configuredModules = null;
            item = null;
        }
        catch (IOException | ParserConfigurationException | FactoryConfigurationError | TransformerException | TransformerFactoryConfigurationError | SAXException e) {
            logger.error("Could not read module table.");
            logger.trace(" ", e);
            return false;
        }
        return true;
    }

    public void runInteractive() {
        boolean exit = false;
        String userInput = null;
        String lastCommand = null;
        Vector<String> lastParams = null;
        String lastUserInput = null;
        this.output.println("Welcome to Pepper, type '" + COMMAND.HELP.getName() + "' for help or '" + COMMAND.CONVERT.getName() + "' to start a conversion.");
        while (!exit) {
            try {
                this.output.print("pepper>");
                userInput = this.input.readLine();
            }
            catch (IOException ioe) {
                this.output.println("Cannot read command, type in 'help' for help.");
            }
            if (userInput == null) continue;
            userInput = userInput.trim();
            String[] parts = userInput.split(" ");
            String command = parts[0];
            Vector<String> params = new Vector<String>();
            int i = 0;
            for (String part : parts) {
                if (i > 0) {
                    params.add(part);
                }
                ++i;
            }
            if (COMMAND.EXIT.getName().equalsIgnoreCase(command) || COMMAND.EXIT.getAbbreviation().equalsIgnoreCase(command)) break;
            if (COMMAND.REPEAT.getName().equalsIgnoreCase(command) || COMMAND.REPEAT.getAbbreviation().equalsIgnoreCase(command)) {
                if (lastUserInput != null && lastCommand != null && lastParams != null) {
                    this.executeSingleCommand(lastUserInput, lastCommand, lastParams);
                    continue;
                }
                this.output.println("Can not repeat if no other command was executed before.");
                continue;
            }
            this.executeSingleCommand(lastUserInput, command, params);
            lastCommand = command;
            lastParams = params;
            lastUserInput = userInput;
        }
    }

    private void executeSingleCommand(String userInput, String command, List<String> params) {
        try {
            if (COMMAND.HELP.getName().equalsIgnoreCase(command) || COMMAND.HELP.getAbbreviation().equalsIgnoreCase(command)) {
                this.output.println(this.help());
            } else if (params.size() == 0 && (COMMAND.LIST.getName().equalsIgnoreCase(command) || COMMAND.LIST.getAbbreviation().equalsIgnoreCase(command))) {
                this.output.println(this.list());
            } else if (params.size() > 0 && (COMMAND.LIST.getName().equalsIgnoreCase(command) || COMMAND.LIST.getAbbreviation().equalsIgnoreCase(command))) {
                if (params.size() == 1) {
                    this.output.println(this.list(params.get(0)));
                } else {
                    this.output.println("Please pass exactly one module name.");
                }
            } else if (COMMAND.CONF.getName().equalsIgnoreCase(command) || COMMAND.CONF.getAbbreviation().equalsIgnoreCase(command)) {
                this.output.println(this.conf());
            } else if (COMMAND.SELFTEST.getName().equalsIgnoreCase(command) || COMMAND.SELFTEST.getAbbreviation().equalsIgnoreCase(command)) {
                this.output.println(this.selfTest());
            } else if (COMMAND.FITNESS.getName().equalsIgnoreCase(command) || COMMAND.FITNESS.getAbbreviation().equalsIgnoreCase(command)) {
                this.output.println(this.fitness());
            } else if (COMMAND.CONVERT.getName().equalsIgnoreCase(command) || COMMAND.CONVERT.getAbbreviation().equalsIgnoreCase(command)) {
                if (params.size() == 1) {
                    this.convert(params.get(0));
                } else {
                    this.convert(null);
                }
            } else if (COMMAND.OSGI.getName().equalsIgnoreCase(command) || COMMAND.OSGI.getAbbreviation().equalsIgnoreCase(command)) {
                this.output.println(this.osgi());
            } else if (COMMAND.INSTALL_START.getName().equalsIgnoreCase(command) || COMMAND.INSTALL_START.getAbbreviation().equalsIgnoreCase(command)) {
                this.output.println(this.installAndStart(params));
            } else if (COMMAND.REMOVE.getName().equalsIgnoreCase(command) || COMMAND.REMOVE.getAbbreviation().equalsIgnoreCase(command)) {
                this.output.println(this.remove(params));
            } else if (COMMAND.START_OSGI.getName().equalsIgnoreCase(command) || COMMAND.START_OSGI.getAbbreviation().equalsIgnoreCase(command)) {
                this.output.println(this.start_osgi());
            } else if (COMMAND.STOP_OSGI.getName().equalsIgnoreCase(command) || COMMAND.STOP_OSGI.getAbbreviation().equalsIgnoreCase(command)) {
                this.output.println(this.stop_osgi());
            } else if (COMMAND.CLEAN.getName().equalsIgnoreCase(command) || COMMAND.CLEAN.getAbbreviation().equalsIgnoreCase(command)) {
                this.output.println(this.clean());
            } else if (COMMAND.DEBUG.getName().equalsIgnoreCase(command) || COMMAND.DEBUG.getAbbreviation().equalsIgnoreCase(command)) {
                this.output.println(this.debug());
            } else if (COMMAND.UPDATE.getName().equalsIgnoreCase(command) || COMMAND.UPDATE.getAbbreviation().equalsIgnoreCase(command)) {
                this.output.println(this.update(params));
            } else if (COMMAND.PRINT_DEPS.getName().equalsIgnoreCase(command) || COMMAND.PRINT_DEPS.getAbbreviation().equalsIgnoreCase(command)) {
                this.output.print(this.printDependencies(params));
            } else if (COMMAND.VERSION.getName().equalsIgnoreCase(command) || COMMAND.VERSION.getAbbreviation().equalsIgnoreCase(command)) {
                this.output.print(((PepperOSGiConnector)this.getPepper()).getFrameworkVersion().concat(System.lineSeparator()));
            } else {
                this.output.println("Type 'help' for help.");
            }
        }
        catch (Error | Exception e) {
            this.output.print("An error occured while processing '" + userInput + "': " + e.getMessage() + ". ");
            if (!this.isDebug.booleanValue()) {
                this.output.println("For more details enter '" + COMMAND.DEBUG.getName() + "' and redo last action. ");
            }
            String msg = e.getMessage();
            if (msg != null && !msg.isEmpty()) {
                logger.error(" ", e);
            }
            e.printStackTrace();
        }
    }

    private String printDependencies(List<String> params) {
        PepperOSGiConnector connector = (PepperOSGiConnector)this.getPepper();
        Map<String, String[]> moduleTable = null;
        try {
            moduleTable = this.getModuleTable();
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            logger.error("Could not parse module table.");
            return "No operation performed.";
        }
        StringBuilder retVal = new StringBuilder();
        String groupId = null;
        String version = null;
        for (String param : params) {
            if ("all".equalsIgnoreCase(param)) {
                retVal.delete(0, retVal.length());
                for (Map.Entry<String, String[]> entry : moduleTable.entrySet()) {
                    String[] val = entry.getValue();
                    groupId = val[0];
                    Bundle bundle = connector.getBundle(groupId, entry.getKey(), null);
                    String string = version = bundle == null ? null : bundle.getVersion().toString().replace(".SNAPSHOT", "-SNAPSHOT");
                    if (version == null) {
                        logger.info(entry.getKey().concat(" not installed. Collecting dependencies for newest version."));
                        break;
                    }
                    boolean isSnapshot = version.contains("SNAPSHOT");
                    retVal.append(connector.printDependencies(val[0], entry.getKey(), version, isSnapshot ? val[1] : val[2])).append(System.lineSeparator()).append(System.lineSeparator());
                }
                return retVal.toString();
            }
            if (param.contains("::")) {
                String[] coords = params.get(0).split("::");
                if (coords.length != 4) continue;
                retVal.append(connector.printDependencies(coords[0], coords[1], coords[2], coords[3])).append(System.lineSeparator());
                continue;
            }
            if (moduleTable.keySet().contains(param)) {
                String[] val = moduleTable.get(param);
                groupId = val[0];
                Bundle bundle = connector.getBundle(groupId, param, null);
                String string = version = bundle == null ? null : bundle.getVersion().toString().replace(".SNAPSHOT", "-SNAPSHOT");
                if (version == null) {
                    logger.info(param.concat(" not installed. Collecting dependencies for newest version."));
                    break;
                }
                retVal.append(connector.printDependencies(groupId, param, version, version.contains("SNAPSHOT") ? val[1] : val[1])).append(System.lineSeparator());
                continue;
            }
            if (!param.matches("#?[0-9]+")) continue;
            retVal.append(connector.printDependencies(param.replace("#", ""))).append(System.lineSeparator());
        }
        return retVal.toString();
    }

    public static String getVersion() {
        String version = null;
        Properties versionProp = new Properties();
        try (InputStream is = PepperStarter.class.getResourceAsStream("version.properties");){
            versionProp.load(is);
            version = versionProp.getProperty("version");
        }
        catch (IOException | NullPointerException ex) {
            throw new PepperException("Cannot read current Pepper version. ", (Throwable)ex);
        }
        return version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        boolean endedWithErrors;
        block31: {
            Long timestamp = 0L;
            PepperStarter starter = null;
            PepperOSGiConnector pepper = null;
            endedWithErrors = false;
            if (LoggerFactory.getILoggerFactory() instanceof LoggerContext) {
                LoggerContext lc = (LoggerContext)LoggerFactory.getILoggerFactory();
                lc.setPackagingDataEnabled(false);
            }
            PepperStarterConfiguration pepperProps = null;
            try {
                pepperProps = new PepperStarterConfiguration();
                pepperProps.load();
                String eMail = pepperProps.getPepperEMail();
                String hp = pepperProps.getPepperHomepage();
                starter = new PepperStarter();
                starter.setPepperConfiguration(pepperProps);
                if (args.length > 0 && args[0].equalsIgnoreCase(COMMAND.DEBUG.toString())) {
                    starter.debug();
                }
                logger.info(Greet.getHello(pepperProps.getConsoleWidth(), eMail, hp));
                pepper = new PepperOSGiConnector();
                pepper.setConfiguration(pepperProps);
                boolean runInteractive = false;
                try {
                    starter.setPepper(pepper);
                }
                catch (Exception e) {
                    logger.info("An error occured, while starting Pepper. To get more information on that, please check the log file, which is by default located at 'PEPPER_HOME/pepper_out.log'. You now can exit Pepper or try to find out more about that exception using the Pepper console. ", (Throwable)e);
                    runInteractive = true;
                }
                if (args.length == 0 || runInteractive) {
                    starter.runInteractive();
                    break block31;
                }
                if (COMMAND.HELP.getName().equalsIgnoreCase(args[0]) || COMMAND.HELP.getAbbreviation().equalsIgnoreCase(args[0])) {
                    logger.info(starter.help());
                    break block31;
                }
                if (COMMAND.LIST.getName().equalsIgnoreCase(args[0]) || COMMAND.LIST.getAbbreviation().equalsIgnoreCase(args[0])) {
                    if (args.length == 1) {
                        logger.info(starter.list());
                    } else {
                        logger.info(starter.list(args[1]));
                    }
                    break block31;
                }
                if (COMMAND.FITNESS.getName().equalsIgnoreCase(args[0]) || COMMAND.FITNESS.getAbbreviation().equalsIgnoreCase(args[0])) {
                    logger.info(starter.fitness());
                    break block31;
                }
                if (COMMAND.UPDATE.getName().equalsIgnoreCase(args[0]) || COMMAND.UPDATE.getAbbreviation().equalsIgnoreCase(args[0])) {
                    Vector<String> params = new Vector<String>();
                    for (int i = 1; i < args.length; ++i) {
                        params.add(args[i]);
                    }
                    logger.info(starter.update(params));
                    break block31;
                }
                if (!"-p".equalsIgnoreCase(args[0]) && !"-w".equalsIgnoreCase(args[0]) && args[0] == null) break block31;
                String workFlowFile = null;
                if ("-p".equalsIgnoreCase(args[0]) || "-w".equalsIgnoreCase(args[0])) {
                    if (args[1] == null) {
                        logger.error("Cannot start conversion, since no workflow description file is given.");
                        endedWithErrors = true;
                    } else {
                        workFlowFile = args[1];
                    }
                } else {
                    workFlowFile = args[0];
                }
                try {
                    timestamp = System.currentTimeMillis();
                    if (logger.isDebugEnabled()) {
                        for (Map.Entry entry : pepperProps.entrySet()) {
                            logger.debug(String.format("%-40s%-16s", entry.getKey() + ":", entry.getValue()));
                        }
                    }
                    logger.debug(pepper.getRegisteredModulesAsString());
                    if (workFlowFile != null) {
                        workFlowFile = workFlowFile.replace("\\", "/");
                        starter.convert(workFlowFile);
                    } else {
                        logger.error("The passed workflow file was empty. ");
                    }
                    timestamp = System.currentTimeMillis() - timestamp;
                }
                catch (Exception e) {
                    timestamp = System.currentTimeMillis() - timestamp;
                    endedWithErrors = true;
                    throw e;
                }
            }
            catch (Exception e) {
                logger.info("An error occured, to get more information on that, please check the log file, which is by default located at 'PEPPER_HOME/pepper_out.log'. ");
                logger.error(" ", (Throwable)e);
            }
            finally {
                if (pepperProps != null) {
                    logger.info(Greet.getGoodBye(pepperProps.getConsoleWidth()));
                } else {
                    logger.info(Greet.getGoodBye(120));
                }
            }
        }
        if (endedWithErrors) {
            System.exit(-1);
        } else {
            System.exit(0);
        }
    }

    private static class ModuleTableReader
    extends DefaultHandler2 {
        private Map<String, String[]> listedModules;
        private String artifactId;
        private String groupId;
        private String snapshotRepository;
        private String releaseRepository;
        private static final String TAG_LIST = "pepperModulesList";
        private static final String TAG_ITEM = "pepperModules";
        private static final String TAG_GROUPID = "groupId";
        private static final String TAG_ARTIFACTID = "artifactId";
        @Deprecated
        private static final String TAG_REPO = "repository";
        private static final String TAG_SNAPSHOT_REPO = "snapshotRepository";
        private static final String TAG_RELEASE_REPO = "releaseRepository";
        private static final String ATT_DEFAULT_SNAPSHOT_REPO = "defaultSnapshotRepository";
        private static final String ATT_DEFAULT_RELEASE_REPO = "defaultReleaseRepository";
        private static final String ATT_DEFAULTGROUPID = "defaultGroupId";
        private String defaultGroupId;
        private String defaultSnapshotRepository;
        private String defaultReleaseRepository;
        private StringBuilder chars;

        public ModuleTableReader(Map<String, String[]> artifactIdUrlMap) {
            this.listedModules = artifactIdUrlMap;
            this.chars = new StringBuilder();
            this.groupId = null;
            this.artifactId = null;
            this.snapshotRepository = null;
            this.releaseRepository = null;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            localName = qName.substring(qName.lastIndexOf(":") + 1);
            if (TAG_LIST.equals(localName)) {
                this.defaultReleaseRepository = attributes.getValue(ATT_DEFAULT_RELEASE_REPO);
                this.defaultSnapshotRepository = attributes.getValue(ATT_DEFAULT_SNAPSHOT_REPO);
                this.defaultGroupId = attributes.getValue(ATT_DEFAULTGROUPID);
            }
            this.chars.delete(0, this.chars.length());
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            for (int i = start; i < start + length; ++i) {
                this.chars.append(ch[i]);
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            localName = qName.substring(qName.lastIndexOf(":") + 1);
            if (TAG_ARTIFACTID.equals(localName)) {
                this.artifactId = this.chars.toString();
                this.chars.delete(0, this.chars.length());
            } else if (TAG_GROUPID.equals(localName)) {
                this.groupId = this.chars.toString();
                this.chars.delete(0, this.chars.length());
            } else if (TAG_SNAPSHOT_REPO.equals(localName)) {
                this.snapshotRepository = this.chars.toString();
                this.chars.delete(0, this.chars.length());
            } else if (TAG_RELEASE_REPO.equals(localName)) {
                this.releaseRepository = this.chars.toString();
                this.chars.delete(0, this.chars.length());
            } else if (TAG_ITEM.equals(localName)) {
                String[] installVals = new String[]{this.groupId == null ? this.defaultGroupId : this.groupId.trim(), this.snapshotRepository == null ? this.defaultSnapshotRepository : this.snapshotRepository.trim(), this.releaseRepository == null ? this.defaultReleaseRepository : this.releaseRepository.trim()};
                this.listedModules.put(this.artifactId.trim(), installVals);
                this.chars.delete(0, this.chars.length());
                this.groupId = null;
                this.artifactId = null;
                this.snapshotRepository = null;
                this.releaseRepository = null;
            }
        }
    }

    public static enum COMMAND {
        VERSION("version", "v", "no arguments", "prints pepper version"),
        PRINT_DEPS("dependencies", "deps", "Bundle id or GROUP_ID::ARTIFACT_ID::VERSION::MAVEN_REPOSITORY_URL or plugin names split by space; parameter all prints dependencies for all plugins", "displays all dependencies of the specified component"),
        UPDATE("update", "u", "module name or location", "Updates the pepper module(s). Parameter \"all\" updates all modules listed in modules.xml."),
        LIST_ALL("list", "l", null, "A table with information about all available Pepper modules."),
        LIST("list", "l", "module name", "A table with information about the passed Pepper module."),
        CONF("conf", "co", null, "Shows the configuration for current Pepper instance."),
        HELP("help", "h", null, "Prints this help."),
        SELFTEST("self-test", "st", null, "Tests if the Pepper framework is in runnable mode or if any problems are detected, either in Pepper itself or in any registered Pepper module."),
        FITNESS("fitness", "f", null, "Checks the fitness of each registered Pepper module. The fitness check tests features of a module that are necessary to run a module and features which should be implemented. Modules having the status \"HEALTHY\" should be possible to run, having the status \"FIT\" means they also passed the more rigid tests. Modules that have a \"CRITICAL\" health status are very likely to cause problems."),
        EXIT("exit", "e", null, "Exits Pepper."),
        CONVERT("convert", "c", "workflow file", "If no workflow file is passed, Pepper opens a conversion wizard, which help you through the definition of a workflow proecess. If a 'worklow file' is passed, this file is load and the described workflow will be started."),
        OSGI("osgi", "o", null, "Opens a console to access the underlying OSGi environment, if OSGi is used."),
        INSTALL_START("install_start", "is", "module path", "Installs the Pepper module located at 'module path' and starts it."),
        REMOVE("remove", "re", "bundle name", "Removes all Pepper modules, being contained in the budnle with name 'bundle name'. To find out the bundle name open the osgi console and list all bundles. "),
        START_OSGI("start-osgi", "start", null, "Starts the OSGi environment (the plugin system of Pepper)."),
        STOP_OSGI("stop-osgi", "stop", null, "Stops the OSGi environment (the plugin system of Pepper)."),
        CLEAN("clean", "cl", null, "Cleans the current Pepper instance and especially removes the OSGi workspace."),
        DEBUG("debug", "d", null, "Switches on/off the debug output."),
        REPEAT("repeat", "r", null, "Repeats the last command.");

        private String name = null;
        private String abbreviation = null;
        private String description = null;
        private String parameters = null;

        private COMMAND(String name, String abbreviation, String parameters, String description) {
            this.name = name;
            this.abbreviation = abbreviation;
            this.parameters = parameters;
            this.description = description;
        }

        public String getName() {
            return this.name;
        }

        public String getAbbreviation() {
            return this.abbreviation;
        }

        public String getParameters() {
            return this.parameters;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

