/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.jxc;

import com.sun.tools.jxc.Messages;
import com.sun.tools.jxc.SecureLoader;
import com.sun.tools.jxc.ap.Options;
import com.sun.tools.xjc.BadCommandLineException;
import com.sun.xml.bind.util.Which;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.SourceVersion;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.OptionChecker;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;
import javax.xml.bind.JAXBContext;

public class SchemaGenerator {
    public static void main(String[] args) throws Exception {
        System.exit(SchemaGenerator.run(args));
    }

    public static int run(String[] args) throws Exception {
        try {
            ClassLoader cl = SecureLoader.getClassClassLoader(SchemaGenerator.class);
            if (cl == null) {
                cl = SecureLoader.getSystemClassLoader();
            }
            return SchemaGenerator.run(args, cl);
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            return -1;
        }
    }

    public static int run(String[] args, ClassLoader classLoader) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Options options = new Options();
        if (args.length == 0) {
            SchemaGenerator.usage();
            return -1;
        }
        for (String arg : args) {
            if (arg.equals("-help")) {
                SchemaGenerator.usage();
                return -1;
            }
            if (arg.equals("-version")) {
                System.out.println(Messages.VERSION.format(new Object[0]));
                return -1;
            }
            if (!arg.equals("-fullversion")) continue;
            System.out.println(Messages.FULLVERSION.format(new Object[0]));
            return -1;
        }
        try {
            options.parseArguments(args);
        }
        catch (BadCommandLineException e) {
            System.out.println(e.getMessage());
            System.out.println();
            SchemaGenerator.usage();
            return -1;
        }
        Class<?> schemagenRunner = classLoader.loadClass(Runner.class.getName());
        Method compileMethod = schemagenRunner.getDeclaredMethod("compile", String[].class, File.class);
        ArrayList<String> aptargs = new ArrayList<String>();
        if (options.encoding != null) {
            aptargs.add("-encoding");
            aptargs.add(options.encoding);
        }
        aptargs.add("-cp");
        aptargs.add(SchemaGenerator.setClasspath(options.classpath));
        if (options.targetDir != null) {
            aptargs.add("-d");
            aptargs.add(options.targetDir.getPath());
        }
        aptargs.addAll(options.arguments);
        String[] argsarray = aptargs.toArray(new String[aptargs.size()]);
        return (Boolean)compileMethod.invoke(null, argsarray, options.episodeFile) != false ? 0 : 1;
    }

    private static String setClasspath(String givenClasspath) {
        StringBuilder cp = new StringBuilder();
        SchemaGenerator.appendPath(cp, givenClasspath);
        for (ClassLoader cl = Thread.currentThread().getContextClassLoader(); cl != null; cl = cl.getParent()) {
            if (!(cl instanceof URLClassLoader)) continue;
            for (URL url : ((URLClassLoader)cl).getURLs()) {
                SchemaGenerator.appendPath(cp, url.getPath());
            }
        }
        SchemaGenerator.appendPath(cp, SchemaGenerator.findJaxbApiJar());
        return cp.toString();
    }

    private static void appendPath(StringBuilder cp, String url) {
        if (url == null || url.trim().isEmpty()) {
            return;
        }
        if (cp.length() != 0) {
            cp.append(File.pathSeparatorChar);
        }
        cp.append(url);
    }

    private static String findJaxbApiJar() {
        String url = Which.which(JAXBContext.class);
        if (url == null) {
            return null;
        }
        if (!url.startsWith("jar:") || url.lastIndexOf(33) == -1) {
            return null;
        }
        String jarFileUrl = url.substring(4, url.lastIndexOf(33));
        if (!jarFileUrl.startsWith("file:")) {
            return null;
        }
        try {
            File f = new File(new URL(jarFileUrl).toURI());
            if (f.exists() && f.getName().endsWith(".jar")) {
                return f.getPath();
            }
            f = new File(new URL(jarFileUrl).getFile());
            if (f.exists() && f.getName().endsWith(".jar")) {
                return f.getPath();
            }
        }
        catch (URISyntaxException ex) {
            Logger.getLogger(SchemaGenerator.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (MalformedURLException ex) {
            Logger.getLogger(SchemaGenerator.class.getName()).log(Level.SEVERE, null, ex);
        }
        return null;
    }

    private static void usage() {
        System.out.println(Messages.USAGE.format(new Object[0]));
    }

    private static final class JavacOptions {
        private final List<String> recognizedOptions;
        private final List<String> classNames;
        private final List<File> files;
        private final List<String> unrecognizedOptions;

        private JavacOptions(List<String> recognizedOptions, List<String> classNames, List<File> files, List<String> unrecognizedOptions) {
            this.recognizedOptions = recognizedOptions;
            this.classNames = classNames;
            this.files = files;
            this.unrecognizedOptions = unrecognizedOptions;
        }

        public static JavacOptions parse(OptionChecker primary, OptionChecker secondary, String ... arguments) {
            ArrayList<String> recognizedOptions = new ArrayList<String>();
            ArrayList<String> unrecognizedOptions = new ArrayList<String>();
            ArrayList<String> classNames = new ArrayList<String>();
            ArrayList<File> files = new ArrayList<File>();
            for (int i = 0; i < arguments.length; ++i) {
                String argument = arguments[i];
                int optionCount = primary.isSupportedOption(argument);
                if (optionCount < 0) {
                    optionCount = secondary.isSupportedOption(argument);
                }
                if (optionCount < 0) {
                    File file = new File(argument);
                    if (file.exists()) {
                        files.add(file);
                        continue;
                    }
                    if (SourceVersion.isName(argument)) {
                        classNames.add(argument);
                        continue;
                    }
                    unrecognizedOptions.add(argument);
                    continue;
                }
                for (int j = 0; j < optionCount + 1; ++j) {
                    int index = i + j;
                    if (index == arguments.length) {
                        throw new IllegalArgumentException(argument);
                    }
                    recognizedOptions.add(arguments[index]);
                }
                i += optionCount;
            }
            return new JavacOptions(recognizedOptions, classNames, files, unrecognizedOptions);
        }

        public List<String> getRecognizedOptions() {
            return Collections.unmodifiableList(this.recognizedOptions);
        }

        public List<File> getFiles() {
            return Collections.unmodifiableList(this.files);
        }

        public List<String> getClassNames() {
            return Collections.unmodifiableList(this.classNames);
        }

        public List<String> getUnrecognizedOptions() {
            return Collections.unmodifiableList(this.unrecognizedOptions);
        }

        public String toString() {
            return String.format("recognizedOptions = %s; classNames = %s; files = %s; unrecognizedOptions = %s", this.recognizedOptions, this.classNames, this.files, this.unrecognizedOptions);
        }
    }

    public static final class Runner {
        public static boolean compile(String[] args, File episode) throws Exception {
            DiagnosticCollector diagnostics;
            StandardJavaFileManager fileManager;
            JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
            JavacOptions options = JavacOptions.parse(compiler, fileManager = compiler.getStandardFileManager(diagnostics = new DiagnosticCollector(), null, null), args);
            List<String> unrecognizedOptions = options.getUnrecognizedOptions();
            if (!unrecognizedOptions.isEmpty()) {
                Logger.getLogger(SchemaGenerator.class.getName()).log(Level.WARNING, "Unrecognized options found: {0}", unrecognizedOptions);
            }
            Iterable<? extends JavaFileObject> compilationUnits = fileManager.getJavaFileObjectsFromFiles(options.getFiles());
            JavaCompiler.CompilationTask task = compiler.getTask(null, fileManager, diagnostics, options.getRecognizedOptions(), options.getClassNames(), compilationUnits);
            com.sun.tools.jxc.ap.SchemaGenerator r = new com.sun.tools.jxc.ap.SchemaGenerator();
            if (episode != null) {
                r.setEpisodeFile(episode);
            }
            task.setProcessors(Collections.singleton(r));
            return task.call();
        }
    }
}

