/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.salt.index;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.corpus_tools.salt.exceptions.SaltException;
import org.corpus_tools.salt.index.IndexMgr;

public class IndexMgrImpl
implements IndexMgr {
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private Map<String, Index> indexes;
    private final boolean threadSafe;

    public IndexMgrImpl() {
        this(false);
    }

    public IndexMgrImpl(boolean threadSafe) {
        this.threadSafe = threadSafe;
        this.indexes = Maps.newHashMap();
    }

    @Override
    public <K, V> void createIndex(String indexId, Class<K> keyType, Class<V> valueType) {
        this.createIndex(indexId, keyType, valueType, -1, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <K, V> void createIndex(String indexId, Class<K> keyType, Class<V> valueType, int expectedKeys, int expectedValuesPerKey) {
        if (this.threadSafe) {
            this.lock.writeLock().lock();
            try {
                this.createIndex_intern(indexId, keyType, valueType, expectedKeys, expectedValuesPerKey);
            }
            finally {
                this.lock.writeLock().unlock();
            }
        } else {
            this.createIndex_intern(indexId, keyType, valueType, expectedKeys, expectedValuesPerKey);
        }
    }

    private <K, V> void createIndex_intern(String indexId, Class<K> keyType, Class<V> valueType, int expectedKeys, int expectedValuesPerKey) {
        if (this.containsIndex(indexId)) {
            throw new SaltException("Cannot add the given index, because an index with this id already exists: " + indexId);
        }
        ArrayListMultimap map = expectedKeys > 0 && expectedValuesPerKey > 0 ? ArrayListMultimap.create((int)expectedKeys, (int)expectedValuesPerKey) : ArrayListMultimap.create();
        this.indexes.put(indexId, new Index<K, V>(map, keyType, valueType));
    }

    @Override
    public boolean containsIndex(String indexId) {
        if (this.threadSafe) {
            this.lock.readLock().lock();
            try {
                boolean bl = this.indexes.containsKey(indexId);
                return bl;
            }
            finally {
                this.lock.readLock().unlock();
            }
        }
        return this.indexes.containsKey(indexId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <K, V> boolean put(String indexId, K key, V value) {
        if (this.threadSafe) {
            this.lock.writeLock().lock();
        }
        try {
            Index idx;
            if (indexId != null && key != null && value != null && (idx = this.indexes.get(indexId)) != null) {
                if (idx.keyClass.isAssignableFrom(key.getClass()) && idx.valueClass.isAssignableFrom(value.getClass())) {
                    boolean bl = idx.map.put(key, value);
                    return bl;
                }
                if (!idx.keyClass.isAssignableFrom(key.getClass())) {
                    throw new ClassCastException("The type passed key '" + key.getClass() + "' is not assignable to '" + idx.keyClass + "'. ");
                }
                if (!idx.valueClass.isAssignableFrom(value.getClass())) {
                    throw new ClassCastException("The type passed value '" + value.getClass() + "' is not assignable to '" + idx.valueClass + "'. ");
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (this.threadSafe) {
                this.lock.writeLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <K, V> boolean putAll(String indexId, K key, Collection<V> values) {
        if (this.threadSafe) {
            this.lock.writeLock().lock();
        }
        try {
            if (indexId != null && key != null && values != null && !values.isEmpty()) {
                Index idx = this.indexes.get(indexId);
                if (idx.keyClass.isAssignableFrom(key.getClass()) && idx.valueClass.isAssignableFrom(values.iterator().next().getClass())) {
                    boolean bl = idx.map.putAll(key, values);
                    return bl;
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (this.threadSafe) {
                this.lock.writeLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <K, V> V get(String indexId, K key) {
        V result = null;
        if (indexId != null && key != null) {
            if (this.threadSafe) {
                this.lock.readLock().lock();
            }
            try {
                Collection col;
                Index idx = this.indexes.get(indexId);
                if (idx != null && !(col = idx.map.get(key)).isEmpty()) {
                    result = (V)col.iterator().next();
                }
            }
            finally {
                if (this.threadSafe) {
                    this.lock.readLock().unlock();
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <K, V> List<V> getAll(String indexId, K key) {
        if (indexId != null && key != null) {
            if (this.threadSafe) {
                this.lock.readLock().lock();
            }
            try {
                Index idx = this.indexes.get(indexId);
                if (idx != null) {
                    Collection col = idx.map.get(key);
                    if (col instanceof List) {
                        List list = Collections.unmodifiableList((List)col);
                        return list;
                    }
                    List list = Collections.unmodifiableList(new ArrayList(col));
                    return list;
                }
            }
            finally {
                if (this.threadSafe) {
                    this.lock.readLock().unlock();
                }
            }
        }
        return Collections.unmodifiableList(new ArrayList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <K> boolean containsKey(String indexId, K key) {
        boolean result = false;
        if (indexId != null && key != null) {
            if (this.threadSafe) {
                this.lock.readLock().lock();
            }
            try {
                Index idx = this.indexes.get(indexId);
                if (idx != null) {
                    result = idx.map.containsKey(key);
                }
            }
            finally {
                if (this.threadSafe) {
                    this.lock.readLock().unlock();
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <K> boolean remove(String indexId, K key) {
        if (indexId != null && key != null) {
            if (this.threadSafe) {
                this.lock.writeLock().lock();
            }
            try {
                Index idx = this.indexes.get(indexId);
                if (idx != null && idx.keyClass.isAssignableFrom(key.getClass())) {
                    boolean bl = !idx.map.removeAll(key).isEmpty();
                    return bl;
                }
            }
            finally {
                if (this.threadSafe) {
                    this.lock.writeLock().unlock();
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <K, V> boolean remove(String indexId, K key, V value) {
        if (indexId != null && key != null && value != null) {
            if (this.threadSafe) {
                this.lock.writeLock().lock();
            }
            try {
                Index idx = this.indexes.get(indexId);
                if (idx != null && idx.keyClass.isAssignableFrom(key.getClass()) && idx.valueClass.isAssignableFrom(value.getClass())) {
                    boolean bl = idx.map.remove(key, value);
                    return bl;
                }
            }
            finally {
                if (this.threadSafe) {
                    this.lock.writeLock().unlock();
                }
            }
        }
        return false;
    }

    @Override
    public boolean removeIndex(String indexId) {
        if (this.threadSafe) {
            this.lock.writeLock().lock();
            try {
                if (this.indexes.remove(indexId) == null) {
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
        return this.indexes.remove(indexId) == null;
    }

    @Override
    public void clearIndex(String indexId) {
        if (this.threadSafe) {
            this.lock.writeLock().lock();
        }
        try {
            Index idx = this.indexes.get(indexId);
            if (idx != null) {
                idx.map.clear();
            }
        }
        finally {
            if (this.threadSafe) {
                this.lock.writeLock().unlock();
            }
        }
    }

    @Override
    public void removeAll() {
        if (this.threadSafe) {
            this.lock.writeLock().lock();
            try {
                this.indexes.clear();
            }
            finally {
                this.lock.writeLock().unlock();
            }
        } else {
            this.indexes.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <V> boolean removeValue(V element) {
        boolean result = false;
        if (element != null) {
            if (this.threadSafe) {
                this.lock.writeLock().lock();
            }
            try {
                for (Map.Entry<String, Index> e : this.indexes.entrySet()) {
                    if (!e.getValue().valueClass.isAssignableFrom(element.getClass())) continue;
                    result = e.getValue().map.values().remove(element) || result;
                }
            }
            finally {
                if (this.threadSafe) {
                    this.lock.writeLock().unlock();
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <V> boolean removeValue(String indexId, V element) {
        boolean result = false;
        if (indexId != null && element != null) {
            if (this.threadSafe) {
                this.lock.writeLock().lock();
            }
            try {
                Index idx = this.indexes.get(indexId);
                if (idx != null && idx.valueClass.isAssignableFrom(element.getClass())) {
                    result = idx.map.values().remove(element);
                }
            }
            finally {
                if (this.threadSafe) {
                    this.lock.writeLock().unlock();
                }
            }
        }
        return result;
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        for (Map.Entry<String, Index> indexEntry : this.indexes.entrySet()) {
            str.append(indexEntry.getKey());
            str.append(": ");
            str.append(indexEntry.getValue().map);
            str.append(",\n");
        }
        return str.toString();
    }

    private static class Index<K, V>
    implements Serializable {
        final Multimap<K, V> map;
        final Class<K> keyClass;
        final Class<V> valueClass;

        public Index(Multimap<K, V> map, Class<K> keyClass, Class<V> valueClass) {
            if (map == null) {
                throw new IllegalArgumentException("Cannot create Index with empty map parameter. ");
            }
            if (keyClass == null) {
                throw new IllegalArgumentException("Cannot create Index with empty keyClass parameter. ");
            }
            if (valueClass == null) {
                throw new IllegalArgumentException("Cannot create Index with empty valueClass parameter. ");
            }
            this.map = map;
            this.keyClass = keyClass;
            this.valueClass = valueClass;
        }
    }
}

