/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.pepper.impl;

import java.util.List;
import org.corpus_tools.pepper.common.DOCUMENT_STATUS;
import org.corpus_tools.pepper.exceptions.NotInitializedException;
import org.corpus_tools.pepper.exceptions.PepperException;
import org.corpus_tools.pepper.exceptions.PepperFWException;
import org.corpus_tools.pepper.impl.BeforeAfterAction;
import org.corpus_tools.pepper.modules.DocumentController;
import org.corpus_tools.pepper.modules.MappingSubject;
import org.corpus_tools.pepper.modules.PepperMapper;
import org.corpus_tools.pepper.modules.PepperMapperController;
import org.corpus_tools.pepper.modules.PepperModule;
import org.corpus_tools.pepper.modules.exceptions.PepperModuleException;
import org.corpus_tools.salt.graph.Identifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PepperMapperControllerImpl
extends Thread
implements PepperMapperController {
    public Logger logger = LoggerFactory.getLogger((String)"Pepper");
    private PepperMapper pepperMapper = null;
    private List<MappingSubject> mappingSubjects = null;
    protected volatile Double progress = 0.0;
    protected PepperModule pepperModule = null;

    public PepperMapperControllerImpl(ThreadGroup threadGroup, String threadName) {
        super(threadGroup, threadName);
    }

    @Override
    public void setPepperMapper(PepperMapper pepperMapper) {
        this.pepperMapper = pepperMapper;
        if (this.pepperMapper != null) {
            pepperMapper.setPepperMapperController(this);
            this.mappingSubjects = pepperMapper.getMappingSubjects();
        }
    }

    @Override
    public PepperMapper getPepperMapper() {
        return this.pepperMapper;
    }

    @Override
    public List<MappingSubject> getMappingSubjects() {
        return this.mappingSubjects;
    }

    @Override
    public DOCUMENT_STATUS getMappingResult() {
        DOCUMENT_STATUS retVal = null;
        if (this.getMappingSubjects().size() <= 0) {
            throw new PepperModuleException(this.getPepperMapper(), "This might be a bug. No mapping result is given in mapper controller.");
        }
        retVal = this.getMappingSubjects().get(0).getMappingResult();
        return retVal;
    }

    @Override
    public Identifier getIdentifier() {
        Identifier retVal = null;
        if (this.getMappingSubjects().size() <= 0) {
            throw new PepperModuleException(this.getPepperMapper(), "This might be a bug. No mapping result is given in mapper controller.");
        }
        retVal = this.getMappingSubjects().get(0).getIdentifier();
        return retVal;
    }

    @Override
    public void setIdentifier(Identifier sElementId) {
        if (sElementId == null) {
            throw new PepperModuleException(this.getPepperMapper(), "Cannot set an empty sElementId.");
        }
        MappingSubject subj = null;
        if (this.getMappingSubjects().size() < 1) {
            subj = new MappingSubject();
            this.getMappingSubjects().add(subj);
        } else {
            subj = this.getMappingSubjects().get(0);
        }
        subj.setIdentifier(sElementId);
    }

    @Override
    public Double getProgress() {
        if (this.getPepperMapper() != null) {
            return this.getPepperMapper().getProgress();
        }
        if (this.progress != null) {
            return this.progress;
        }
        throw new PepperModuleException("Cannot return progress, because no PepperMapper '" + this.getName() + "' is given. This might be a bug of the Pepper module, please make sure, that method PepperModule.createPepperMapper() is implemented.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        PepperException origException = null;
        try {
            this.map();
            return;
        }
        catch (Exception e) {
            if (e instanceof PepperException) {
                origException = (PepperException)e;
            }
            origException = new PepperModuleException("Any exception occured while mapping.", e);
        }
        finally {
            this.progress = 1.0;
            this.setPepperMapper(null);
            if (this.getPepperModule() == null) {
                throw new PepperFWException("The containing PepperModule object is not set.");
            }
            if (this.getMappingSubjects().size() > 0) {
                for (MappingSubject subj : this.getMappingSubjects()) {
                    if (subj.getMappingResult() != null && !DOCUMENT_STATUS.IN_PROGRESS.equals((Object)subj.getMappingResult())) continue;
                    subj.setMappingResult(DOCUMENT_STATUS.FAILED);
                }
            }
            PepperException newException = null;
            try {
                this.getPepperModule().done(this);
            }
            catch (PepperException e) {
                newException = e;
            }
            finally {
                if (origException != null) {
                    throw origException;
                }
                if (newException == null) return;
                throw newException;
            }
        }
    }

    @Override
    public void map() {
        DOCUMENT_STATUS mappingResult = null;
        for (MappingSubject subj : this.getMappingSubjects()) {
            new BeforeAfterAction(this.getPepperModule()).before(subj.getIdentifier());
        }
        if (this.getPepperMapper().getCorpus() != null) {
            this.progress = 0.0;
            mappingResult = this.getPepperMapper().mapSCorpus();
            this.progress = 1.0;
        } else if (this.getPepperMapper().getDocument() != null) {
            mappingResult = this.getPepperMapper().mapSDocument();
        } else {
            throw new NotInitializedException("Cannot start mapper, because neither the SDocument nor the SCorpus value is set.");
        }
        for (MappingSubject subj : this.getMappingSubjects()) {
            new BeforeAfterAction(this.getPepperModule()).after(subj.getIdentifier());
        }
        if (!(DOCUMENT_STATUS.FAILED.equals((Object)this.getPepperMapper().getMappingResult()) || DOCUMENT_STATUS.COMPLETED.equals((Object)this.getPepperMapper().getMappingResult()) || DOCUMENT_STATUS.DELETED.equals((Object)this.getPepperMapper().getMappingResult()))) {
            this.getPepperMapper().setMappingResult(mappingResult);
        }
    }

    @Override
    public void setPepperModule(PepperModule pepperModule) {
        this.pepperModule = pepperModule;
        if (this.pepperModule != null) {
            this.logger = LoggerFactory.getLogger((String)this.getPepperModule().getName());
        }
    }

    public PepperModule getPepperModule() {
        return this.pepperModule;
    }

    @Override
    public boolean getPermissionForProcessDoument(DocumentController controller) {
        return this.getPepperModule().getModuleController().getJob().getPermissionForProcessDoument(controller);
    }
}

