/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.pepper.connectors.impl;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.apache.http.client.HttpResponseException;
import org.apache.maven.repository.internal.DefaultArtifactDescriptorReader;
import org.apache.maven.repository.internal.DefaultVersionRangeResolver;
import org.apache.maven.repository.internal.DefaultVersionResolver;
import org.apache.maven.repository.internal.SnapshotMetadataGeneratorFactory;
import org.apache.maven.repository.internal.VersionsMetadataGeneratorFactory;
import org.codehaus.plexus.util.FileUtils;
import org.corpus_tools.pepper.connectors.impl.PepperOSGiConnector;
import org.eclipse.aether.AbstractRepositoryListener;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositoryEvent;
import org.eclipse.aether.RepositoryListener;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.ArtifactType;
import org.eclipse.aether.artifact.ArtifactTypeRegistry;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.artifact.DefaultArtifactType;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.collection.CollectResult;
import org.eclipse.aether.collection.DependencyCollectionException;
import org.eclipse.aether.collection.DependencyGraphTransformer;
import org.eclipse.aether.collection.DependencyManager;
import org.eclipse.aether.collection.DependencySelector;
import org.eclipse.aether.collection.DependencyTraverser;
import org.eclipse.aether.connector.basic.BasicRepositoryConnectorFactory;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.impl.ArtifactDescriptorReader;
import org.eclipse.aether.impl.DefaultServiceLocator;
import org.eclipse.aether.impl.MetadataGeneratorFactory;
import org.eclipse.aether.impl.VersionRangeResolver;
import org.eclipse.aether.impl.VersionResolver;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.LocalRepositoryManager;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactDescriptorPolicy;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.VersionRangeRequest;
import org.eclipse.aether.resolution.VersionRangeResolutionException;
import org.eclipse.aether.resolution.VersionRangeResult;
import org.eclipse.aether.spi.connector.RepositoryConnectorFactory;
import org.eclipse.aether.spi.connector.transport.TransporterFactory;
import org.eclipse.aether.transfer.AbstractTransferListener;
import org.eclipse.aether.transfer.ArtifactNotFoundException;
import org.eclipse.aether.transfer.MetadataNotFoundException;
import org.eclipse.aether.transfer.TransferEvent;
import org.eclipse.aether.transfer.TransferListener;
import org.eclipse.aether.transfer.TransferResource;
import org.eclipse.aether.transport.file.FileTransporterFactory;
import org.eclipse.aether.transport.http.HttpTransporterFactory;
import org.eclipse.aether.util.artifact.DefaultArtifactTypeRegistry;
import org.eclipse.aether.util.graph.manager.ClassicDependencyManager;
import org.eclipse.aether.util.graph.selector.AndDependencySelector;
import org.eclipse.aether.util.graph.selector.ExclusionDependencySelector;
import org.eclipse.aether.util.graph.selector.OptionalDependencySelector;
import org.eclipse.aether.util.graph.selector.ScopeDependencySelector;
import org.eclipse.aether.util.graph.transformer.ConflictResolver;
import org.eclipse.aether.util.graph.transformer.JavaScopeDeriver;
import org.eclipse.aether.util.graph.transformer.JavaScopeSelector;
import org.eclipse.aether.util.graph.transformer.NearestVersionSelector;
import org.eclipse.aether.util.graph.transformer.SimpleOptionalitySelector;
import org.eclipse.aether.util.graph.traverser.FatArtifactTraverser;
import org.eclipse.aether.util.repository.SimpleArtifactDescriptorPolicy;
import org.eclipse.aether.util.version.GenericVersionScheme;
import org.eclipse.aether.version.InvalidVersionSpecificationException;
import org.eclipse.aether.version.Version;
import org.eclipse.aether.version.VersionRange;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.ext.DefaultHandler2;
import org.xml.sax.helpers.DefaultHandler;

public class MavenAccessor {
    private static final Logger logger = LoggerFactory.getLogger(MavenAccessor.class);
    private final PepperOSGiConnector pepperOSGiConnector;
    private Set<String> forbiddenFruits = null;
    private HashMap<String, List<Dependency>> parentDependencies = null;
    private static final String BLACKLIST_PATH = "./conf/dep/blacklist.cfg";
    public static final String ARTIFACT_ID_PEPPER_FRAMEWORK = "pepper-framework";
    public static final String ARTIFACT_ID_PEPPER_PARENT = "pepper-parentModule";
    public static final String KORPLING_MAVEN_REPO = "http://korpling.german.hu-berlin.de/maven2/";
    public static final String CENTRAL_REPO = "http://central.maven.org/maven2/";
    public static final String GROUP_ID_PEPPER = "org.corpus_tools.pepper";
    private static final String DELIMITER = ":";
    private final String PATH_LOCAL_REPO;
    RepositorySystem mvnSystem = null;
    HashMap<String, RemoteRepository> repos = null;
    RemoteRepository.Builder repoBuilder = null;
    private final MavenTransferListener transferListener = new MavenTransferListener();
    private final MavenRepositoryListener repoListener = new MavenRepositoryListener();

    public MavenAccessor(PepperOSGiConnector pepperOSGiConnector) {
        this.pepperOSGiConnector = pepperOSGiConnector;
        DefaultServiceLocator locator = new DefaultServiceLocator();
        locator.addService(ArtifactDescriptorReader.class, DefaultArtifactDescriptorReader.class);
        locator.addService(VersionResolver.class, DefaultVersionResolver.class);
        locator.addService(VersionRangeResolver.class, DefaultVersionRangeResolver.class);
        locator.addService(MetadataGeneratorFactory.class, SnapshotMetadataGeneratorFactory.class);
        locator.addService(MetadataGeneratorFactory.class, VersionsMetadataGeneratorFactory.class);
        locator.addService(RepositoryConnectorFactory.class, BasicRepositoryConnectorFactory.class);
        locator.addService(TransporterFactory.class, FileTransporterFactory.class);
        locator.addService(TransporterFactory.class, HttpTransporterFactory.class);
        this.mvnSystem = (RepositorySystem)locator.getService(RepositorySystem.class);
        this.repoBuilder = new RemoteRepository.Builder("", "default", "");
        this.repos = new HashMap();
        this.forbiddenFruits = new HashSet<String>();
        this.parentDependencies = new HashMap();
        this.PATH_LOCAL_REPO = pepperOSGiConnector.getPepperStarterConfiguration().getTempPath().getAbsolutePath().concat("/local-repo/");
        try {
            File lr = new File(this.PATH_LOCAL_REPO);
            if (lr.exists()) {
                FileUtils.deleteDirectory((File)lr);
            }
        }
        catch (IOException e) {
            logger.warn("Failed to clean local repository.");
        }
        this.init();
        this.initDependencies();
    }

    private void init() {
        File blacklistFile = new File(BLACKLIST_PATH);
        if (blacklistFile.exists()) {
            try {
                FileReader fR = new FileReader(blacklistFile);
                BufferedReader reader = new BufferedReader(fR);
                String line = reader.readLine();
                while (line != null) {
                    this.forbiddenFruits.add(line);
                    line = reader.readLine();
                }
                reader.close();
                fR.close();
            }
            catch (IOException e) {
                logger.debug("Could not read blacklist file.", (Throwable)e);
            }
        }
    }

    private boolean initDependencies() {
        String frameworkVersion = this.pepperOSGiConnector.getFrameworkVersion();
        RemoteRepository repo = this.getRepo("korpling", KORPLING_MAVEN_REPO);
        this.getRepo("central", CENTRAL_REPO);
        if (this.forbiddenFruits.isEmpty()) {
            logger.info("Configuring update mechanism ...");
            DefaultArtifact pepArt = new DefaultArtifact(GROUP_ID_PEPPER, ARTIFACT_ID_PEPPER_PARENT, "pom", frameworkVersion);
            DefaultRepositorySystemSession session = this.getNewSession();
            CollectRequest collectRequest = new CollectRequest();
            collectRequest.setRoot(new Dependency((Artifact)pepArt, ""));
            collectRequest.setRepositories(null);
            collectRequest.addRepository(repo);
            collectRequest.addRepository(this.repos.get(CENTRAL_REPO));
            collectRequest.setRootArtifact((Artifact)pepArt);
            try {
                CollectResult collectResult = this.mvnSystem.collectDependencies((RepositorySystemSession)session, collectRequest);
                List<Dependency> allDeps = this.getAllDependencies(collectResult.getRoot(), false);
                this.parentDependencies.put(frameworkVersion.replace("-SNAPSHOT", ""), allDeps);
                Bundle bundle = null;
                STATUS status = null;
                for (Dependency dependency : allDeps) {
                    bundle = this.pepperOSGiConnector.getBundle(dependency.getArtifact().getGroupId(), dependency.getArtifact().getArtifactId(), null);
                    status = bundle == null || ((String)bundle.getHeaders().get("Bundle-SymbolicName")).contains("singleton:=true") ? STATUS.FINAL : STATUS.OVERRIDABLE;
                    this.forbiddenFruits.add(dependency.getArtifact().toString().concat(DELIMITER).concat(status.toString()).concat(DELIMITER).concat(bundle == null ? "" : bundle.getSymbolicName()));
                }
                this.write2Blacklist();
                collectResult = null;
            }
            catch (DependencyCollectionException e) {
                logger.warn("An error occured initializing the update mechanism. Please check your internet connection.", (Throwable)e);
                return false;
            }
            session = null;
            pepArt = null;
            collectRequest = null;
        }
        this.write2Blacklist();
        return true;
    }

    private DefaultRepositorySystemSession getNewSession() {
        DefaultRepositorySystemSession session = new DefaultRepositorySystemSession();
        LocalRepository localRepo = new LocalRepository(this.PATH_LOCAL_REPO);
        LocalRepositoryManager repoManager = this.mvnSystem.newLocalRepositoryManager((RepositorySystemSession)session, localRepo);
        session.setLocalRepositoryManager(repoManager);
        session.setRepositoryListener((RepositoryListener)this.repoListener);
        session.setTransferListener((TransferListener)this.transferListener);
        FatArtifactTraverser depTraverser = new FatArtifactTraverser();
        session.setDependencyTraverser((DependencyTraverser)depTraverser);
        ClassicDependencyManager depManager = new ClassicDependencyManager();
        session.setDependencyManager((DependencyManager)depManager);
        AndDependencySelector depFilter = new AndDependencySelector(new DependencySelector[]{new ScopeDependencySelector(new String[]{"test", "Test"}), new OptionalDependencySelector(), new ExclusionDependencySelector()});
        session.setDependencySelector((DependencySelector)depFilter);
        ConflictResolver transformer = new ConflictResolver((ConflictResolver.VersionSelector)new NearestVersionSelector(), (ConflictResolver.ScopeSelector)new JavaScopeSelector(), (ConflictResolver.OptionalitySelector)new SimpleOptionalitySelector(), (ConflictResolver.ScopeDeriver)new JavaScopeDeriver());
        session.setDependencyGraphTransformer((DependencyGraphTransformer)transformer);
        DefaultArtifactTypeRegistry stereotypes = new DefaultArtifactTypeRegistry();
        stereotypes.add((ArtifactType)new DefaultArtifactType("pom"));
        stereotypes.add((ArtifactType)new DefaultArtifactType("maven-plugin", "jar", "", "java"));
        stereotypes.add((ArtifactType)new DefaultArtifactType("jar", "jar", "", "java"));
        stereotypes.add((ArtifactType)new DefaultArtifactType("zip", "zip", "", "java"));
        stereotypes.add((ArtifactType)new DefaultArtifactType("ejb", "jar", "", "java"));
        stereotypes.add((ArtifactType)new DefaultArtifactType("ejb-client", "jar", "client", "java"));
        stereotypes.add((ArtifactType)new DefaultArtifactType("test-jar", "jar", "tests", "java"));
        stereotypes.add((ArtifactType)new DefaultArtifactType("javadoc", "jar", "javadoc", "java"));
        stereotypes.add((ArtifactType)new DefaultArtifactType("java-source", "jar", "sources", "java", false, false));
        stereotypes.add((ArtifactType)new DefaultArtifactType("war", "war", "", "java", false, true));
        stereotypes.add((ArtifactType)new DefaultArtifactType("ear", "ear", "", "java", false, true));
        stereotypes.add((ArtifactType)new DefaultArtifactType("rar", "rar", "", "java", false, true));
        stereotypes.add((ArtifactType)new DefaultArtifactType("par", "par", "", "java", false, true));
        session.setArtifactTypeRegistry((ArtifactTypeRegistry)stereotypes);
        session.setArtifactDescriptorPolicy((ArtifactDescriptorPolicy)new SimpleArtifactDescriptorPolicy(true, true));
        Properties sysProps = System.getProperties();
        session.setSystemProperties((Map)sysProps);
        session.setConfigProperties((Map)sysProps);
        session.setConfigProperty("aether.connector.requestTimeout", (Object)60000);
        return session;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean update(String groupId, String artifactId, String repositoryUrl, boolean isSnapshot, boolean ignoreFrameworkVersion, Bundle installedBundle) {
        if (this.forbiddenFruits.isEmpty() && !this.initDependencies()) {
            MavenAccessor.logger.warn("Update could not be performed, because the pepper dependencies could not be listed.");
            return false;
        }
        if (MavenAccessor.logger.isTraceEnabled()) {
            MavenAccessor.logger.trace("Starting update process for " + groupId + ", " + artifactId + ", " + repositoryUrl + ", isSnapshot=" + isSnapshot + ", ignoreFrameworkVersion=" + ignoreFrameworkVersion + ", installedBundle=" + installedBundle);
        } else {
            MavenAccessor.logger.info("Starting update process for " + artifactId);
        }
        newLine = System.getProperty("line.separator");
        session = this.getNewSession();
        update = true;
        repo = this.getRepo("repo", repositoryUrl);
        artifact = new DefaultArtifact(groupId, artifactId, "zip", "[0,)");
        try {
            rangeRequest = new VersionRangeRequest();
            rangeRequest.addRepository(repo);
            rangeRequest.setArtifact((Artifact)artifact);
            rangeResult = this.mvnSystem.resolveVersionRange((RepositorySystemSession)session, rangeRequest);
            rangeRequest.setArtifact((Artifact)artifact);
            artifactRequest = new ArtifactRequest();
            artifactRequest.addRepository(repo);
            artifactResult = null;
            versions = rangeResult.getVersions();
            Collections.reverse(versions);
            itVersions = versions.iterator();
            vScheme = new GenericVersionScheme();
            srcExists = false;
            installedVersion = installedBundle == null ? vScheme.parseVersion("0.0.0") : vScheme.parseVersion(installedBundle.getVersion().toString().replace(".SNAPSHOT", "-SNAPSHOT"));
            newestVersion = null;
            file = null;
            while (true) {
                block38: {
                    if (!srcExists && itVersions.hasNext() && update) break block38;
                }
                newestVersion = (Version)itVersions.next();
                artifact = new DefaultArtifact(groupId, artifactId, "zip", newestVersion.toString());
                if (artifact.isSnapshot() && !isSnapshot) continue;
                update = newestVersion.compareTo((Object)installedVersion) > 0;
                artifactRequest.setArtifact((Artifact)artifact);
                try {
                    artifactResult = this.mvnSystem.resolveArtifact((RepositorySystemSession)session, artifactRequest);
                    artifact = artifactResult.getArtifact();
                    srcExists = update != false && artifact.getFile().exists() != false;
                    file = artifact.getFile();
                }
                catch (ArtifactResolutionException e) {
                    MavenAccessor.logger.warn("Plugin version " + newestVersion + " could not be found in repository. Checking the next lower version ...");
                }
            }
            if (!(update &= file != null)) {
                MavenAccessor.logger.info("No (newer) version of " + artifactId + " could be found.");
                return update;
            }
            pom = new DefaultArtifact(artifact.getGroupId(), artifact.getArtifactId(), "pom", artifact.getVersion());
            artifactRequest.setArtifact((Artifact)pom);
            pomReadingErrors = false;
            try {
                artifactResult = null;
                artifactResult = this.mvnSystem.resolveArtifact((RepositorySystemSession)session, artifactRequest);
            }
            catch (ArtifactResolutionException e1) {
                pomReadingErrors = true;
            }
            repoList = new ArrayList<RemoteRepository>();
            repoList.add(this.repos.get("http://central.maven.org/maven2/"));
            repoList.add(this.repos.get(repositoryUrl));
            if (artifactResult != null && artifactResult.getArtifact().getFile().exists()) {
                try {
                    saxParser = SAXParserFactory.newInstance().newSAXParser();
                    saxParser.parse(artifactResult.getArtifact().getFile().getAbsolutePath(), (DefaultHandler)new POMReader(repoList));
                }
                catch (IOException | ParserConfigurationException | SAXException e) {
                    pomReadingErrors = true;
                }
            }
            if (pomReadingErrors) {
                MavenAccessor.logger.warn("Could not determine all relevant repositories, update might fail. Trying to continue ...");
                repoList.add(this.repos.get("http://korpling.german.hu-berlin.de/maven2/"));
            }
            if (installedBundle != null) {
                try {
                    if (!this.pepperOSGiConnector.remove(installedBundle.getSymbolicName())) {
                        MavenAccessor.logger.warn("Could not remove older version. Update process aborted.");
                        return false;
                    }
                    MavenAccessor.logger.info("Successfully removed version ".concat(installedBundle.getVersion().toString()).concat(" of ").concat(artifactId));
                }
                catch (IOException | BundleException e) {
                    MavenAccessor.logger.warn("An error occured while trying to remove OSGi bundle " + installedBundle.getSymbolicName() + ". This may cause update problems. Trying to continue ...");
                }
            }
            installArtifacts = new ArrayList<Object>();
            installArtifacts.add(artifact);
            collectRequest = new CollectRequest();
            collectRequest.setRoot(new Dependency((Artifact)artifact, ""));
            collectRequest.setRepositories(repoList);
            collectResult = this.mvnSystem.collectDependencies((RepositorySystemSession)session, collectRequest);
            allDependencies = this.getAllDependencies(collectResult.getRoot(), true);
            parentVersion = null;
            i = 0;
            while (true) {
                if (i >= allDependencies.size() || parentVersion != null) {
                    if (parentVersion != null) break;
                    MavenAccessor.logger.warn(String.valueOf(artifactId) + ": Could not perform update: pepper-parent version could not be determined.");
                    return false;
                }
                if ("pepper-framework".equals(allDependencies.get(i).getArtifact().getArtifactId())) {
                    parentVersion = allDependencies.get(i).getArtifact().getVersion();
                }
                ++i;
            }
            range = this.isCompatiblePlugin(parentVersion);
            if (!ignoreFrameworkVersion && range != null) {
                MavenAccessor.logger.info("No update was performed because of a version incompatibility according to pepper-framework: " + newLine + artifactId + " only supports " + range.toString() + ", but " + this.pepperOSGiConnector.getFrameworkVersion() + " is installed!" + newLine + "You can make pepper ignore this by using \"update" + (isSnapshot != false ? " snapshot " : " ") + "iv " + artifactId + "\"");
                return false;
            }
            allDependencies = this.cleanDependencies(allDependencies, (RepositorySystemSession)session, parentVersion);
            bundle = null;
            dependency = null;
            i = 1;
            while (true) {
                block37: {
                    block39: {
                        if (i < allDependencies.size()) break block39;
                        artifact = null;
                        installArtifact = null;
                        i = installArtifacts.size() - 1;
                        if (true) ** GOTO lbl166
                    }
                    dependency = allDependencies.get(i);
                    if (!"pepper-framework".equals(dependency.getArtifact().getArtifactId())) {
                        artifactRequest = new ArtifactRequest();
                        artifactRequest.setArtifact(dependency.getArtifact());
                        artifactRequest.setRepositories(repoList);
                        try {
                            artifactResult = this.mvnSystem.resolveArtifact((RepositorySystemSession)session, artifactRequest);
                            installArtifacts.add(artifactResult.getArtifact());
                        }
                        catch (ArtifactResolutionException e) {
                            MavenAccessor.logger.warn("Artifact " + dependency.getArtifact().getArtifactId() + " could not be resolved. Dependency will not be installed.");
                            if (Boolean.parseBoolean(this.pepperOSGiConnector.getPepperStarterConfiguration().getProperty("pepper.forceUpdate").toString())) break block37;
                            MavenAccessor.logger.error("Artifact ".concat(artifact.getArtifactId()).concat(" will not be installed. Resolution of dependency ").concat(dependency.getArtifact().getArtifactId()).concat(" failed and \"force update\" is disabled in pepper.properties."));
                            return false;
                        }
                    }
                }
                ++i;
            }
        }
        catch (DependencyCollectionException | VersionRangeResolutionException | InvalidVersionSpecificationException e) {
            if (e instanceof DependencyCollectionException == false) return false;
            t = e.getCause();
            if (true) ** GOTO lbl171
        }
        do {
            try {
                installArtifact = (Artifact)installArtifacts.get(i);
                MavenAccessor.logger.info("installing: " + installArtifact);
                bundle = this.pepperOSGiConnector.installAndCopy(installArtifact.getFile().toURI());
                if (i != 0) {
                    this.putOnBlacklist(installArtifact);
                }
                if (bundle != null) {
                    bundle.start();
                }
            }
            catch (IOException | BundleException e) {
                if (MavenAccessor.logger.isTraceEnabled()) {
                    MavenAccessor.logger.trace("File could not be installed: " + installArtifact + " (" + installArtifact.getFile() + "); " + e.getClass().getSimpleName());
                }
                MavenAccessor.logger.warn("File could not be installed: " + installArtifact.getFile());
            }
            --i;
lbl166:
            // 2 sources

        } while (i >= 0);
        this.write2Blacklist();
        return update;
        do {
            t = t.getCause();
lbl171:
            // 2 sources

        } while (t.getCause() != null);
        if (t instanceof ArtifactNotFoundException) {
            if (MavenAccessor.logger.isDebugEnabled()) {
                MavenAccessor.logger.debug(t.getMessage(), e);
            } else {
                MavenAccessor.logger.warn("Update of " + artifactId + " failed, could not resolve dependencies ");
            }
        }
        if (t instanceof HttpResponseException == false) return false;
        MavenAccessor.logger.error("Dependency resolution failed!" + System.lineSeparator() + "\tUnsatisfying http response: " + t.getMessage());
        return false;
    }

    private VersionRange isCompatiblePlugin(String pluginFrameworkVersion) {
        GenericVersionScheme vScheme = new GenericVersionScheme();
        try {
            Version frameworkVersion = vScheme.parseVersion(this.pepperOSGiConnector.getFrameworkVersion().replace(".SNAPSHOT", "-SNAPSHOT"));
            Version depParentVersion = vScheme.parseVersion(pluginFrameworkVersion);
            int m = 1 + Integer.parseInt(depParentVersion.toString().split("\\.")[0]);
            Version maxVersion = vScheme.parseVersion(String.valueOf(m) + ".0.0");
            String rangeString = "[".concat(pluginFrameworkVersion).concat(",").concat(maxVersion.toString()).concat(")");
            VersionRange range = vScheme.parseVersionRange(rangeString);
            if (!range.containsVersion(frameworkVersion)) {
                return range;
            }
        }
        catch (InvalidVersionSpecificationException e) {
            logger.error("Could not compare required framework version to running framework. Trying to perform update anyway...");
        }
        return null;
    }

    private List<Dependency> getAllDependencies(DependencyNode startNode, boolean skipFramework) {
        ArrayList<Dependency> retVal = new ArrayList<Dependency>();
        retVal.add(startNode.getDependency());
        for (DependencyNode node : startNode.getChildren()) {
            boolean isFramework = ARTIFACT_ID_PEPPER_FRAMEWORK.equals(node.getArtifact().getArtifactId());
            boolean isSalt = node.getArtifact().getArtifactId().contains("salt-");
            if (isFramework && !skipFramework || !isFramework && !isSalt) {
                String blackListLine = this.getBlackListString(node.getArtifact());
                if (blackListLine != null && blackListLine.split(DELIMITER)[4].equals(STATUS.FINAL.toString())) continue;
                if ("provided".equalsIgnoreCase(startNode.getDependency().getScope())) {
                    this.putOnBlacklist(node.getArtifact());
                    return Collections.emptyList();
                }
                retVal.addAll(this.getAllDependencies(node, skipFramework));
                continue;
            }
            if (!skipFramework || !isFramework) continue;
            retVal.add(node.getDependency());
        }
        return retVal;
    }

    private void putOnBlacklist(Artifact artifact) {
        if (this.getBlackListString(artifact) == null) {
            Bundle bundle = this.pepperOSGiConnector.getBundle(artifact.getGroupId(), artifact.getArtifactId(), null);
            STATUS status = bundle == null || !this.pepperOSGiConnector.isSingleton(bundle) ? STATUS.OVERRIDABLE : STATUS.FINAL;
            this.forbiddenFruits.add(artifact.toString().concat(DELIMITER).concat(status.toString()).concat(DELIMITER).concat(bundle == null ? "" : bundle.getSymbolicName()));
            logger.debug("Put dependency on blacklist: ".concat(artifact.toString()));
        }
    }

    private String getBlackListString(Artifact artifact) {
        String as = artifact.toString().substring(0, artifact.toString().lastIndexOf(DELIMITER.charAt(0)));
        for (String artifactString : this.forbiddenFruits) {
            if (!artifactString.startsWith(as) && !artifactString.split(DELIMITER)[1].equals(as.split(DELIMITER)[1])) continue;
            return artifactString;
        }
        return null;
    }

    private void write2Blacklist() {
        File blacklistFile = new File(BLACKLIST_PATH);
        if (!blacklistFile.exists()) {
            if (!blacklistFile.getParentFile().exists() && !blacklistFile.getParentFile().mkdirs()) {
                logger.warn("Cannot create folder {}. ", (Object)blacklistFile.getParentFile());
            }
            try {
                if (!blacklistFile.createNewFile()) {
                    logger.warn("Cannot create file {}. ", (Object)blacklistFile);
                }
            }
            catch (IOException e) {
                logger.warn("Could not write blacklist file.");
            }
        }
        try {
            PrintWriter fW = new PrintWriter(blacklistFile);
            BufferedWriter bW = new BufferedWriter(fW);
            for (String s : this.forbiddenFruits) {
                bW.write(s);
                bW.newLine();
            }
            bW.close();
            fW.close();
        }
        catch (IOException e) {
            logger.warn("Could not write blacklist file.");
        }
    }

    public String getBlacklist() {
        String lineSeparator = System.getProperty("line.separator");
        String indent = "\t";
        StringBuilder retVal = new StringBuilder().append(lineSeparator);
        retVal.append(indent).append("installed dependencies:").append(lineSeparator).append(lineSeparator);
        for (String s : this.forbiddenFruits) {
            retVal.append(indent).append(s).append(lineSeparator);
        }
        return retVal.toString();
    }

    private List<Dependency> cleanDependencies(List<Dependency> dependencies, RepositorySystemSession session, String parentVersion) {
        try {
            List<Dependency> parentDeps;
            List<Dependency> checkList = this.parentDependencies.get(parentVersion.replace("-SNAPSHOT", ""));
            if (checkList == null) {
                CollectRequest collectRequest = new CollectRequest();
                collectRequest.setRoot(new Dependency((Artifact)new DefaultArtifact(GROUP_ID_PEPPER, ARTIFACT_ID_PEPPER_PARENT, "pom", parentVersion), ""));
                collectRequest.addRepository(this.repos.get(CENTRAL_REPO));
                collectRequest.addRepository(this.repos.get(KORPLING_MAVEN_REPO));
                CollectResult collectResult = this.mvnSystem.collectDependencies(session, collectRequest);
                parentDeps = this.getAllDependencies(collectResult.getRoot(), false);
                this.parentDependencies.put(parentVersion.replace("-SNAPSHOT", ""), parentDeps);
            } else {
                parentDeps = checkList;
            }
            Iterator<Dependency> itDeps = parentDeps.iterator();
            Dependency next = itDeps.next();
            while (!ARTIFACT_ID_PEPPER_FRAMEWORK.equals(next.getArtifact().getArtifactId()) && itDeps.hasNext()) {
                next = itDeps.next();
            }
            itDeps = null;
            int j = 0;
            ArrayList<Dependency> newDeps = new ArrayList<Dependency>();
            STATUS status = null;
            int i = 0;
            while (i < dependencies.size()) {
                j = 0;
                next = dependencies.get(i);
                status = this.getDependencyStatus(next.toString());
                while (j < parentDeps.size() && !next.getArtifact().getArtifactId().equals(parentDeps.get(j).getArtifact().getArtifactId()) && !STATUS.OVERRIDABLE.equals((Object)status)) {
                    ++j;
                }
                if (!"provided".equals(next.getScope()) && (j == parentDeps.size() || STATUS.OVERRIDABLE.equals((Object)status))) {
                    newDeps.add(next);
                } else {
                    this.forbiddenFruits.add(String.valueOf(next.getArtifact().toString()) + DELIMITER + (Object)((Object)STATUS.FINAL));
                    logger.debug("The following dependency was put on blacklist, because it equals a parent dependency: " + next.getArtifact().toString());
                }
                ++i;
            }
            return newDeps;
        }
        catch (DependencyCollectionException e) {
            logger.warn("Could not collect dependencies for parent. No dependencies will be installed.");
            ArrayList<Dependency> retVal = new ArrayList<Dependency>();
            return retVal;
        }
    }

    private STATUS getDependencyStatus(String dependencyString) {
        dependencyString = dependencyString.substring(0, dependencyString.lastIndexOf(58));
        for (String fruit : this.forbiddenFruits) {
            if (!fruit.startsWith(dependencyString)) continue;
            if (fruit.split(DELIMITER)[4].equals(STATUS.FINAL.toString())) {
                return STATUS.FINAL;
            }
            return STATUS.OVERRIDABLE;
        }
        return null;
    }

    private RemoteRepository getRepo(String id, String url) {
        RemoteRepository repo = this.repos.get(url);
        if (repo == null) {
            this.repoBuilder.setId(id);
            this.repoBuilder.setUrl(url);
            repo = this.repoBuilder.build();
            this.repos.put(url, repo);
        }
        return repo;
    }

    public String printDependencies(String groupId, String artifactId, String version, String repositoryUrl) {
        RemoteRepository repo = null;
        repo = repositoryUrl == null ? this.getRepo("korpling", KORPLING_MAVEN_REPO) : this.getRepo("repository", repositoryUrl);
        DefaultRepositorySystemSession session = this.getNewSession();
        DefaultArtifact artifact = new DefaultArtifact(groupId, artifactId, "pom", version == null ? "[0,)" : version);
        if (version == null) {
            VersionRangeRequest request = new VersionRangeRequest();
            request.setArtifact((Artifact)artifact);
            if (repositoryUrl == null) {
                request.addRepository(this.repos.get(CENTRAL_REPO));
            }
            request.addRepository(repo);
            try {
                VersionRangeResult rangeResult = this.mvnSystem.resolveVersionRange((RepositorySystemSession)session, request);
                version = rangeResult.getHighestVersion().toString();
                artifact.setVersion(version);
            }
            catch (VersionRangeResolutionException e) {
                logger.error("Could not determine newest version.");
                return null;
            }
        }
        CollectRequest collectRequest = new CollectRequest();
        collectRequest.setRoot(new Dependency((Artifact)artifact, ""));
        if (repositoryUrl == null) {
            collectRequest.addRepository(this.repos.get(CENTRAL_REPO));
        }
        collectRequest.addRepository(repo);
        try {
            CollectResult collectResult = this.mvnSystem.collectDependencies((RepositorySystemSession)session, collectRequest);
            return this.getDependencyPrint(collectResult.getRoot(), 0);
        }
        catch (DependencyCollectionException e) {
            logger.error("Could not print dependencies for ".concat(artifactId).concat("."));
            return null;
        }
    }

    private String getDependencyPrint(DependencyNode startNode, int depth) {
        StringBuilder dep = new StringBuilder();
        int i = 0;
        while (i < depth) {
            dep.append(" ");
            ++i;
        }
        dep.append(depth == 0 ? "" : "+- ");
        dep.append(startNode.getArtifact().toString().concat(" (").concat(startNode.getDependency().getScope()).concat(")"));
        for (DependencyNode node : startNode.getChildren()) {
            dep.append(System.lineSeparator().concat(this.getDependencyPrint(node, depth + 1)));
        }
        return dep.toString();
    }

    protected String printDependencies(Bundle bundle) {
        String[] coords = null;
        for (String s : this.forbiddenFruits) {
            coords = s.split(DELIMITER);
            if (bundle == null || coords.length != 6 || !coords[5].equals(bundle.getSymbolicName())) continue;
            return this.printDependencies(coords[0], coords[1], coords[3].replace(".SNAPSHOT", "-SNAPSHOT"), null);
        }
        return this.printDependencies(bundle.getSymbolicName().substring(0, bundle.getSymbolicName().lastIndexOf(46)), bundle.getSymbolicName().substring(bundle.getSymbolicName().lastIndexOf(46) + 1), bundle.getVersion().toString(), KORPLING_MAVEN_REPO);
    }

    private static class MavenRepositoryListener
    extends AbstractRepositoryListener {
        private final boolean TRACE = MavenAccessor.access$0().isTraceEnabled();

        private MavenRepositoryListener() {
        }

        public void artifactDeployed(RepositoryEvent event) {
            if (this.TRACE) {
                logger.trace("Deployed " + event.getArtifact() + " to " + event.getRepository());
            }
        }

        public void artifactDeploying(RepositoryEvent event) {
            if (this.TRACE) {
                logger.trace("Deploying " + event.getArtifact() + " to " + event.getRepository());
            }
        }

        public void artifactDescriptorInvalid(RepositoryEvent event) {
            if (this.TRACE) {
                logger.trace("Invalid artifact descriptor for " + event.getArtifact() + ": " + event.getException().getMessage());
            }
        }

        public void artifactDescriptorMissing(RepositoryEvent event) {
            if (this.TRACE) {
                logger.trace("Missing artifact descriptor for " + event.getArtifact());
            }
        }

        public void artifactInstalled(RepositoryEvent event) {
            if (this.TRACE) {
                logger.trace("Installed " + event.getArtifact() + " to " + event.getFile());
            }
        }

        public void artifactInstalling(RepositoryEvent event) {
            if (this.TRACE) {
                logger.trace("Installing " + event.getArtifact() + " to " + event.getFile());
            }
        }

        public void artifactResolved(RepositoryEvent event) {
            if (this.TRACE) {
                logger.trace("Resolved artifact " + event.getArtifact() + " from " + event.getRepository());
            }
        }

        public void artifactDownloading(RepositoryEvent event) {
            if (this.TRACE) {
                logger.trace("Downloading artifact " + event.getArtifact() + " from " + event.getRepository());
            }
        }

        public void artifactDownloaded(RepositoryEvent event) {
            if (this.TRACE) {
                logger.trace("Downloaded artifact " + event.getArtifact() + " from " + event.getRepository());
            }
        }

        public void artifactResolving(RepositoryEvent event) {
            if (this.TRACE) {
                logger.trace("Resolving artifact " + event.getArtifact());
            }
        }

        public void metadataDeployed(RepositoryEvent event) {
            if (this.TRACE) {
                logger.trace("Deployed " + event.getMetadata() + " to " + event.getRepository());
            }
        }

        public void metadataDeploying(RepositoryEvent event) {
            if (this.TRACE) {
                logger.trace("Deploying " + event.getMetadata() + " to " + event.getRepository());
            }
        }

        public void metadataInstalled(RepositoryEvent event) {
            if (this.TRACE) {
                logger.trace("Installed " + event.getMetadata() + " to " + event.getFile());
            }
        }

        public void metadataInstalling(RepositoryEvent event) {
            if (this.TRACE) {
                logger.trace("Installing " + event.getMetadata() + " to " + event.getFile());
            }
        }

        public void metadataInvalid(RepositoryEvent event) {
            if (this.TRACE) {
                logger.trace("Invalid metadata {}", (Object)event.getMetadata());
            }
        }

        public void metadataResolved(RepositoryEvent event) {
            if (this.TRACE) {
                logger.trace("Resolved metadata " + event.getMetadata() + " from " + event.getRepository());
            }
        }

        public void metadataResolving(RepositoryEvent event) {
            if (this.TRACE) {
                logger.trace("Resolving metadata " + event.getMetadata() + " from " + event.getRepository());
            }
        }
    }

    private static class MavenTransferListener
    extends AbstractTransferListener {
        private final boolean TRACE = MavenAccessor.access$0().isTraceEnabled();

        private MavenTransferListener() {
        }

        public void transferInitiated(TransferEvent event) {
            String message;
            String string = message = event.getRequestType() == TransferEvent.RequestType.PUT ? "Uploading" : "Downloading";
            if (this.TRACE) {
                logger.trace(String.valueOf(message) + ": " + event.getResource().getRepositoryUrl() + event.getResource().getResourceName());
            }
        }

        public void transferProgressed(TransferEvent event) {
        }

        public void transferSucceeded(TransferEvent event) {
            if (this.TRACE) {
                this.transferCompleted(event);
                TransferResource resource = event.getResource();
                long contentLength = event.getTransferredBytes();
                if (contentLength >= 0L) {
                    String type = event.getRequestType() == TransferEvent.RequestType.PUT ? "Uploaded" : "Downloaded";
                    String len = contentLength >= 1024L ? String.valueOf(this.toKB(contentLength)) + " KB" : String.valueOf(contentLength) + " B";
                    String throughput = "";
                    long duration = System.currentTimeMillis() - resource.getTransferStartTime();
                    if (duration > 0L) {
                        long bytes = contentLength - resource.getResumeOffset();
                        DecimalFormat format = new DecimalFormat("0.0", new DecimalFormatSymbols(Locale.ENGLISH));
                        double kbPerSec = (double)bytes / 1024.0 / ((double)duration / 1000.0);
                        throughput = " at " + format.format(kbPerSec) + " KB/sec";
                    }
                    logger.trace(String.valueOf(type) + ": " + resource.getRepositoryUrl() + resource.getResourceName() + " (" + len + throughput + ")");
                }
            }
        }

        public void transferFailed(TransferEvent event) {
            if (this.TRACE) {
                this.transferCompleted(event);
                if (!(event.getException() instanceof MetadataNotFoundException)) {
                    logger.trace("An error occured transfering " + event.getResource(), (Throwable)event.getException());
                }
            }
        }

        private void transferCompleted(TransferEvent event) {
            logger.trace("Transfer completed.");
        }

        public void transferCorrupted(TransferEvent event) {
            if (this.TRACE) {
                logger.trace("Transfer corrupted.", (Throwable)event.getException());
            }
        }

        protected long toKB(long bytes) {
            return (bytes + 1023L) / 1024L;
        }
    }

    private class POMReader
    extends DefaultHandler2 {
        private boolean read = true;
        static final String TAG_REPOSITORIES = "repositories";
        static final String TAG_REPOSITORY = "repository";
        static final String TAG_URL = "url";
        static final String TAG_ID = "id";
        static final String ROOT_TAG = "project";
        private String pppparent = null;
        private String ppparent = null;
        private String pparent = null;
        private String parent = null;
        private String currTag = null;
        private StringBuilder chars = new StringBuilder();
        private String url = null;
        private String id = null;
        private List<RemoteRepository> resultsList;

        private POMReader(List<RemoteRepository> targetList) {
            this.resultsList = targetList;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            if (this.read) {
                localName = qName.substring(qName.lastIndexOf(MavenAccessor.DELIMITER) + 1);
                this.pppparent = this.ppparent;
                this.ppparent = this.pparent;
                this.pparent = this.parent;
                this.parent = this.currTag;
                this.currTag = localName;
                this.chars.delete(0, this.chars.length());
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.read && ROOT_TAG.equals(this.ppparent) && TAG_REPOSITORIES.equals(this.pparent) && TAG_REPOSITORY.equals(this.parent) && (TAG_ID.equals(this.currTag) || TAG_URL.equals(this.currTag))) {
                int i = start;
                while (i < start + length) {
                    this.chars.append(ch[i]);
                    ++i;
                }
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (this.read) {
                boolean constraint;
                localName = qName.substring(qName.lastIndexOf(MavenAccessor.DELIMITER) + 1);
                boolean bl = constraint = ROOT_TAG.equals(this.ppparent) && TAG_REPOSITORIES.equals(this.pparent) && TAG_REPOSITORY.equals(this.parent);
                if (constraint && TAG_URL.equals(localName)) {
                    this.url = this.chars.toString();
                } else if (constraint && TAG_ID.equals(localName)) {
                    this.id = this.chars.toString();
                } else if (ROOT_TAG.equals(this.pparent) && TAG_REPOSITORIES.equals(this.parent) && TAG_REPOSITORY.equals(localName)) {
                    this.resultsList.add(MavenAccessor.this.getRepo(this.id, this.url));
                } else if (ROOT_TAG.equals(this.parent) && TAG_REPOSITORIES.equals(localName)) {
                    this.read = false;
                }
                this.chars.delete(0, this.chars.length());
                this.currTag = this.parent;
                this.parent = this.pparent;
                this.pparent = this.ppparent;
                this.ppparent = this.pppparent;
                this.pppparent = null;
            }
        }
    }

    private static enum STATUS {
        OVERRIDABLE,
        FINAL;

    }
}

