/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.pepper.cli;

import com.google.common.base.Splitter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.corpus_tools.pepper.cli.exceptions.PepperPropertyException;
import org.corpus_tools.pepper.common.PepperConfiguration;

public class PepperStarterConfiguration
extends PepperConfiguration {
    public static final String PROP_PREFIX = "pepper.";
    public static final String ENV_PEPPER_HOME = "PEPPER_HOME";
    public static final String PROP_PEPPER_HOME = "pepper.home";
    public static final String PROP_CONSOLE_WIDTH = "pepper.console.width";
    public static final String KEY_PEPPER_HOME = "$PEPPER_HOME";
    public static final String FILE_PEPPER_PROP = "pepper.properties";
    public static final String FILE_PEPPER_TEST_PROP = "pepper-test.properties";
    public static final String FILE_PEPPER_CONF = "conf";
    public static final String PROP_PLUGIN_PATH = "pepper.plugin.path";
    public static final String PROP_DROPIN_PATHS = "pepper.dropin.paths";
    public static final String PROP_OSGI_PROFILE = "pepper.osgi.profile";
    public static final String PROP_OSGI_SHAREDPACKAGES = "pepper.org.osgi.framework.system.packages";

    public static File findPepperHome() {
        String pepperHome = null;
        pepperHome = System.getenv().get(ENV_PEPPER_HOME);
        if (pepperHome == null) {
            pepperHome = System.getProperty(PROP_PEPPER_HOME);
        }
        if (pepperHome == null) {
            pepperHome = String.valueOf(System.getProperty("user.dir")) + "/";
        }
        if (!pepperHome.endsWith("/") && !pepperHome.endsWith("\\")) {
            pepperHome = String.valueOf(pepperHome) + "/";
        }
        pepperHome = pepperHome.replace("\\", "/");
        File pepperHomeFile = new File(pepperHome);
        return pepperHomeFile;
    }

    public PepperStarterConfiguration() {
    }

    public PepperStarterConfiguration(File propertiesFile) {
        this.load(propertiesFile);
    }

    public void load() {
        File pepperHome = PepperStarterConfiguration.findPepperHome();
        File propFile = new File(String.valueOf(pepperHome.getAbsolutePath()) + "/" + FILE_PEPPER_CONF + "/" + FILE_PEPPER_TEST_PROP + "/");
        if (!propFile.exists()) {
            propFile = new File(String.valueOf(pepperHome.getAbsolutePath()) + "/" + FILE_PEPPER_CONF + "/" + FILE_PEPPER_PROP + "/");
        }
        this.load(propFile);
    }

    public void load(File propertiesFile) {
        if (!propertiesFile.exists()) {
            throw new PepperPropertyException("Cannot read pepper property file, because it does not exist '" + propertiesFile.getAbsolutePath() + "'.");
        }
        try {
            this.setConfFolder(propertiesFile.getParentFile());
            this.load(new FileInputStream(propertiesFile));
            this.cleanUp_PepperPath();
        }
        catch (FileNotFoundException e) {
            throw new PepperPropertyException("Cannot read pepper property file, because of a nested exception.", e);
        }
        catch (IOException e) {
            throw new PepperPropertyException("Cannot read pepper property file, because of a nested exception.", e);
        }
    }

    private void cleanUp_PepperPath() {
        String replacePath = PepperStarterConfiguration.findPepperHome().getAbsolutePath();
        for (Object key : Collections.synchronizedSet(this.keySet())) {
            this.put(key, this.get(key).toString().replace(KEY_PEPPER_HOME, replacePath));
        }
    }

    public String getPlugInPath() {
        return this.getProperty(PROP_PLUGIN_PATH);
    }

    public List<String> getDropInPaths() {
        String rawList = this.getProperty(PROP_DROPIN_PATHS);
        if (rawList != null) {
            Iterator it = Splitter.on((char)',').trimResults().omitEmptyStrings().split((CharSequence)rawList).iterator();
            ArrayList<String> result = new ArrayList<String>();
            while (it.hasNext()) {
                result.add((String)it.next());
            }
            return result;
        }
        return null;
    }

    public String getPepperEMail() {
        return "saltnpepper@lists.hu-berlin.de";
    }

    public String getPepperHomepage() {
        return "http://corpus-tools.org/pepper/";
    }

    public File getOSGiProfileFile() {
        String osgiProfile = this.getProperty(PROP_OSGI_PROFILE);
        if (osgiProfile == null || osgiProfile.isEmpty()) {
            return null;
        }
        File osgiProfileFile = new File(osgiProfile);
        return osgiProfileFile;
    }

    public String getSharedPackages() {
        return this.getProperty(PROP_OSGI_SHAREDPACKAGES);
    }

    public int getConsoleWidth() {
        Integer width = null;
        String widthProp = this.getProperty(PROP_CONSOLE_WIDTH);
        if (widthProp != null && !widthProp.isEmpty()) {
            try {
                width = Integer.valueOf(widthProp.trim());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (width == null) {
            width = 120;
        }
        width = width < 120 ? Integer.valueOf(80) : Integer.valueOf(120);
        return width;
    }
}

