/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.pepper.cli;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.corpus_tools.pepper.connectors.impl.PepperOSGiConnector;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceReference;

public class OSGiConsole {
    private static final String PROMPT = "osgi>";
    private String prompt = null;
    private PepperOSGiConnector connector = null;

    public PepperOSGiConnector getConnector() {
        return this.connector;
    }

    public OSGiConsole(PepperOSGiConnector connector, String prefixPrompt) {
        this.prompt = String.valueOf(prefixPrompt) + "/" + PROMPT;
        this.connector = connector;
    }

    public void start() {
        this.start(new BufferedReader(new InputStreamReader(System.in)), System.out);
    }

    public String help() {
        StringBuilder retVal = new StringBuilder();
        String format = "| %1$-20s | %2$-5s | %3$-15s | %4$-70s |\n";
        String line = "+----------------------+-------+-----------------+------------------------------------------------------------------------+\n";
        retVal.append(line);
        retVal.append(String.format(format, "command", "short", "parameters", "description"));
        retVal.append(line);
        COMMAND[] cOMMANDArray = COMMAND.values();
        int n = cOMMANDArray.length;
        int n2 = 0;
        while (n2 < n) {
            COMMAND command = cOMMANDArray[n2];
            retVal.append(String.format(format, command.getName(), command.getAbbreviation(), command.getParameters() == null ? " -- " : command.getParameters(), command.getDescription()));
            ++n2;
        }
        retVal.append(line);
        return retVal.toString();
    }

    public void start(BufferedReader in, PrintStream out) {
        boolean exit = false;
        String userInput = null;
        while (!exit) {
            try {
                out.print(this.prompt);
                userInput = in.readLine();
            }
            catch (IOException ioe) {
                out.println("Cannot read command, type in 'help' for help.");
            }
            if (userInput == null) continue;
            userInput = userInput.trim();
            String[] parts = userInput.split(" ");
            String command = parts[0];
            Vector<String> params = new Vector<String>();
            int i = 0;
            String[] stringArray = parts;
            int n = parts.length;
            int n2 = 0;
            while (n2 < n) {
                String part = stringArray[n2];
                if (i > 0) {
                    params.add(part);
                }
                ++i;
                ++n2;
            }
            if ("exit".equalsIgnoreCase(command)) {
                exit = true;
                continue;
            }
            if ("help".equalsIgnoreCase(command)) {
                out.println(this.help());
                continue;
            }
            if (COMMAND.SS.getName().equalsIgnoreCase(command) || COMMAND.SS.getAbbreviation().equalsIgnoreCase(command)) {
                this.ss(params, out);
                continue;
            }
            if (COMMAND.LS.getName().equalsIgnoreCase(command) || COMMAND.LS.getAbbreviation().equalsIgnoreCase(command)) {
                this.ls(params, out);
                continue;
            }
            if (COMMAND.INSTALL.getName().equalsIgnoreCase(command) || COMMAND.INSTALL.getAbbreviation().equalsIgnoreCase(command)) {
                this.install(params, out);
                continue;
            }
            if (COMMAND.STOP.getName().equalsIgnoreCase(command) || COMMAND.STOP.getAbbreviation().equalsIgnoreCase(command)) {
                this.stop(params, out);
                continue;
            }
            if (COMMAND.START.getName().equalsIgnoreCase(command) || COMMAND.START.getAbbreviation().equalsIgnoreCase(command)) {
                this.start(params, out);
                continue;
            }
            if (COMMAND.UNINSTALL.getName().equalsIgnoreCase(command) || COMMAND.UNINSTALL.getAbbreviation().equalsIgnoreCase(command)) {
                this.uninstall(params, out);
                continue;
            }
            if (COMMAND.INSTALL_START.getName().equalsIgnoreCase(command) || COMMAND.INSTALL_START.getAbbreviation().equalsIgnoreCase(command)) {
                this.installAndStart(params, out);
                continue;
            }
            if (COMMAND.UPDATE.getName().equalsIgnoreCase(command) || COMMAND.UPDATE.getAbbreviation().equalsIgnoreCase(command)) {
                this.update(params, out);
                continue;
            }
            if (COMMAND.REMOVE.getName().equalsIgnoreCase(command) || COMMAND.REMOVE.getAbbreviation().equalsIgnoreCase(command)) {
                this.remove(params, out);
                continue;
            }
            out.println(this.help());
        }
    }

    public void ss(List<String> params, PrintStream out) {
        String format = "| %1$-10s | %2$-15s | %3$-60s | %4$-20s |\n";
        out.append("+------------+-----------------+----------------------------------------------------------------------------------+\n");
        out.print(String.format(format, "id", "state", "bundle name", "version"));
        out.append("+------------+-----------------+----------------------------------------------------------------------------------+\n");
        if (this.getConnector().getBundleContext().getBundles() != null) {
            Bundle[] bundleArray = this.getConnector().getBundleContext().getBundles();
            int n = bundleArray.length;
            int n2 = 0;
            while (n2 < n) {
                Bundle bundle = bundleArray[n2];
                out.print(String.format(format, bundle.getBundleId(), this.transformState(bundle.getState()), bundle.getSymbolicName(), bundle.getVersion()));
                ++n2;
            }
        }
        out.append("+------------+-----------------+----------------------------------------------------------------------------------+\n");
    }

    public void ls(List<String> params, PrintStream out) {
        String format = "| %1$-10s | %2$-15s | %3$-80s | %4$-80s |\n";
        out.append("+------------+-----------------+----------------------------------------------------------------------------------+----------------------------------------------------------------------------------+\n");
        out.print(String.format(format, "id", "state", "component name", "bundle name"));
        out.append("+------------+-----------------+----------------------------------------------------------------------------------+----------------------------------------------------------------------------------+\n");
        if (this.getConnector().getBundleContext().getBundles() != null) {
            Bundle[] bundleArray = this.getConnector().getBundleContext().getBundles();
            int n = bundleArray.length;
            int n2 = 0;
            while (n2 < n) {
                Bundle bundle = bundleArray[n2];
                if (bundle.getRegisteredServices() != null) {
                    ServiceReference[] serviceReferenceArray = bundle.getRegisteredServices();
                    int n3 = serviceReferenceArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        ServiceReference ref = serviceReferenceArray[n4];
                        out.print(String.format(format, bundle.getBundleId(), this.transformState(bundle.getState()), this.getConnector().getBundleContext().getService(ref), bundle.getSymbolicName()));
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        out.append("+------------+-----------------+----------------------------------------------------------------------------------+----------------------------------------------------------------------------------+\n");
    }

    public Long install(List<String> params, PrintStream out) {
        Long retVal = null;
        if (params == null || params.size() != 1) {
            out.println("To install a bundle, you need to pass a path as URI.");
        } else {
            URI bundleURI = null;
            try {
                bundleURI = URI.create(params.get(0));
                if (bundleURI.getScheme() == null) {
                    bundleURI = URI.create("file:" + params.get(0));
                }
            }
            catch (Exception e) {
                out.println("Cannot load bundle at path '" + params.get(0) + "'.");
            }
            if (bundleURI != null) {
                Bundle bundle = null;
                try {
                    bundle = this.getConnector().installAndCopy(bundleURI);
                }
                catch (BundleException e) {
                    out.println("Cannot install bundle at path '" + params.get(0) + "' because of a nested exception. " + e.getMessage());
                }
                catch (IOException e) {
                    out.println("Cannot install bundle at path '" + params.get(0) + "' because of a nested exception. " + e.getMessage());
                }
                if (bundle != null) {
                    out.println("bundle installed with id '" + bundle.getBundleId() + "'.");
                    retVal = bundle.getBundleId();
                }
            }
        }
        return retVal;
    }

    public void start(List<String> params, PrintStream out) {
        if (params == null || params.size() != 1) {
            out.println("To start a bundle, you need to pass a bundle id.");
        } else {
            Long bundleId = null;
            try {
                bundleId = Long.valueOf(params.get(0));
            }
            catch (NumberFormatException e) {
                out.println("The passed bundle id '" + params.get(0) + "'is not a valid id.");
            }
            if (bundleId != null) {
                this.getConnector().start(bundleId);
                out.println("started bundle with id '" + bundleId + "'");
            }
        }
    }

    public void installAndStart(List<String> params, PrintStream out) {
        Long bundleId = this.install(params, out);
        ArrayList<String> params2 = new ArrayList<String>();
        if (bundleId != null) {
            params2.add("" + bundleId);
            this.start(params2, out);
        }
    }

    public void update(List<String> params, PrintStream out) {
        if (params == null) {
            out.println("stupid help text");
        } else if (params.size() == 1) {
            params.get(0).equals("all");
        }
    }

    public void stop(List<String> params, PrintStream out) {
        Long bundleId = null;
        if (params == null || params.size() != 1) {
            out.println("To stop a bundle, you need to pass a bundle id.");
        } else {
            try {
                bundleId = Long.valueOf(params.get(0));
            }
            catch (NumberFormatException e) {
                out.println("The passed bundle id '" + params.get(0) + "'is not a valid id.");
            }
            if (bundleId != null) {
                try {
                    this.getConnector().getBundleContext().getBundle(bundleId.longValue()).stop();
                    out.println("Stopped bundle '" + bundleId + "'");
                }
                catch (BundleException e) {
                    out.println("Cannot stop bundle '" + bundleId + "' because of a nested exception. " + e.getMessage());
                }
            }
        }
    }

    public void uninstall(List<String> params, PrintStream out) {
        Long bundleId = null;
        URI bundleURI = null;
        if (params == null || params.size() != 1) {
            out.println("To uninstall a bundle, you need to pass a bundle id.");
        } else {
            try {
                bundleId = Long.valueOf(params.get(0));
            }
            catch (NumberFormatException e) {
                try {
                    bundleURI = URI.create(params.get(0));
                }
                catch (IllegalArgumentException e1) {
                    out.println("The passed bundle id '" + params.get(0) + "'is neither a valid id nor a valid bundle location. Please use only digits for ids and the URI syntax for bundle locations");
                }
            }
            if (bundleId != null) {
                try {
                    this.getConnector().uninstall(bundleId);
                    out.println("Uninstalled bundle '" + bundleId + "'");
                }
                catch (BundleException e) {
                    out.println("Cannot uninstall bundle '" + bundleId + "' because of a nested exception. " + e.getMessage());
                }
            } else if (bundleURI != null) {
                try {
                    this.getConnector().uninstall(bundleURI);
                    out.println("Uninstalled bundle from loaction '" + bundleURI + "'");
                }
                catch (BundleException e) {
                    out.println("Cannot uninstall bundle from location '" + bundleURI + "' because of a nested exception. " + e.getMessage());
                }
            }
        }
    }

    public void remove(List<String> params, PrintStream out) {
        if (params == null || params.size() > 1) {
            out.println("To remove a bundle, you need to pass its name.");
        } else {
            try {
                if (this.getConnector().remove(params.get(0))) {
                    out.println("Removed bundle '" + params.get(0) + "'.");
                } else {
                    out.println("Cannot remove bundle '" + params.get(0) + "'.");
                }
            }
            catch (BundleException e) {
                out.println("Cannot remove bundle '" + params.get(0) + "', because of nested exception (BundleException): " + e.getMessage());
            }
            catch (IOException e) {
                out.println("Cannot remove bundle '" + params.get(0) + "', because of nested exception (IOException): " + e.getMessage());
            }
        }
    }

    public String transformState(int state) {
        String retVal = null;
        switch (state) {
            case 32: {
                retVal = "ACTIVE";
                break;
            }
            case 2: {
                retVal = "INSTALLED";
                break;
            }
            case 4: {
                retVal = "RESOLVED";
                break;
            }
            case 1: {
                retVal = "SIGNERS_ALL";
                break;
            }
            case 8: {
                retVal = "STARTING";
                break;
            }
            case 16: {
                retVal = "STOPPING";
                break;
            }
            default: {
                retVal = "UNKNOWN";
            }
        }
        return retVal;
    }

    public static enum COMMAND {
        SS("ss", "ss", null, "display installed bundles (short status)"),
        LS("list", "ls", null, "lists all components"),
        INSTALL("install", "i", "bundle path", "install and optionally start bundle from the given URL"),
        UNINSTALL("uninstall", "un", "bundle id", "uninstall the specified bundle"),
        START("start", "s", "bundle id", "start the specified bundle"),
        STOP("stop", "stop", "bundle id", "stop the specified bundle"),
        INSTALL_START("install_start", "is", "bundle path", "installs the bundle located at 'bundle path' and starts it"),
        UPDATE("update", "up", "module-path", "updates the Pepper module, which was installed from 'module path'."),
        REMOVE("remove", "re", "bundle name", "removes the bundle 'bundle name' from the OSGi context and from plugin folder."),
        HELP("help", "h", null, "Prints this help."),
        EXIT("exit", "e", null, "exits Pepper");

        private String name = null;
        private String abbreviation = null;
        private String description = null;
        private String parameters = null;

        private COMMAND(String name, String abbreviation, String parameters, String description) {
            this.name = name;
            this.abbreviation = abbreviation;
            this.parameters = parameters;
            this.description = description;
        }

        public String getName() {
            return this.name;
        }

        public String getAbbreviation() {
            return this.abbreviation;
        }

        public String getParameters() {
            return this.parameters;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

