/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Iterator;
import org.assertj.core.api.AbstractIterableAssert;
import org.assertj.core.util.VisibleForTesting;

public class IterableAssert<T>
extends AbstractIterableAssert<IterableAssert<T>, Iterable<? extends T>, T> {
    protected IterableAssert(Iterable<? extends T> actual) {
        super(actual, IterableAssert.class);
    }

    protected IterableAssert(Iterator<? extends T> actual) {
        this(IterableAssert.toLazyIterable(actual));
    }

    private static <T> Iterable<T> toLazyIterable(Iterator<T> actual) {
        if (actual == null) {
            return null;
        }
        return new LazyIterable<T>(actual);
    }

    @Override
    public IterableAssert<T> isInstanceOf(Class<?> type) {
        if (this.actual instanceof LazyIterable) {
            this.objects.assertIsInstanceOf(this.info, this.asLazyIterable().iterator, type);
            return (IterableAssert)this.myself;
        }
        return (IterableAssert)super.isInstanceOf((Class)type);
    }

    @Override
    public IterableAssert<T> isInstanceOfAny(Class<?> ... types) {
        if (this.actual instanceof LazyIterable) {
            this.objects.assertIsInstanceOfAny(this.info, this.asLazyIterable().iterator, types);
            return (IterableAssert)this.myself;
        }
        return (IterableAssert)super.isInstanceOfAny((Class[])types);
    }

    @Override
    public IterableAssert<T> isOfAnyClassIn(Class<?> ... types) {
        if (this.actual instanceof LazyIterable) {
            this.objects.assertIsOfAnyClassIn(this.info, this.asLazyIterable().iterator, types);
            return (IterableAssert)this.myself;
        }
        return (IterableAssert)super.isOfAnyClassIn((Class[])types);
    }

    @Override
    public IterableAssert<T> isExactlyInstanceOf(Class<?> type) {
        if (this.actual instanceof LazyIterable) {
            this.objects.assertIsExactlyInstanceOf(this.info, this.asLazyIterable().iterator, type);
            return (IterableAssert)this.myself;
        }
        return (IterableAssert)super.isExactlyInstanceOf((Class)type);
    }

    @Override
    public IterableAssert<T> isNotInstanceOf(Class<?> type) {
        if (this.actual instanceof LazyIterable) {
            this.objects.assertIsNotInstanceOf(this.info, this.asLazyIterable().iterator, type);
            return (IterableAssert)this.myself;
        }
        return (IterableAssert)super.isNotInstanceOf((Class)type);
    }

    @Override
    public IterableAssert<T> isNotInstanceOfAny(Class<?> ... types) {
        if (this.actual instanceof LazyIterable) {
            this.objects.assertIsNotInstanceOfAny(this.info, this.asLazyIterable().iterator, types);
            return (IterableAssert)this.myself;
        }
        return (IterableAssert)super.isNotInstanceOfAny((Class[])types);
    }

    @Override
    public IterableAssert<T> isNotOfAnyClassIn(Class<?> ... types) {
        if (this.actual instanceof LazyIterable) {
            this.objects.assertIsNotOfAnyClassIn(this.info, this.asLazyIterable().iterator, types);
            return (IterableAssert)this.myself;
        }
        return (IterableAssert)super.isNotOfAnyClassIn((Class[])types);
    }

    @Override
    public IterableAssert<T> isNotExactlyInstanceOf(Class<?> type) {
        if (this.actual instanceof LazyIterable) {
            this.objects.assertIsNotExactlyInstanceOf(this.info, this.asLazyIterable().iterator, type);
            return (IterableAssert)this.myself;
        }
        return (IterableAssert)super.isNotExactlyInstanceOf((Class)type);
    }

    private LazyIterable asLazyIterable() {
        return (LazyIterable)this.actual;
    }

    private static <T> Iterable<T> toIterable(Iterator<T> iterator) {
        ArrayList<T> list = new ArrayList<T>();
        while (iterator.hasNext()) {
            list.add(iterator.next());
        }
        return list;
    }

    @VisibleForTesting
    static class LazyIterable<T>
    extends AbstractCollection<T> {
        private Iterator<T> iterator;
        private Iterable<T> iterable;

        public LazyIterable(Iterator<T> iterator) {
            this.iterator = iterator;
        }

        @Override
        public Iterator<T> iterator() {
            if (this.iterable == null) {
                this.iterable = IterableAssert.toIterable(this.iterator);
            }
            return this.iterable.iterator();
        }

        @Override
        public int size() {
            int size = 0;
            Iterator<T> localIterator = this.iterator();
            while (localIterator.hasNext()) {
                localIterator.next();
                ++size;
            }
            return size;
        }
    }
}

