/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.pepper.impl;

import com.google.common.base.Strings;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Random;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.corpus_tools.pepper.exceptions.NotInitializedException;
import org.corpus_tools.pepper.modules.exceptions.PepperModuleException;
import org.eclipse.emf.common.util.URI;

public class CorpusPathResolver {
    public static final int NUMBER_OF_SAMPLED_FILES = 20;
    public static final int NUMBER_OF_SAMPLED_LINES = 10;
    private static final String NO_FILE_ENDING = "all";
    protected Multimap<String, File> unreadFilesGroupedByExtension;
    protected Multimap<String, FileContent> readFilesGroupedByExtension = HashMultimap.create();

    protected CorpusPathResolver() {
    }

    public CorpusPathResolver(URI corpusPath) throws FileNotFoundException {
        this();
        this.setCorpusPath(corpusPath);
    }

    protected void setCorpusPath(URI corpusPath) throws FileNotFoundException {
        this.unreadFilesGroupedByExtension = this.groupFilesByEnding(corpusPath);
    }

    public Collection<String> sampleFileContent(String ... fileEndings) {
        return this.sampleFileContent(20, 10, fileEndings);
    }

    public Collection<String> sampleFileContent(int numberOfSampledFiles, int numberOfSampledLines, String ... fileEndings) {
        if (numberOfSampledFiles < 1 || numberOfSampledLines < 1) {
            return new ArrayList<String>();
        }
        ArrayList<FileContent> fileContents = new ArrayList<FileContent>();
        if (fileEndings == null || fileEndings.length == 0) {
            fileContents.addAll(this.getXFilesWithExtension(numberOfSampledFiles, numberOfSampledLines, NO_FILE_ENDING));
        } else {
            for (String fileEnding : fileEndings) {
                fileContents.addAll(this.getXFilesWithExtension(numberOfSampledFiles, numberOfSampledLines, fileEnding));
            }
        }
        ArrayList<String> contents = new ArrayList<String>();
        for (FileContent content : fileContents) {
            if (content.numberOfLines < numberOfSampledLines) {
                content.firstXlines = this.readFirstLines(content.file, numberOfSampledLines);
            }
            contents.add(content.firstXlines);
        }
        return contents;
    }

    protected Multimap<String, File> groupFilesByEnding(URI corpusPath) throws FileNotFoundException {
        HashMultimap files = HashMultimap.create();
        if (corpusPath == null) {
            return files;
        }
        File dir = new File(corpusPath.toFileString());
        if (dir == null || !dir.exists()) {
            throw new FileNotFoundException("Cannot sample files in folder, since folder '" + dir + "' is empty or does not exist. ");
        }
        Collection allFiles = FileUtils.listFiles((File)dir, null, (boolean)true);
        String ext = null;
        for (File file : allFiles) {
            ext = FilenameUtils.getExtension((String)file.getName());
            if (!Strings.isNullOrEmpty((String)ext)) {
                files.put((Object)ext, (Object)file);
            }
            files.put((Object)NO_FILE_ENDING, (Object)file);
        }
        return files;
    }

    protected Collection<FileContent> getXFilesWithExtension(int numOfFiles, int numOfLinesToRead, String fileEnding) {
        Collection readFiles = this.readFilesGroupedByExtension.get((Object)fileEnding);
        if (readFiles.size() >= numOfFiles) {
            return readFiles;
        }
        int numOfReadFiles = readFiles.size();
        if (this.unreadFilesGroupedByExtension == null) {
            throw new NotInitializedException("Please call setCorpusPath(URI) first or use other constructor new CorpusPathResolver(URI). ");
        }
        Collection unreadFiles = this.unreadFilesGroupedByExtension.get((Object)fileEnding);
        if (unreadFiles != null) {
            Collection<File> newFiles = this.sampleFiles(unreadFiles, numOfFiles - numOfReadFiles);
            for (File newFile : newFiles) {
                this.unreadFilesGroupedByExtension.remove((Object)fileEnding, (Object)newFile);
                String firstLines = this.readFirstLines(newFile, numOfLinesToRead);
                FileContent content = new FileContent(newFile, firstLines, numOfLinesToRead);
                this.readFilesGroupedByExtension.put((Object)fileEnding, (Object)content);
            }
            readFiles = this.readFilesGroupedByExtension.get((Object)fileEnding);
        }
        return readFiles;
    }

    protected Collection<File> sampleFiles(Collection<File> files, int numberOfSampledFiles) {
        int maxFiles;
        File[] allFiles = new File[files.size()];
        allFiles = files.toArray(allFiles);
        HashSet<File> sampledFiles = new HashSet<File>(numberOfSampledFiles);
        Random randomGenerator = new Random();
        int n = maxFiles = numberOfSampledFiles > allFiles.length ? allFiles.length : numberOfSampledFiles;
        while (sampledFiles.size() < maxFiles) {
            sampledFiles.add(allFiles[randomGenerator.nextInt(allFiles.length)]);
        }
        return sampledFiles;
    }

    protected String readFirstLines(File file, int numOfLinesToRead) {
        if (file == null || !file.exists()) {
            throw new PepperModuleException("Cannot read first '" + numOfLinesToRead + "' of specified file '" + (file == null ? "" : file.getAbsolutePath()) + "', because it was null or does not exist. ");
        }
        if (numOfLinesToRead < 1) {
            return null;
        }
        StringBuilder fileContent = new StringBuilder();
        try (LineNumberReader reader = new LineNumberReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));){
            String line;
            boolean isFirstLine = true;
            while ((line = reader.readLine()) != null && reader.getLineNumber() <= numOfLinesToRead) {
                if (!isFirstLine) {
                    fileContent.append(System.lineSeparator());
                }
                isFirstLine = false;
                fileContent.append(line);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return fileContent.toString();
    }

    private class FileContent {
        public File file;
        public String firstXlines;
        public int numberOfLines;

        public FileContent(File file, String firstXlines, int numberOfLines) {
            this.file = file;
            this.firstXlines = firstXlines;
            this.numberOfLines = numberOfLines;
        }
    }
}

