/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.pepper.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.corpus_tools.pepper.modules.PepperImporter;
import org.corpus_tools.pepper.modules.PepperModule;
import org.corpus_tools.pepper.modules.exceptions.PepperModuleException;
import org.corpus_tools.salt.SaltFactory;
import org.corpus_tools.salt.common.SCorpus;
import org.corpus_tools.salt.common.SCorpusGraph;
import org.corpus_tools.salt.common.SDocument;
import org.corpus_tools.salt.core.SAnnotation;
import org.corpus_tools.salt.core.SAnnotationContainer;
import org.corpus_tools.salt.core.SLayer;
import org.corpus_tools.salt.core.SMetaAnnotation;
import org.corpus_tools.salt.core.SNode;
import org.corpus_tools.salt.core.SRelation;
import org.corpus_tools.salt.graph.IdentifiableElement;
import org.corpus_tools.salt.graph.Identifier;
import org.corpus_tools.salt.graph.Label;
import org.corpus_tools.salt.graph.Layer;
import org.corpus_tools.salt.graph.Relation;
import org.corpus_tools.salt.util.SaltUtil;
import org.eclipse.emf.common.util.URI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeforeAfterAction {
    private PepperModule pepperModule;
    private Logger logger = LoggerFactory.getLogger((String)"Pepper");

    public BeforeAfterAction(PepperModule pepperModule) {
        this.pepperModule = pepperModule;
        this.logger = LoggerFactory.getLogger((String)this.getPepperModule().getName());
    }

    public PepperModule getPepperModule() {
        return this.pepperModule;
    }

    public void before(SCorpusGraph corpusGraph) throws PepperModuleException {
        List roots;
        boolean isReport;
        if (this.getPepperModule().getProperties().getProperty("pepper.after.reportCorpusGraph") != null && (isReport = Boolean.parseBoolean(this.getPepperModule().getProperties().getProperty("pepper.after.reportCorpusGraph").getValue().toString())) && corpusGraph != null && (roots = corpusGraph.getRoots()) != null) {
            StringBuilder str = new StringBuilder();
            str.append("corpus structure imported by ");
            str.append(this.getPepperModule().getName());
            for (SNode root : roots) {
                str.append(":\n");
                str.append(this.getPepperModule().getSaltProject().getCorpusGraphs().indexOf(((SCorpus)root).getGraph()));
                str.append("\n");
                str.append(this.reportCorpusStructure(corpusGraph, root, "", true));
            }
            this.logger.info(str.toString());
        }
    }

    public void after(SCorpusGraph corpusGraph) throws PepperModuleException {
        if (this.getPepperModule().getProperties().getProperty("pepper.after.copyRes") != null) {
            String resString = (String)this.getPepperModule().getProperties().getProperty("pepper.after.copyRes").getValue();
            this.copyResources(resString);
        }
    }

    @Deprecated
    protected String reportCorpusStructure(SCorpusGraph corpusGraph, SNode node, String prefix, boolean isTail) {
        StringBuilder retStr = new StringBuilder();
        retStr.append(prefix);
        retStr.append((isTail ? "\u2514\u2500\u2500 " : "\u251c\u2500\u2500 ") + node.getName());
        retStr.append("\n");
        List outRelations = corpusGraph.getOutRelations(node.getId());
        int i = 0;
        for (Relation out : outRelations) {
            if (i < outRelations.size() - 1) {
                retStr.append(prefix);
                retStr.append(this.reportCorpusStructure(corpusGraph, (SNode)out.getTarget(), prefix + (isTail ? "    " : "\u2502   "), false));
            } else {
                retStr.append(this.reportCorpusStructure(corpusGraph, (SNode)out.getTarget(), prefix + (isTail ? "    " : "\u2502   "), true));
            }
            ++i;
        }
        return retStr.toString();
    }

    public void copyResources(String resString) {
        String[] resources;
        if (resString != null && !resString.isEmpty() && (resources = resString.split(";")).length > 0) {
            for (String resource : resources) {
                String[] parts = (resource = resource.trim()).split("->");
                if (parts.length != 2) continue;
                String sourceStr = parts[0];
                String targetStr = parts[1];
                sourceStr = sourceStr.trim();
                targetStr = targetStr.trim();
                boolean copyOk = true;
                if (sourceStr == null || sourceStr.isEmpty()) {
                    this.logger.warn("Cannot copy resources for '" + this.getPepperModule().getName() + "' because no source file was given in property value '" + resource + "'. ");
                    copyOk = false;
                }
                if (targetStr == null || targetStr.isEmpty()) {
                    this.logger.warn("Cannot copy resources for '" + this.getPepperModule().getName() + "' because no target file was given in property value '" + resource + "'. ");
                    copyOk = false;
                }
                if (!copyOk) continue;
                File source = new File(sourceStr);
                File target = new File(targetStr);
                String baseDir = this.getPepperModule().getModuleController().getJob().getBaseDir().toFileString();
                if (!baseDir.endsWith("/")) {
                    baseDir = baseDir + "/";
                }
                if (!source.isAbsolute()) {
                    source = new File(baseDir + sourceStr);
                }
                if (!source.exists()) {
                    this.logger.warn("Cannot copy resources for '" + this.getPepperModule().getName() + "' because source does not exist '" + source.getAbsolutePath() + "'. Check the property value '" + resource + "'. ");
                    continue;
                }
                if (!target.isAbsolute()) {
                    target = new File(baseDir + targetStr);
                }
                if (!target.exists() && !target.mkdirs()) {
                    this.logger.warn("Cannot create folder {}. ", (Object)target);
                }
                try {
                    if (source.isDirectory()) {
                        targetStr = target.getAbsolutePath();
                        if (!targetStr.endsWith("/")) {
                            targetStr = targetStr + "/";
                        }
                        target = new File(targetStr + source.getName());
                        FileUtils.copyDirectory((File)source, (File)target);
                        this.logger.trace("Copied resource from '" + source.getAbsolutePath() + "' to '" + target.getAbsolutePath() + "'.");
                        continue;
                    }
                    targetStr = target.getCanonicalPath();
                    if (!targetStr.endsWith("/")) {
                        targetStr = targetStr + "/";
                    }
                    target = new File(targetStr + source.getName());
                    FileUtils.copyFile((File)source, (File)target);
                    this.logger.trace("Copied resource from '" + source.getAbsolutePath() + "' to '" + target.getAbsolutePath() + "'.");
                }
                catch (IOException e) {
                    this.logger.warn("Cannot copy resources for '" + this.getPepperModule().getName() + "' because of '" + e.getMessage() + "'. Check the property value '" + resource + "'. ");
                }
            }
        }
    }

    public void before(Identifier id) throws PepperModuleException {
        if (this.getPepperModule().getProperties() != null) {
            if (this.getPepperModule().getProperties().getProperty("pepper.before.addSLayer") != null && id != null && id.getIdentifiableElement() != null) {
                if (id.getIdentifiableElement() instanceof SDocument) {
                    SDocument sDoc = (SDocument)id.getIdentifiableElement();
                    String layers = (String)this.getPepperModule().getProperties().getProperty("pepper.before.addSLayer").getValue();
                    this.addSLayers(sDoc, layers);
                } else if (id.getIdentifiableElement() instanceof SCorpus) {
                    // empty if block
                }
            }
            if (this.getPepperModule().getProperties().getProperty("pepper.before.readMeta") != null && this.getPepperModule().getProperties().getProperty("pepper.before.readMeta").getValue() != null) {
                this.readMeta(id);
            }
        }
    }

    public void after(Identifier id) throws PepperModuleException {
        if (this.getPepperModule().getProperties() != null && id != null && id.getIdentifiableElement() != null) {
            if (this.getPepperModule().getProperties().getProperty("pepper.after.addSLayer") != null && id.getIdentifiableElement() instanceof SDocument) {
                SDocument sDoc = (SDocument)id.getIdentifiableElement();
                String layers = (String)this.getPepperModule().getProperties().getProperty("pepper.after.addSLayer").getValue();
                this.addSLayers(sDoc, layers);
            }
            if (this.getPepperModule().getProperties().getProperty("pepper.after.renameAnnos").getValue() != null && id.getIdentifiableElement() instanceof SDocument && ((SDocument)id.getIdentifiableElement()).getDocumentGraph() != null) {
                this.renameAnnotations(id, (String)this.getPepperModule().getProperties().getProperty("pepper.after.renameAnnos").getValue());
            }
            if (this.getPepperModule().getProperties().getProperty("pepper.after.removeAnnos").getValue() != null && id.getIdentifiableElement() instanceof SDocument && ((SDocument)id.getIdentifiableElement()).getDocumentGraph() != null) {
                this.renameAnnotations(id, (String)this.getPepperModule().getProperties().getProperty("pepper.after.removeAnnos").getValue());
            }
            if (((Boolean)this.getPepperModule().getProperties().getProperty("pepper.after.tokenize").getValue()).booleanValue() && id.getIdentifiableElement() instanceof SDocument && ((SDocument)id.getIdentifiableElement()).getDocumentGraph() != null) {
                ((SDocument)id.getIdentifiableElement()).getDocumentGraph().tokenize();
            }
        }
    }

    public void addSLayers(SDocument sDoc, String layers) {
        String[] layerArray;
        if (layers != null && !layers.isEmpty() && (layerArray = layers.split(";")).length > 0) {
            for (String layer : layerArray) {
                layer = layer.trim();
                List sLayers = sDoc.getDocumentGraph().getLayerByName(layer);
                SLayer sLayer = null;
                if (sLayers != null && sLayers.size() > 0) {
                    sLayer = (SLayer)sLayers.get(0);
                }
                if (sLayer == null) {
                    sLayer = SaltFactory.createSLayer();
                    sLayer.setName(layer);
                    sDoc.getDocumentGraph().addLayer((Layer)sLayer);
                }
                for (SNode sNode : sDoc.getDocumentGraph().getNodes()) {
                    sNode.addLayer((Layer)sLayer);
                }
                for (SRelation sRel : sDoc.getDocumentGraph().getRelations()) {
                    sRel.addLayer((Layer)sLayer);
                }
            }
        }
    }

    public void readMeta(Identifier id) {
        if (this.getPepperModule() instanceof PepperImporter) {
            URI resourceURI = ((PepperImporter)this.getPepperModule()).getIdentifier2ResourceTable().get(id);
            Object endingObj = this.getPepperModule().getProperties().getProperty("pepper.before.readMeta").getValue();
            if (endingObj != null) {
                String ending = endingObj.toString().trim();
                if (resourceURI != null) {
                    File resource = new File(resourceURI.toFileString());
                    File metaFile = null;
                    if (resource.isDirectory()) {
                        File[] files = resource.listFiles();
                        if (files != null) {
                            for (File file : files) {
                                if (!file.getName().equalsIgnoreCase(((SNode)id.getIdentifiableElement()).getPath().lastSegment() + "." + ending)) continue;
                                metaFile = file;
                                break;
                            }
                        }
                    } else {
                        String[] parts = resource.getName().split("[.]");
                        if (parts != null && !(metaFile = new File(resource.getAbsolutePath().substring(0, resource.getAbsolutePath().lastIndexOf(".")) + "." + ending)).exists()) {
                            metaFile = null;
                        }
                    }
                    if (metaFile != null) {
                        Properties props = new Properties();
                        try (InputStreamReader rdr = new InputStreamReader((InputStream)new FileInputStream(metaFile), "UTF-8");){
                            props.load(rdr);
                        }
                        catch (IOException e) {
                            this.logger.warn("Tried to load meta data file '" + metaFile.getAbsolutePath() + "', but a problem occured: " + e.getMessage() + ". ", (Throwable)e);
                        }
                        for (Object key : props.keySet()) {
                            IdentifiableElement container = id.getIdentifiableElement();
                            if (container == null || !(container instanceof SAnnotationContainer)) continue;
                            if (!((SAnnotationContainer)container).containsLabel(key.toString())) {
                                ((SAnnotationContainer)container).createMetaAnnotation(null, key.toString(), (Object)props.getProperty(key.toString()));
                                continue;
                            }
                            this.logger.warn("Cannot add meta annotation '" + key.toString() + "', because it already exist on object '" + id.getId() + "' please check file '" + metaFile.getAbsolutePath() + "'. ");
                        }
                    }
                }
            }
        }
    }

    public void renameAnnotations(Identifier id, String renameTemplate) {
        if (id != null && id.getIdentifiableElement() != null) {
            try {
                String[] renamings;
                HashMap<String[], String[]> renamingMap = new HashMap<String[], String[]>();
                for (String renaming : renamings = renameTemplate.split(";")) {
                    String[] parts = renaming.split(":=");
                    if (parts.length == 2) {
                        renamingMap.put((String[])SaltUtil.unmarshalAnnotation((String)parts[0]).iterator().next(), (String[])SaltUtil.unmarshalAnnotation((String)parts[1]).iterator().next());
                        continue;
                    }
                    if (parts.length != 1) continue;
                    renamingMap.put((String[])SaltUtil.unmarshalAnnotation((String)parts[0]).iterator().next(), (String[])null);
                }
                SDocument document = (SDocument)id.getIdentifiableElement();
                Iterator<Object> it = document.getDocumentGraph().getNodes().iterator();
                this.rename(it, renamingMap);
                it = document.getDocumentGraph().getRelations().iterator();
                this.rename(it, renamingMap);
            }
            catch (RuntimeException e) {
                e.printStackTrace();
                this.logger.warn("Cannot rename labels in object '{}', because of a nested exeption '{}'. ", (Object)id, (Object)e.getMessage());
            }
        }
    }

    private void rename(Iterator<SAnnotationContainer> it, Map<String[], String[]> renamingMap) {
        while (it.hasNext()) {
            SAnnotationContainer node = it.next();
            for (Map.Entry<String[], String[]> entry : renamingMap.entrySet()) {
                Label label = node.getLabel(entry.getKey()[0], entry.getKey()[1]);
                if (label == null) continue;
                if (entry.getValue() == null) {
                    node.removeLabel(label.getQName());
                    continue;
                }
                if (label.getQName().equals(SaltUtil.createQName((String)entry.getValue()[0], (String)entry.getValue()[1]))) {
                    label.setValue((Object)entry.getValue()[2]);
                    continue;
                }
                node.removeLabel(label.getQName());
                if (label instanceof SAnnotation) {
                    if (entry.getValue()[2] == null) {
                        node.createAnnotation(entry.getValue()[0], entry.getValue()[1], label.getValue());
                        continue;
                    }
                    node.createAnnotation(entry.getValue()[0], entry.getValue()[1], (Object)entry.getValue()[2]);
                    continue;
                }
                if (!(label instanceof SMetaAnnotation)) continue;
                if (entry.getValue()[2] == null) {
                    node.createMetaAnnotation(entry.getValue()[0], entry.getValue()[1], label.getValue());
                    continue;
                }
                node.createMetaAnnotation(entry.getValue()[0], entry.getValue()[1], (Object)entry.getValue()[2]);
            }
        }
    }
}

