/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.pepper.core;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.corpus_tools.pepper.common.CorpusDesc;
import org.corpus_tools.pepper.common.FormatDesc;
import org.corpus_tools.pepper.common.ModuleFitness;
import org.corpus_tools.pepper.common.Pepper;
import org.corpus_tools.pepper.common.PepperUtil;
import org.corpus_tools.pepper.core.SelfTestDesc;
import org.corpus_tools.pepper.exceptions.PepperFWException;
import org.corpus_tools.pepper.modules.PepperExporter;
import org.corpus_tools.pepper.modules.PepperImporter;
import org.corpus_tools.pepper.modules.PepperManipulator;
import org.corpus_tools.pepper.modules.PepperModule;
import org.corpus_tools.pepper.testFramework.PepperTestUtil;
import org.corpus_tools.salt.common.SaltProject;
import org.corpus_tools.salt.util.SaltUtil;
import org.eclipse.emf.common.util.URI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModuleFitnessChecker {
    private static final Logger logger = LoggerFactory.getLogger((String)"Pepper");
    private static URI corpusPath = URI.createFileURI((String)PepperUtil.getTempFile("fitnessCheck").getAbsolutePath());
    private final Pepper pepper;

    public ModuleFitnessChecker(Pepper pepper) {
        this.pepper = pepper;
    }

    public ModuleFitnessChecker() {
        this.pepper = PepperTestUtil.createDefaultPepper();
    }

    public List<ModuleFitness> checkFitness(Collection<PepperModule> modules) {
        ArrayList<ModuleFitness> moduleFitness = new ArrayList<ModuleFitness>();
        if (modules == null) {
            return moduleFitness;
        }
        for (PepperModule module : modules) {
            if (module == null) continue;
            moduleFitness.add(this.checkFitness(module));
        }
        return moduleFitness;
    }

    public ModuleFitness checkFitness(final PepperModule module) {
        if (module == null) {
            return null;
        }
        ModuleFitness fitness = this.checkHealth(module);
        new AddFeature(fitness, ModuleFitness.FitnessFeature.HAS_DESCRIPTION){

            @Override
            public boolean condition() {
                return !Strings.isNullOrEmpty((String)module.getDesc());
            }
        };
        new AddFeature(fitness, ModuleFitness.FitnessFeature.HAS_SUPPLIER_HP){

            @Override
            public boolean condition() {
                return module.getSupplierHomepage() != null;
            }
        };
        new AddFeature(fitness, ModuleFitness.FitnessFeature.HAS_SUPPLIER_CONTACT){

            @Override
            public boolean condition() {
                return module.getSupplierContact() != null;
            }
        };
        if (module instanceof PepperImporter) {
            final PepperImporter importer = (PepperImporter)module;
            new AddFeature(fitness, ModuleFitness.FitnessFeature.IS_IMPORTABLE){

                @Override
                public boolean condition() {
                    return importer.isImportable(corpusPath) != null;
                }
            };
            new AddFeature(fitness, ModuleFitness.FitnessFeature.HAS_SUPPORTED_FORMATS){

                @Override
                public boolean condition() {
                    return ModuleFitnessChecker.hasSupportedFormats(importer.getSupportedFormats());
                }
            };
        }
        if (module instanceof PepperExporter) {
            final PepperExporter exporter = (PepperExporter)module;
            new AddFeature(fitness, ModuleFitness.FitnessFeature.HAS_SUPPORTED_FORMATS){

                @Override
                public boolean condition() {
                    return ModuleFitnessChecker.hasSupportedFormats(exporter.getSupportedFormats());
                }
            };
        }
        if (this.pepper != null) {
            fitness = this.selfTest(module, fitness);
        }
        return fitness;
    }

    private static boolean hasSupportedFormats(List<FormatDesc> formatDescs) {
        boolean hasFormats = false;
        if (formatDescs != null && formatDescs.size() > 0) {
            hasFormats = true;
            for (FormatDesc formatDesc : formatDescs) {
                if (!Strings.isNullOrEmpty((String)formatDesc.getFormatName())) continue;
                hasFormats = false;
            }
        }
        return hasFormats;
    }

    public List<ModuleFitness> checkHealth(Collection<PepperModule> modules) {
        ArrayList<ModuleFitness> moduleFitness = new ArrayList<ModuleFitness>();
        if (modules == null) {
            return moduleFitness;
        }
        for (PepperModule module : modules) {
            if (module == null) continue;
            moduleFitness.add(this.checkHealth(module));
        }
        return moduleFitness;
    }

    public ModuleFitness checkHealth(final PepperModule module) {
        if (module == null) {
            return null;
        }
        ModuleFitness fitness = new ModuleFitness(module.getName());
        new AddFeature(fitness, ModuleFitness.FitnessFeature.HAS_NAME){

            @Override
            public boolean condition() {
                return !Strings.isNullOrEmpty((String)module.getName());
            }
        };
        new AddFeature(fitness, ModuleFitness.FitnessFeature.IS_READY_TO_RUN){

            @Override
            public boolean condition() {
                PepperTestUtil.prepareFixturesAndCreateJob(ModuleFitnessChecker.this.pepper, Arrays.asList(module));
                return module.isReadyToStart();
            }
        };
        return fitness;
    }

    public ModuleFitness selfTest(PepperModule pepperModule) {
        return this.selfTest(pepperModule, null);
    }

    protected ModuleFitness selfTest(PepperModule pepperModule, ModuleFitness moduleFitness) {
        if (pepperModule == null) {
            return moduleFitness;
        }
        if (moduleFitness == null) {
            moduleFitness = new ModuleFitness(pepperModule.getName());
        }
        if (this.pepper == null) {
            throw new PepperFWException("Cannot run integration test for module '" + pepperModule + "', because Pepper framework is not specified. ");
        }
        SelfTestDesc selfTestDesc = pepperModule.getSelfTestDesc();
        if (selfTestDesc == null) {
            moduleFitness.setFeature(ModuleFitness.FitnessFeature.HAS_SELFTEST, false);
            return moduleFitness;
        }
        moduleFitness.setFeature(ModuleFitness.FitnessFeature.HAS_SELFTEST, true);
        boolean hasPassed = false;
        moduleFitness.setFeature(ModuleFitness.FitnessFeature.HAS_PASSED_SELFTEST, hasPassed);
        if (this.selfTestIsNotValid(selfTestDesc, pepperModule)) {
            return moduleFitness;
        }
        if (pepperModule instanceof PepperImporter) {
            PepperImporter importer = (PepperImporter)pepperModule;
            CorpusDesc corpusDesc = PepperUtil.createCorpusDesc().withCorpusPath(this.cleanURI(selfTestDesc.getInputCorpusPath())).build();
            importer.setCorpusDesc(corpusDesc);
            Double importRate = importer.isImportable(corpusDesc.getCorpusPath());
            boolean isImportable = importRate != null && importRate > 0.0;
            moduleFitness.setFeature(ModuleFitness.FitnessFeature.IS_IMPORTABLE_SEFTEST_DATA, isImportable);
        } else if (pepperModule instanceof PepperManipulator || pepperModule instanceof PepperExporter) {
            SaltProject saltProject = null;
            try {
                saltProject = SaltUtil.loadCompleteSaltProject((URI)this.cleanURI(selfTestDesc.getInputCorpusPath()));
            }
            catch (RuntimeException e) {
                logger.warn(ModuleFitnessChecker.warn(pepperModule, "The input salt project was could not have been loaded from path '" + selfTestDesc.getInputCorpusPath() + "'. The path might not contain a salt project. "));
                return moduleFitness;
            }
            if (pepperModule instanceof PepperExporter) {
                PepperExporter exporter = (PepperExporter)pepperModule;
                exporter.setCorpusDesc(new CorpusDesc.Builder().withCorpusPath(URI.createFileURI((String)PepperUtil.getTempFile("self-test").getAbsolutePath()).appendSegment("" + System.currentTimeMillis())).build());
            }
            pepperModule.setSaltProject(saltProject);
        }
        PepperTestUtil.start(this.pepper, Arrays.asList(pepperModule));
        if (pepperModule instanceof PepperImporter || pepperModule instanceof PepperManipulator) {
            hasPassed = ModuleFitnessChecker.whenModuleIsImpoterOrManipualtorThenCallSelftestDescCompare(pepperModule, selfTestDesc);
            boolean isValid = SaltUtil.validate((Object)pepperModule.getSaltProject()).andFindInvalidities().isValid();
            moduleFitness.setFeature(ModuleFitness.FitnessFeature.IS_VALID_SELFTEST_DATA, isValid);
        } else if (pepperModule instanceof PepperExporter) {
            hasPassed = ModuleFitnessChecker.whenModuleIsExpoterThenCallSelftestDescCompare(pepperModule, selfTestDesc);
        }
        moduleFitness.setFeature(ModuleFitness.FitnessFeature.HAS_PASSED_SELFTEST, hasPassed);
        return moduleFitness;
    }

    private boolean selfTestIsNotValid(SelfTestDesc selfTestDesc, PepperModule pepperModule) {
        ArrayList<String> problems = new ArrayList<String>();
        if (!selfTestDesc.isValid(problems)) {
            if (PepperUtil.isNotNullOrEmpty(problems)) {
                for (String problem : problems) {
                    logger.warn(ModuleFitnessChecker.warn(pepperModule, problem));
                }
            }
            return true;
        }
        return false;
    }

    private URI cleanURI(URI input) {
        URI cleanedURI = input;
        if (cleanedURI.toFileString().contains("//")) {
            cleanedURI = URI.createFileURI((String)cleanedURI.toFileString().replace("//", "/"));
        }
        return cleanedURI;
    }

    private static boolean whenModuleIsImpoterOrManipualtorThenCallSelftestDescCompare(PepperModule pepperModule, SelfTestDesc selfTestDesc) {
        SaltProject outputProject = pepperModule.getSaltProject();
        if (SaltUtil.isNullOrEmpty((Collection)outputProject.getCorpusGraphs()) || outputProject.getCorpusGraphs().size() != 1) {
            logger.warn(ModuleFitnessChecker.warn(pepperModule, "The salt project contains no corpus structures or it contains more than one corpus structure. "));
            return false;
        }
        URI expected = selfTestDesc.getExpectedCorpusPath();
        SaltProject expectedProject = SaltUtil.loadSaltProject((URI)expected);
        try {
            return selfTestDesc.compare(pepperModule.getSaltProject(), expectedProject);
        }
        catch (RuntimeException e) {
            logger.warn(ModuleFitnessChecker.warn(pepperModule, "An error occured while comparing actual salt project with expected salt project. "));
            return false;
        }
    }

    private static boolean whenModuleIsExpoterThenCallSelftestDescCompare(PepperModule pepperModule, SelfTestDesc selfTestDesc) {
        PepperExporter exporter = (PepperExporter)pepperModule;
        try {
            return selfTestDesc.compare(exporter.getCorpusDesc().getCorpusPath(), selfTestDesc.getExpectedCorpusPath());
        }
        catch (RuntimeException e) {
            logger.warn(ModuleFitnessChecker.warn(pepperModule, "An error occured while comparing actual salt project with expected salt project. "));
            return false;
        }
    }

    private static String warn(PepperModule pepperModule, String msg) {
        return "Failure in self-test of module '" + pepperModule.getName() + "': " + msg;
    }

    private static abstract class AddFeature {
        public AddFeature(ModuleFitness fitness, ModuleFitness.FitnessFeature feature) {
            boolean val;
            try {
                val = this.condition();
            }
            catch (Throwable e) {
                val = false;
                logger.warn("Cannot check fitness feature '" + (Object)((Object)feature) + "', because a nested excpetion occured. ", e);
            }
            fitness.setFeature(feature, val);
        }

        public abstract boolean condition();
    }
}

