/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.pepper.common;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.io.ByteOrderMark;
import org.apache.commons.io.input.BOMInputStream;
import org.corpus_tools.pepper.common.CorpusDesc;
import org.corpus_tools.pepper.common.FormatDesc;
import org.corpus_tools.pepper.common.PepperConfiguration;
import org.corpus_tools.pepper.common.PepperJob;
import org.corpus_tools.pepper.common.PepperModuleDesc;
import org.corpus_tools.pepper.exceptions.PepperException;
import org.corpus_tools.pepper.modules.exceptions.PepperModuleException;
import org.corpus_tools.pepper.modules.exceptions.PepperModuleXMLResourceException;
import org.eclipse.emf.common.util.URI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.DefaultHandler2;

public abstract class PepperUtil {
    private static final Logger logger = LoggerFactory.getLogger((String)"Pepper");
    public static final String FILE_ENDING_PEPPER = "pepper";
    public static final int CONSOLE_WIDTH = 120;
    public static final int CONSOLE_WIDTH_120 = 120;
    public static final int CONSOLE_WIDTH_80 = 80;

    public static String getHello() {
        return PepperUtil.getHello(120, "saltnpepper@lists.hu-berlin.de", "http://u.hu-berlin.de/saltnpepper");
    }

    public static String getHello(int width, String eMail, String hp) {
        StringBuilder retVal = new StringBuilder();
        if (80 == width) {
            retVal.append("********************************************************************************\n");
            retVal.append("*                    ____                                                      *\n");
            retVal.append("*                   |  _ \\ ___ _ __  _ __   ___ _ __                           *\n");
            retVal.append("*                   | |_) / _ \\ '_ \\| '_ \\ / _ \\ '__|                          *\n");
            retVal.append("*                   |  __/  __/ |_) | |_) |  __/ |                             *\n");
            retVal.append("*                   |_|   \\___| .__/| .__/ \\___|_|                             *\n");
            retVal.append("*                             |_|   |_|                                        *\n");
            retVal.append("*                                                                              *\n");
            retVal.append("********************************************************************************\n");
            retVal.append("* Pepper is a Salt model based converter for a variety of linguistic formats.  *\n");
            retVal.append("* For further information, visit: " + hp + "            *\n");
            retVal.append("* For contact write an eMail to:  " + eMail + "               *\n");
            retVal.append("********************************************************************************\n");
            retVal.append("\n");
        } else {
            retVal.append("************************************************************************************************************************\n");
            retVal.append("*                                         ____                                                                         *\n");
            retVal.append("*                                        |  _ \\ ___ _ __  _ __   ___ _ __                                              *\n");
            retVal.append("*                                        | |_) / _ \\ '_ \\| '_ \\ / _ \\ '__|                                             *\n");
            retVal.append("*                                        |  __/  __/ |_) | |_) |  __/ |                                                *\n");
            retVal.append("*                                        |_|   \\___| .__/| .__/ \\___|_|                                                *\n");
            retVal.append("*                                                  |_|   |_|                                                           *\n");
            retVal.append("*                                                                                                                      *\n");
            retVal.append("************************************************************************************************************************\n");
            retVal.append("* Pepper is a Salt model based converter for a variety of linguistic formats.                                          *\n");
            retVal.append("* For further information, visit: " + hp + "                                                    *\n");
            retVal.append("* For contact write an eMail to:  " + eMail + "                                                       *\n");
            retVal.append("************************************************************************************************************************\n");
            retVal.append("\n");
        }
        return retVal.toString();
    }

    public static String breakString(String theString) {
        return PepperUtil.breakString("", theString, 120);
    }

    public static String breakString(String theString, int length) {
        return PepperUtil.breakString("", theString, length);
    }

    public static String breakString(String linePrefix, String theString) {
        return PepperUtil.breakString(linePrefix, theString, 120);
    }

    public static String breakString(String linePrefix, String theString, int length) {
        if (length > theString.length() + linePrefix.length()) {
            return theString;
        }
        StringBuilder str = new StringBuilder();
        int pos = 0;
        int offset = length - linePrefix.length();
        boolean goOn = true;
        while (goOn) {
            str.append(linePrefix);
            if (pos + offset < theString.length()) {
                str.append(theString.substring(pos, pos + offset));
                str.append("\n");
            } else {
                str.append(theString.substring(pos));
                goOn = false;
            }
            pos += offset;
        }
        return str.toString();
    }

    public static String breakString2(StringBuilder output, String theString, int length) {
        if (theString != null && !theString.isEmpty()) {
            int i;
            StringBuilder rest = new StringBuilder();
            if (length >= theString.length() + output.toString().length()) {
                output.append(theString);
                return null;
            }
            char[] chrs = theString.toCharArray();
            HashSet<Character> separators = new HashSet<Character>();
            separators.add(Character.valueOf(' '));
            separators.add(Character.valueOf('.'));
            separators.add(Character.valueOf(','));
            separators.add(Character.valueOf(';'));
            separators.add(Character.valueOf(':'));
            separators.add(Character.valueOf('?'));
            separators.add(Character.valueOf('!'));
            separators.add(Character.valueOf('\"'));
            separators.add(Character.valueOf('\''));
            separators.add(Character.valueOf('-'));
            separators.add(Character.valueOf('~'));
            separators.add(Character.valueOf('*'));
            separators.add(Character.valueOf('+'));
            int currLength = output.toString().length();
            StringBuilder stagingStr = new StringBuilder();
            for (i = 0; i < length - currLength; ++i) {
                stagingStr.append(chrs[i]);
                if (!separators.contains(Character.valueOf(chrs[i]))) continue;
                output.append(stagingStr.toString());
                stagingStr = new StringBuilder();
            }
            if (currLength == output.toString().length()) {
                output.append(stagingStr.toString());
            } else {
                rest.append(stagingStr.toString());
            }
            if (length - currLength > 0) {
                for (i = length - currLength; i < theString.length(); ++i) {
                    rest.append(chrs[i]);
                }
            }
            return rest.toString();
        }
        return null;
    }

    public static String createTable(Integer[] length, String[][] map, boolean hasHeader, boolean hasBlanks, boolean drawInnerVerticalLine) {
        if (length == null) {
            throw new PepperException("Cannot create a table with empty length. ");
        }
        StringBuilder retVal = new StringBuilder();
        String hr = null;
        StringBuilder hrb = new StringBuilder();
        Integer[] arr$ = length;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            int a = arr$[i$];
            hrb.append("+");
            for (int b = 0; b < a; ++b) {
                hrb.append("-");
            }
            if (!hasBlanks) continue;
            hrb.append("-");
        }
        if (hasBlanks) {
            hrb.append("-");
        }
        hrb.append("+");
        hrb.append("\n");
        hr = hrb.toString();
        retVal.append(hr);
        for (int line = 0; line < map.length; ++line) {
            String[] currLine = new String[map[line].length];
            for (int col = 0; col < map[line].length; ++col) {
                currLine[col] = map[line][col];
            }
            StringBuilder out = new StringBuilder();
            boolean goOn = true;
            if ("--".equalsIgnoreCase(currLine[0])) {
                goOn = false;
                retVal.append(hr);
            }
            while (goOn) {
                goOn = false;
                for (int col = 0; col < currLine.length; ++col) {
                    currLine[col] = PepperUtil.breakString2(out, currLine[col], length[col]);
                    int diff = length[col] - out.toString().length();
                    if (diff > 0) {
                        for (int i = 0; i < diff; ++i) {
                            out.append(" ");
                        }
                    }
                    if (currLine[col] != null) {
                        goOn = true;
                    }
                    if (drawInnerVerticalLine) {
                        retVal.append("|");
                    }
                    if (hasBlanks) {
                        retVal.append(" ");
                    }
                    retVal.append(out.toString());
                    out = new StringBuilder();
                }
                if (hasBlanks) {
                    retVal.append(" ");
                }
                retVal.append("|\n");
            }
            if (!hasHeader || line != 0) continue;
            retVal.append(hr);
        }
        retVal.append(hr);
        return retVal.toString();
    }

    public static synchronized File getTempTestFile(String segments) {
        return PepperUtil.getTempFile(segments, "pepper-test");
    }

    public static synchronized File getTempTestFile() {
        return PepperUtil.getTempFile(null, "pepper-test");
    }

    public static synchronized File getTempFile() {
        return PepperUtil.getTempFile(null);
    }

    public static synchronized File getTempFile(String segments) {
        return PepperUtil.getTempFile(segments, FILE_ENDING_PEPPER);
    }

    public static synchronized File getTempFile(String segments, String prefix) {
        String usr = System.getProperty("user.name");
        String path = null;
        if (usr != null && !usr.isEmpty()) {
            path = System.getProperty("java.io.tmpdir");
            if (!path.endsWith("/")) {
                path = path + "/";
            }
            path = path + prefix + "_" + usr + "/";
        } else {
            try {
                path = Files.createTempDirectory(prefix + "_", new FileAttribute[0]).toFile().getAbsolutePath();
                if (!path.endsWith("/")) {
                    path = path + "/";
                }
            }
            catch (IOException e) {
                throw new PepperException("Cannot create temporary folder at " + System.getProperty("java.io.tmpdir") + ". ");
            }
        }
        File file = null;
        file = segments == null ? new File(path) : new File(path + segments);
        if (!file.exists() && !file.mkdirs()) {
            logger.warn("Cannot create folder {}. ", (Object)file);
        }
        return file;
    }

    public static String reportConfiguration(PepperConfiguration conf) {
        String line = "+----------------------------------------------------------------------------------------------------------------------+\n";
        StringBuilder str = new StringBuilder();
        String format1 = "| %-116s |\n";
        String format2 = "| %-40s: %-74s |\n";
        str.append(line);
        str.append(String.format(format1, " configuration for Pepper"));
        str.append(line);
        if (conf != null && conf.size() != 0) {
            for (Map.Entry<Object, Object> entry : conf.entrySet()) {
                str.append(String.format(format2, entry.getKey(), entry.getValue()));
            }
        } else {
            str.append(String.format(format1, "- no configurations set -"));
        }
        str.append(line);
        return str.toString();
    }

    public static String reportModuleList(int width, Collection<PepperModuleDesc> moduleDescs, Map<Integer, PepperModuleDesc> number2module) {
        String retVal = "- no modules registered -\n";
        if (moduleDescs != null && moduleDescs.size() != 0) {
            String[][] map = new String[moduleDescs.size() + 1][6];
            map[0][0] = "no.";
            map[0][1] = "module-name";
            map[0][2] = "module-version";
            map[0][3] = "module-type";
            map[0][4] = "formats";
            map[0][5] = "website";
            int i = 1;
            for (PepperModuleDesc desc : moduleDescs) {
                map[i][0] = Integer.valueOf(i).toString();
                map[i][1] = desc.getName();
                map[i][2] = desc.getVersion();
                map[i][3] = desc.getModuleType().toString();
                StringBuilder formatString = new StringBuilder();
                if (desc.getSupportedFormats() != null && desc.getSupportedFormats().size() > 0) {
                    int j = 0;
                    for (FormatDesc formatDesc : desc.getSupportedFormats()) {
                        if (j != 0) {
                            formatString.append("; ");
                        }
                        formatString.append(formatDesc.getFormatName());
                        formatString.append(", ");
                        formatString.append(formatDesc.getFormatVersion());
                        ++j;
                    }
                }
                map[i][4] = formatString.toString();
                URI contact = desc.getSupplierHomepage();
                map[i][5] = contact != null ? contact.toString() : "";
                if (number2module != null) {
                    number2module.put(i, desc);
                }
                ++i;
            }
            Integer[] length = new Integer[6];
            if (80 == width) {
                length[0] = 4;
                length[1] = 15;
                length[2] = 10;
                length[3] = 11;
                length[4] = 16;
                length[5] = 10;
            } else {
                length[0] = 4;
                length[1] = 20;
                length[2] = 15;
                length[3] = 11;
                length[4] = 31;
                length[5] = 25;
            }
            retVal = PepperUtil.createTable(length, map, true, true, true);
        }
        return retVal;
    }

    public static String reportModuleList(int width, Collection<PepperModuleDesc> moduleDescs) {
        return PepperUtil.reportModuleList(width, moduleDescs, null);
    }

    public static void readXMLResource(DefaultHandler2 contentHandler, URI documentLocation) {
        XMLReader xmlReader;
        SAXParser parser;
        if (documentLocation == null) {
            throw new PepperModuleXMLResourceException("Cannot load a xml-resource, because the given uri to locate file is null.");
        }
        File resourceFile = new File(documentLocation.toFileString());
        if (!resourceFile.exists()) {
            throw new PepperModuleXMLResourceException("Cannot load a xml-resource, because the file does not exist: " + resourceFile);
        }
        if (!resourceFile.canRead()) {
            throw new PepperModuleXMLResourceException("Cannot load a xml-resource, because the file can not be read: " + resourceFile);
        }
        SAXParserFactory factory = SAXParserFactory.newInstance();
        try {
            parser = factory.newSAXParser();
            xmlReader = parser.getXMLReader();
            xmlReader.setErrorHandler(contentHandler);
            xmlReader.setContentHandler(contentHandler);
        }
        catch (ParserConfigurationException e) {
            throw new PepperModuleXMLResourceException("Cannot load a xml-resource '" + resourceFile.getAbsolutePath() + "'.", e);
        }
        catch (Exception e) {
            throw new PepperModuleXMLResourceException("Cannot load a xml-resource '" + resourceFile.getAbsolutePath() + "'.", e);
        }
        try {
            FileInputStream inputStream = new FileInputStream(resourceFile);
            BOMInputStream bomInputStream = new BOMInputStream((InputStream)inputStream, new ByteOrderMark[]{ByteOrderMark.UTF_8, ByteOrderMark.UTF_16BE, ByteOrderMark.UTF_16LE, ByteOrderMark.UTF_32BE, ByteOrderMark.UTF_32LE});
            InputStreamReader reader = new InputStreamReader((InputStream)bomInputStream, "UTF-8");
            InputSource is = new InputSource(reader);
            is.setEncoding("UTF-8");
            xmlReader.parse(is);
        }
        catch (SAXException e) {
            if (e instanceof SAXParseException) {
                throw new PepperModuleXMLResourceException("Error parsing the file '" + resourceFile.getAbsolutePath() + "'!", e.getCause());
            }
            try {
                parser = factory.newSAXParser();
                xmlReader = parser.getXMLReader();
                xmlReader.setErrorHandler(contentHandler);
                xmlReader.setContentHandler(contentHandler);
                xmlReader.parse(resourceFile.getAbsolutePath());
            }
            catch (Exception e1) {
                throw new PepperModuleXMLResourceException("Cannot load a xml-resource '" + resourceFile.getAbsolutePath() + "'.", e1);
            }
        }
        catch (Exception e) {
            if (e instanceof PepperModuleException) {
                throw (PepperModuleException)e;
            }
            throw new PepperModuleXMLResourceException("Cannot read xml-file'" + documentLocation + "', because of a nested exception. ", e);
        }
    }

    public static CorpusDesc.Builder createCorpusDesc() {
        return new CorpusDesc.Builder();
    }

    public static <T> boolean isNullOrEmpty(Collection<T> collection) {
        return collection == null || collection.isEmpty();
    }

    public static <T> boolean isNotNullOrEmpty(Collection<T> collection) {
        return !PepperUtil.isNullOrEmpty(collection);
    }

    public static class PepperJobReporter
    extends Thread {
        private static final Logger logger = LoggerFactory.getLogger(PepperJobReporter.class);
        private int interval = 10000;
        private PepperJob pepperJob = null;
        private boolean stop = false;

        public PepperJobReporter(PepperJob pepperJob, int interval) {
            if (pepperJob == null) {
                throw new PepperException("Cannot observe Pepper job, because it was null.");
            }
            this.pepperJob = pepperJob;
            this.interval = interval;
        }

        public PepperJobReporter(PepperJob pepperJob) {
            this(pepperJob, 10000);
        }

        public int getInterval() {
            return this.interval;
        }

        public PepperJob getPepperJob() {
            return this.pepperJob;
        }

        public boolean isStop() {
            return this.stop;
        }

        public void setStop(boolean stop) {
            this.stop = stop;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!this.isStop()) {
                String report = null;
                try {
                    if (this.getPepperJob() == null) {
                        logger.warn("No status report is available, because no reference to the Pepper job is given. ");
                    }
                    report = this.getPepperJob().getStatusReport();
                }
                catch (Exception e) {
                    report = "- no status report is available -";
                    logger.warn("No status report is available, because of a nested exception: ", (Throwable)e);
                }
                finally {
                    if (report != null) {
                        logger.info(report);
                    }
                }
                try {
                    Thread.sleep(this.getInterval());
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

