/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.pepper.modules.coreModules;

import java.io.File;
import org.corpus_tools.pepper.common.DOCUMENT_STATUS;
import org.corpus_tools.pepper.impl.PepperImporterImpl;
import org.corpus_tools.pepper.impl.PepperMapperImpl;
import org.corpus_tools.pepper.modules.PepperImporter;
import org.corpus_tools.pepper.modules.PepperMapper;
import org.corpus_tools.pepper.modules.PepperModuleProperties;
import org.corpus_tools.pepper.modules.exceptions.PepperModuleException;
import org.corpus_tools.salt.common.SCorpusGraph;
import org.corpus_tools.salt.common.SDocument;
import org.corpus_tools.salt.graph.Identifier;
import org.eclipse.emf.common.util.URI;
import org.osgi.service.component.annotations.Component;

@Component(name="SaltXMLImporterComponent", factory="PepperImporterComponentFactory")
public class SaltXMLImporter
extends PepperImporterImpl
implements PepperImporter {
    public static final String MODULE_NAME = "SaltXMLImporter";
    public static final String FORMAT_NAME_SALTXML = "SaltXML";
    public static final String FORMAT_VERSION_SALTXML = "1.0";

    public SaltXMLImporter() {
        super(MODULE_NAME);
        this.setSupplierContact(URI.createURI((String)"saltnpepper@lists.hu-berlin.de"));
        this.setSupplierHomepage(URI.createURI((String)"http://corpus-tools.org/pepper/"));
        this.setDesc("This importer imports a Salt model from a SaltXML representation. SaltXML is the native format to persist Salt. ");
        this.addSupportedFormat(FORMAT_NAME_SALTXML, FORMAT_VERSION_SALTXML, null);
        this.setProperties(new PepperModuleProperties());
    }

    @Override
    public Double isImportable(URI corpusPath) {
        String content;
        Double retVal = null;
        File file = new File(corpusPath.toFileString());
        File[] allFiles = null;
        boolean abort = false;
        while (!abort && file.isDirectory()) {
            allFiles = file.listFiles();
            if (allFiles != null && allFiles.length != 0) {
                file = allFiles[0];
                continue;
            }
            abort = true;
        }
        if (!abort && (content = this.readFirstLines(URI.createFileURI((String)file.getAbsolutePath()), 20)).contains("<?xml") && content.contains("xmi:version=\"2.0\"") && content.contains("salt")) {
            retVal = 1.0;
        }
        return retVal;
    }

    @Override
    public void importCorpusStructure(SCorpusGraph corpusGraph) throws PepperModuleException {
        this.setCorpusGraph(corpusGraph);
        corpusGraph.load(this.getCorpusDesc().getCorpusPath());
    }

    @Override
    public PepperMapper createPepperMapper(Identifier sElementId) {
        SaltXMLMapper mapper = new SaltXMLMapper();
        if (sElementId.getIdentifiableElement() instanceof SDocument) {
            SDocument sDocument = (SDocument)sElementId.getIdentifiableElement();
            URI location = this.getCorpusDesc().getCorpusPath();
            location = location.appendSegments(sDocument.getPath().segments());
            location = location.appendFileExtension("salt");
            mapper.setResourceURI(location);
        }
        return mapper;
    }

    private static class SaltXMLMapper
    extends PepperMapperImpl {
        private SaltXMLMapper() {
        }

        @Override
        public DOCUMENT_STATUS mapSDocument() {
            this.getDocument().loadDocumentGraph(this.getResourceURI());
            return DOCUMENT_STATUS.COMPLETED;
        }
    }
}

