/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.pepper.core;

import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.corpus_tools.pepper.common.DOCUMENT_STATUS;
import org.corpus_tools.pepper.core.ModuleControllerImpl;
import org.corpus_tools.pepper.exceptions.PepperFWException;
import org.corpus_tools.pepper.modules.DocumentController;
import org.corpus_tools.pepper.modules.ModuleController;
import org.corpus_tools.pepper.modules.PepperModule;
import org.corpus_tools.salt.common.SDocument;
import org.corpus_tools.salt.graph.Identifier;
import org.corpus_tools.salt.util.SaltUtil;
import org.eclipse.emf.common.util.URI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocumentControllerImpl
implements DocumentController {
    private static final Logger logger = LoggerFactory.getLogger(DocumentControllerImpl.class);
    private volatile SDocument document = null;
    private boolean callGC = false;
    private URI location = null;
    private boolean aSleep = false;
    private Lock sleepLock = new ReentrantLock();
    protected volatile List<ModuleControllerImpl> moduleControllers = null;
    protected volatile boolean isStarted = false;
    private volatile Map<String, DetailedStatus> detailedStatuses = null;
    protected volatile int numberOfProcessingModules = 0;
    protected volatile ModuleController currentModuleController = null;
    private volatile DOCUMENT_STATUS globalStatus = null;
    int numOfNodes = 0;
    int numOfRelations = 0;

    public DocumentControllerImpl() {
        this(null);
    }

    public DocumentControllerImpl(SDocument document) {
        this.setDocument(document);
        this.globalStatus = DOCUMENT_STATUS.NOT_STARTED;
    }

    @Override
    public SDocument getDocument() {
        return this.document;
    }

    @Override
    public void setDocument(SDocument sDocument) {
        this.document = sDocument;
    }

    @Override
    public Identifier getDocumentId() {
        if (this.getDocument() == null) {
            return null;
        }
        return this.getDocument().getIdentifier();
    }

    @Override
    public String getGlobalId() {
        String globalId = SaltUtil.getGlobalId((Identifier)this.getDocumentId());
        return globalId;
    }

    public void setCallGC(boolean callGC) {
        this.callGC = callGC;
    }

    @Override
    public URI getLocation() {
        return this.location;
    }

    @Override
    public void setLocation(URI location) {
        this.location = location;
    }

    @Override
    public boolean isAsleep() {
        return this.aSleep;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sleep() {
        if (this.getDocument() == null) {
            throw new PepperFWException("Cannot send document to sleep, since no " + SDocument.class.getSimpleName() + " is set.");
        }
        if (this.getLocation() == null) {
            throw new PepperFWException("Cannot send document to sleep, since no location to store document '" + this.getDocumentId() + "' is set.");
        }
        this.sleepLock.lock();
        try {
            this.aSleep = true;
            if (this.getDocument().getDocumentGraph() != null) {
                this.numOfNodes = this.getDocument().getDocumentGraph().getNodes().size();
                this.numOfRelations = this.getDocument().getDocumentGraph().getRelations().size();
                this.getDocument().saveDocumentGraph(this.getLocation());
                logger.debug("[Pepper] Sent document '{}' to sleep. ", (Object)SaltUtil.getGlobalId((Identifier)this.getDocumentId()));
            }
        }
        finally {
            this.sleepLock.unlock();
        }
        if (this.callGC) {
            System.gc();
        }
    }

    @Override
    public void sendToSleep() {
        if (this.getNumOfProcessingModules() == 0) {
            this.sleep();
        }
    }

    @Override
    public void sendToSleep_FORCE() {
        this.sleep();
    }

    @Override
    public void awake() {
        if (this.getDocument() == null) {
            throw new PepperFWException("Cannot send document to sleep, since no " + SDocument.class.getSimpleName() + " is set.");
        }
        this.sleepLock.lock();
        try {
            this.getDocument().loadDocumentGraph(this.getLocation());
            this.aSleep = false;
            logger.debug("[Pepper] woke up document '{}'. ", (Object)SaltUtil.getGlobalId((Identifier)this.getDocumentId()));
        }
        catch (Exception e) {
            throw new PepperFWException("Cannot awake the document '" + this.getDocumentId().getId() + "', because an exception occured, loading it from location '" + this.getLocation() + "'. ", e);
        }
        finally {
            this.sleepLock.unlock();
        }
    }

    public String toString() {
        return this.getGlobalId() + ": " + this.getGlobalStatus().toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ModuleControllerImpl> getModuleControllers() {
        if (this.moduleControllers == null) {
            DocumentControllerImpl documentControllerImpl = this;
            synchronized (documentControllerImpl) {
                if (this.moduleControllers == null) {
                    this.moduleControllers = new Vector<ModuleControllerImpl>();
                }
            }
        }
        return this.moduleControllers;
    }

    @Override
    public synchronized void addModuleControllers(ModuleControllerImpl moduleController) {
        if (this.isStarted) {
            throw new PepperFWException("Cannot add any further module controllers, since the processing of document '" + this.getGlobalId() + "' has already been started.");
        }
        this.getModuleControllers().add(moduleController);
        this.getDetailedStatuses().put(moduleController.getId(), new DetailedStatus());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, DetailedStatus> getDetailedStatuses() {
        if (this.detailedStatuses == null) {
            DocumentControllerImpl documentControllerImpl = this;
            synchronized (documentControllerImpl) {
                if (this.detailedStatuses == null) {
                    this.detailedStatuses = new Hashtable<String, DetailedStatus>();
                }
            }
        }
        return this.detailedStatuses;
    }

    @Override
    public int getNumOfProcessingModules() {
        return this.numberOfProcessingModules;
    }

    @Override
    public ModuleController getCurrentModuleController() {
        return this.currentModuleController;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateStatus(ModuleController moduleController, DOCUMENT_STATUS status) {
        if (moduleController == null) {
            throw new PepperFWException("Can not update status for document '" + this.getGlobalId() + "', because the given identifier for module conttroller is empty.");
        }
        if (status == null) {
            throw new PepperFWException("Can not update status for document '" + this.getGlobalId() + "', because the passed status is null.");
        }
        ModuleController moduleController2 = moduleController;
        synchronized (moduleController2) {
            DetailedStatus detailedStatus = this.getDetailedStatuses().get(moduleController.getId());
            if (detailedStatus == null) {
                throw new PepperFWException("Can not update status for document '" + this.getGlobalId() + "', because the passed identifier for module controller '" + moduleController.getId() + "' is not registered.");
            }
            this.isStarted = true;
            if (DOCUMENT_STATUS.NOT_STARTED.equals((Object)detailedStatus.getStatus()) && DOCUMENT_STATUS.IN_PROGRESS.equals((Object)status)) {
                ++this.numberOfProcessingModules;
                detailedStatus.setStatus(status);
                this.currentModuleController = moduleController;
            } else if (DOCUMENT_STATUS.IN_PROGRESS.equals((Object)detailedStatus.getStatus()) && (DOCUMENT_STATUS.COMPLETED.equals((Object)status) || DOCUMENT_STATUS.FAILED.equals((Object)status) || DOCUMENT_STATUS.DELETED.equals((Object)status))) {
                --this.numberOfProcessingModules;
                if (this.getNumOfProcessingModules() < 0) {
                    throw new PepperFWException("The number of " + PepperModule.class.getSimpleName() + " for this " + DocumentControllerImpl.class.getSimpleName() + " object '" + this.getGlobalId() + "' was set to a value less than 0.");
                }
                this.currentModuleController = null;
                detailedStatus.setStatus(status);
            } else {
                throw new PepperFWException("Cannot update status of document '" + this.getGlobalId() + "' for module controller '" + moduleController + "', because the level of current status '" + (Object)((Object)detailedStatus.getStatus()) + "' is higher or equal to the given status '" + (Object)((Object)status) + "'.");
            }
            this.updateGlobalStatus();
        }
    }

    @Override
    public DOCUMENT_STATUS getGlobalStatus() {
        return this.globalStatus;
    }

    private synchronized void updateGlobalStatus() {
        DOCUMENT_STATUS newGlobalStatus = null;
        boolean completedExists = false;
        boolean notStartedExists = false;
        for (DetailedStatus detailedStatus : this.getDetailedStatuses().values()) {
            if (DOCUMENT_STATUS.DELETED.equals((Object)detailedStatus.getStatus())) {
                newGlobalStatus = DOCUMENT_STATUS.DELETED;
                break;
            }
            if (DOCUMENT_STATUS.IN_PROGRESS.equals((Object)detailedStatus.getStatus())) {
                newGlobalStatus = DOCUMENT_STATUS.IN_PROGRESS;
                break;
            }
            if (DOCUMENT_STATUS.FAILED.equals((Object)detailedStatus.getStatus())) {
                newGlobalStatus = DOCUMENT_STATUS.FAILED;
                break;
            }
            if (DOCUMENT_STATUS.COMPLETED.equals((Object)detailedStatus.getStatus())) {
                completedExists = true;
                continue;
            }
            if (!DOCUMENT_STATUS.NOT_STARTED.equals((Object)detailedStatus.getStatus())) continue;
            notStartedExists = true;
        }
        if (newGlobalStatus == null) {
            if (notStartedExists && completedExists) {
                this.globalStatus = DOCUMENT_STATUS.IN_PROGRESS;
            } else if (completedExists) {
                this.globalStatus = DOCUMENT_STATUS.COMPLETED;
            }
        } else {
            this.globalStatus = newGlobalStatus;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getProgress() {
        if (DOCUMENT_STATUS.DELETED.equals((Object)this.globalStatus)) {
            return 1.0;
        }
        if (DOCUMENT_STATUS.FAILED.equals((Object)this.globalStatus)) {
            return 1.0;
        }
        if (DOCUMENT_STATUS.COMPLETED.equals((Object)this.globalStatus)) {
            return 1.0;
        }
        double p_total = 0.0;
        DocumentControllerImpl documentControllerImpl = this;
        synchronized (documentControllerImpl) {
            for (ModuleControllerImpl moduleController : this.getModuleControllers()) {
                Double newVal = moduleController.getProgress(this.getGlobalId());
                if (newVal == null) {
                    DetailedStatus detailedStatus = this.getDetailedStatuses().get(moduleController.getId());
                    if (DOCUMENT_STATUS.IN_PROGRESS.equals((Object)detailedStatus.getStatus())) {
                        newVal = 0.0;
                    } else if (DOCUMENT_STATUS.NOT_STARTED.equals((Object)detailedStatus.getStatus())) {
                        newVal = 0.0;
                    } else if (DOCUMENT_STATUS.COMPLETED.equals((Object)detailedStatus.getStatus())) {
                        newVal = 1.0;
                    }
                }
                if (newVal == null || 0.0 == newVal) continue;
                p_total += newVal / Double.valueOf(this.moduleControllers.size());
            }
        }
        return p_total;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long getProcessingTime() {
        Long time = 0L;
        DocumentControllerImpl documentControllerImpl = this;
        synchronized (documentControllerImpl) {
            for (DetailedStatus detailedStatus : this.detailedStatuses.values()) {
                time = time + detailedStatus.getProcessingTime();
            }
        }
        return time;
    }

    public String getStatusReport() {
        StringBuilder retVal = new StringBuilder();
        retVal.append(this.getDocumentId());
        retVal.append("..........");
        retVal.append("(");
        retVal.append(this.getProcessingTime());
        retVal.append(")");
        for (ModuleController moduleController : this.getModuleControllers()) {
            retVal.append("\t");
            retVal.append(moduleController.getPepperModule().getName());
            retVal.append("\t\t");
            retVal.append(moduleController.getProgress(this.getGlobalId()));
        }
        return retVal.toString();
    }

    @Override
    public int getSize_nodes() {
        return this.numOfNodes;
    }

    @Override
    public int getSize_relations() {
        return this.numOfRelations;
    }

    protected static class DetailedStatus {
        private DOCUMENT_STATUS status = DOCUMENT_STATUS.NOT_STARTED;
        private Long startTime = null;
        private Long processingTime = null;

        public DOCUMENT_STATUS getStatus() {
            return this.status;
        }

        public synchronized void setStatus(DOCUMENT_STATUS status) {
            if (DOCUMENT_STATUS.IN_PROGRESS.equals((Object)status)) {
                this.startTime = System.nanoTime();
            } else if (DOCUMENT_STATUS.COMPLETED.equals((Object)status) || DOCUMENT_STATUS.FAILED.equals((Object)status) || DOCUMENT_STATUS.DELETED.equals((Object)status)) {
                this.processingTime = (System.nanoTime() - this.startTime) / 1000000L;
            }
            this.status = status;
        }

        public Long getProcessingTime() {
            Long time = null;
            if (this.processingTime != null || this.startTime == null) {
                return this.processingTime;
            }
            time = (System.nanoTime() - this.startTime) / 1000000L;
            return time;
        }
    }
}

