/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.salt.samples;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import org.corpus_tools.salt.SALT_TYPE;
import org.corpus_tools.salt.SaltFactory;
import org.corpus_tools.salt.common.SCorpus;
import org.corpus_tools.salt.common.SCorpusGraph;
import org.corpus_tools.salt.common.SDocument;
import org.corpus_tools.salt.common.SDocumentGraph;
import org.corpus_tools.salt.common.SOrderRelation;
import org.corpus_tools.salt.common.SPointingRelation;
import org.corpus_tools.salt.common.SSpan;
import org.corpus_tools.salt.common.SSpanningRelation;
import org.corpus_tools.salt.common.SStructure;
import org.corpus_tools.salt.common.STextualDS;
import org.corpus_tools.salt.common.STextualRelation;
import org.corpus_tools.salt.common.STimelineRelation;
import org.corpus_tools.salt.common.SToken;
import org.corpus_tools.salt.common.SaltProject;
import org.corpus_tools.salt.core.SAnnotation;
import org.corpus_tools.salt.core.SLayer;
import org.corpus_tools.salt.core.SRelation;
import org.corpus_tools.salt.exceptions.SaltSampleException;
import org.corpus_tools.salt.graph.Node;
import org.corpus_tools.salt.semantics.SLemmaAnnotation;
import org.corpus_tools.salt.semantics.SPOSAnnotation;

public class SampleGenerator {
    public static final String PRIMARY_TEXT_EN = "Is this example more complicated than it appears to be?";
    public static final String PRIMARY_TEXT_EN_SPK1 = "Is this example more complicated than it appears to be?";
    public static final String PRIMARY_TEXT_EN_SPK2 = "Uhm oh yes!";
    public static final String PRIMARY_TEXT_DE = "Ist dieses Beispiel komplizierter als es zu sein scheint?";
    public static final String MORPHOLOGY_LAYER = "morphology";
    public static final String LANG_EN = "en";
    public static final String LANG_DE = "de";
    public static final String SYNTAX_LAYER = "syntax";

    public static SCorpusGraph createCorpusStructure(SaltProject saltProject) {
        if (saltProject == null) {
            throw new SaltSampleException("Cannot create example, because the given saltProjects is empty.");
        }
        SCorpusGraph corpGraph = SaltFactory.createSCorpusGraph();
        saltProject.addCorpusGraph(corpGraph);
        SCorpus rootCorpus = SaltFactory.createSCorpus();
        rootCorpus.setName("rootCorpus");
        corpGraph.addNode(rootCorpus);
        SCorpus subCorpus1 = SaltFactory.createSCorpus();
        subCorpus1.setName("subCorpus1");
        SCorpus subCorpus2 = SaltFactory.createSCorpus();
        subCorpus2.setName("subCorpus2");
        corpGraph.addSubCorpus(rootCorpus, subCorpus1);
        corpGraph.addSubCorpus(rootCorpus, subCorpus2);
        SDocument doc = null;
        doc = SaltFactory.createSDocument();
        doc.setName("doc1");
        corpGraph.addDocument(subCorpus1, doc);
        doc = SaltFactory.createSDocument();
        doc.setName("doc2");
        corpGraph.addDocument(subCorpus1, doc);
        doc = SaltFactory.createSDocument();
        doc.setName("doc3");
        corpGraph.addDocument(subCorpus1, doc);
        doc = SaltFactory.createSDocument();
        doc.setName("doc4");
        corpGraph.addDocument(subCorpus1, doc);
        return corpGraph;
    }

    public static SaltProject createSaltProject() {
        SaltProject saltProject = SaltFactory.createSaltProject();
        saltProject.setName("sampleSaltProject");
        SCorpusGraph corpGraph = SaltFactory.createSCorpusGraph();
        corpGraph = SampleGenerator.createCorpusStructure(corpGraph);
        saltProject.addCorpusGraph(corpGraph);
        for (SDocument document : corpGraph.getDocuments()) {
            SampleGenerator.createDocumentStructure(document);
        }
        return saltProject;
    }

    public static SCorpusGraph createCorpusStructure() {
        SCorpusGraph corpGraph = SaltFactory.createSCorpusGraph();
        SampleGenerator.createCorpusStructure(corpGraph);
        return corpGraph;
    }

    public static SCorpusGraph createCorpusStructure(SCorpusGraph corpGraph1) {
        if (corpGraph1 == null) {
            throw new SaltSampleException("Cannot create example, because the given sCorpusGraph is empty.");
        }
        corpGraph1.setId("corpusGraph1");
        SCorpus corpusRoot = SaltFactory.createSCorpus();
        corpusRoot.setName("rootCorpus");
        corpGraph1.addNode(corpusRoot);
        SCorpus corpusSub1 = SaltFactory.createSCorpus();
        corpusSub1.setName("subCorpus1");
        SCorpus corpusSub2 = SaltFactory.createSCorpus();
        corpusSub2.setName("subCorpus2");
        corpGraph1.addSubCorpus(corpusRoot, corpusSub1);
        corpGraph1.addSubCorpus(corpusRoot, corpusSub2);
        SDocument doc = null;
        doc = SaltFactory.createSDocument();
        doc.setName("doc1");
        corpGraph1.addDocument(corpusSub1, doc);
        doc = SaltFactory.createSDocument();
        doc.setName("doc2");
        corpGraph1.addDocument(corpusSub1, doc);
        doc = SaltFactory.createSDocument();
        doc.setName("doc3");
        corpGraph1.addDocument(corpusSub2, doc);
        doc = SaltFactory.createSDocument();
        doc.setName("doc4");
        corpGraph1.addDocument(corpusSub2, doc);
        return corpGraph1;
    }

    public static SCorpusGraph createCorpusStructure_simple() {
        SCorpusGraph corpGraph = SaltFactory.createSCorpusGraph();
        corpGraph.setId("corpusGraph1");
        SCorpus corpus = SaltFactory.createSCorpus();
        corpus.setName("rootCorpus");
        corpGraph.addNode(corpus);
        SDocument doc = null;
        doc = SaltFactory.createSDocument();
        doc.setName("doc1");
        corpGraph.addDocument(corpus, doc);
        return corpGraph;
    }

    /*
     * WARNING - void declaration
     */
    public static void createDialogue(SDocument document) {
        if (document == null) {
            throw new SaltSampleException("Cannot create example, because the given document is empty.");
        }
        document.setDocumentGraph(SaltFactory.createSDocumentGraph());
        document.getDocumentGraph().createTextualDS("Is this example more complicated than it appears to be?");
        SampleGenerator.createTokens(document);
        document.getDocumentGraph().createTimeline();
        ArrayList<STimelineRelation> timelineRelationsToDelete = new ArrayList<STimelineRelation>();
        for (STimelineRelation sTimelineRelation : document.getDocumentGraph().getTimelineRelations()) {
            timelineRelationsToDelete.add(sTimelineRelation);
        }
        for (SRelation sRelation : timelineRelationsToDelete) {
            document.getDocumentGraph().removeRelation(sRelation);
        }
        SToken lastSTok = null;
        boolean bl = false;
        for (SToken tok : document.getDocumentGraph().getTokens()) {
            void var3_7;
            if (lastSTok != null) {
                SOrderRelation rel = SaltFactory.createSOrderRelation();
                rel.setSource(lastSTok);
                rel.setTarget(tok);
                document.getDocumentGraph().addRelation(rel);
            }
            STimelineRelation timeRel = SaltFactory.createSTimelineRelation();
            timeRel.setSource(tok);
            timeRel.setTarget(document.getDocumentGraph().getTimeline());
            timeRel.setStart((int)var3_7);
            if (++var3_7 == 10) {
                ++var3_7;
            }
            timeRel.setEnd((int)var3_7);
            document.getDocumentGraph().addRelation(timeRel);
            lastSTok = tok;
        }
        STextualDS text2 = document.getDocumentGraph().createTextualDS(PRIMARY_TEXT_EN_SPK2);
        SToken spk2_tok0 = SampleGenerator.createToken(0, 3, text2, document, null);
        STimelineRelation timeRel0 = SaltFactory.createSTimelineRelation();
        timeRel0.setSource(spk2_tok0);
        timeRel0.setTarget(document.getDocumentGraph().getTimeline());
        timeRel0.setStart(7);
        timeRel0.setEnd(9);
        document.getDocumentGraph().addRelation(timeRel0);
        SToken spk2_tok1 = SampleGenerator.createToken(4, 6, text2, document, null);
        STimelineRelation sTimeRel1 = SaltFactory.createSTimelineRelation();
        sTimeRel1.setSource(spk2_tok1);
        sTimeRel1.setTarget(document.getDocumentGraph().getTimeline());
        sTimeRel1.setStart(9);
        sTimeRel1.setEnd(10);
        document.getDocumentGraph().addRelation(sTimeRel1);
        SToken spk2_tok2 = SampleGenerator.createToken(7, 11, text2, document, null);
        STimelineRelation timeRel2 = SaltFactory.createSTimelineRelation();
        timeRel2.setSource(spk2_tok2);
        timeRel2.setTarget(document.getDocumentGraph().getTimeline());
        timeRel2.setStart(10);
        timeRel2.setEnd(11);
        document.getDocumentGraph().addRelation(timeRel2);
        SOrderRelation ord1 = SaltFactory.createSOrderRelation();
        ord1.setSource(spk2_tok0);
        ord1.setTarget(spk2_tok1);
        document.getDocumentGraph().addRelation(ord1);
        SOrderRelation ord2 = SaltFactory.createSOrderRelation();
        ord2.setSource(spk2_tok1);
        ord2.setTarget(spk2_tok2);
        document.getDocumentGraph().addRelation(ord2);
    }

    public static STextualDS createPrimaryData(SDocument document) {
        return SampleGenerator.createPrimaryData(document, LANG_EN);
    }

    public static STextualDS createPrimaryData(SDocument document, String language) {
        if (document == null) {
            throw new SaltSampleException("Cannot create example, because the given document is empty.");
        }
        if (document.getDocumentGraph() == null) {
            document.setDocumentGraph(SaltFactory.createSDocumentGraph());
        }
        STextualDS textualDS = null;
        textualDS = SaltFactory.createSTextualDS();
        if (LANG_EN.equalsIgnoreCase(language)) {
            textualDS.setText("Is this example more complicated than it appears to be?");
        } else if (LANG_DE.equalsIgnoreCase(language)) {
            textualDS.setText(PRIMARY_TEXT_DE);
        }
        document.getDocumentGraph().addNode(textualDS);
        return textualDS;
    }

    public static void createTokens(SDocument document) {
        if (document == null) {
            throw new SaltSampleException("Cannot create example, because the given document is empty.");
        }
        if (document.getDocumentGraph() == null) {
            document.setDocumentGraph(SaltFactory.createSDocumentGraph());
        }
        if (document.getDocumentGraph().getTextualDSs().isEmpty()) {
            SampleGenerator.createPrimaryData(document);
        }
        SampleGenerator.createTokens(document, document.getDocumentGraph().getTextualDSs().get(0));
    }

    public static List<SToken> createTokens(SDocument document, STextualDS textualDS) {
        if (document == null) {
            throw new SaltSampleException("Cannot create example, because the given document is empty.");
        }
        SLayer morphLayer = SaltFactory.createSLayer();
        morphLayer.setName(MORPHOLOGY_LAYER);
        document.getDocumentGraph().addLayer(morphLayer);
        Vector<SToken> retVal = new Vector<SToken>();
        if (textualDS.getText().equals("Is this example more complicated than it appears to be?")) {
            retVal.add(SampleGenerator.createToken(0, 2, textualDS, document, morphLayer));
            retVal.add(SampleGenerator.createToken(3, 7, textualDS, document, morphLayer));
            retVal.add(SampleGenerator.createToken(8, 15, textualDS, document, morphLayer));
            retVal.add(SampleGenerator.createToken(16, 20, textualDS, document, morphLayer));
            retVal.add(SampleGenerator.createToken(21, 32, textualDS, document, morphLayer));
            retVal.add(SampleGenerator.createToken(33, 37, textualDS, document, morphLayer));
            retVal.add(SampleGenerator.createToken(38, 40, textualDS, document, morphLayer));
            retVal.add(SampleGenerator.createToken(41, 48, textualDS, document, morphLayer));
            retVal.add(SampleGenerator.createToken(49, 51, textualDS, document, morphLayer));
            retVal.add(SampleGenerator.createToken(52, 54, textualDS, document, morphLayer));
            retVal.add(SampleGenerator.createToken(54, 55, textualDS, document, morphLayer));
        } else if (textualDS.getText().equals(PRIMARY_TEXT_DE)) {
            retVal.add(SampleGenerator.createToken(0, 3, textualDS, document, morphLayer));
            retVal.add(SampleGenerator.createToken(4, 10, textualDS, document, morphLayer));
            retVal.add(SampleGenerator.createToken(11, 19, textualDS, document, morphLayer));
            retVal.add(SampleGenerator.createToken(20, 33, textualDS, document, morphLayer));
            retVal.add(SampleGenerator.createToken(34, 37, textualDS, document, morphLayer));
            retVal.add(SampleGenerator.createToken(38, 40, textualDS, document, morphLayer));
            retVal.add(SampleGenerator.createToken(41, 43, textualDS, document, morphLayer));
            retVal.add(SampleGenerator.createToken(44, 48, textualDS, document, morphLayer));
            retVal.add(SampleGenerator.createToken(49, 56, textualDS, document, morphLayer));
            retVal.add(SampleGenerator.createToken(56, 57, textualDS, document, morphLayer));
        }
        return retVal;
    }

    public static SToken createToken(int start, int end, STextualDS textualDS, SDocument document, SLayer layer) {
        if (document == null) {
            throw new SaltSampleException("Cannot create example, because the given document is empty.");
        }
        if (document.getDocumentGraph() == null) {
            document.setDocumentGraph(SaltFactory.createSDocumentGraph());
        }
        if (document.getDocumentGraph().getTextualDSs().isEmpty()) {
            SampleGenerator.createPrimaryData(document);
            textualDS = document.getDocumentGraph().getTextualDSs().get(0);
        }
        SToken token = SaltFactory.createSToken();
        document.getDocumentGraph().addNode(token);
        if (layer != null) {
            layer.addNode(token);
        }
        STextualRelation textRel = SaltFactory.createSTextualRelation();
        textRel.setSource(token);
        textRel.setTarget(textualDS);
        textRel.setStart(start);
        textRel.setEnd(end);
        document.getDocumentGraph().addRelation(textRel);
        return token;
    }

    public static void createParallelData(SDocument document) {
        SampleGenerator.createParallelData(document, true);
    }

    public static void createParallelData(SDocument document, boolean setTypeForPointRel) {
        if (document == null) {
            throw new SaltSampleException("Cannot create example, because the given document is empty.");
        }
        STextualDS pd_EN = SampleGenerator.createPrimaryData(document, LANG_EN);
        STextualDS pd_DE = SampleGenerator.createPrimaryData(document, LANG_DE);
        List<SToken> englishToks = SampleGenerator.createTokens(document, pd_EN);
        List<SToken> germanToks = SampleGenerator.createTokens(document, pd_DE);
        SPointingRelation pointRel = null;
        pointRel = (SPointingRelation)document.getDocumentGraph().createRelation(englishToks.get(0), germanToks.get(0), SALT_TYPE.SPOINTING_RELATION, "align=en_de");
        if (setTypeForPointRel) {
            pointRel.setType("align");
        }
        pointRel = (SPointingRelation)document.getDocumentGraph().createRelation(englishToks.get(1), germanToks.get(1), SALT_TYPE.SPOINTING_RELATION, "align=en_de");
        if (setTypeForPointRel) {
            pointRel.setType("align");
        }
        pointRel = (SPointingRelation)document.getDocumentGraph().createRelation(englishToks.get(2), germanToks.get(2), SALT_TYPE.SPOINTING_RELATION, "align=en_de");
        if (setTypeForPointRel) {
            pointRel.setType("align");
        }
        pointRel = (SPointingRelation)document.getDocumentGraph().createRelation(englishToks.get(5), germanToks.get(4), SALT_TYPE.SPOINTING_RELATION, "align=en_de");
        if (setTypeForPointRel) {
            pointRel.setType("align");
        }
        pointRel = (SPointingRelation)document.getDocumentGraph().createRelation(englishToks.get(6), germanToks.get(5), SALT_TYPE.SPOINTING_RELATION, "align=en_de");
        if (setTypeForPointRel) {
            pointRel.setType("align");
        }
        pointRel = (SPointingRelation)document.getDocumentGraph().createRelation(englishToks.get(7), germanToks.get(6), SALT_TYPE.SPOINTING_RELATION, "align=en_de");
        if (setTypeForPointRel) {
            pointRel.setType("align");
        }
        pointRel = (SPointingRelation)document.getDocumentGraph().createRelation(englishToks.get(8), germanToks.get(7), SALT_TYPE.SPOINTING_RELATION, "align=en_de");
        if (setTypeForPointRel) {
            pointRel.setType("align");
        }
        pointRel = (SPointingRelation)document.getDocumentGraph().createRelation(englishToks.get(9), germanToks.get(8), SALT_TYPE.SPOINTING_RELATION, "align=en_de");
        if (setTypeForPointRel) {
            pointRel.setType("align");
        }
        SSpan sSpan = document.getDocumentGraph().createSpan(englishToks.get(3), englishToks.get(4));
        pointRel = (SPointingRelation)document.getDocumentGraph().createRelation(sSpan, germanToks.get(3), SALT_TYPE.SPOINTING_RELATION, "align=en_de");
        if (setTypeForPointRel) {
            pointRel.setType("align");
        }
    }

    public static void createUntypedParallelData(SDocument document) {
        SampleGenerator.createParallelData(document, false);
    }

    public static void createMorphologyAnnotations(SDocument document) {
        int i;
        if (document == null) {
            throw new SaltSampleException("Cannot create example, because the given document is empty.");
        }
        if (document.getDocumentGraph() == null) {
            document.setDocumentGraph(SaltFactory.createSDocumentGraph());
        }
        if (document.getDocumentGraph().getTextualDSs().isEmpty()) {
            SampleGenerator.createPrimaryData(document);
            SampleGenerator.createTokens(document);
        }
        List<SToken> tokens = Collections.synchronizedList(document.getDocumentGraph().getTokens());
        SPOSAnnotation posAnno = null;
        String[] posAnnotations = new String[]{"VBZ", "DT", "NN", "RBR", "JJ", "IN", "PRP", "VBZ", "TO", "VB", "."};
        for (i = 0; i < tokens.size(); ++i) {
            posAnno = SaltFactory.createSPOSAnnotation();
            posAnno.setValue(posAnnotations[i]);
            tokens.get(i).addAnnotation(posAnno);
        }
        SLemmaAnnotation lemmaAnno = null;
        posAnnotations = new String[]{"be", "this", "example", "more", "complicated", "than", "it", "appear", "to", "be", "?"};
        for (i = 0; i < tokens.size(); ++i) {
            lemmaAnno = SaltFactory.createSLemmaAnnotation();
            lemmaAnno.setValue(posAnnotations[i]);
            tokens.get(i).addAnnotation(lemmaAnno);
        }
    }

    public static void createInformationStructureSpan(SDocument document) {
        if (document == null) {
            throw new SaltSampleException("Cannot create example, because the given document is empty.");
        }
        if (document.getDocumentGraph() == null) {
            document.setDocumentGraph(SaltFactory.createSDocumentGraph());
        }
        if (document.getDocumentGraph().getTokens() == null || document.getDocumentGraph().getTokens().size() == 0) {
            if (document.getDocumentGraph().getTextualDSs() == null || document.getDocumentGraph().getTextualDSs().size() == 0) {
                SampleGenerator.createPrimaryData(document);
            }
            SampleGenerator.createTokens(document);
        }
        List<SToken> sTokens = Collections.synchronizedList(document.getDocumentGraph().getTokens());
        SSpan span = null;
        SSpanningRelation spanRel = null;
        span = SaltFactory.createSSpan();
        span.setName("IS_span1");
        document.getDocumentGraph().addNode(span);
        spanRel = SaltFactory.createSSpanningRelation();
        spanRel.setSource(span);
        spanRel.setTarget((Node)sTokens.get(0));
        document.getDocumentGraph().addRelation(spanRel);
        span = SaltFactory.createSSpan();
        span.setName("IS_span2");
        document.getDocumentGraph().addNode(span);
        for (int i = 1; i < sTokens.size(); ++i) {
            spanRel = SaltFactory.createSSpanningRelation();
            spanRel.setSource(span);
            spanRel.setTarget((Node)sTokens.get(i));
            document.getDocumentGraph().addRelation(spanRel);
        }
    }

    public static void createInformationStructureAnnotations(SDocument document) {
        if (document == null) {
            throw new SaltSampleException("Cannot create example, because the given document is empty.");
        }
        if (document.getDocumentGraph() == null) {
            document.setDocumentGraph(SaltFactory.createSDocumentGraph());
        }
        if (document.getDocumentGraph().getTextualDSs().isEmpty()) {
            SampleGenerator.createPrimaryData(document);
        }
        if (document.getDocumentGraph().getNodesByName("IS_span1").size() == 0) {
            SampleGenerator.createInformationStructureSpan(document);
        }
        SAnnotation anno = null;
        anno = SaltFactory.createSAnnotation();
        anno.setName("Inf-Struct");
        anno.setValue("contrast-focus");
        document.getDocumentGraph().getSpans().get(0).addAnnotation(anno);
        anno = SaltFactory.createSAnnotation();
        anno.setName("Inf-Struct");
        anno.setValue("topic");
        document.getDocumentGraph().getSpans().get(1).addAnnotation(anno);
    }

    public static void createSyntaxStructure(SDocument document) {
        if (document == null) {
            throw new SaltSampleException("Cannot create example, because the given document is empty.");
        }
        if (document.getDocumentGraph() == null) {
            document.setDocumentGraph(SaltFactory.createSDocumentGraph());
        }
        if (document.getDocumentGraph().getTokens() == null || document.getDocumentGraph().getTokens().size() == 0) {
            if (document.getDocumentGraph().getTextualDSs() == null || document.getDocumentGraph().getTextualDSs().size() == 0) {
                SampleGenerator.createPrimaryData(document);
            }
            SampleGenerator.createTokens(document);
        }
        List<SToken> tokens = Collections.synchronizedList(document.getDocumentGraph().getTokens());
        SDocumentGraph docGraph = document.getDocumentGraph();
        SStructure root = SaltFactory.createSStructure();
        SStructure sq = SaltFactory.createSStructure();
        SStructure np1 = SaltFactory.createSStructure();
        SStructure adjp1 = SaltFactory.createSStructure();
        SStructure adjp2 = SaltFactory.createSStructure();
        SStructure sbar = SaltFactory.createSStructure();
        SStructure s1 = SaltFactory.createSStructure();
        SStructure np2 = SaltFactory.createSStructure();
        SStructure vp1 = SaltFactory.createSStructure();
        SStructure s2 = SaltFactory.createSStructure();
        SStructure vp2 = SaltFactory.createSStructure();
        SStructure vp3 = SaltFactory.createSStructure();
        SALT_TYPE domRel = SALT_TYPE.SDOMINANCE_RELATION;
        docGraph.addNode(root);
        docGraph.addNode(root, sq, domRel);
        docGraph.addNode(sq, tokens.get(0), domRel);
        docGraph.addNode(sq, np1, domRel);
        docGraph.addNode(np1, tokens.get(1), domRel);
        docGraph.addNode(np1, tokens.get(2), domRel);
        docGraph.addNode(sq, adjp1, domRel);
        docGraph.addNode(adjp1, adjp2, domRel);
        docGraph.addNode(adjp2, tokens.get(3), domRel);
        docGraph.addNode(adjp2, tokens.get(4), domRel);
        docGraph.addNode(adjp1, sbar, domRel);
        docGraph.addNode(sbar, tokens.get(5), domRel);
        docGraph.addNode(sbar, s1, domRel);
        docGraph.addNode(s1, np2, domRel);
        docGraph.addNode(np2, tokens.get(6), domRel);
        docGraph.addNode(s1, vp1, domRel);
        docGraph.addNode(vp1, tokens.get(7), domRel);
        docGraph.addNode(vp1, s2, domRel);
        docGraph.addNode(s2, vp2, domRel);
        docGraph.addNode(vp2, tokens.get(8), domRel);
        docGraph.addNode(vp2, vp3, domRel);
        docGraph.addNode(vp3, tokens.get(9), domRel);
        docGraph.addNode(root, tokens.get(10), domRel);
        SLayer syntaxLayer = SaltFactory.createSLayer();
        syntaxLayer.setName(SYNTAX_LAYER);
        docGraph.addLayer(syntaxLayer);
        syntaxLayer.addNode(root);
        syntaxLayer.addNode(sq);
        syntaxLayer.addNode(np1);
        syntaxLayer.addNode(adjp1);
        syntaxLayer.addNode(adjp2);
        syntaxLayer.addNode(sbar);
        syntaxLayer.addNode(s1);
        syntaxLayer.addNode(np2);
        syntaxLayer.addNode(vp1);
        syntaxLayer.addNode(s2);
        syntaxLayer.addNode(vp2);
        syntaxLayer.addNode(vp3);
    }

    public static void createSyntaxAnnotations(SDocument document) {
        if (document == null) {
            throw new SaltSampleException("Cannot create example, because the given document is empty.");
        }
        if (document.getDocumentGraph() == null || document.getDocumentGraph().getLayerByName(SYNTAX_LAYER).isEmpty()) {
            SampleGenerator.createSyntaxStructure(document);
        }
        List<SStructure> structures = Collections.synchronizedList(document.getDocumentGraph().getStructures());
        String[] annotations = new String[]{"ROOT", "SQ", "NP", "ADJP", "ADJP", "SBar", "S", "NP", "VP", "S", "VP", "VP"};
        int i = 0;
        for (SStructure structure : structures) {
            structure.createAnnotation(null, "const", annotations[i]);
            ++i;
        }
    }

    public static void createDependencies(SDocument document) {
        SDocumentGraph docGraph;
        if (document == null) {
            throw new SaltSampleException("Cannot create example, because the given document is empty.");
        }
        if (document.getDocumentGraph() == null) {
            document.setDocumentGraph(SaltFactory.createSDocumentGraph());
        }
        if ((docGraph = document.getDocumentGraph()).getTextualDSs() == null || docGraph.getTextualDSs().size() == 0) {
            SampleGenerator.createPrimaryData(document);
        }
        if (docGraph.getTokens() == null || docGraph.getTokens().size() == 0) {
            SampleGenerator.createTokens(document);
        }
        List<SToken> tokens = docGraph.getSortedTokenByText();
        SLayer depLayer = SaltFactory.createSLayer();
        depLayer.setName("dependencies");
        depLayer.createMetaAnnotation(null, "tagset", "penn treebank");
        document.getDocumentGraph().addLayer(depLayer);
        SPointingRelation depRel = SaltFactory.createSPointingRelation();
        depRel.setSource((Node)tokens.get(4));
        depRel.setTarget((Node)tokens.get(0));
        depRel.createAnnotation(null, "dependency", "cop");
        docGraph.addRelation(depRel);
        depLayer.addRelation(depRel);
        depRel = SaltFactory.createSPointingRelation();
        depRel.setSource((Node)tokens.get(2));
        depRel.setTarget((Node)tokens.get(1));
        depRel.createAnnotation(null, "dependency", "det");
        docGraph.addRelation(depRel);
        depLayer.addRelation(depRel);
        depRel = SaltFactory.createSPointingRelation();
        depRel.setSource((Node)tokens.get(4));
        depRel.setTarget((Node)tokens.get(2));
        depRel.createAnnotation(null, "dependency", "nsubj");
        docGraph.addRelation(depRel);
        depLayer.addRelation(depRel);
        depRel = SaltFactory.createSPointingRelation();
        depRel.setSource((Node)tokens.get(4));
        depRel.setTarget((Node)tokens.get(3));
        depRel.createAnnotation(null, "dependency", "advmod");
        docGraph.addRelation(depRel);
        depLayer.addRelation(depRel);
        depRel = SaltFactory.createSPointingRelation();
        depRel.setSource((Node)tokens.get(7));
        depRel.setTarget((Node)tokens.get(5));
        depRel.createAnnotation(null, "dependency", "mark");
        docGraph.addRelation(depRel);
        depLayer.addRelation(depRel);
        depRel = SaltFactory.createSPointingRelation();
        depRel.setSource((Node)tokens.get(7));
        depRel.setTarget((Node)tokens.get(6));
        depRel.createAnnotation(null, "dependency", "nsubj");
        docGraph.addRelation(depRel);
        depLayer.addRelation(depRel);
        depRel = SaltFactory.createSPointingRelation();
        depRel.setSource((Node)tokens.get(4));
        depRel.setTarget((Node)tokens.get(7));
        depRel.createAnnotation(null, "dependency", "advcl");
        docGraph.addRelation(depRel);
        depLayer.addRelation(depRel);
        depRel = SaltFactory.createSPointingRelation();
        depRel.setSource((Node)tokens.get(9));
        depRel.setTarget((Node)tokens.get(8));
        depRel.createAnnotation(null, "dependency", "aux");
        docGraph.addRelation(depRel);
        depLayer.addRelation(depRel);
        depRel = SaltFactory.createSPointingRelation();
        depRel.setSource((Node)tokens.get(7));
        depRel.setTarget((Node)tokens.get(9));
        depRel.createAnnotation(null, "dependency", "xcomp");
        docGraph.addRelation(depRel);
        depLayer.addRelation(depRel);
    }

    public static void createAnaphoricAnnotations(SDocument document) {
        if (document == null) {
            throw new SaltSampleException("Cannot create example, because the given document is empty.");
        }
        if (document.getDocumentGraph() == null) {
            SampleGenerator.createPrimaryData(document);
            SampleGenerator.createTokens(document);
        }
        List<SToken> sTokens = Collections.synchronizedList(document.getDocumentGraph().getTokens());
        SSpan span = SaltFactory.createSSpan();
        document.getDocumentGraph().addNode(span);
        SSpanningRelation spanRel = null;
        spanRel = SaltFactory.createSSpanningRelation();
        spanRel.setSource(span);
        spanRel.setTarget((Node)sTokens.get(1));
        document.getDocumentGraph().addRelation(spanRel);
        spanRel = SaltFactory.createSSpanningRelation();
        spanRel.setSource(span);
        spanRel.setTarget((Node)sTokens.get(2));
        document.getDocumentGraph().addRelation(spanRel);
        SPointingRelation pointingRelation = SaltFactory.createSPointingRelation();
        pointingRelation.setSource((Node)sTokens.get(6));
        pointingRelation.setTarget(span);
        document.getDocumentGraph().addRelation(pointingRelation);
        pointingRelation.setType("anaphoric");
    }

    public static void createDocumentStructure(SDocument document) {
        if (document == null) {
            throw new SaltSampleException("Cannot create example, because the given document is empty.");
        }
        document.setDocumentGraph(SaltFactory.createSDocumentGraph());
        SampleGenerator.createPrimaryData(document);
        SampleGenerator.createTokens(document);
        SampleGenerator.createMorphologyAnnotations(document);
        SampleGenerator.createInformationStructureSpan(document);
        SampleGenerator.createInformationStructureAnnotations(document);
        SampleGenerator.createSyntaxStructure(document);
        SampleGenerator.createSyntaxAnnotations(document);
        SampleGenerator.createAnaphoricAnnotations(document);
    }
}

