/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.salt.graph.impl;

import org.apache.commons.lang3.tuple.Pair;
import org.corpus_tools.salt.exceptions.SaltException;
import org.corpus_tools.salt.graph.Label;
import org.corpus_tools.salt.graph.LabelableElement;
import org.corpus_tools.salt.graph.impl.LabelableElementImpl;
import org.corpus_tools.salt.util.Copyable;
import org.corpus_tools.salt.util.SaltUtil;

public class LabelImpl
extends LabelableElementImpl
implements Label,
Copyable<Label> {
    protected String namespace = null;
    protected String name = null;
    protected Object value = null;
    protected LabelableElement container = null;

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public void setNamespace(String namespace) {
        this.namespace = namespace != null ? namespace.intern() : null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        if (name == null || name.isEmpty()) {
            throw new SaltException("Cannot set the name of this label object, because it is empty.");
        }
        if (name.contains("::")) {
            throw new SaltException("Cannot set the name to the given, because a namespace with namespace seperaor is illegal.");
        }
        this.name = name.intern();
    }

    @Override
    public String getQName() {
        return SaltUtil.createQName(this.getNamespace(), this.getName());
    }

    @Override
    public void setQName(String newQName) {
        Pair<String, String> pair = SaltUtil.splitQName(newQName);
        this.setNamespace((String)pair.getLeft());
        this.setName((String)pair.getRight());
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public void setValue(Object value) {
        this.value = value;
    }

    public void setContainer(LabelableElement container) {
        LabelableElement oldContainer = this.container;
        if (container != null && container instanceof LabelableElementImpl) {
            container.addLabel(this);
        }
        if (oldContainer != null && oldContainer instanceof LabelableElementImpl) {
            ((LabelableElementImpl)oldContainer).basicRemoveLabel(this.getQName());
        }
    }

    public LabelableElement getContainer() {
        return this.container;
    }

    public void basicSetLabelableElement(LabelableElement container) {
        this.container = container;
    }

    @Override
    public Label copy(Label other) {
        if (other == null) {
            throw new SaltException("Cannot clone label '" + this + "', because the given object is null and its not possible to copy values into a null object.");
        }
        other.setNamespace(this.getNamespace());
        other.setName(this.getName());
        other.setValue(this.getValue());
        return other;
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append(SaltUtil.createQName(this.getNamespace(), this.getName()));
        str.append("=");
        str.append(this.getValue());
        return str.toString();
    }
}

