/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.pepper.testFramework;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.corpus_tools.pepper.exceptions.PepperTestException;
import org.corpus_tools.pepper.modules.PepperModule;
import org.corpus_tools.pepper.testFramework.PepperTestUtil;
import org.corpus_tools.pepper.util.FileComparator;
import org.corpus_tools.salt.SaltFactory;
import org.corpus_tools.salt.common.SCorpusGraph;
import org.eclipse.emf.common.util.URI;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PepperModuleTest {
    private static final Logger logger = LoggerFactory.getLogger((String)"Pepper");
    private URI resourceURI = null;
    protected PepperModule fixture = null;
    public static String TMP_TEST_DIR = PepperTestUtil.TMP_TEST_DIR;

    protected void setFixture(PepperModule fixture) {
        this.fixture = fixture;
        if (this.resourceURI != null) {
            this.getFixture().setResources(this.resourceURI);
        }
        this.getFixture().setSaltProject(SaltFactory.createSaltProject());
        this.getFixture().getSaltProject().addCorpusGraph(SaltFactory.createSCorpusGraph());
    }

    protected PepperModule getFixture() {
        return this.fixture;
    }

    public PepperModuleTest() {
        this.initilaize();
    }

    public void initilaize() {
        this.setResourcesURI(URI.createFileURI((String)"src/main/resources"));
    }

    public URI getTempURI(String testDirectory) {
        return URI.createFileURI((String)PepperModuleTest.getTempPath_static(testDirectory).getAbsolutePath());
    }

    public File getTempPath(String testDirectory) {
        return PepperModuleTest.getTempPath_static(testDirectory);
    }

    public static File getTempPath_static(String testDirectory) {
        return PepperTestUtil.getTempPath_static(testDirectory);
    }

    public static String getTestResources() {
        return PepperTestUtil.getTestResources();
    }

    public static String getSrcResources() {
        return PepperTestUtil.getSrcResources();
    }

    public void start() {
        ArrayList<PepperModule> fixtures = new ArrayList<PepperModule>();
        fixtures.add(this.getFixture());
        PepperTestUtil.start(fixtures);
    }

    @Test
    public void testSetGetCorpusGraph() {
        SCorpusGraph corpGraph = SaltFactory.createSCorpusGraph();
        this.getFixture().setCorpusGraph(corpGraph);
        Assert.assertEquals((Object)corpGraph, (Object)this.getFixture().getCorpusGraph());
    }

    @Test
    public void testGetName() {
        Assert.assertNotNull((String)"The importer has to have a name.", (Object)this.getFixture().getName());
        Assert.assertFalse((String)"The name of the importer cannot be empty.", (boolean)this.getFixture().getName().equals(""));
    }

    public void setResourcesURI(URI resourceURI) {
        if (resourceURI != null) {
            File resourceDir = new File(resourceURI.toFileString());
            if (!resourceDir.exists() && !resourceDir.mkdirs()) {
                logger.warn("Cannot create folder {}. ", (Object)resourceDir);
            }
            this.resourceURI = resourceURI;
            if (this.getFixture() != null) {
                this.getFixture().setResources(resourceURI);
            }
        } else {
            throw new PepperTestException("A resource uri must be set.");
        }
    }

    @Test
    public void testSetGetResources() {
        Assert.assertNotNull((String)"Cannot run test, because resources arent set. Please call setResourcesURI(URI resourceURI) before start testing.", (Object)this.resourceURI);
        this.getFixture().setResources(this.resourceURI);
        Assert.assertEquals((Object)this.resourceURI, (Object)this.getFixture().getResources());
    }

    public boolean compareFiles(URI uri1, URI uri2) throws IOException {
        return this.compareFiles(new File(uri1.toFileString()), new File(uri2.toFileString()));
    }

    public boolean compareFiles(File file1, File file2) throws IOException {
        FileComparator comparator = new FileComparator();
        return comparator.compareFiles(file1, file2);
    }
}

