/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.pepper.common;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Properties;
import org.corpus_tools.pepper.common.MEMORY_POLICY;
import org.corpus_tools.pepper.common.PepperUtil;
import org.corpus_tools.pepper.exceptions.PepperConfigurationException;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PepperConfiguration
extends Properties {
    private Logger logger = LoggerFactory.getLogger((String)"Pepper");
    public static final String EMAIL = "saltnpepper@lists.hu-berlin.de";
    public static final String HOMEPAGE = "http://corpus-tools.org/pepper/";
    public static final String DEFAULT_WORKSPACE = "workspace";
    public static final String PROP_PREFIX = "pepper";
    public static final String PROP_COMPUTE_PERFORMANCE = "pepper.computePerformance";
    public static final String PROP_TEMP_FOLDER = "pepper.temporaries";
    public static final String PROP_MAX_AMOUNT_OF_SDOCUMENTS = "pepper.maxAmountOfProcessedSDocuments";
    public static final String PROP_MEMORY_POLICY = "pepper.memPolicy";
    public static final String PROP_CALL_GC_AFTER_DOCUMENT = "pepper.gcAfterDocumentSleep";
    public static final String PROP_KEEP_TEMP_DOCS = "pepper.keepTempDocs";
    public static final String PROP_DETAILED_STATUS_REPORT = "pepper.detailedStatusReport";
    public static final String PROP_WORKSPACE = "pepper.workspace";
    public static final String PROP_REPORT_INTERVAL = "pepper.reportInterval";
    public static final String[] ALL_PROP_NAMES = new String[]{"pepper.computePerformance", "pepper.maxAmountOfProcessedSDocuments"};
    public static final String ENV_PEPPER_MODULE_RESOURCES = "pepper.modules.resources";
    public static final String PROP_PEPPER_MODULE_RESOURCES = "pepper.modules.resources";
    public static final String SOURCES_RESOURCES = "src/main/resources/";
    public static final String FILE_CONF_FOLDER = "conf";
    public static final String FILE_CONF_FILE = "pepper.properties";
    public static final String FILE_CONF_TEST_FILE = "pepper-test.properties";
    private File confFolder = null;

    public PepperConfiguration() {
        this.put(PROP_CALL_GC_AFTER_DOCUMENT, Boolean.TRUE);
        this.put(PROP_MEMORY_POLICY, (Object)MEMORY_POLICY.MODERATE);
        this.put(PROP_MAX_AMOUNT_OF_SDOCUMENTS, (Object)10);
        this.put(PROP_DETAILED_STATUS_REPORT, (Object)true);
    }

    public PepperConfiguration(Properties properties) {
        Enumeration<Object> propNames = properties.keys();
        while (propNames.hasMoreElements()) {
            String propName = propNames.nextElement().toString();
            if (propName == null) continue;
            this.put(propName, properties.getProperty(propName));
        }
    }

    public void load(File configurationFile) {
        this.confFolder = configurationFile.getParentFile();
        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(configurationFile.getAbsolutePath()));){
            this.load(in);
        }
        catch (FileNotFoundException e2) {
            throw new PepperConfigurationException("Cannot load configuration file for Pepper at location '" + configurationFile.getAbsolutePath() + "', because of nested exception: ", e2);
        }
        catch (IOException e) {
            throw new PepperConfigurationException("Cannot load configuration file for Pepper at location '" + configurationFile.getAbsolutePath() + "', because of nested exception: ", e);
        }
    }

    public void load(ComponentContext componentContext) {
        String[] bundleNames;
        if (componentContext == null) {
            throw new PepperConfigurationException("Cannot resolve configuration file for Pepper, because the given component context is null.");
        }
        String configFileStr = null;
        if (componentContext.getBundleContext() != null && componentContext.getBundleContext().getBundle() != null && componentContext.getBundleContext().getBundle().getLocation() != null && (bundleNames = System.getProperty("osgi.bundles").split(",")).length > 0) {
            String currLocation = componentContext.getBundleContext().getBundle().getLocation();
            currLocation = currLocation.replace("initial@reference:file:", "");
            if ((currLocation = currLocation.replace("../", "")).endsWith("/")) {
                currLocation = currLocation.substring(0, currLocation.length() - 1);
            }
            String location = null;
            for (String bundleName : bundleNames) {
                bundleName = bundleName.replace("reference:", "");
                if (!(bundleName = bundleName.replaceAll("@([0-9]+:)?start", "")).endsWith(currLocation)) continue;
                location = bundleName;
                break;
            }
            if (location != null) {
                File confFile;
                if (location.endsWith(".jar")) {
                    location = location.replace(".jar", "/");
                } else {
                    if (!location.endsWith("/")) {
                        location = location + "/";
                    }
                    location = location + SOURCES_RESOURCES;
                }
                configFileStr = location;
                if (configFileStr.startsWith("file:")) {
                    configFileStr = configFileStr.replace("file:", "");
                }
                configFileStr = !(confFile = new File(configFileStr + FILE_CONF_FOLDER + "/" + FILE_CONF_TEST_FILE)).exists() ? configFileStr + FILE_CONF_FOLDER + "/" + FILE_CONF_FILE : configFileStr + FILE_CONF_FOLDER + "/" + FILE_CONF_TEST_FILE;
            }
        }
        if (configFileStr != null) {
            this.load(new File(configFileStr));
        }
    }

    protected void setConfFolder(File confFolder) {
        this.confFolder = confFolder;
    }

    public File getConfFolder() {
        return this.confFolder;
    }

    public File getTempPath() {
        String tmpFolderStr = this.getProperty(PROP_TEMP_FOLDER);
        File tmpFolder = null;
        if (tmpFolderStr != null) {
            tmpFolder = new File(tmpFolderStr = tmpFolderStr + "/pepper/");
            if (!tmpFolder.exists() && !tmpFolder.mkdirs()) {
                this.logger.warn("Cannot create folder {}. ", (Object)tmpFolder);
            }
        } else {
            tmpFolder = PepperUtil.getTempFile();
        }
        return tmpFolder;
    }

    public File getWorkspace() {
        File workspace = null;
        String workspaceStr = this.getProperty(PROP_WORKSPACE);
        if (workspaceStr != null && !workspaceStr.isEmpty()) {
            workspace = new File(workspaceStr);
        }
        if (workspace == null) {
            workspace = new File(this.getTempPath().getAbsolutePath() + "/" + DEFAULT_WORKSPACE);
        }
        return workspace;
    }

    public MEMORY_POLICY getMemPolicy() {
        String memPolicyStr = this.getProperty(PROP_MEMORY_POLICY, MEMORY_POLICY.MODERATE.toString());
        return MEMORY_POLICY.valueOf(memPolicyStr);
    }

    public Integer getMaxAmountOfDocuments() {
        String amountOfDocs = this.getProperty(PROP_MAX_AMOUNT_OF_SDOCUMENTS, "10");
        return Integer.valueOf(amountOfDocs);
    }

    public Boolean getGcAfterDocumentSleep() {
        String callGC = this.getProperty(PROP_CALL_GC_AFTER_DOCUMENT, Boolean.FALSE.toString());
        return Boolean.valueOf(callGC);
    }

    public Boolean getKeepDocuments() {
        String isToKeep = this.getProperty(PROP_KEEP_TEMP_DOCS, Boolean.FALSE.toString());
        return Boolean.valueOf(isToKeep);
    }

    public Integer getReportInterval() {
        String interval = this.getProperty(PROP_REPORT_INTERVAL, "1000");
        return Integer.valueOf(interval);
    }

    public Boolean getDetaialedStatReport() {
        String callGC = this.getProperty(PROP_DETAILED_STATUS_REPORT);
        return Boolean.valueOf(callGC);
    }
}

