/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.salt.util.internal.persistence;

import com.google.common.io.BaseEncoding;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.SerializationUtils;
import org.corpus_tools.salt.SaltFactory;
import org.corpus_tools.salt.common.SCorpusGraph;
import org.corpus_tools.salt.common.SDocumentGraph;
import org.corpus_tools.salt.common.STextualDS;
import org.corpus_tools.salt.common.SToken;
import org.corpus_tools.salt.common.SaltProject;
import org.corpus_tools.salt.core.SAbstractAnnotation;
import org.corpus_tools.salt.core.SLayer;
import org.corpus_tools.salt.core.SNode;
import org.corpus_tools.salt.core.SRelation;
import org.corpus_tools.salt.exceptions.SaltInsertionException;
import org.corpus_tools.salt.exceptions.SaltResourceException;
import org.corpus_tools.salt.graph.IdentifiableElement;
import org.corpus_tools.salt.graph.LabelableElement;
import org.corpus_tools.salt.util.internal.persistence.SaltXML10Dictionary;
import org.eclipse.emf.common.util.URI;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.ext.DefaultHandler2;

public class SaltXML10Handler
extends DefaultHandler2
implements SaltXML10Dictionary {
    private final List<Object> rootObjects = new LinkedList<Object>();
    private static final Pattern RELATION_REF = Pattern.compile("/[0-9]*/@((sCorpusGraphs)|(nodes))\\.(?<nr>[0-9]+)");
    private static final Pattern LAYER_REF = Pattern.compile("/[0-9]*/@layers\\.");
    private Stack<Object> currentContainer = null;
    private SaltProject saltProject = null;
    private List<SNode> nodes = new ArrayList<SNode>();
    private List<SRelation<SNode, SNode>> relations = new ArrayList<SRelation<SNode, SNode>>();
    private Map<String, SLayer> layers = new HashMap<String, SLayer>();
    private Integer layerIdx = 0;

    public SaltXML10Handler() {
        this.currentContainer = new Stack();
    }

    private void addObject(Object object) {
        if (this.currentContainer.isEmpty()) {
            this.rootObjects.add(object);
            this.nodes.clear();
            this.relations.clear();
            this.layers.clear();
            this.layerIdx = 0;
            this.saltProject = null;
        }
        this.currentContainer.push(object);
    }

    public Object getSaltObject() {
        if (this.rootObjects.isEmpty()) {
            return null;
        }
        return this.rootObjects.get(0);
    }

    public List<Object> getRootObjects() {
        return Collections.unmodifiableList(this.rootObjects);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if ("saltCommon:SaltProject".equals(qName)) {
            SaltProject project = SaltFactory.createSaltProject();
            String sName = attributes.getValue("sName");
            if (sName != null) {
                project.setName(sName);
            }
            this.addObject(project);
            this.saltProject = project;
        } else if ("sCorpusGraphs".equals(qName)) {
            SCorpusGraph graph = SaltFactory.createSCorpusGraph();
            this.addObject(graph);
            if (this.saltProject != null) {
                this.saltProject.addCorpusGraph(graph);
            }
        } else if ("sDocumentStructure:SDocumentGraph".equals(qName)) {
            SDocumentGraph graph = SaltFactory.createSDocumentGraph();
            this.addObject(graph);
        } else if ("nodes".equals(qName)) {
            String[] layerNums;
            String layersStr;
            SNode sNode = null;
            String type = attributes.getValue("xsi:type");
            if ("sDocumentStructure:SAudioDS".equals(type)) {
                sNode = SaltFactory.createSMedialDS();
            } else if ("sDocumentStructure:STextualDS".equals(type)) {
                sNode = SaltFactory.createSTextualDS();
            } else if ("sDocumentStructure:STimeline".equals(type)) {
                sNode = SaltFactory.createSTimeline();
            } else if ("sDocumentStructure:SToken".equals(type)) {
                sNode = SaltFactory.createSToken();
            } else if ("sDocumentStructure:SSpan".equals(type)) {
                sNode = SaltFactory.createSSpan();
            } else if ("sDocumentStructure:SStructure".equals(type)) {
                sNode = SaltFactory.createSStructure();
            } else if ("sCorpusStructure:SCorpus".equals(type)) {
                sNode = SaltFactory.createSCorpus();
            } else if ("sCorpusStructure:SDocument".equals(type)) {
                sNode = SaltFactory.createSDocument();
            }
            if (sNode != null) {
                this.addObject(sNode);
                this.nodes.add(sNode);
            }
            if ((layersStr = attributes.getValue("layers")) != null && (layerNums = (layersStr = LAYER_REF.matcher(layersStr).replaceAll("")).split(" ")).length > 0) {
                for (String layerNum : layerNums) {
                    SLayer layer = this.layers.get(layerNum);
                    if (layer == null) {
                        layer = SaltFactory.createSLayer();
                        this.layers.put(layerNum, layer);
                    }
                    sNode.addLayer(layer);
                }
            }
        } else if ("edges".equals(qName)) {
            String[] layerNums;
            String layersStr;
            SRelation<SToken, STextualDS> sRel = null;
            String type = attributes.getValue("xsi:type");
            String source = attributes.getValue("source");
            String target = attributes.getValue("target");
            if ("sDocumentStructure:STextualRelation".equals(type)) {
                sRel = SaltFactory.createSTextualRelation();
            } else if ("sDocumentStructure:SAudioRelation".equals(type)) {
                sRel = SaltFactory.createSMedialRelation();
            } else if ("sDocumentStructure:STimelineRelation".equals(type)) {
                sRel = SaltFactory.createSTimelineRelation();
            } else if ("sDocumentStructure:SSpanningRelation".equals(type)) {
                sRel = SaltFactory.createSSpanningRelation();
            } else if ("sDocumentStructure:SOrderRelation".equals(type)) {
                sRel = SaltFactory.createSOrderRelation();
            } else if ("sDocumentStructure:SDominanceRelation".equals(type)) {
                sRel = SaltFactory.createSDominanceRelation();
            } else if ("sDocumentStructure:SPointingRelation".equals(type)) {
                sRel = SaltFactory.createSPointingRelation();
            } else if ("sCorpusStructure:SCorpusRelation".equals(type)) {
                sRel = SaltFactory.createSCorpusRelation();
            } else if ("sCorpusStructure:SCorpusDocumentRelation".equals(type)) {
                sRel = SaltFactory.createSCorpusDocumentRelation();
            }
            if (sRel != null && target != null && source != null) {
                Matcher matcherSource = RELATION_REF.matcher(source);
                if (!matcherSource.matches()) {
                    throw new SaltResourceException("Invalid source reference \"" + source + "\" for relation");
                }
                Matcher matcherTarget = RELATION_REF.matcher(target);
                if (!matcherTarget.matches()) {
                    throw new SaltResourceException("Invalid target reference \"" + target + "\" for relation");
                }
                Integer sourceIdx = Integer.parseInt(matcherSource.group("nr"));
                Integer targetIdx = Integer.parseInt(matcherTarget.group("nr"));
                if (sourceIdx >= this.nodes.size()) {
                    throw new SaltResourceException("Cannot find a source node '" + source + "' for relation. ");
                }
                if (targetIdx >= this.nodes.size()) {
                    throw new SaltResourceException("Cannot find a target node '" + target + "' for relation. ");
                }
                SNode sourceNode = this.nodes.get(sourceIdx);
                SNode targetNode = this.nodes.get(targetIdx);
                if (sourceNode == null) {
                    throw new SaltResourceException("Cannot find a source node '" + source + "' for relation. ");
                }
                if (targetNode == null) {
                    throw new SaltResourceException("Cannot find a target node '" + target + "' for relation. ");
                }
                this.addObject(sRel);
                sRel.setSource((SToken)sourceNode);
                sRel.setTarget((STextualDS)targetNode);
                this.relations.add(sRel);
            }
            if ((layersStr = attributes.getValue("layers")) != null && (layerNums = (layersStr = LAYER_REF.matcher(layersStr).replaceAll("")).split(" ")).length > 0) {
                for (String layerNum : layerNums) {
                    SLayer layer = this.layers.get(layerNum);
                    if (layer == null) {
                        layer = SaltFactory.createSLayer();
                        this.layers.put(layerNum, layer);
                    }
                    sRel.addLayer(layer);
                }
            }
        } else if ("labels".equals(qName)) {
            SAbstractAnnotation label = null;
            String type = attributes.getValue("xsi:type");
            String ns = attributes.getValue("namespace");
            if ("saltCommon".equals(ns)) {
                ns = "salt";
            }
            String name = attributes.getValue("name");
            String value = attributes.getValue("valueString");
            if (value == null) {
                value = attributes.getValue("value");
            }
            if ("saltCore:SElementId".equals(type)) {
                if (!this.currentContainer.isEmpty() && this.currentContainer.peek() instanceof IdentifiableElement) {
                    ((IdentifiableElement)this.currentContainer.peek()).setId((String)this.createObjectFromString(value));
                }
                this.currentContainer.push("SElementId");
            } else {
                label = "saltCore:SFeature".equals(type) ? SaltFactory.createSFeature() : ("saltCore:SAnnotation".equals(type) ? SaltFactory.createSAnnotation() : ("saltCore:SMetaAnnotation".equals(type) ? SaltFactory.createSMetaAnnotation() : ("saltCore:SProcessingAnnotation".equals(type) ? SaltFactory.createSProcessingAnnotation() : ("saltSemantics:SPOSAnnotation".equals(type) ? SaltFactory.createSPOSAnnotation() : ("saltSemantics:SLemmaAnnotation".equals(type) ? SaltFactory.createSLemmaAnnotation() : ("saltSemantics:SCatAnnotation".equals(type) ? SaltFactory.createSCatAnnotation() : ("saltSemantics:SentenceAnnotation".equals(type) ? SaltFactory.createSSentenceAnnotation() : ("saltSemantics:SWordAnnotation".equals(type) ? SaltFactory.createSWordAnnotation() : ("saltSemantics:STypeAnnotation".equals(type) ? SaltFactory.createSTypeAnnotation() : SaltFactory.createSAnnotation())))))))));
            }
            if (label != null) {
                label.setNamespace(ns);
                label.setName(name);
                label.setValue(this.createObjectFromString(value));
                if (!this.currentContainer.isEmpty() && this.currentContainer.peek() != null) {
                    try {
                        Object container = this.currentContainer.peek();
                        if (container instanceof LabelableElement) {
                            ((LabelableElement)container).addLabel(label);
                        }
                    }
                    catch (SaltInsertionException saltInsertionException) {
                        // empty catch block
                    }
                }
                this.addObject(label);
            }
        } else if ("layers".equals(qName)) {
            SLayer layer = this.layers.get(this.layerIdx.toString());
            if (layer == null) {
                layer = SaltFactory.createSLayer();
            }
            if (this.currentContainer.peek() instanceof SDocumentGraph) {
                ((SDocumentGraph)this.currentContainer.peek()).addLayer(layer);
            }
            this.currentContainer.push(layer);
            Integer n = this.layerIdx;
            Integer n2 = this.layerIdx = Integer.valueOf(this.layerIdx + 1);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (!this.currentContainer.isEmpty()) {
            Object obj = this.currentContainer.pop();
            Object parent = null;
            if (!this.currentContainer.isEmpty()) {
                parent = this.currentContainer.peek();
            }
            if ("nodes".equals(qName)) {
                if (parent != null) {
                    if (parent instanceof SDocumentGraph) {
                        ((SDocumentGraph)this.currentContainer.peek()).addNode((SNode)obj);
                    } else if (parent instanceof SCorpusGraph) {
                        ((SCorpusGraph)this.currentContainer.peek()).addNode((SNode)obj);
                    }
                }
            } else if ("edges".equals(qName) && parent != null) {
                if (parent instanceof SDocumentGraph) {
                    ((SDocumentGraph)this.currentContainer.peek()).addRelation((SRelation)obj);
                } else if (parent instanceof SCorpusGraph) {
                    ((SCorpusGraph)this.currentContainer.peek()).addRelation((SRelation)obj);
                }
            }
        }
    }

    public Object createObjectFromString(String value) {
        Object retVal = null;
        if (value != null && value.length() >= 3) {
            if (value.startsWith("T")) {
                retVal = value.substring(3);
            } else if (value.startsWith("B")) {
                retVal = Boolean.parseBoolean(value.substring(3));
            } else if (value.startsWith("N")) {
                try {
                    retVal = Integer.parseInt(value.substring(3));
                }
                catch (NumberFormatException e) {
                    retVal = Long.parseLong(value.substring(3));
                }
            } else if (value.startsWith("F")) {
                retVal = Double.parseDouble(value.substring(3));
            } else if (value.startsWith("U")) {
                retVal = URI.createURI((String)value.substring(3));
            } else if (value.startsWith("O")) {
                byte[] rawBytes = BaseEncoding.base64().decode((CharSequence)value.substring(3));
                retVal = SerializationUtils.deserialize((byte[])rawBytes);
            }
        }
        return retVal;
    }
}

