/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.salt.common.impl;

import org.corpus_tools.salt.SaltFactory;
import org.corpus_tools.salt.common.SCorpusGraph;
import org.corpus_tools.salt.common.SDocument;
import org.corpus_tools.salt.common.SDocumentGraph;
import org.corpus_tools.salt.common.impl.SDocumentGraphImpl;
import org.corpus_tools.salt.core.SFeature;
import org.corpus_tools.salt.core.SGraph;
import org.corpus_tools.salt.core.impl.SNodeImpl;
import org.corpus_tools.salt.exceptions.SaltInvalidModelException;
import org.corpus_tools.salt.graph.Identifier;
import org.corpus_tools.salt.graph.Node;
import org.corpus_tools.salt.util.SaltUtil;
import org.eclipse.emf.common.util.URI;

public class SDocumentImpl
extends SNodeImpl
implements SDocument {
    public SDocumentImpl() {
    }

    public SDocumentImpl(Node delegate) {
        super(delegate);
    }

    @Override
    public SDocumentGraph getDocumentGraph() {
        SDocumentGraph retVal = null;
        SFeature sFeature = this.getFeature("salt::SDOCUMENT_GRAPH");
        if (sFeature != null) {
            retVal = (SDocumentGraph)sFeature.getValue();
        }
        return retVal;
    }

    @Override
    public void setDocumentGraph(SDocumentGraph documentGraph) {
        SDocumentGraph oldDocumentGraph = this.getDocumentGraph();
        if (oldDocumentGraph != null && oldDocumentGraph != documentGraph && oldDocumentGraph instanceof SDocumentGraphImpl) {
            ((SDocumentGraphImpl)oldDocumentGraph).basic_setDocument(null);
        }
        if (documentGraph != null && documentGraph instanceof SDocumentGraphImpl) {
            ((SDocumentGraphImpl)documentGraph).basic_setDocument(this);
        }
        this.basic_setDocumentGraph(documentGraph);
    }

    public void basic_setDocumentGraph(SDocumentGraph documentGraph) {
        SFeature sFeature = this.getFeature("salt::SDOCUMENT_GRAPH");
        if (sFeature == null) {
            sFeature = SaltFactory.createSFeature();
            sFeature.setNamespace("salt");
            sFeature.setName("SDOCUMENT_GRAPH");
            this.addFeature(sFeature);
        }
        sFeature.setValue(documentGraph);
        if (this.getId() != null && !this.getId().isEmpty()) {
            SaltFactory.createIdentifier(documentGraph, this.getId());
        }
    }

    @Override
    public void setId(String id) {
        super.setId(id);
        if (this.getDocumentGraph() != null && this.getId() != null && !this.getId().isEmpty()) {
            SaltFactory.createIdentifier(this.getDocumentGraph(), this.getId());
        }
    }

    @Override
    public void setIdentifier(Identifier identifier) {
        super.setIdentifier(identifier);
        if (this.getDocumentGraph() != null && this.getId() != null && !this.getId().isEmpty()) {
            SaltFactory.createIdentifier(this.getDocumentGraph(), this.getId());
        }
    }

    @Override
    public URI getDocumentGraphLocation() {
        URI retVal = null;
        String name = "salt::SDOCUMENT_GRAPH_LOCATION";
        SFeature sFeature = this.getFeature(name);
        if (sFeature != null) {
            Object obj = sFeature.getValue();
            retVal = obj instanceof URI ? (URI)obj : URI.createURI((String)obj.toString());
        }
        return retVal;
    }

    @Override
    public void setDocumentGraphLocation(URI location) {
        String name = "salt::SDOCUMENT_GRAPH_LOCATION";
        SFeature sFeature = this.getFeature(name);
        if (sFeature == null) {
            sFeature = SaltFactory.createSFeature();
            sFeature.setNamespace("salt");
            sFeature.setName("SDOCUMENT_GRAPH_LOCATION");
            sFeature.setValue(location);
            this.addFeature(sFeature);
        }
        sFeature.setValue(location.toString());
    }

    @Override
    public void saveDocumentGraph(URI documentGraphLocation) {
        SaltUtil.saveDocumentGraph(this.getDocumentGraph(), documentGraphLocation);
        this.setDocumentGraph(null);
        this.setDocumentGraphLocation(documentGraphLocation);
    }

    @Override
    public void loadDocumentGraph() {
        this.loadDocumentGraph(this.getDocumentGraphLocation());
    }

    @Override
    public void loadDocumentGraph(URI documentGraphLocation) {
        SDocumentGraph sDocumentGraph = SaltUtil.loadDocumentGraph(documentGraphLocation);
        this.setDocumentGraph(sDocumentGraph);
    }

    @Override
    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append(this.getClass().getSimpleName());
        str.append("(");
        str.append(this.getId());
        str.append(")");
        return str.toString();
    }

    @Override
    public SCorpusGraph getGraph() {
        SGraph superGraph = super.getGraph();
        if (superGraph == null) {
            return null;
        }
        if (superGraph instanceof SCorpusGraph) {
            return (SCorpusGraph)superGraph;
        }
        throw new SaltInvalidModelException("Graph implementation is not of type SCorpusGraph (actual type is " + superGraph.getClass().getName() + ")");
    }
}

