/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.pepper.connectors.impl;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.filefilter.SuffixFileFilter;
import org.corpus_tools.pepper.cli.PepperStarter;
import org.corpus_tools.pepper.cli.PepperStarterConfiguration;
import org.corpus_tools.pepper.cli.exceptions.PepperOSGiException;
import org.corpus_tools.pepper.cli.exceptions.PepperOSGiFrameworkPluginException;
import org.corpus_tools.pepper.cli.exceptions.PepperPropertyException;
import org.corpus_tools.pepper.common.Pepper;
import org.corpus_tools.pepper.common.PepperConfiguration;
import org.corpus_tools.pepper.common.PepperJob;
import org.corpus_tools.pepper.common.PepperModuleDesc;
import org.corpus_tools.pepper.connectors.PepperConnector;
import org.corpus_tools.pepper.connectors.impl.MavenAccessor;
import org.corpus_tools.pepper.exceptions.JobNotFoundException;
import org.corpus_tools.pepper.exceptions.PepperConfigurationException;
import org.corpus_tools.pepper.exceptions.PepperException;
import org.corpus_tools.pepper.exceptions.PepperFWException;
import org.corpus_tools.pepper.modules.PepperModuleProperties;
import org.corpus_tools.pepper.util.XMLStreamWriter;
import org.eclipse.core.runtime.adaptor.EclipseStarter;
import org.eclipse.emf.common.util.URI;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.launch.Framework;
import org.osgi.framework.launch.FrameworkFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PepperOSGiConnector
implements Pepper,
PepperConnector {
    private static final Logger logger = LoggerFactory.getLogger(PepperOSGiConnector.class);
    private static final String ARTIFACT_ID_PEPPER_FRAMEWORK = "pepper-framework";
    private String frameworkVersion = null;
    private MavenAccessor maven = null;
    private boolean isInit = false;
    private Map<String, String> frameworkProperties = null;
    private PepperStarterConfiguration properties = null;
    private Pepper pepper = null;
    private BundleContext bundleContext = null;
    public static final String PROP_OSGI_BUNDLES = "osgi.bundles";
    private Map<Long, Bundle> bundleIdMap = new Hashtable<Long, Bundle>();
    private BiMap<java.net.URI, Long> locationBundleIdMap = HashBiMap.create();

    @Override
    public boolean isInitialized() {
        return this.isInit;
    }

    @Override
    public void init() {
        if (this.getPepperStarterConfiguration().getPlugInPath() == null) {
            throw new PepperPropertyException("Cannot start Pepper, because no plugin path is given for Pepper modules.");
        }
        File pluginPath = new File(this.getPepperStarterConfiguration().getPlugInPath());
        if (!pluginPath.exists()) {
            throw new PepperOSGiException("Cannot load any plugins, since the configured path for plugins '" + pluginPath.getAbsolutePath() + "' does not exist. Please check the entry '" + "pepper.plugin.path" + "' in the Pepper configuration file at '" + this.getConfiguration().getConfFolder().getAbsolutePath() + "'. ");
        }
        try {
            System.setProperty("org.corpus_tools.pepper.disableTest", Boolean.TRUE.toString());
            this.setBundleContext(this.startEquinox());
        }
        catch (Exception e) {
            throw new PepperOSGiException("The OSGi environment could not have been started: " + e.getMessage(), e);
        }
        try {
            logger.debug("plugin path:\t\t" + this.getPepperStarterConfiguration().getPlugInPath());
            logger.debug("installing OSGI-bundles...");
            logger.debug("-------------------- installing bundles --------------------");
            Collection<Bundle> bundles = null;
            ArrayList<java.net.URI> dropInURIs = null;
            List<String> dropInRawStrings = this.getPepperStarterConfiguration().getDropInPaths();
            if (dropInRawStrings != null) {
                dropInURIs = new ArrayList<java.net.URI>(dropInRawStrings.size());
                for (String path : dropInRawStrings) {
                    dropInURIs.add(new File(path).toURI());
                }
            }
            logger.debug("\tinstalling OSGI-bundles:");
            bundles = this.installBundles(new File(this.getPepperStarterConfiguration().getPlugInPath()).toURI(), dropInURIs);
            logger.debug("----------------------------------------------------------");
            logger.debug("installing OSGI-bundles...FINISHED");
            logger.debug("starting OSGI-bundles...");
            logger.debug("-------------------- starting bundles --------------------");
            if (bundles == null || bundles.isEmpty()) {
                bundles = new ArrayList<Bundle>();
                this.bundleIdMap = new Hashtable<Long, Bundle>();
                for (Bundle bundle : this.getBundleContext().getBundles()) {
                    bundles.add(bundle);
                    this.bundleIdMap.put(bundle.getBundleId(), bundle);
                }
            }
            this.startBundles(bundles);
            logger.debug("----------------------------------------------------------");
            logger.debug("starting OSGI-bundles...FINISHED");
        }
        catch (PepperException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PepperOSGiException("An exception occured installing bundles for OSGi environment. ", e);
        }
        ArrayList<Bundle> bList = new ArrayList<Bundle>();
        bList.addAll(this.bundleIdMap.values());
        for (int i = 0; i < bList.size(); ++i) {
            if (((Bundle)bList.get(i)).getSymbolicName() == null || !((Bundle)bList.get(i)).getSymbolicName().contains(ARTIFACT_ID_PEPPER_FRAMEWORK)) continue;
            this.frameworkVersion = ((Bundle)bList.get(i)).getVersion().toString().replace(".SNAPSHOT", "-SNAPSHOT");
        }
        this.maven = new MavenAccessor(this);
        this.isInit = true;
    }

    protected BundleContext startEquinox() throws Exception {
        BundleContext bc = null;
        this.frameworkProperties = new HashMap<String, String>();
        this.frameworkProperties.put("org.osgi.framework.system.packages.extra", this.getSharedPackages());
        this.frameworkProperties.put("osgi.clean", "true");
        this.frameworkProperties.put("osgi.console", "true");
        this.frameworkProperties.put("osgi.noShutdown", "true");
        this.frameworkProperties.put("osgi.install.area", this.getConfiguration().getTempPath().getCanonicalPath());
        FrameworkFactory frameworkFactory = ServiceLoader.load(FrameworkFactory.class).iterator().next();
        Framework oSGiframework = frameworkFactory.newFramework(this.frameworkProperties);
        oSGiframework.start();
        bc = oSGiframework.getBundleContext();
        return bc;
    }

    public void stopOSGi() throws Exception {
        EclipseStarter.shutdown();
    }

    public PepperConfiguration getConfiguration() {
        return this.properties;
    }

    public PepperStarterConfiguration getPepperStarterConfiguration() {
        return this.properties;
    }

    public void setConfiguration(PepperConfiguration configuration) {
        if (!(configuration instanceof PepperStarterConfiguration)) {
            throw new PepperConfigurationException("Cannot set the given configuration, since it is not of type '" + PepperStarterConfiguration.class.getSimpleName() + "'.");
        }
        this.properties = (PepperStarterConfiguration)configuration;
    }

    protected Pepper getPepper() {
        if (this.pepper == null) {
            try {
                ServiceReference<?> serviceReference = this.getBundleContext().getServiceReference(Pepper.class.getName());
                Pepper pepperOSGi = null;
                if (serviceReference != null) {
                    try {
                        pepperOSGi = (Pepper)this.getBundleContext().getService(serviceReference);
                    }
                    catch (ClassCastException e) {
                        pepperOSGi = (Pepper)this.getBundleContext().getService(serviceReference);
                    }
                } else {
                    throw new PepperFWException("The pepper-framework was not found in OSGi environment. Searching for class: " + Pepper.class.getName() + " brought no result. May be the container package is not listed in property '" + "org.osgi.framework.system.packages.extra" + "': '" + this.frameworkProperties + "'. ");
                }
                this.pepper = pepperOSGi;
                this.pepper.setConfiguration(this.getConfiguration());
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        return this.pepper;
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    protected String getSharedPackages() {
        StringBuilder retVal = new StringBuilder();
        String sharedPackages = this.getPepperStarterConfiguration().getSharedPackages();
        if (sharedPackages != null && !sharedPackages.isEmpty()) {
            retVal.append(sharedPackages);
        } else {
            retVal.append(Pepper.class.getPackage().getName());
            retVal.append(";version=");
            retVal.append(PepperStarter.getVersion().replace("-", "."));
            retVal.append(", ");
            retVal.append(PepperException.class.getPackage().getName());
            retVal.append(";version=");
            retVal.append(PepperStarter.getVersion().replace("-", "."));
            retVal.append(", ");
            retVal.append(PepperModuleProperties.class.getPackage().getName());
            retVal.append(";version=");
            retVal.append(PepperStarter.getVersion().replace("-", "."));
            retVal.append(", ");
            retVal.append(XMLStreamWriter.class.getPackage().getName());
            retVal.append(", ");
            retVal.append(URI.class.getPackage().getName());
        }
        return retVal.toString();
    }

    protected Collection<Bundle> installBundles(java.net.URI pluginPath, List<java.net.URI> dropinPaths) throws BundleException, URISyntaxException, IOException {
        ArrayList<Bundle> bundles = new ArrayList<Bundle>();
        LinkedList<java.net.URI> loadLocations = new LinkedList<java.net.URI>();
        if (dropinPaths != null) {
            loadLocations.addAll(dropinPaths);
        }
        loadLocations.add(pluginPath);
        StringBuilder osgiBundlesProp = null;
        for (java.net.URI dropinLocation : loadLocations) {
            File[] fileLocations = new File(dropinLocation.getPath()).listFiles((FilenameFilter)new SuffixFileFilter(".jar"));
            if (fileLocations == null) continue;
            for (File bundleJar : fileLocations) {
                java.net.URI bundleURI;
                Bundle bundle;
                if (!bundleJar.isFile() || !bundleJar.canRead() || (bundle = this.install(bundleURI = bundleJar.toURI())) == null) continue;
                bundles.add(bundle);
                logger.debug("\t\tinstalling bundle: " + bundle.getSymbolicName() + "-" + bundle.getVersion());
                if (osgiBundlesProp == null) {
                    osgiBundlesProp = new StringBuilder();
                }
                osgiBundlesProp.append("reference:");
                osgiBundlesProp.append(bundleURI);
                osgiBundlesProp.append(",");
            }
        }
        if (System.getProperty(PROP_OSGI_BUNDLES) == null || System.getProperty(PROP_OSGI_BUNDLES).isEmpty()) {
            System.setProperty(PROP_OSGI_BUNDLES, osgiBundlesProp.toString());
        }
        return bundles;
    }

    public Long getBundleId(java.net.URI location) {
        if (location != null) {
            return (Long)this.locationBundleIdMap.get((Object)location);
        }
        return null;
    }

    public Bundle installAndCopy(java.net.URI bundleURI) throws BundleException, IOException {
        String pluginPath;
        Bundle retVal = null;
        if (bundleURI != null && (pluginPath = this.getPepperStarterConfiguration().getPlugInPath()) != null) {
            Serializable bundleUrl;
            if ("http".equalsIgnoreCase(bundleURI.getScheme()) || "https".equalsIgnoreCase(bundleURI.getScheme())) {
                String tempPath = this.getPepperStarterConfiguration().getTempPath().getCanonicalPath();
                bundleUrl = bundleURI.toURL();
                if (!tempPath.endsWith("/")) {
                    tempPath = tempPath + "/";
                }
                String baseName = FilenameUtils.getBaseName((String)((URL)bundleUrl).toString());
                String extension = FilenameUtils.getExtension((String)((URL)bundleUrl).toString());
                File bundleFile = new File(tempPath + baseName + "." + extension);
                FileUtils.copyURLToFile((URL)bundleURI.toURL(), (File)bundleFile);
                bundleURI = java.net.URI.create(bundleFile.getAbsolutePath());
            }
            if (bundleURI.getPath().endsWith("zip")) {
                ZipFile zipFile = new ZipFile(bundleURI.getPath());
                bundleUrl = null;
                try {
                    Enumeration<? extends ZipEntry> entries = zipFile.entries();
                    while (entries.hasMoreElements()) {
                        ZipEntry entry = entries.nextElement();
                        File entryDestination = new File(pluginPath, entry.getName());
                        if (!entryDestination.getParentFile().exists() && !entryDestination.getParentFile().mkdirs()) {
                            logger.warn("Cannot create folder '" + entryDestination.getParentFile() + "'. ");
                        }
                        if (entry.isDirectory()) {
                            if (entryDestination.getParentFile().exists() || entryDestination.getParentFile().mkdirs()) continue;
                            logger.warn("Cannot create folder {}. ", (Object)entryDestination.getParentFile());
                            continue;
                        }
                        InputStream in = zipFile.getInputStream(entry);
                        FileOutputStream out = new FileOutputStream(entryDestination);
                        IOUtils.copy((InputStream)in, (OutputStream)out);
                        IOUtils.closeQuietly((InputStream)in);
                        IOUtils.closeQuietly((OutputStream)out);
                        if (!entryDestination.getName().endsWith(".jar")) continue;
                        retVal = this.install(entryDestination.toURI());
                    }
                }
                catch (Throwable throwable) {
                    bundleUrl = throwable;
                    throw throwable;
                }
                finally {
                    if (zipFile != null) {
                        if (bundleUrl != null) {
                            try {
                                zipFile.close();
                            }
                            catch (Throwable x2) {
                                ((Throwable)bundleUrl).addSuppressed(x2);
                            }
                        } else {
                            zipFile.close();
                        }
                    }
                }
            } else if (bundleURI.getPath().endsWith("jar")) {
                File bundleFile = new File(bundleURI.getPath());
                File jarFile = new File(pluginPath, bundleFile.getName());
                FileUtils.copyFile((File)bundleFile, (File)jarFile);
                retVal = this.install(jarFile.toURI());
            }
        }
        return retVal;
    }

    public Bundle install(java.net.URI bundleURI) throws BundleException {
        Bundle bundle = null;
        try {
            bundle = this.getBundleContext().installBundle(bundleURI.toString());
        }
        catch (BundleException e) {
            return null;
        }
        this.bundleIdMap.put(bundle.getBundleId(), bundle);
        String osgiBundleProp = System.getProperty(PROP_OSGI_BUNDLES);
        osgiBundleProp = osgiBundleProp == null ? "" : osgiBundleProp + ",";
        osgiBundleProp = osgiBundleProp + "reference:" + bundleURI;
        System.setProperty(PROP_OSGI_BUNDLES, osgiBundleProp);
        this.locationBundleIdMap.put((Object)bundleURI, (Object)bundle.getBundleId());
        return bundle;
    }

    public void uninstall(Long bundleId) throws BundleException {
        Bundle bundle = this.getBundleContext().getBundle(bundleId);
        bundle.uninstall();
    }

    public void uninstall(java.net.URI location) throws BundleException {
        Long bundleId;
        if (location != null && (bundleId = (Long)this.locationBundleIdMap.get((Object)location)) != null) {
            Bundle bundle = this.getBundleContext().getBundle(bundleId);
            bundle.uninstall();
        }
    }

    public boolean remove(String bundleName) throws BundleException, IOException {
        boolean retVal = false;
        if (bundleName != null && !bundleName.isEmpty()) {
            block0: for (Bundle bundle : this.getBundleContext().getBundles()) {
                if (bundle.getSymbolicName() == null || !bundle.getSymbolicName().equalsIgnoreCase(bundleName)) continue;
                for (Map.Entry entry : this.locationBundleIdMap.entrySet()) {
                    if (!((Long)entry.getValue()).equals(bundle.getBundleId())) continue;
                    bundle.stop();
                    bundle.uninstall();
                    File fileToRemove = new File(((java.net.URI)entry.getKey()).getPath());
                    retVal = fileToRemove.delete();
                    File[] files = new File(this.getPepperStarterConfiguration().getPlugInPath()).listFiles();
                    if (files == null) break block0;
                    for (File file : files) {
                        if (!file.getName().startsWith(fileToRemove.getName().replace(".jar", "")) || !file.isDirectory()) continue;
                        FileUtils.deleteDirectory((File)file);
                    }
                    break block0;
                }
                break;
            }
        }
        return retVal;
    }

    public void start(Long bundleId) {
        Bundle bundle = this.bundleIdMap.get(bundleId);
        logger.debug("\t\tstarting bundle: " + bundle.getSymbolicName() + "-" + bundle.getVersion());
        if (bundle.getState() != 32) {
            try {
                bundle.start();
            }
            catch (BundleException e) {
                logger.warn("The bundle '" + bundle.getSymbolicName() + "-" + bundle.getVersion() + "' wasn't started correctly. The bundle is located at '" + this.locationBundleIdMap.inverse().get((Object)bundleId) + "'. This could cause other problems. For more details turn on log mode to debug and see log file. ", (Throwable)e);
            }
        }
        if (bundle.getState() != 32) {
            logger.error("The bundle '" + bundle.getSymbolicName() + "-" + bundle.getVersion() + "' wasn't started correctly.");
        }
    }

    protected void startBundles(Collection<Bundle> bundles) throws BundleException {
        if (bundles != null) {
            Bundle pepperBundle = null;
            for (Bundle bundle : bundles) {
                if ("org.corpus-tools.pepper-framework".equalsIgnoreCase(bundle.getSymbolicName())) {
                    pepperBundle = bundle;
                    continue;
                }
                this.start(bundle.getBundleId());
            }
            try {
                if (pepperBundle != null) {
                    pepperBundle.start();
                }
            }
            catch (BundleException e) {
                throw new PepperOSGiFrameworkPluginException("The Pepper framework bundle could not have been started. Unfortunatly Pepper cannot be started without that OSGi bundle. ", e);
            }
        }
    }

    public String createJob() {
        if (this.getPepper() == null) {
            throw new PepperException("We are sorry, but no Pepper has been resolved in OSGi environment. ");
        }
        return this.getPepper().createJob();
    }

    public PepperJob getJob(String id) throws JobNotFoundException {
        if (this.getPepper() == null) {
            throw new PepperException("We are sorry, but no Pepper has been resolved in OSGi environment. ");
        }
        return this.getPepper().getJob(id);
    }

    public boolean removeJob(String id) throws JobNotFoundException {
        if (this.getPepper() == null) {
            throw new PepperException("We are sorry, but no Pepper has been resolved in OSGi environment. ");
        }
        return this.getPepper().removeJob(id);
    }

    public Collection<PepperModuleDesc> getRegisteredModules() {
        if (this.getPepper() == null) {
            throw new PepperException("We are sorry, but no Pepper has been resolved in OSGi environment. ");
        }
        return this.getPepper().getRegisteredModules();
    }

    public String getRegisteredModulesAsString() {
        if (this.getPepper() == null) {
            throw new PepperException("We are sorry, but no Pepper has been resolved in OSGi environment. ");
        }
        return this.getPepper().getRegisteredModulesAsString();
    }

    public Collection<String> selfTest() {
        if (this.getPepper() == null) {
            throw new PepperException("We are sorry, but no Pepper has been resolved in OSGi environment. ");
        }
        return this.getPepper().selfTest();
    }

    public boolean update(String groupId, String artifactId, String repositoryUrl, boolean isSnapshot, boolean ignoreFrameworkVersion) {
        return this.maven.update(groupId, artifactId, repositoryUrl, isSnapshot, ignoreFrameworkVersion, this.getBundle(groupId, artifactId, null));
    }

    public String getFrameworkVersion() {
        return this.frameworkVersion;
    }

    public String getBlacklist() {
        return this.maven.getBlacklist();
    }

    private String getBundleNameByDependency(String groupId, String artifactId, String version) {
        String symName = null;
        boolean ignoreVersion = version == null;
        for (Bundle bundle : this.bundleIdMap.values()) {
            symName = bundle.getSymbolicName();
            if (symName == null || !symName.contains(groupId) && !groupId.contains(symName) || !symName.contains(artifactId) && !artifactId.contains(symName) || !ignoreVersion && !version.contains(bundle.getVersion().toString()) && !bundle.getVersion().toString().contains(version)) continue;
            return bundle.toString();
        }
        return null;
    }

    public Bundle getBundle(String groupId, String artifactId, String version) {
        String bundleName = this.getBundleNameByDependency(groupId, artifactId, version);
        for (Bundle bundle : this.bundleIdMap.values()) {
            if (bundleName == null || bundle == null || !bundleName.equals(bundle.toString())) continue;
            return bundle;
        }
        return null;
    }

    public boolean isSingleton(Bundle bundle) {
        return bundle.getHeaders().get("Bundle-SymbolicName").contains("singleton:=true");
    }

    public String printDependencies(String bundleId) {
        String result = this.maven.printDependencies(this.bundleIdMap.get(Long.parseLong(bundleId)));
        return result == null ? "Could not compute dependencies for bundle #".concat(bundleId).concat(System.lineSeparator()) : result;
    }

    public String printDependencies(String groupId, String artifactId, String version, String repositoryUrl) {
        String result = this.maven.printDependencies(groupId, artifactId, version, repositoryUrl);
        return result == null ? "Could not compute dependencies for given coordinates".concat(System.lineSeparator()) : result;
    }

    public Double isImportable(URI corpusPath, PepperModuleDesc description) {
        if (this.getPepper() == null) {
            throw new PepperException("We are sorry, but no Pepper has been resolved in OSGi environment. ");
        }
        return this.getPepper().isImportable(corpusPath, description);
    }
}

