/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.pepper.testFramework;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import org.corpus_tools.pepper.common.CorpusDesc;
import org.corpus_tools.pepper.common.FormatDesc;
import org.corpus_tools.pepper.common.MEMORY_POLICY;
import org.corpus_tools.pepper.common.MODULE_TYPE;
import org.corpus_tools.pepper.common.PepperConfiguration;
import org.corpus_tools.pepper.common.PepperJob;
import org.corpus_tools.pepper.common.PepperUtil;
import org.corpus_tools.pepper.core.PepperImpl;
import org.corpus_tools.pepper.core.PepperJobImpl;
import org.corpus_tools.pepper.core.Step;
import org.corpus_tools.pepper.modules.DocumentController;
import org.corpus_tools.pepper.modules.PepperExporter;
import org.corpus_tools.pepper.modules.PepperImporter;
import org.corpus_tools.pepper.modules.PepperModule;
import org.corpus_tools.pepper.modules.coreModules.DoNothingExporter;
import org.corpus_tools.pepper.modules.coreModules.DoNothingImporter;
import org.corpus_tools.pepper.modules.exceptions.PepperModuleTestException;
import org.corpus_tools.pepper.testFramework.PepperModuleTest;
import org.corpus_tools.salt.SaltFactory;
import org.corpus_tools.salt.common.SCorpusGraph;
import org.corpus_tools.salt.common.SaltProject;
import org.eclipse.emf.common.util.URI;

public class PepperTestUtil {
    public static String TMP_TEST_DIR = "pepper-test";

    public static File getTempPath_static(String testDirectory) {
        if (testDirectory == null || testDirectory.isEmpty()) {
            throw new PepperModuleTestException("Cannot return a temporary directory, since the given last part is empty.");
        }
        File retVal = null;
        retVal = PepperUtil.getTempTestFile(TMP_TEST_DIR + "/" + testDirectory);
        return retVal;
    }

    public static String getSrcResources() {
        return "src/main/resources/";
    }

    public static String getTestResources() {
        return "src/test/resources/";
    }

    private static Step createAlibiStep(boolean createAlibiImporter) {
        URI dummyResourceURI = URI.createFileURI((String)new File(System.getProperty("java.io.tmpdir")).getAbsolutePath());
        File tmpFolder = PepperModuleTest.getTempPath_static("pepperModuleTest");
        Step step = null;
        CorpusDesc corpusDesc = new CorpusDesc();
        corpusDesc.setCorpusPath(URI.createFileURI((String)tmpFolder.getAbsolutePath()));
        FormatDesc formatDesc = new FormatDesc();
        formatDesc.setFormatName("doNothing");
        formatDesc.setFormatVersion("0.0");
        corpusDesc.setFormatDesc(formatDesc);
        if (createAlibiImporter) {
            step = new Step("doNothing_import_step");
            DoNothingImporter importer = new DoNothingImporter();
            importer.setResources(dummyResourceURI);
            importer.setCorpusDesc(corpusDesc);
            step.setPepperModule(importer);
            step.setModuleType(MODULE_TYPE.IMPORTER);
        } else {
            step = new Step("doNothing_export_step");
            DoNothingExporter exporter = new DoNothingExporter();
            exporter.setCorpusDesc(corpusDesc);
            exporter.setResources(dummyResourceURI);
            step.setPepperModule(exporter);
            step.setModuleType(MODULE_TYPE.EXPORTER);
        }
        step.setCorpusDesc(corpusDesc);
        step.setName("DoNothingImporter");
        return step;
    }

    public static void start(Collection<PepperModule> fixtures) {
        if (fixtures == null) {
            throw new PepperModuleTestException("Cannot start Pepper modules, because the list of fixtures is not set.");
        }
        ArrayList<PepperImporter> importers = new ArrayList<PepperImporter>();
        ArrayList<PepperExporter> exporters = new ArrayList<PepperExporter>();
        SaltProject saltProject = null;
        int i = 1;
        for (PepperModule fixture : fixtures) {
            if (i == 1) {
                saltProject = fixture.getSaltProject();
            } else if (saltProject != fixture.getSaltProject()) {
                throw new PepperModuleTestException("Cannot run test because the SaltProject objects are not equal for all Pepper modules. ");
            }
            ++i;
            fixture.setResources(URI.createFileURI((String)"src/main/resources"));
            if (fixture instanceof PepperImporter) {
                importers.add((PepperImporter)fixture);
                continue;
            }
            if (!(fixture instanceof PepperExporter)) continue;
            exporters.add((PepperExporter)fixture);
        }
        if (saltProject == null) {
            saltProject = SaltFactory.createSaltProject();
            for (PepperModule fixture : fixtures) {
                fixture.setSaltProject(saltProject);
            }
        }
        PepperImpl pepper = new PepperImpl();
        PepperConfiguration conf = new PepperConfiguration();
        conf.setProperty("pepper.memPolicy", MEMORY_POLICY.MODERATE.toString());
        pepper.setConfiguration(conf);
        PepperJob job = pepper.getJob(pepper.createJob());
        if (!(job instanceof PepperJobImpl)) {
            throw new PepperModuleTestException("Cannot start Pepper module test, because '" + PepperJob.class + "' is not of type '" + PepperJobImpl.class + "'. ");
        }
        ((PepperJobImpl)job).setSaltProject(saltProject);
        for (PepperModule fixture : fixtures) {
            Step fixtureStep = null;
            fixtureStep = new Step("fixture_step");
            fixtureStep.setModuleType(fixture.getModuleType());
            fixtureStep.setName(fixture.getName());
            fixtureStep.setVersion(fixture.getVersion());
            if (fixture instanceof PepperImporter) {
                fixtureStep.setCorpusDesc(((PepperImporter)fixture).getCorpusDesc());
            } else if (fixture instanceof PepperExporter) {
                fixtureStep.setCorpusDesc(((PepperExporter)fixture).getCorpusDesc());
            }
            fixtureStep.setPepperModule(fixture);
            ((PepperJobImpl)job).addStep(fixtureStep);
        }
        if (importers.size() == 0 || importers.size() != saltProject.getCorpusGraphs().size()) {
            for (SCorpusGraph cGraph : saltProject.getCorpusGraphs()) {
                boolean isAssociated = false;
                for (PepperModule fixture : fixtures) {
                    if (fixture.getCorpusGraph() != cGraph) continue;
                    isAssociated = true;
                    break;
                }
                if (isAssociated) continue;
                Step alibiStep = PepperTestUtil.createAlibiStep(true);
                ((PepperJobImpl)job).addStep(alibiStep);
            }
        }
        if (exporters.size() == 0) {
            Step alibiStep = PepperTestUtil.createAlibiStep(false);
            ((PepperJobImpl)job).addStep(alibiStep);
        }
        job.convert();
        for (DocumentController controller : ((PepperJobImpl)job).getDocumentControllers()) {
            controller.awake();
        }
    }
}

