/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.pepper.common;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Vector;
import org.corpus_tools.pepper.common.JOB_STATUS;
import org.corpus_tools.pepper.common.StepDesc;
import org.corpus_tools.pepper.exceptions.WorkflowException;
import org.eclipse.emf.common.util.URI;

public abstract class PepperJob {
    protected String id = null;
    private URI baseDir = null;
    protected JOB_STATUS status = JOB_STATUS.NOT_STARTED;
    protected Vector<StepDesc> stepDescs = null;

    public String getId() {
        return this.id;
    }

    public void setBaseDir(URI baseDir) {
        this.baseDir = baseDir;
    }

    public URI getBaseDir() {
        if (this.baseDir == null) {
            try {
                this.baseDir = URI.createFileURI((String)new File("./").getCanonicalPath());
            }
            catch (IOException e) {
                this.baseDir = URI.createFileURI((String)new File("./").getAbsolutePath());
            }
        }
        return this.baseDir;
    }

    public JOB_STATUS getStatus() {
        return this.status;
    }

    public abstract String getStatusReport();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<StepDesc> getStepDescs() {
        if (this.stepDescs == null) {
            PepperJob pepperJob = this;
            synchronized (pepperJob) {
                if (this.stepDescs == null) {
                    this.stepDescs = new Vector();
                }
            }
        }
        return this.stepDescs;
    }

    public void addStepDesc(StepDesc stepDesc) {
        if (stepDesc == null) {
            throw new WorkflowException("Cannot deal with an empty StepDesc object for job '" + this.getId() + "'.");
        }
        this.getStepDescs().add(stepDesc);
    }

    public StepDesc createStepDesc() {
        return new StepDesc();
    }

    public abstract void convert();

    public abstract void convertFrom();

    public abstract void convertTo();

    public abstract void load(URI var1);

    public abstract URI save(URI var1);

    public abstract void clear();

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append(this.getId());
        if (this.getStepDescs() != null) {
            str.append("{");
            for (StepDesc stepDesc : this.getStepDescs()) {
                str.append(stepDesc.getName());
                str.append(", ");
            }
            str.append("}");
        }
        return str.toString();
    }
}

